/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.DataLocation;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DataFormat
extends AbstractUIPage {
    private final String pageID = "DATA_FORMAT";
    private String nextPageID = "ENTITY";
    private final String pageNumber = "";
    private final String title = "Data File Information:";
    private final String subtitle = "File Format";
    private final String OTHER_LABEL = "other";
    private final String EMPTY_STRING = "";
    private final String COLUMN_MAJOR = "column";
    private final String ROW_MAJOR = "row";
    private String orientationSimple = "column";
    private String orientationComplex = "column";
    private String formatXPath;
    private final String PHYSICAL_XPATH = "/eml:eml/dataset/dataTable/physical/";
    private final String TEXT_BASE_XPATH = "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/";
    private final String SIMPLE_TEXT_XPATH = "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter";
    private final String COMPLEX_TEXT_XPATH = "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/complex/";
    private final String PROPRIETARY_XPATH = "/eml:eml/dataset/dataTable/physical/dataFormat/externallyDefinedFormat/formatName";
    private final String RASTER_XPATH = "/eml:eml/dataset/dataTable/physical/dataFormat/binaryRasterFormat";
    private JPanel radioPanel;
    private JPanel simpleTextpanel;
    private JPanel complexTextPanel;
    private JPanel proprietaryPanel;
    private JPanel rasterPanel;
    private JPanel currentPanel;
    private JLabel radioButtonGrpLabel;
    private final String[] buttonsText = new String[]{"Simple delimited text format (uses one or more delimiters throughout the file).", "Complex text format (delimited fields, fixed width fields, and mixtures of the two).", "Non-text or proprietary formatted file that is externally defined (e.g. 'Microsoft Excel')."};
    private final String[] orientButtonsText = new String[]{"Columns", "Rows"};
    private final String[] delimiterCheckBoxesText = new String[]{"tab", "comma", "space", "semicolon", "other"};
    private String[] pickListVals = new String[]{"Fixed-Width", "Delimited"};
    private String delim_tab = null;
    private String delim_comma = null;
    private String delim_space = null;
    private String delim_semicolon = null;
    private boolean delim_other = false;
    private CustomList list;
    private WizardContainerFrame mainWizFrame;
    private String fileName = "";
    private JLabel delimiterLabel;
    private JLabel listLabel;
    private JLabel proprietaryLabel;
    private String proprietaryText;
    private JTextField otherProprietaryTextField;
    private OrderedMap listResultsMap = new OrderedMap();
    private OrderedMap returnMap = new OrderedMap();
    private final JTextField otherDelimTextFieldSimple = WidgetFactory.makeOneLineTextField();

    public DataFormat(WizardContainerFrame mainWizFrame) {
        this.mainWizFrame = mainWizFrame;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        Box topBox = Box.createVerticalBox();
        JLabel desc = WidgetFactory.makeHTMLLabel("<b>Enter some information about your data file</b>.", 2);
        topBox.add(desc);
        topBox.add(WidgetFactory.makeDefaultSpacer());
        this.radioButtonGrpLabel = WidgetFactory.makeHTMLLabel("What is the format of your data?", 1);
        topBox.add(this.radioButtonGrpLabel);
        final DataFormat instance = this;
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                DataFormat.this.onLoadAction();
                if (e.getActionCommand().equals(DataFormat.this.buttonsText[0])) {
                    instance.remove(DataFormat.this.currentPanel);
                    DataFormat.this.currentPanel = DataFormat.this.simpleTextpanel;
                    DataFormat.this.formatXPath = "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter";
                    instance.add((Component)DataFormat.this.simpleTextpanel, "Center");
                } else if (e.getActionCommand().equals(DataFormat.this.buttonsText[1])) {
                    instance.remove(DataFormat.this.currentPanel);
                    DataFormat.this.currentPanel = DataFormat.this.complexTextPanel;
                    DataFormat.this.formatXPath = "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/complex/";
                    instance.add((Component)DataFormat.this.complexTextPanel, "Center");
                } else if (e.getActionCommand().equals(DataFormat.this.buttonsText[2])) {
                    instance.remove(DataFormat.this.currentPanel);
                    DataFormat.this.currentPanel = DataFormat.this.proprietaryPanel;
                    DataFormat.this.formatXPath = "/eml:eml/dataset/dataTable/physical/dataFormat/externallyDefinedFormat/formatName";
                    instance.add((Component)DataFormat.this.proprietaryPanel, "Center");
                } else if (e.getActionCommand().equals(DataFormat.this.buttonsText[3])) {
                    instance.remove(DataFormat.this.currentPanel);
                    DataFormat.this.currentPanel = DataFormat.this.rasterPanel;
                    DataFormat.this.formatXPath = "/eml:eml/dataset/dataTable/physical/dataFormat/binaryRasterFormat";
                    instance.add((Component)DataFormat.this.rasterPanel, "Center");
                }
                instance.validate();
                instance.repaint();
            }
        };
        this.radioPanel = WidgetFactory.makeRadioPanel(this.buttonsText, -1, listener);
        topBox.add(this.radioPanel);
        topBox.add(WidgetFactory.makeDefaultSpacer());
        this.add((Component)topBox, "North");
        this.simpleTextpanel = this.getSimpleTextpanel();
        this.complexTextPanel = this.getComplexTextPanel();
        this.proprietaryPanel = this.getProprietaryPanel();
        this.currentPanel = this.getEmptyPanel();
    }

    private JPanel getSimpleTextpanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        WidgetFactory.addTitledBorder(panel, this.buttonsText[0]);
        panel.add(WidgetFactory.makeDefaultSpacer());
        panel.add(WidgetFactory.makeHTMLLabel("Data Attributes are arranged in:", 1));
        JPanel orientationPanel = WidgetFactory.makePanel(2);
        JLabel spacerLabel = WidgetFactory.makeLabel("", false);
        orientationPanel.add(spacerLabel);
        orientationPanel.add(this.getOrientationRadioPanel());
        panel.add(orientationPanel);
        panel.add(WidgetFactory.makeDefaultSpacer());
        panel.add(WidgetFactory.makeHTMLLabel("Define one or more delimiters used to indicate the ends of fields:", 1));
        JPanel delimiterPanel = WidgetFactory.makePanel(8);
        this.delimiterLabel = WidgetFactory.makeLabel("Delimiter(s)", true);
        delimiterPanel.add(this.delimiterLabel);
        delimiterPanel.add(this.getDelimiterCheckBoxPanel());
        panel.add(delimiterPanel);
        panel.add(WidgetFactory.makeDefaultSpacer());
        panel.add(Box.createGlue());
        return panel;
    }

    private JPanel getComplexTextPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        WidgetFactory.addTitledBorder(panel, this.buttonsText[1]);
        panel.add(WidgetFactory.makeHTMLLabel("Data Attributes are arranged in:", 1));
        JPanel orientationPanel = WidgetFactory.makePanel(2);
        JLabel spacerLabel = WidgetFactory.makeLabel("", false);
        orientationPanel.add(spacerLabel);
        orientationPanel.add(this.getOrientationRadioPanel());
        panel.add(orientationPanel);
        panel.add(WidgetFactory.makeDefaultSpacer());
        this.listLabel = WidgetFactory.makeHTMLLabel("Define the delimited fields and/or fixed width fields that describe how the data is structured:", 1);
        panel.add(this.listLabel);
        JComboBox pickList = WidgetFactory.makePickList(this.pickListVals, false, 0, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Log.debug(45, "got PickList state changed; src = " + e.getSource().getClass().getName());
            }
        });
        Object[] colTemplates = new Object[]{pickList, new JTextField()};
        String[] colNames = new String[]{"Fixed-Width or Delimited?", "Width or Delimiter Character:"};
        this.list = WidgetFactory.makeList(colNames, colTemplates, 4, true, false, false, true, true, true);
        panel.add(this.list);
        return panel;
    }

    private JPanel getProprietaryPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        WidgetFactory.addTitledBorder(panel, this.buttonsText[2]);
        panel.add(WidgetFactory.makeDefaultSpacer());
        OrderedMap mimeMap = WizardSettings.getSupportedMIMETypesForEntity((short)10);
        String[] proprietaryButtonsText = new String[mimeMap.size() + 1];
        int i = 0;
        for (Object nextObj : mimeMap.keySet()) {
            if (nextObj == null) continue;
            proprietaryButtonsText[i++] = ((String)nextObj).trim();
        }
        this.otherProprietaryTextField = WidgetFactory.makeOneLineTextField();
        Dimension dim = new Dimension(385, WizardSettings.WIZARD_CONTENT_TEXTFIELD_DIMS.height);
        this.otherProprietaryTextField.setPreferredSize(dim);
        this.otherProprietaryTextField.setMaximumSize(dim);
        ActionListener listener = new ActionListener((Map)mimeMap){
            final /* synthetic */ Map val$mimeMap;
            {
                this.val$mimeMap = map;
            }

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                DataFormat.this.onLoadAction();
                if (e.getActionCommand().equals("other")) {
                    DataFormat.this.setProprietaryText("other", this.val$mimeMap);
                } else {
                    DataFormat.this.setProprietaryText(e.getActionCommand(), this.val$mimeMap);
                }
            }
        };
        proprietaryButtonsText[i] = "other";
        JPanel proprietaryPanel = new JPanel();
        proprietaryPanel.setLayout(new BoxLayout(proprietaryPanel, 1));
        this.proprietaryLabel = WidgetFactory.makeLabel("Format:", true);
        JPanel leftJustifyPanel = WidgetFactory.makePanel(1);
        leftJustifyPanel.add(this.proprietaryLabel);
        leftJustifyPanel.add(Box.createGlue());
        proprietaryPanel.add(leftJustifyPanel);
        boolean INITIAL_SELECTION = false;
        JPanel radioPanel = WidgetFactory.makeRadioPanel(proprietaryButtonsText, 0, listener);
        this.setProprietaryText(proprietaryButtonsText[0], (Map)mimeMap);
        JPanel radioJustifyPanel = new JPanel();
        radioJustifyPanel.setLayout(new BoxLayout(radioJustifyPanel, 0));
        radioJustifyPanel.add(WidgetFactory.makeLabel("", false));
        radioJustifyPanel.add(radioPanel);
        proprietaryPanel.add(radioJustifyPanel);
        JPanel otherJustifyPanel = new JPanel();
        otherJustifyPanel.setLayout(new BoxLayout(otherJustifyPanel, 0));
        otherJustifyPanel.setPreferredSize(WizardSettings.WIZARD_CONTENT_TEXTFIELD_DIMS);
        otherJustifyPanel.setMaximumSize(WizardSettings.WIZARD_CONTENT_TEXTFIELD_DIMS);
        otherJustifyPanel.add(WidgetFactory.makeLabel("", false));
        otherJustifyPanel.add(this.otherProprietaryTextField);
        otherJustifyPanel.add(Box.createGlue());
        proprietaryPanel.add(otherJustifyPanel);
        JPanel otherHelpJustifyPanel = new JPanel();
        otherHelpJustifyPanel.setLayout(new BoxLayout(otherHelpJustifyPanel, 0));
        otherHelpJustifyPanel.add(WidgetFactory.makeLabel("", false));
        JLabel help = WidgetFactory.makeHTMLLabel("<font style=\"font-size: 9px;\" color=\"#666666\">If your format does not appear in the above list, select \"other\" and enter a description in the field above. <br>This would preferably be in the form of a standard MIME type (e.g: application/msword ), but if you do not know the MIME type, enter a text description</font>", 4);
        Dimension helpDim = new Dimension(770 - 2 * WizardSettings.WIZARD_CONTENT_LABEL_DIMS.width, 3 * WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.height);
        help.setPreferredSize(helpDim);
        help.setMaximumSize(helpDim);
        Dimension helpPanelDim = new Dimension(770, 3 * WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.height);
        otherHelpJustifyPanel.setPreferredSize(helpPanelDim);
        otherHelpJustifyPanel.setMaximumSize(helpPanelDim);
        otherHelpJustifyPanel.add(help);
        otherHelpJustifyPanel.add(Box.createGlue());
        proprietaryPanel.add(otherHelpJustifyPanel);
        panel.add(proprietaryPanel);
        panel.add(WidgetFactory.makeDefaultSpacer());
        panel.add(Box.createGlue());
        return panel;
    }

    private void setProprietaryText(String labelString, Map mimeMap) {
        if (labelString == null) {
            return;
        }
        if (labelString.equals("other")) {
            this.otherProprietaryTextField.setEnabled(true);
            this.otherProprietaryTextField.requestFocus();
            this.proprietaryText = "";
        } else {
            this.otherProprietaryTextField.setEnabled(false);
            this.proprietaryText = ((String)mimeMap.get(labelString.trim())).trim();
        }
    }

    private JPanel getEmptyPanel() {
        return WidgetFactory.makeVerticalPanel(7);
    }

    public void onLoadAction() {
        AbstractUIPage prevPage = this.mainWizFrame.getPreviousPage();
        boolean flag = ((DataLocation)prevPage).isCreateChoice();
        this.fileName = ((DataLocation)prevPage).getFileName();
        Container middlePanel = (Container)this.radioPanel.getComponent(1);
        JRadioButton jrb = (JRadioButton)middlePanel.getComponent(1);
        if (flag) {
            jrb.setEnabled(false);
        } else {
            jrb.setEnabled(true);
        }
        WidgetFactory.unhiliteComponent(this.radioButtonGrpLabel);
        WidgetFactory.unhiliteComponent(this.proprietaryLabel);
        WidgetFactory.unhiliteComponent(this.listLabel);
        WidgetFactory.unhiliteComponent(this.otherProprietaryTextField);
        this.otherProprietaryTextField.setForeground(WizardSettings.WIZARD_CONTENT_TEXT_COLOR);
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        if (this.formatXPath == null || this.currentPanel == null) {
            WidgetFactory.hiliteComponent(this.radioButtonGrpLabel);
            return false;
        }
        if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter") {
            String otherTxt;
            if (this.delim_tab == null && this.delim_comma == null && this.delim_space == null && this.delim_semicolon == null && !this.delim_other) {
                WidgetFactory.hiliteComponent(this.delimiterLabel);
                return false;
            }
            if (this.delim_other && ((otherTxt = this.otherDelimTextFieldSimple.getText()) == null || otherTxt.equals(""))) {
                WidgetFactory.hiliteComponent(this.otherDelimTextFieldSimple);
                this.otherDelimTextFieldSimple.requestFocus();
                return false;
            }
        } else if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/complex/") {
            this.list.fireEditingStopped();
            OrderedMap listNVP = this.getCmplxDelimListAsNVP();
            if (listNVP == null || listNVP.size() < 1) {
                WidgetFactory.hiliteComponent(this.listLabel);
                return false;
            }
            if (!this.listContainsOnlyPosNumericWidths()) {
                WidgetFactory.hiliteComponent(this.listLabel);
                return false;
            }
            WidgetFactory.unhiliteComponent(this.listLabel);
        } else if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/externallyDefinedFormat/formatName" && (this.proprietaryText == null || this.proprietaryText.equals(""))) {
            this.proprietaryText = this.otherProprietaryTextField.getText().trim();
            if (this.proprietaryText.equals("")) {
                WidgetFactory.hiliteComponent(this.otherProprietaryTextField);
                return false;
            }
        }
        return true;
    }

    private boolean listContainsOnlyPosNumericWidths() {
        boolean returnVal = true;
        List rowLists = this.list.getListOfRowLists();
        String nextWidthStr = null;
        for (Object nextRowObj : rowLists) {
            boolean nextCol1IsNull;
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            boolean nextCol0IsNull = nextRow.get(0) == null;
            boolean bl = nextCol1IsNull = nextRow.get(1) == null;
            if (nextCol0IsNull || nextCol1IsNull || !nextRow.get(0).equals(this.pickListVals[0]) || (nextWidthStr = (String)nextRow.get(1)).trim().equals("")) continue;
            if (!WizardSettings.isFloat(nextWidthStr)) {
                returnVal = false;
                continue;
            }
            returnVal = Float.parseFloat(nextWidthStr) > 0.0f;
        }
        return returnVal;
    }

    private OrderedMap getCmplxDelimListAsNVP() {
        this.listResultsMap.clear();
        this.list.deleteEmptyRows((short)51, new short[]{0, 20});
        int fixedIndex = 1;
        int delimitedIndex = 1;
        StringBuffer buff = new StringBuffer();
        List rowLists = this.list.getListOfRowLists();
        String fixedDelimStr = null;
        for (Object nextRowObj : rowLists) {
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            if (nextRow.get(0).equals(this.pickListVals[0])) {
                fixedDelimStr = "textFixed[" + fixedIndex++ + "]/fieldWidth";
            } else if (nextRow.get(0).equals(this.pickListVals[1])) {
                fixedDelimStr = "textDelimited[" + delimitedIndex++ + "]/fieldDelimiter";
            }
            String nextVal = (String)nextRow.get(1);
            if (nextVal.equals("\\t")) {
                nextVal = "#x09";
            }
            if (nextVal.equals(" ")) {
                nextVal = "#x20";
            }
            buff.delete(0, buff.length());
            buff.append("/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/complex/");
            buff.append(fixedDelimStr);
            this.listResultsMap.put((Object)buff.toString(), (Object)nextVal);
        }
        return this.listResultsMap;
    }

    public OrderedMap getPageData() {
        this.returnMap.clear();
        if (this.formatXPath == null || this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/binaryRasterFormat") {
            return this.returnMap;
        }
        if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter") {
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/objectName", (Object)this.fileName);
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/attributeOrientation", (Object)this.orientationSimple);
            int index = 1;
            StringBuffer buff = new StringBuffer();
            if (this.delim_tab != null) {
                buff.delete(0, buff.length());
                buff.append("/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter");
                buff.append("[");
                buff.append(index++);
                buff.append("]");
                this.returnMap.put((Object)buff.toString(), (Object)this.delim_tab);
            }
            if (this.delim_comma != null) {
                buff.delete(0, buff.length());
                buff.append("/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter");
                buff.append("[");
                buff.append(index++);
                buff.append("]");
                this.returnMap.put((Object)buff.toString(), (Object)this.delim_comma);
            }
            if (this.delim_space != null) {
                buff.delete(0, buff.length());
                buff.append("/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter");
                buff.append("[");
                buff.append(index++);
                buff.append("]");
                this.returnMap.put((Object)buff.toString(), (Object)this.delim_space);
            }
            if (this.delim_semicolon != null) {
                buff.delete(0, buff.length());
                buff.append("/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter");
                buff.append("[");
                buff.append(index++);
                buff.append("]");
                this.returnMap.put((Object)buff.toString(), (Object)this.delim_semicolon);
            }
            if (this.delim_other) {
                buff.delete(0, buff.length());
                buff.append("/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter");
                buff.append("[");
                buff.append(index++);
                buff.append("]");
                this.returnMap.put((Object)buff.toString(), (Object)this.otherDelimTextFieldSimple.getText());
            }
        } else if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/complex/") {
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/objectName", (Object)this.fileName);
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/attributeOrientation", (Object)this.orientationComplex);
            this.returnMap.putAll((Map)this.getCmplxDelimListAsNVP());
        } else if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/externallyDefinedFormat/formatName") {
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/objectName", (Object)this.fileName);
            this.returnMap.put((Object)"/eml:eml/dataset/dataTable/physical/dataFormat/externallyDefinedFormat/formatName", (Object)this.proprietaryText);
        }
        return this.returnMap;
    }

    public OrderedMap getPageData(String rootXPath) {
        throw new UnsupportedOperationException("getPageData(String rootXPath) Method Not Implemented");
    }

    private JPanel getDelimiterCheckBoxPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        JPanel cbPanel = WidgetFactory.makeCheckBoxPanel(this.delimiterCheckBoxesText, -1, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String cmd = ((JCheckBox)e.getSource()).getActionCommand();
                int stateChange = e.getStateChange();
                Log.debug(45, "got checkBox state changed: " + cmd + "; type of state change = " + (stateChange == 1 ? "SELECTED" : "UNSELECTED"));
                if (cmd.indexOf(DataFormat.this.delimiterCheckBoxesText[0]) == 0) {
                    DataFormat.this.delim_tab = stateChange == 1 ? "#x09" : null;
                } else if (cmd.indexOf(DataFormat.this.delimiterCheckBoxesText[1]) == 0) {
                    DataFormat.this.delim_comma = stateChange == 1 ? "," : null;
                } else if (cmd.indexOf(DataFormat.this.delimiterCheckBoxesText[2]) == 0) {
                    DataFormat.this.delim_space = stateChange == 1 ? "#x20" : null;
                } else if (cmd.indexOf(DataFormat.this.delimiterCheckBoxesText[3]) == 0) {
                    DataFormat.this.delim_semicolon = stateChange == 1 ? ";" : null;
                } else if (cmd.indexOf(DataFormat.this.delimiterCheckBoxesText[4]) == 0) {
                    DataFormat.this.delim_other = stateChange == 1;
                    DataFormat.this.otherDelimTextFieldSimple.setEnabled(DataFormat.this.delim_other);
                    DataFormat.this.otherDelimTextFieldSimple.requestFocus();
                }
            }
        });
        panel.add(cbPanel);
        this.otherDelimTextFieldSimple.setPreferredSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.otherDelimTextFieldSimple.setMaximumSize(WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.otherDelimTextFieldSimple.setEnabled(false);
        JPanel otherPanel = new JPanel();
        otherPanel.setLayout(new BoxLayout(otherPanel, 0));
        otherPanel.add(this.otherDelimTextFieldSimple);
        otherPanel.add(Box.createGlue());
        panel.add(otherPanel);
        return panel;
    }

    private JPanel getOrientationRadioPanel() {
        return WidgetFactory.makeRadioPanel(this.orientButtonsText, 0, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(DataFormat.this.orientButtonsText[0])) {
                    DataFormat.this.setOrientation("column");
                } else if (e.getActionCommand().equals(DataFormat.this.orientButtonsText[1])) {
                    DataFormat.this.setOrientation("row");
                }
            }
        });
    }

    private void setOrientation(String orient) {
        if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/simpleDelimited/fieldDelimiter") {
            this.orientationSimple = orient;
        }
        if (this.formatXPath == "/eml:eml/dataset/dataTable/physical/dataFormat/textFormat/complex/") {
            this.orientationComplex = orient;
        }
    }

    public String getPageID() {
        return "DATA_FORMAT";
    }

    public String getPageNumber() {
        return "";
    }

    public String getTitle() {
        return "Data File Information:";
    }

    public String getSubtitle() {
        return "File Format";
    }

    public String getNextPageID() {
        return this.nextPageID;
    }

    public boolean setPageData(OrderedMap data, String xPathRoot) {
        return false;
    }
}

