/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.DateTimePanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.IntervalRatioPanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.NominalOrdinalPanel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class AttributePage
extends AbstractUIPage {
    private final String pageID = "ATTRIBUTE_PAGE";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Attribute Page";
    private final String subtitle = "";
    public static final int BORDERED_PANEL_TOT_ROWS = 7;
    public static final int DOMAIN_NUM_ROWS = 8;
    private final String CONFIG_KEY_CSS_LOCATION = "emlCSSLocation";
    private final String CONFIG_KEY_MCONFJAR_LOC = "morphoConfigJarLocation";
    private String attribIDField = "";
    private String attribScopeField = "";
    private String attribSystemField = "";
    private JTextField attribNameField;
    private JTextField attribLabelField;
    private JTextArea attribDefinitionField;
    private JTextField attribStorageField;
    private JTextField attribStorageSystemField;
    private JLabel attribNameLabel;
    private JLabel attribLabelLabel;
    private JLabel attribDefinitionLabel;
    private JLabel attribStorageLabel;
    private JLabel attribStorageSystemLabel;
    private JLabel measScaleLabel;
    private JPanel currentPanel;
    private JPanel radioPanel;
    private JPanel nominalPanel;
    private JPanel ordinalPanel;
    private JPanel intervalPanel;
    private JPanel ratioPanel;
    private JPanel dateTimePanel;
    private JPanel middlePanel;
    private JPanel topMiddlePanel;
    private String measurementScale;
    private JTextField missingValueCodeField;
    private JTextField missingValueExplnField;
    private String xPathRoot = "/eml:eml/dataset/dataTable/attributeList/attribute";
    final String ATTRIB_NAME_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Name of the attribute as it appears in the data file</html>";
    final String ATTRIB_LABEL_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">A more readable label for the attribute</html>";
    final String ATTRIB_STORAGE_TYPE_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Storage type for this field<font style=\"font-size: 9px;\" color=\"#666666\"> e.g:&nbsp;  integer, float</font></html>";
    final String ATTRIB_STORAGE_SYSTEM_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">The system used to define the storage types<font style=\"font-size: 9px;\" color=\"#666666\"> e.g:&nbsp; C, Java, Oracle</font></html>";
    final String ATTRIB_DEFN_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Define the contents of the attribute (or column) precisely, so that a data user could interpret the attribute accurately.<br></br><font style=\"font-size: 9px;\" color=\"#666666\">e.g:&nbsp;&nbsp;&nbsp;\"spden\" is the number of individuals of all macro invertebrate species found in the plot</font><html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">";
    private final String[] buttonsText = new String[]{"<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Unordered:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; unordered categories or text   (statistically &nbsp;<b>nominal</b>) <font style=\"font-size: 9px;\" color=\"#666666\">e.g: Male, Female</font></html>", "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Ordered:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ordered categories (statistically &nbsp;<b>ordinal</b>) <font style=\"font-size: 9px;\" color=\"#666666\">e.g: Low, High</font></html>", "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Relative:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; values from a scale with equidistant points (statistically &nbsp;<b>interval</b>) <font style=\"font-size: 9px;\" color=\"#666666\">e.g: 12.2 meters</font></html>", "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Absolute:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;measurement scale with a meaningful zero point (statistically &nbsp;<b>ratio</b>) <font style=\"font-size: 9px;\" color=\"#666666\">e.g: 273 Kelvin</font></html>", "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Date-Time:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;date or time values from the Gregorian calendar <font style=\"font-size: 9px;\" color=\"#666666\">e.g: 2002-10-24</font></html>"};
    private final String[] measScaleElemNames = new String[5];
    private final String[] measScaleDisplayNames = new String[5];
    public static final int MEASUREMENTSCALE_NOMINAL = 0;
    public static final int MEASUREMENTSCALE_ORDINAL = 1;
    public static final int MEASUREMENTSCALE_INTERVAL = 2;
    public static final int MEASUREMENTSCALE_RATIO = 3;
    public static final int MEASUREMENTSCALE_DATETIME = 4;
    private final Dimension HELP_DIALOG_SIZE = new Dimension(400, 500);
    private OrderedMap returnMap = new OrderedMap();

    public AttributePage() {
        this.initNames();
        this.init();
    }

    private void initNames() {
        this.measScaleElemNames[0] = "nominal";
        this.measScaleElemNames[1] = "ordinal";
        this.measScaleElemNames[2] = "interval";
        this.measScaleElemNames[3] = "ratio";
        this.measScaleElemNames[4] = "datetime";
        this.measScaleDisplayNames[0] = "Unordered";
        this.measScaleDisplayNames[1] = "Ordered";
        this.measScaleDisplayNames[2] = "Relative";
        this.measScaleDisplayNames[3] = "Absolute";
        this.measScaleDisplayNames[4] = "Datetime";
    }

    public boolean isImportNeeded() {
        if (this.measurementScale.equalsIgnoreCase("nominal")) {
            return ((NominalOrdinalPanel)this.nominalPanel).isImportNeeded();
        }
        if (this.measurementScale.equalsIgnoreCase("ordinal")) {
            return ((NominalOrdinalPanel)this.ordinalPanel).isImportNeeded();
        }
        return false;
    }

    private void init() {
        this.middlePanel = new JPanel();
        this.topMiddlePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.middlePanel, "Center");
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 1));
        this.topMiddlePanel.setLayout(new BoxLayout(this.topMiddlePanel, 1));
        this.topMiddlePanel.add(WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>Define Attribute or Column:</b></font>", 1));
        this.topMiddlePanel.add(WidgetFactory.makeDefaultSpacer());
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new GridLayout(1, 2));
        JPanel attribNamePanel = WidgetFactory.makePanel(1);
        this.attribNameLabel = WidgetFactory.makeLabel("Name:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        attribNamePanel.add(this.attribNameLabel);
        this.attribNameField = WidgetFactory.makeOneLineTextField();
        attribNamePanel.add(this.attribNameField);
        JLabel attribNameHelpLabel = this.getLabel(this.ATTRIB_NAME_HELP);
        namePanel.add(attribNamePanel);
        namePanel.add(attribNameHelpLabel);
        this.missingValueCodeField = WidgetFactory.makeOneLineTextField();
        this.missingValueExplnField = WidgetFactory.makeOneLineTextField();
        this.topMiddlePanel.add(namePanel);
        this.topMiddlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new GridLayout(1, 2));
        JPanel attribLabelPanel = WidgetFactory.makePanel(1);
        this.attribLabelLabel = WidgetFactory.makeLabel("Label:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        attribLabelPanel.add(this.attribLabelLabel);
        this.attribLabelField = WidgetFactory.makeOneLineTextField();
        attribLabelPanel.add(this.attribLabelField);
        JLabel attribLabelHelpLabel = this.getLabel(this.ATTRIB_LABEL_HELP);
        labelPanel.add(attribLabelPanel);
        labelPanel.add(attribLabelHelpLabel);
        this.topMiddlePanel.add(labelPanel);
        this.topMiddlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel defnPanel = new JPanel();
        defnPanel.setLayout(new GridLayout(1, 2));
        JPanel attribDefinitionPanel = WidgetFactory.makePanel(2);
        this.attribDefinitionLabel = WidgetFactory.makeLabel("Definition:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.attribDefinitionLabel.setVerticalAlignment(1);
        this.attribDefinitionLabel.setAlignmentY(1.0f);
        attribDefinitionPanel.add(this.attribDefinitionLabel);
        this.attribDefinitionField = WidgetFactory.makeTextArea("", 3, true);
        JScrollPane jscrl = new JScrollPane(this.attribDefinitionField);
        attribDefinitionPanel.add(jscrl);
        JLabel attribDefnHelpLabel = this.getLabel(this.ATTRIB_DEFN_HELP);
        defnPanel.add(attribDefinitionPanel);
        defnPanel.add(attribDefnHelpLabel);
        this.topMiddlePanel.add(defnPanel);
        this.topMiddlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel storagePanel = new JPanel();
        storagePanel.setLayout(new GridLayout(1, 2));
        JPanel attribStoragePanel = WidgetFactory.makePanel(1);
        this.attribStorageLabel = WidgetFactory.makeLabel("Storage:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        attribStoragePanel.add(this.attribStorageLabel);
        this.attribStorageField = WidgetFactory.makeOneLineTextField();
        attribStoragePanel.add(this.attribStorageField);
        JLabel attribStorageHelpLabel = this.getLabel(this.ATTRIB_STORAGE_TYPE_HELP);
        storagePanel.add(attribStoragePanel);
        storagePanel.add(attribStorageHelpLabel);
        this.topMiddlePanel.add(storagePanel);
        this.topMiddlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel storageSystemPanel = new JPanel();
        storageSystemPanel.setLayout(new GridLayout(1, 2));
        JPanel attribStorageSystemPanel = WidgetFactory.makePanel(1);
        this.attribStorageSystemLabel = WidgetFactory.makeLabel("Storage System:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        attribStorageSystemPanel.add(this.attribStorageSystemLabel);
        this.attribStorageSystemField = WidgetFactory.makeOneLineTextField();
        attribStorageSystemPanel.add(this.attribStorageSystemField);
        JLabel attribStorageSystemHelpLabel = this.getLabel(this.ATTRIB_STORAGE_SYSTEM_HELP);
        storageSystemPanel.add(attribStorageSystemPanel);
        storageSystemPanel.add(attribStorageSystemHelpLabel);
        this.topMiddlePanel.add(storageSystemPanel);
        this.topMiddlePanel.add(WidgetFactory.makeDefaultSpacer());
        ActionListener listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "got radiobutton command: " + e.getActionCommand());
                if (e.getActionCommand().equals(AttributePage.this.buttonsText[0])) {
                    AttributePage.this.setMeasurementScaleUI(AttributePage.this.nominalPanel);
                    AttributePage.this.setMeasurementScale(AttributePage.this.measScaleElemNames[0]);
                } else if (e.getActionCommand().equals(AttributePage.this.buttonsText[1])) {
                    AttributePage.this.setMeasurementScaleUI(AttributePage.this.ordinalPanel);
                    AttributePage.this.setMeasurementScale(AttributePage.this.measScaleElemNames[1]);
                } else if (e.getActionCommand().equals(AttributePage.this.buttonsText[2])) {
                    AttributePage.this.setMeasurementScaleUI(AttributePage.this.intervalPanel);
                    AttributePage.this.setMeasurementScale(AttributePage.this.measScaleElemNames[2]);
                } else if (e.getActionCommand().equals(AttributePage.this.buttonsText[3])) {
                    AttributePage.this.setMeasurementScaleUI(AttributePage.this.ratioPanel);
                    AttributePage.this.setMeasurementScale(AttributePage.this.measScaleElemNames[3]);
                } else if (e.getActionCommand().equals(AttributePage.this.buttonsText[4])) {
                    AttributePage.this.setMeasurementScaleUI(AttributePage.this.dateTimePanel);
                    AttributePage.this.setMeasurementScale(AttributePage.this.measScaleElemNames[4]);
                }
            }
        };
        this.measScaleLabel = WidgetFactory.makeLabel("Category:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.measScaleLabel.setAlignmentY(0.5f);
        JButton helpButton = new JButton("Help");
        helpButton.setMinimumSize(new Dimension(35, 15));
        helpButton.setMaximumSize(new Dimension(35, 15));
        helpButton.setMargin(new Insets(0, 2, 1, 2));
        helpButton.setEnabled(true);
        helpButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        helpButton.setFocusPainted(false);
        helpButton.setToolTipText("More Information about the Categories");
        Point loc1 = this.getLocation();
        helpButton.addActionListener(new ActionListener(){
            private JDialog helpDialog = null;

            public void actionPerformed(ActionEvent ae) {
                if (this.helpDialog == null) {
                    this.helpDialog = new CategoryHelpDialog();
                }
                Point loc = AttributePage.this.getLocationOnScreen();
                int wd = AttributePage.this.getWidth();
                int ht = AttributePage.this.getHeight();
                int dwd = ((AttributePage)AttributePage.this).HELP_DIALOG_SIZE.width;
                int dht = ((AttributePage)AttributePage.this).HELP_DIALOG_SIZE.height;
                this.helpDialog.setLocation((int)loc.getX() + wd / 2 - dwd / 2, (int)loc.getY() + ht / 2 - dht / 2);
                this.helpDialog.setSize(AttributePage.this.HELP_DIALOG_SIZE);
                this.helpDialog.setVisible(true);
                this.helpDialog.toFront();
            }
        });
        JPanel categoryPanel = new JPanel();
        categoryPanel.setLayout(new BoxLayout(categoryPanel, 1));
        JPanel helpButtonPanel = new JPanel();
        helpButtonPanel.setLayout(new BoxLayout(helpButtonPanel, 0));
        helpButtonPanel.add(helpButton);
        helpButtonPanel.add(Box.createHorizontalGlue());
        helpButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        categoryPanel.add(this.measScaleLabel);
        categoryPanel.add(WidgetFactory.makeHalfSpacer());
        categoryPanel.add(helpButtonPanel);
        categoryPanel.setMinimumSize(new Dimension(90, 45));
        categoryPanel.setMaximumSize(new Dimension(90, 45));
        JPanel outerCategoryPanel = new JPanel(new BorderLayout());
        outerCategoryPanel.add((Component)categoryPanel, "Center");
        outerCategoryPanel.add(Box.createGlue(), "South");
        outerCategoryPanel.add(Box.createGlue(), "North");
        this.radioPanel = WidgetFactory.makeRadioPanel(this.buttonsText, -1, listener);
        JPanel outerRadioPanel = new JPanel();
        outerRadioPanel.setLayout(new BoxLayout(outerRadioPanel, 0));
        outerRadioPanel.add(categoryPanel);
        outerRadioPanel.add(this.radioPanel);
        this.topMiddlePanel.add(outerRadioPanel);
        this.middlePanel.add(this.topMiddlePanel);
        this.currentPanel = this.getEmptyPanel();
        this.middlePanel.add(this.currentPanel);
        this.middlePanel.add(Box.createGlue());
        this.topMiddlePanel.setMaximumSize(this.topMiddlePanel.getPreferredSize());
        this.topMiddlePanel.setMinimumSize(this.topMiddlePanel.getPreferredSize());
        this.nominalPanel = this.getNomOrdPanel(0);
        this.ordinalPanel = this.getNomOrdPanel(1);
        this.intervalPanel = this.getIntervalRatioPanel(2);
        this.ratioPanel = this.getIntervalRatioPanel(3);
        this.dateTimePanel = this.getDateTimePanel();
        this.refreshUI();
    }

    private void setMeasurementScale(String scale) {
        this.measurementScale = scale;
    }

    private void setMeasurementScaleUI(JPanel panel) {
        this.topMiddlePanel.setMinimumSize(new Dimension(0, 0));
        this.middlePanel.remove(this.currentPanel);
        this.currentPanel = panel;
        this.middlePanel.add(this.currentPanel);
        this.topMiddlePanel.setMaximumSize(this.topMiddlePanel.getPreferredSize());
        this.topMiddlePanel.setMinimumSize(this.topMiddlePanel.getPreferredSize());
        ((WizardPageSubPanelAPI)((Object)this.currentPanel)).onLoadAction();
        this.currentPanel.invalidate();
        this.currentPanel.repaint();
        this.topMiddlePanel.validate();
        this.topMiddlePanel.repaint();
        this.middlePanel.validate();
        this.middlePanel.repaint();
    }

    private JPanel getEmptyPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(7);
        panel.add(WidgetFactory.makeDefaultSpacer());
        return panel;
    }

    private NominalOrdinalPanel getNomOrdPanel(int nom_ord) {
        NominalOrdinalPanel panel = new NominalOrdinalPanel(this);
        WidgetFactory.addTitledBorder(panel, this.measScaleDisplayNames[nom_ord]);
        return panel;
    }

    private IntervalRatioPanel getIntervalRatioPanel(int intvl_ratio) {
        IntervalRatioPanel panel = new IntervalRatioPanel(this);
        WidgetFactory.addTitledBorder(panel, this.measScaleDisplayNames[intvl_ratio]);
        return panel;
    }

    private DateTimePanel getDateTimePanel() {
        DateTimePanel panel = new DateTimePanel();
        WidgetFactory.addTitledBorder(panel, this.measScaleDisplayNames[4]);
        return panel;
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public void refreshUI() {
        this.currentPanel.validate();
        this.currentPanel.repaint();
        this.middlePanel.validate();
        this.middlePanel.repaint();
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Attribute Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    public boolean onAdvanceAction() {
        if (this.attribNameField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.attribNameLabel);
            this.attribNameField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.attribNameLabel);
        if (this.attribDefinitionField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.attribDefinitionLabel);
            this.attribDefinitionField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.attribDefinitionLabel);
        if (this.measurementScale == null) {
            WidgetFactory.hiliteComponent(this.measScaleLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.measScaleLabel);
        boolean valid = ((WizardPageSubPanelAPI)((Object)this.currentPanel)).validateUserInput();
        return valid;
    }

    public List getSurrogate() {
        WidgetFactory.unhiliteComponent(this.attribDefinitionLabel);
        ArrayList<String> surrogate = new ArrayList<String>();
        String attribName = this.attribNameField.getText().trim();
        if (attribName == null) {
            attribName = "";
        }
        surrogate.add(attribName);
        String attribDefinition = this.attribDefinitionField.getText().trim();
        if (attribDefinition == null) {
            attribDefinition = "";
        }
        surrogate.add(attribDefinition);
        if (this.measurementScale == null) {
            this.measurementScale = "";
        }
        surrogate.add(this.measurementScale);
        return surrogate;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPath) {
        String missingValueExpln;
        String missingValueCode;
        String storageTypeTypeSystem;
        String storageType;
        String attribDef;
        String attribLabel;
        String attribName;
        String attribSystem;
        String attribScope;
        this.returnMap.clear();
        String attribID = this.attribIDField.trim();
        if (attribID != null && !attribID.equals("")) {
            this.returnMap.put((Object)(xPath + "/@id"), (Object)attribID);
        }
        if ((attribScope = this.attribScopeField.trim()) != null && !attribScope.equals("")) {
            this.returnMap.put((Object)(xPath + "/@scope"), (Object)attribScope);
        }
        if ((attribSystem = this.attribSystemField.trim()) != null && !attribSystem.equals("")) {
            this.returnMap.put((Object)(xPath + "/@system"), (Object)attribSystem);
        }
        if ((attribName = this.attribNameField.getText().trim()) != null && !attribName.equals("")) {
            this.returnMap.put((Object)(xPath + "/attributeName"), (Object)attribName);
        }
        if ((attribLabel = this.attribLabelField.getText().trim()) != null && !attribLabel.equals("")) {
            this.returnMap.put((Object)(xPath + "/attributeLabel"), (Object)attribLabel);
        }
        if ((attribDef = this.attribDefinitionField.getText().trim()) != null && !attribDef.equals("")) {
            this.returnMap.put((Object)(xPath + "/attributeDefinition"), (Object)attribDef);
        }
        if ((storageType = this.attribStorageField.getText().trim()) != null && !storageType.equals("")) {
            this.returnMap.put((Object)(xPath + "/storageType"), (Object)storageType);
        }
        if ((storageTypeTypeSystem = this.attribStorageSystemField.getText().trim()) != null && !storageTypeTypeSystem.equals("")) {
            this.returnMap.put((Object)(xPath + "/storageType/@typeSystem"), (Object)storageTypeTypeSystem);
        }
        if (this.measurementScale != null && !this.measurementScale.equals("")) {
            this.returnMap.putAll((Map)((WizardPageSubPanelAPI)((Object)this.currentPanel)).getPanelData(xPath + "/measurementScale/" + this.measurementScale));
        }
        if ((missingValueCode = this.missingValueCodeField.getText().trim()) != null && !missingValueCode.equals("")) {
            this.returnMap.put((Object)(xPath + "/missingValueCode/code"), (Object)missingValueCode);
        }
        if ((missingValueExpln = this.missingValueExplnField.getText().trim()) != null && !missingValueExpln.equals("")) {
            this.returnMap.put((Object)(xPath + "/missingValueCode/codeExplanation"), (Object)missingValueExpln);
        }
        return this.returnMap;
    }

    private OrderedMap extractKeysContaining(OrderedMap map, String xPath) {
        OrderedMap resultMap = new OrderedMap();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            int idx = key.indexOf(xPath);
            if (idx < 0) continue;
            String substring = key.substring(idx);
            int idx2 = substring.substring(1).indexOf("/");
            String correctKey = "/additionalMetadata" + substring.substring(idx2 + 1);
            resultMap.put((Object)correctKey, map.get((Object)key));
            it.remove();
        }
        return resultMap;
    }

    private String findMeasurementScale(OrderedMap map) {
        Object o1 = map.get((Object)(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain" + "/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Nominal";
        }
        boolean b1 = map.containsKey((Object)(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain" + "/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Nominal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain" + "/textDomain[1]/definition"));
        if (o1 != null) {
            return "Nominal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain" + "/enumeratedDomain/codeDefinition/code"));
        if (o1 != null) {
            return "Nominal";
        }
        b1 = map.containsKey((Object)(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain" + "/enumeratedDomain/entityCodeList/entityReference"));
        if (b1) {
            return "Nominal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain" + "/textDomain/definition"));
        if (o1 != null) {
            return "Nominal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain" + "/enumeratedDomain[1]/codeDefinition[1]/code"));
        if (o1 != null) {
            return "Ordinal";
        }
        b1 = map.containsKey((Object)(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain" + "/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (b1) {
            return "Ordinal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain" + "/textDomain[1]/definition"));
        if (o1 != null) {
            return "Ordinal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain" + "/enumeratedDomain/codeDefinition/code"));
        if (o1 != null) {
            return "Ordinal";
        }
        b1 = map.containsKey((Object)(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain" + "/enumeratedDomain/entityCodeList/entityReference"));
        if (b1) {
            return "Ordinal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain" + "/textDomain/definition"));
        if (o1 != null) {
            return "Ordinal";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ratio" + "/unit/standardUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ratio" + "/unit/customUnit"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/ratio" + "/numericDomain/numberType"));
        if (o1 != null) {
            return "Ratio";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/interval" + "/unit/standardUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/interval" + "/unit/customUnit"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/interval" + "/numericDomain/numberType"));
        if (o1 != null) {
            return "Interval";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/datetime" + "/formatString"));
        if (o1 != null) {
            return "Datetime";
        }
        o1 = map.get((Object)(this.xPathRoot + "/measurementScale/datetime" + "/dateTimePrecision"));
        if (o1 != null) {
            return "Datetime";
        }
        return "";
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        String missingValueExpln;
        String missingValueCode;
        String storageTypeTypeSystem;
        String storageType;
        String defn;
        String label;
        String name;
        String system;
        String scope;
        String id;
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if ((id = (String)map.get((Object)(this.xPathRoot + "/@id"))) != null) {
            this.attribIDField = id.toString();
            map.remove((Object)(this.xPathRoot + "/@id"));
        }
        if ((scope = (String)map.get((Object)(this.xPathRoot + "/@scope"))) != null) {
            this.attribScopeField = scope.toString();
            map.remove((Object)(this.xPathRoot + "/@scope"));
        }
        if ((system = (String)map.get((Object)(this.xPathRoot + "/@system"))) != null) {
            this.attribSystemField = system.toString();
            map.remove((Object)(this.xPathRoot + "/@system"));
        }
        if ((name = (String)map.get((Object)(this.xPathRoot + "/attributeName[1]"))) != null) {
            map = this.stripIndexOneFromMapKeys(map);
        }
        String mScale = this.findMeasurementScale(map);
        name = (String)map.get((Object)(this.xPathRoot + "/attributeName"));
        if (name != null) {
            this.attribNameField.setText(name);
            map.remove((Object)(this.xPathRoot + "/attributeName"));
        }
        if ((label = (String)map.get((Object)(this.xPathRoot + "/attributeLabel"))) != null) {
            this.attribLabelField.setText(label);
            map.remove((Object)(this.xPathRoot + "/attributeLabel"));
        }
        if ((defn = (String)map.get((Object)(this.xPathRoot + "/attributeDefinition"))) != null) {
            this.attribDefinitionField.setText(defn);
            map.remove((Object)(this.xPathRoot + "/attributeDefinition"));
        }
        if ((storageType = (String)map.get((Object)(this.xPathRoot + "/storageType"))) != null) {
            this.attribStorageField.setText(storageType);
            map.remove((Object)(this.xPathRoot + "/storageType"));
        }
        if ((storageTypeTypeSystem = (String)map.get((Object)(this.xPathRoot + "/storageType/@typeSystem"))) != null) {
            this.attribStorageSystemField.setText(storageTypeTypeSystem.toString());
            map.remove((Object)(this.xPathRoot + "/storageType/@typeSystem"));
        }
        if (mScale == null || mScale.equals("")) {
            return false;
        }
        this.measurementScale = mScale;
        int componentNum = -1;
        if (this.measurementScale.equalsIgnoreCase("nominal")) {
            this.setMeasurementScaleUI(this.nominalPanel);
            this.setMeasurementScale(this.measScaleElemNames[0]);
            componentNum = 0;
            ((NominalOrdinalPanel)this.nominalPanel).setPanelData(this.xPathRoot + "/measurementScale/nominal/nonNumericDomain", map);
        } else if (this.measurementScale.equalsIgnoreCase("ordinal")) {
            this.setMeasurementScaleUI(this.ordinalPanel);
            this.setMeasurementScale(this.measScaleElemNames[1]);
            componentNum = 1;
            ((NominalOrdinalPanel)this.ordinalPanel).setPanelData(this.xPathRoot + "/measurementScale/ordinal/nonNumericDomain", map);
        }
        if (this.measurementScale.equalsIgnoreCase("interval")) {
            this.setMeasurementScaleUI(this.intervalPanel);
            this.setMeasurementScale(this.measScaleElemNames[2]);
            componentNum = 2;
            ((IntervalRatioPanel)this.intervalPanel).setPanelData(this.xPathRoot + "/measurementScale/interval", map);
        }
        if (this.measurementScale.equalsIgnoreCase("ratio")) {
            this.setMeasurementScaleUI(this.ratioPanel);
            this.setMeasurementScale(this.measScaleElemNames[3]);
            componentNum = 3;
            ((IntervalRatioPanel)this.ratioPanel).setPanelData(this.xPathRoot + "/measurementScale/ratio", map);
        }
        if (this.measurementScale.equalsIgnoreCase("datetime")) {
            this.setMeasurementScaleUI(this.dateTimePanel);
            this.setMeasurementScale(this.measScaleElemNames[4]);
            componentNum = 4;
            ((DateTimePanel)this.dateTimePanel).setPanelData(this.xPathRoot + "/measurementScale/datetime", map);
        }
        if (componentNum != -1) {
            Container c = (Container)this.radioPanel.getComponent(1);
            JRadioButton jrb = (JRadioButton)c.getComponent(componentNum);
            jrb.setSelected(true);
        }
        if ((missingValueCode = (String)map.get((Object)(this.xPathRoot + "/missingValueCode/code"))) != null) {
            this.missingValueCodeField.setText(missingValueCode);
            map.remove((Object)(this.xPathRoot + "/missingValueCode/code"));
        }
        if ((missingValueExpln = (String)map.get((Object)(this.xPathRoot + "/missingValueCode/codeExplanation"))) != null) {
            this.missingValueExplnField.setText(missingValueExpln);
            map.remove((Object)(this.xPathRoot + "/missingValueCode/codeExplanation"));
        }
        this.refreshUI();
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "AttributePage.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal;
    }

    private OrderedMap stripIndexOneFromMapKeys(OrderedMap map) {
        OrderedMap newMap = new OrderedMap();
        for (String key : map.keySet()) {
            String val = (String)map.get((Object)key);
            int pos = key.indexOf("[1]");
            if (pos < 0) {
                newMap.put((Object)key, (Object)val);
                continue;
            }
            String newKey = "";
            while (pos != -1) {
                newKey = newKey + key.substring(0, pos);
                key = key.substring(pos + 3);
                pos = key.indexOf("[1]");
            }
            newKey = newKey + key;
            newMap.put((Object)newKey, (Object)val);
        }
        return newMap;
    }

    public String getText() {
        String mainXPath;
        Object o1;
        String text = "<html> <head> <link href=\"" + this.getFullStylePath() + "/entity.css\" type=\"text/css\" rel=\"stylesheet\"> </head> ";
        text = text + "<body>";
        text = text + "<table border=\"0\" cellpadding=\"5\" cellspacing=\"0\" width=\"100%\" cols = \"5\"> ";
        text = text + "<tr>";
        text = text + "<td class=\"highlight\"  width = \"35%\" > Name: </td>";
        text = text + "<td class=\"secondCol\" width=\"65%\" colspan=\"4\">" + this.attribNameField.getText() + "</td>";
        text = text + "</tr>";
        text = text + "<tr>";
        text = text + "<td class=\"highlight\"  width = \"35%\" > Definition: </td>";
        text = text + "<td class=\"secondCol\" width=\"65%\" colspan=\"4\">" + this.attribDefinitionField.getText() + "</td>";
        text = text + "</tr>";
        String scale = this.measurementScale;
        boolean index = false;
        OrderedMap map = this.getPageData("/eml:eml/dataset/dataTable/attributeList/attribute");
        if (this.measurementScale.equalsIgnoreCase("Nominal")) {
            o1 = map.get((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/nominal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code");
            if (o1 != null) {
                scale = scale + "; Enumerated values";
                index = false;
            } else {
                o1 = map.get((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/nominal/nonNumericDomain/textDomain[1]/definition");
                if (o1 != null) {
                    scale = scale + "; Text values";
                    index = true;
                } else {
                    scale = scale + "; Enumerated values";
                    index = false;
                }
            }
        } else if (this.measurementScale.equalsIgnoreCase("Ordinal")) {
            o1 = map.get((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ordinal/nonNumericDomain/enumeratedDomain[1]/codeDefinition[1]/code");
            if (o1 != null) {
                scale = scale + "; Enumerated values";
                index = false;
            } else {
                o1 = map.get((Object)"/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ordinal/nonNumericDomain/textDomain[1]/definition");
                if (o1 != null) {
                    scale = scale + "; Text values";
                    index = true;
                } else {
                    scale = scale + "; Enumerated values";
                    index = false;
                }
            }
        }
        text = text + "<tr>";
        text = text + "<td class = \"highlight\"  width = \"35%\" > Measurement Scale: </td>";
        text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\"> " + scale + "</td>";
        text = text + "</tr>";
        if (this.measurementScale.equalsIgnoreCase("Nominal") || this.measurementScale.equalsIgnoreCase("Ordinal")) {
            mainXPath = this.measurementScale.equalsIgnoreCase("Nominal") ? "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/nominal/nonNumericDomain" : "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ordinal/nonNumericDomain";
            if (!index) {
                Object o;
                text = text + "<tr>";
                text = text + "<td class = \"tablehead\" > Definitions: </td>";
                String table = "";
                table = table + "<td class = \"tablehead\" >Code </td>";
                table = table + "<td class = \"tablehead\" >Definition </td>";
                table = table + "<td class = \"tablehead\" colspan=\"2\">Source </td>";
                table = table + "</tr>";
                int i = 1;
                String enumPath = "/enumeratedDomain[1]/codeDefinition[";
                while ((o = map.get((Object)(mainXPath + enumPath + i + "]/code"))) != null) {
                    String e1 = (String)o;
                    o = map.get((Object)(mainXPath + enumPath + i + "]/definition"));
                    String e2 = o == null ? "no definition" : (String)o;
                    o = map.get((Object)(mainXPath + enumPath + i + "]/source"));
                    String e3 = o == null ? "" : (String)o;
                    table = table + "<tr>";
                    table = table + "<td class = \"highlight\"> </td>";
                    table = table + "<td >" + e1 + "</td> <td  >" + e2 + "</td> <td colspan=\"2\">" + e3 + "</td>";
                    table = table + "</tr>";
                    ++i;
                }
                text = text + table;
            } else if (index) {
                Object o12;
                String textPath = "/textDomain[1]/";
                String data = (String)map.get((Object)(mainXPath + textPath + "definition"));
                text = text + "<tr>";
                text = text + "<td class =\"highlight\"  width = \"35%\"> Definition: </td>";
                text = text + "<td class =\"secondCol\" width=\"65%\" colspan=\"4\"> " + data + "</td>";
                text = text + "</tr>";
                Object o = map.get((Object)(mainXPath + textPath + "source"));
                if (o != null) {
                    text = text + "<tr>";
                    text = text + "<td class =\"highlight\"  width = \"35%\"> Source: </td>";
                    text = text + "<td class=\"secondCol\" width=\"65%\" colspan=\"4\"> " + (String)o + "</td>";
                    text = text + "</tr>";
                }
                int i = 1;
                while ((o12 = map.get((Object)(mainXPath + textPath + "pattern[" + i + "]"))) != null) {
                    text = text + "<tr>";
                    text = i == 1 ? text + "<td class=\"highlight\"  width = \"35%\" valign =\"top\"> Patterns: </td>" : text + "<td class =\"highlight\"></td>";
                    text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\">" + (String)o12 + "</td>";
                    text = text + "</tr>";
                    ++i;
                }
            }
        }
        if (this.measurementScale.equalsIgnoreCase("Interval") || this.measurementScale.equalsIgnoreCase("Ratio")) {
            mainXPath = this.measurementScale.equalsIgnoreCase("Interval") ? "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/interval" : "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/ratio";
            String unit = (String)map.get((Object)(mainXPath + "/unit/standardUnit"));
            if (unit != null) {
                text = text + "<tr>";
                text = text + "<td class = \"highlight\"  width = \"35%\" > Standard Unit: </td>";
                text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\"> " + unit + "</td>";
                text = text + "</tr>";
            } else {
                unit = (String)map.get((Object)(mainXPath + "/unit/customUnit"));
                if (unit != null) {
                    text = text + "<tr>";
                    text = text + "<td class = \"highlight\"  width = \"35%\" > Custom Unit: </td>";
                    text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\"> " + unit + "</td>";
                    text = text + "</tr>";
                }
            }
            String precision = (String)map.get((Object)(mainXPath + "/precision"));
            text = text + "<tr>";
            text = text + "<td class = \"highlight\"  width = \"35%\"> Precision: </td>";
            text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\">" + precision + "</td>";
            text = text + "</tr>";
            String numberType = (String)map.get((Object)(mainXPath + "/numericDomain/numberType"));
            text = text + "<tr>";
            text = text + "<td class = \"highlight\"  width = \"35%\"> Number Type: </td>";
            text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\">" + numberType + "</td>";
            text = text + "</tr>";
            Object o13 = map.get((Object)(mainXPath + "/numericDomain/bounds[1]/minimum"));
            Object o2 = map.get((Object)(mainXPath + "/numericDomain/bounds[1]/maximum"));
            if (o13 != null || o2 != null) {
                int pos = 1;
                while (true) {
                    Object ob1 = map.get((Object)(mainXPath + "/numericDomain/bounds[" + pos + "]/minimum"));
                    Object ob2 = map.get((Object)(mainXPath + "/numericDomain/bounds[" + pos + "]/maximum"));
                    if (ob1 == null && ob2 == null) break;
                    String e1 = ob1 == null ? "" : (String)ob1;
                    String e2 = ob2 == null ? "" : (String)ob2;
                    Object ob3 = map.get((Object)(mainXPath + "/numericDomain/bounds[" + pos + "]/minimum/@exclusive"));
                    Object ob4 = map.get((Object)(mainXPath + "/numericDomain/bounds[" + pos + "]/maximum/@exclusive"));
                    String e3 = ob3 == null || ((String)ob3).equalsIgnoreCase("false") ? "(incl)" : "(excl)";
                    String e4 = ob4 == null || ((String)ob4).equalsIgnoreCase("false") ? "(incl)" : "(excl)";
                    text = text + "<tr>";
                    text = pos == 1 ? text + "<td class = \"highlight\"  width = \"35%\"> Bounds: </td>" : text + "<td class= \"highlight\"> </td>";
                    text = text + "<td>min: " + e1 + "</td>";
                    text = text + "<td>" + e3 + "</td>";
                    text = text + "<td>max: " + e2 + "</td>";
                    text = text + "<td>" + e4 + "</td>";
                    text = text + "</tr>";
                    ++pos;
                }
            }
        }
        if (this.measurementScale.equalsIgnoreCase("Datetime")) {
            mainXPath = "/eml:eml/dataset/dataTable/attributeList/attribute/measurementScale/datetime";
            String format = (String)map.get((Object)(mainXPath + "/formatString"));
            String precision = (String)map.get((Object)(mainXPath + "/dateTimePrecision"));
            text = text + "<tr>";
            text = text + "<td class = \"highlight\"  width = \"35%\" > Format: </td>";
            text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\"> " + format + "</td>";
            text = text + "</tr>";
            text = text + "<tr>";
            text = text + "<td class = \"highlight\"  width = \"35%\" > Precision: </td>";
            text = text + "<td class = \"secondCol\" width=\"65%\" colspan=\"4\"> " + precision + "</td>";
            text = text + "</tr>";
            Object o14 = map.get((Object)(mainXPath + "/dateTimeDomain/bounds[1]/minimum"));
            Object o2 = map.get((Object)(mainXPath + "/dateTimeDomain/bounds[1]/maximum"));
            if (o14 != null || o2 != null) {
                int pos = 1;
                while (true) {
                    Object ob1 = map.get((Object)(mainXPath + "/dateTimeDomain/bounds[" + pos + "]/minimum"));
                    Object ob2 = map.get((Object)(mainXPath + "/dateTimeDomain/bounds[" + pos + "]/maximum"));
                    if (ob1 == null && ob2 == null) break;
                    String e1 = ob1 == null ? "" : (String)ob1;
                    String e2 = ob2 == null ? "" : (String)ob2;
                    Object ob3 = map.get((Object)(mainXPath + "/dateTimeDomain/bounds[" + pos + "]/minimum/@exclusive"));
                    Object ob4 = map.get((Object)(mainXPath + "/dateTimeDomain/bounds[" + pos + "]/maximum/@exclusive"));
                    String e3 = ob3 == null || ((String)ob3).equalsIgnoreCase("false") ? "(incl)" : "(excl)";
                    String e4 = ob4 == null || ((String)ob4).equalsIgnoreCase("false") ? "(incl)" : "(excl)";
                    text = text + "<tr>";
                    text = pos == 1 ? text + "<td class = \"highlight\" > Bounds: </td>" : text + "<td class=\"highlight\"></td>";
                    text = text + "<td class=\"secondCol\">min: " + e1 + "</td>";
                    text = text + "<td class=\"secondCol\">" + e3 + "</td>";
                    text = text + "<td class=\"secondCol\">max: " + e2 + "</td>";
                    text = text + "<td class=\"secondCol\">" + e4 + "</td>";
                    text = text + "</tr>";
                    ++pos;
                }
            }
        }
        text = text + "</table>";
        text = text + "</body>";
        text = text + "</html>";
        Log.debug(15, text);
        return text;
    }

    private String getFullStylePath() {
        String FULL_STYLE_PATH = null;
        ConfigXML config = Morpho.getConfiguration();
        if (FULL_STYLE_PATH == null) {
            StringBuffer pathBuff = new StringBuffer();
            pathBuff.append("jar:file:");
            pathBuff.append(new File("").getAbsolutePath());
            pathBuff.append("/");
            pathBuff.append(config.get("morphoConfigJarLocation", 0));
            pathBuff.append("!/");
            pathBuff.append(config.get("emlCSSLocation", 0));
            FULL_STYLE_PATH = pathBuff.toString();
            Object var3_3 = null;
        }
        return FULL_STYLE_PATH;
    }

    class CategoryHelpDialog
    extends JDialog {
        private final Color TOP_PANEL_BG_COLOR = new Color(11, 85, 112);
        private final Font TITLE_FONT = new Font("Sans-Serif", 1, 13);
        private final Color TITLE_TEXT_COLOR = new Color(255, 255, 255);
        private final Dimension TOP_PANEL_DIMS = new Dimension(100, 40);
        private String helpText = "<html> <body><p>The concept of a measurement scale as defined by Stevens is useful for classifying data despite the weaknesses of the approach that have been pointed out by several practitioners. In particular, the classification allows us to determine some of the mathematical operations that are appropriate for a given set of data, and allows us to determine which types of metadata are needed for a given set of data.  For example, categorical data never have a \"unit\" of measurement. </p><p> Here is a brief overview of the measurement scales we have employed in EML. They are based on Steven's original typology, with the addition of \"Date-Time\"  for purely pragmatic reasons (we need to distinguish date time values in order to collect certain essential metadata about date and time representation).</p><p><b>NOMINAL</b><br></br>  &nbsp;&nbsp;&nbsp;&nbsp;The nominal scale places values into named categories. The different values within a set are unordered.  Some examples of nominal scales include gender (Male/Female) and marital status (single/married/divorced).  Text fields should be classified as nominal.</p><p><b>ORDINAL</b><br></br>&nbsp;&nbsp;&nbsp;&nbsp;The ordinal scale places values in a set order. All ordinal values are also nominal. Ordinal data show a particular value's position relative to other values, such as \"low, medium, high, etc.\" The ordinal scale doesn't indicate the distance between each item.</p><p><b>INTERVAL</b><br></br>&nbsp;&nbsp;&nbsp;&nbsp;The interval scale uses equal-sized units of measurement on a scale between values. It therefore allows the comparison of the differences between two values on the scale. With interval data, the allowable values start from an arbitrary point (not a meaningful zero), and so there is no concept of 'zero' of the measured quantity. Consequently, ratios of interval values are not meaningful. For example, one can not infer that someone with a value of 80 on an ecology test knows twice as much ecology as someone who scores 40 on the test, or that an object at 40 degrees C has twice the kinetic energy as an object at 20 degrees C. All interval values are also ordered and therefore are ordinal scale values as well.</p><p><b>RATIO</b><br></br>&nbsp;&nbsp;&nbsp;&nbsp;The ratio scale is an interval scale with a meaningful zero point. The ratio scale begins at a true zero point that represents an absolute lack of the quality being measured.  Thus, ratios of values are meaningful. For example, an object that is at elevation of 100 meters above sea level is twice as high as an object that is at an elevation of 50 meters above sea level (where sea level is the zero point).  Also, an object at 300 degrees Kelvin has three times the kinetic energy of an object at 100 degrees Kelvin (where absolute zero (no motion) defines the zero point of the Kelvin scale).  Interval values can often be converted to ratio values in order to make ratio comparisons legitimate. For example, an object at 40 degrees C is 313.15 degrees Kelvin, an object at 20 degrees C is 293.15 degrees Kelvin, and so the first object has approximately 1.07 times more kinetic energy (note the wrong answer you would have gotten had you taken the ratio of the values in Celsius).</p><p><b>DATE-TIME</b><br></br>&nbsp;&nbsp;&nbsp;&nbsp;Date and time values in the Gregorian calendar are very strange to use in calculations in that they have properties of both interval and ratio scales.  They also have some properties that do not conform to the interval scale because of the adjustments that are made to time to account for the variations in the period of the Earth around the sun. While the Gregorian calendar has a meaningful zero point, it would be difficult to say that a value taken on midnight January 1, 1000 is twice as old as a value taken on midnight January 1 2000 because the scale has many irregularities in length in practice. However, over short intervals the scale has equidistant points based on the SI second, and so can be considered interval for some purposes, especially with respect to measuring the timing of short-term ecological events.  Date and time values can be represented using several distinct notations, and so we have distinct metadata needs in terms of specifying the format of the value representation.  Because of these pragmatic issues, we separated Date-time into its own measurement scale.  Examples of date-time values are '2003-05-05', '1999/10/10', and '2001-10-10T14:23:20.3'.</p></body> </html>";

        CategoryHelpDialog() {
            this.init();
            this.setVisible(false);
        }

        void init() {
            this.setTitle("Help");
            this.setModal(true);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            JLabel titleLabel = new JLabel("Help on Choosing a Measurement Scale (Category)");
            titleLabel.setFont(this.TITLE_FONT);
            titleLabel.setForeground(this.TITLE_TEXT_COLOR);
            titleLabel.setBorder(new EmptyBorder(5, 0, 5, 0));
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new BoxLayout(topPanel, 1));
            topPanel.setPreferredSize(this.TOP_PANEL_DIMS);
            topPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
            topPanel.setBackground(this.TOP_PANEL_BG_COLOR);
            topPanel.setOpaque(true);
            topPanel.add(titleLabel);
            contentPane.add((Component)topPanel, "North");
            JEditorPane editor = new JEditorPane();
            editor.setEditable(false);
            editor.setContentType("text/html");
            editor.setText(this.helpText);
            editor.setCaretPosition(0);
            contentPane.add((Component)new JScrollPane(editor, 20, 30), "Center");
        }
    }
}

