/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.FileUtils;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ProfileDialog
extends JDialog {
    ConfigXML config;
    Morpho framework = null;
    int numScreens;
    int currentScreen;
    JLabel helpLabel = new JLabel();
    JPanel screenPanel = null;
    JButton previousButton = null;
    JButton nextButton = null;
    JButton cancelButton = new JButton();
    ImageIcon forwardIcon = null;
    JTextField profileNameField = new JTextField();
    JTextField firstNameField = new JTextField();
    JTextField lastNameField = new JTextField();
    JTextField userIdField = new JTextField();
    JTextField scopeField = new JTextField();
    JList orgList = null;
    KeyPressActionListener keyPressListener = new KeyPressActionListener();

    public ProfileDialog(Morpho cont) {
        this(cont, true);
    }

    public ProfileDialog(Morpho cont, boolean modal) {
        this.setModal(true);
        this.framework = cont;
        this.numScreens = 3;
        this.currentScreen = 0;
        this.setDefaultCloseOperation(2);
        this.setTitle("New Profile");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 0));
        this.setVisible(false);
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new BoxLayout(helpPanel, 1));
        helpPanel.setBackground(Color.white);
        Dimension helpDim = new Dimension(250, 400);
        helpPanel.setMaximumSize(helpDim);
        helpPanel.setPreferredSize(helpDim);
        helpPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        helpPanel.add(Box.createRigidArea(new Dimension(8, 8)));
        ImageIcon logoIcon = new ImageIcon(this.getClass().getResource("logo-icon.gif"));
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(logoIcon);
        helpPanel.add(imageLabel);
        this.helpLabel.setText("<html>This is a whole bunch of help text.</html>");
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setFont(new Font("Dialog", 1, 12));
        this.helpLabel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.helpLabel.setVerticalAlignment(1);
        helpPanel.add(this.helpLabel);
        this.getContentPane().add(helpPanel);
        this.getContentPane().add(Box.createRigidArea(new Dimension(8, 8)));
        JPanel entryPanel = new JPanel();
        entryPanel.setLayout(new BoxLayout(entryPanel, 1));
        entryPanel.add(Box.createVerticalStrut(8));
        JLabel headLabel = new JLabel();
        headLabel.setText("New Profile");
        ImageIcon head = new ImageIcon(this.getClass().getResource("smallheader-bg.gif"));
        headLabel.setIcon(head);
        headLabel.setHorizontalTextPosition(0);
        headLabel.setHorizontalAlignment(2);
        headLabel.setAlignmentY(0.0f);
        headLabel.setAlignmentX(0.0f);
        headLabel.setForeground(Color.black);
        headLabel.setFont(new Font("Dialog", 1, 14));
        headLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel headPanel = new JPanel();
        headPanel.setLayout(new FlowLayout());
        headPanel.add(headLabel);
        entryPanel.add(headPanel);
        entryPanel.add(Box.createVerticalStrut(8));
        this.screenPanel = new JPanel();
        this.screenPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        entryPanel.add(this.screenPanel);
        entryPanel.add(Box.createVerticalGlue());
        entryPanel.add(Box.createRigidArea(new Dimension(8, 8)));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setMnemonic(67);
        this.cancelButton.setEnabled(true);
        this.addKeyListenerToComponent(this.cancelButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(8));
        this.previousButton = new JButton("Previous", new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Back16.gif")));
        this.previousButton.setHorizontalTextPosition(4);
        this.previousButton.setMnemonic(80);
        this.addKeyListenerToComponent(this.previousButton);
        buttonPanel.add(this.previousButton);
        buttonPanel.add(Box.createHorizontalStrut(8));
        this.forwardIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Forward16.gif"));
        this.nextButton = new JButton("Next", this.forwardIcon);
        this.nextButton.setHorizontalTextPosition(2);
        this.nextButton.setMnemonic(78);
        this.addKeyListenerToComponent(this.nextButton);
        this.nextButton.setEnabled(true);
        buttonPanel.add(this.nextButton);
        buttonPanel.add(Box.createHorizontalStrut(8));
        entryPanel.add(buttonPanel);
        entryPanel.add(Box.createVerticalStrut(8));
        this.getContentPane().add(entryPanel);
        this.getContentPane().add(Box.createHorizontalGlue());
        this.getContentPane().add(Box.createHorizontalStrut(8));
        this.layoutScreen();
        this.pack();
        this.profileNameField.requestFocus();
        this.setResizable(false);
        Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle frameDim = this.getBounds();
        this.setLocation((screenDim.width - frameDim.width) / 2, (screenDim.height - frameDim.height) / 2);
        ActionHandler myActionHandler = new ActionHandler();
        this.previousButton.addActionListener(myActionHandler);
        this.nextButton.addActionListener(myActionHandler);
        this.cancelButton.addActionListener(myActionHandler);
        ProfileDialog profileDialog = this;
        this.config = profileDialog.framework.getConfiguration();
    }

    private void addKeyListenerToComponents(Component[] components) {
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                this.addKeyListenerToComponent(components[i]);
            }
        } else {
            Log.debug(10, "ProfileDialog.addKeyListenerToComponents() - received null array");
            return;
        }
    }

    private void addKeyListenerToComponent(Component component) {
        if (component == null) {
            Log.debug(10, "ProfileDialog.addKeyListenerToComponent() - received NULL arg");
            return;
        }
        component.addKeyListener(this.keyPressListener);
    }

    private void previousButtonHandler(ActionEvent event) {
        if (this.currentScreen > 0) {
            --this.currentScreen;
            this.layoutScreen();
        }
    }

    private void nextButtonHandler(ActionEvent event) {
        if (this.currentScreen == this.numScreens - 1) {
            this.createProfile();
        } else {
            ++this.currentScreen;
            this.layoutScreen();
        }
    }

    private void cancelButtonHandler(ActionEvent event) {
        this.dispose();
    }

    private void addLabelTextRows(JLabel[] labels, JComponent[] components, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            c.anchor = 13;
            gridbag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            gridbag.setConstraints(components[i], c);
            container.add(components[i]);
        }
    }

    private void layoutScreen() {
        this.screenPanel.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        this.screenPanel.setLayout(gridbag);
        if (0 == this.currentScreen) {
            String helpText = "<html><p>Enter the name for this profile  and your first and last name.</p></html>";
            this.helpLabel.setText(helpText);
            this.screenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), "Basic Information"));
            JLabel profileNameLabel = new JLabel();
            JLabel firstNameLabel = new JLabel();
            JLabel lastNameLabel = new JLabel();
            profileNameLabel.setText("Name of profile: ");
            firstNameLabel.setText("First name: ");
            lastNameLabel.setText("Last name: ");
            profileNameLabel.setForeground(Color.black);
            firstNameLabel.setForeground(Color.black);
            lastNameLabel.setForeground(Color.black);
            profileNameLabel.setFont(new Font("Dialog", 0, 12));
            firstNameLabel.setFont(new Font("Dialog", 0, 12));
            lastNameLabel.setFont(new Font("Dialog", 0, 12));
            profileNameLabel.setHorizontalAlignment(4);
            firstNameLabel.setHorizontalAlignment(4);
            lastNameLabel.setHorizontalAlignment(4);
            this.profileNameField.setColumns(15);
            this.firstNameField.setColumns(15);
            this.lastNameField.setColumns(15);
            JLabel[] labels = new JLabel[]{profileNameLabel, firstNameLabel, lastNameLabel};
            Component[] textFields = new JTextField[]{this.profileNameField, this.firstNameField, this.lastNameField};
            this.addLabelTextRows(labels, (JComponent[])textFields, gridbag, this.screenPanel);
            this.addKeyListenerToComponents(textFields);
        } else if (1 == this.currentScreen) {
            String helpText = "<html><p>Enter the information you submitted when you registered for the Knowledge Network for Biocomplexity (KNB). <br>If you have not registered for the KNB yet, go to: <i>http://knb.ecoinformatics.org/</i>. This will allow you to login to the network and collaborate with other researchers through the KNB.</p></html>";
            this.helpLabel.setText(helpText);
            this.screenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), "Network Account Information"));
            JLabel usernameLabel = new JLabel();
            JLabel orgLabel = new JLabel();
            usernameLabel.setText("Username: ");
            orgLabel.setText("Organization: ");
            usernameLabel.setForeground(Color.black);
            orgLabel.setForeground(Color.black);
            usernameLabel.setFont(new Font("Dialog", 0, 12));
            orgLabel.setFont(new Font("Dialog", 0, 12));
            usernameLabel.setHorizontalAlignment(4);
            orgLabel.setHorizontalAlignment(4);
            this.userIdField.setColumns(15);
            Vector orgs = this.config.get("organization");
            String[] organizations = orgs.toArray(new String[0]);
            this.orgList = new JList<String>(organizations);
            this.orgList.setSelectionMode(1);
            this.orgList.setVisibleRowCount(3);
            this.orgList.setSelectedIndex(0);
            JScrollPane orgScrollPane = new JScrollPane(this.orgList);
            JLabel[] labels = new JLabel[]{usernameLabel, orgLabel};
            Component[] components = new JComponent[]{this.userIdField, orgScrollPane};
            this.addLabelTextRows(labels, (JComponent[])components, gridbag, this.screenPanel);
            this.addKeyListenerToComponents(components);
            this.userIdField.requestFocus();
        } else if (2 == this.currentScreen) {
            String helpText = "<html><p>Enter a short identifier prefix for this profile. All data packages you create under this profile will bear this identifier prefix. For example, using the prefix 'jane_doe', data packages will have names like jane_doe.1.1, jane_doe.2.1, etc.</p></html>";
            this.helpLabel.setText(helpText);
            this.screenPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8), "Data Package Identification"));
            JLabel scopeLabel = new JLabel("Identifier prefix: ");
            scopeLabel.setForeground(Color.black);
            scopeLabel.setFont(new Font("Dialog", 0, 12));
            this.scopeField.setColumns(15);
            this.scopeField.setText(this.userIdField.getText());
            JLabel[] labels = new JLabel[]{scopeLabel};
            Component[] textFields = new JTextField[]{this.scopeField};
            this.addLabelTextRows(labels, (JComponent[])textFields, gridbag, this.screenPanel);
            this.addKeyListenerToComponents(textFields);
            this.scopeField.requestFocus();
        }
        if (0 == this.currentScreen) {
            this.previousButton.setEnabled(false);
        } else {
            this.previousButton.setEnabled(true);
        }
        if (this.currentScreen == this.numScreens - 1) {
            this.nextButton.setEnabled(true);
            this.nextButton.setText("Finished");
            this.nextButton.setIcon(null);
        } else {
            this.nextButton.setEnabled(true);
            this.nextButton.setText("Next");
            this.nextButton.setIcon(this.forwardIcon);
        }
        this.nextButton.isDefaultButton();
        this.screenPanel.validate();
        this.screenPanel.paint(this.screenPanel.getGraphics());
    }

    private boolean validateFieldContents() {
        String org;
        boolean fieldsAreValid = true;
        if (this.profileNameField.getText() == null || this.profileNameField.getText().equals("")) {
            fieldsAreValid = false;
        }
        if (this.userIdField.getText() == null || this.userIdField.getText().equals("")) {
            fieldsAreValid = false;
        }
        if (null == (org = (String)this.orgList.getSelectedValue())) {
            Log.debug(20, "org was initially null");
            fieldsAreValid = false;
        }
        if (this.scopeField.getText() == null || this.scopeField.getText().equals("")) {
            fieldsAreValid = false;
        }
        return fieldsAreValid;
    }

    private void createProfile() {
        if (this.validateFieldContents()) {
            ProfileDialog profileDialog = this;
            String profileDirName = profileDialog.config.getConfigDirectory() + File.separator + this.config.get("profile_directory", 0);
            File profileDirFile = new File(profileDirName);
            if (!profileDirFile.exists() && !profileDirFile.mkdir()) {
                this.currentScreen = 0;
                this.layoutScreen();
                String messageText = "Error creating the profiles directory.\n";
                JOptionPane.showMessageDialog(this, messageText);
            }
            String profileName = this.profileNameField.getText();
            String username = this.userIdField.getText();
            String org = (String)this.orgList.getSelectedValue();
            String scope = this.scopeField.getText();
            String profilePath = profileDirName + File.separator + profileName;
            String profileFileName = profilePath + File.separator + profileName + ".xml";
            File profileDir = new File(profilePath);
            if (!profileDir.mkdir()) {
                this.currentScreen = 0;
                this.layoutScreen();
                String messageText = "A profile named \"" + profileName + "\" already exists.  Would you like to use it?" + "\n\nUse existing profile?\n";
                int result = JOptionPane.showConfirmDialog(this, messageText, "Use existing profile?", 0);
                if (result == 0) {
                    try {
                        ConfigXML profile = new ConfigXML(profileFileName);
                        this.framework.setProfile(profile);
                        this.setVisible(false);
                        this.dispose();
                    }
                    catch (FileNotFoundException fnf) {
                        messageText = "Sorry, I tried, but it looks like that profile\nis corrupted.  You'll have to choose another profile name.";
                        JOptionPane.showMessageDialog(this, messageText);
                    }
                } else {
                    messageText = "OK, then please choose another profile name.\n";
                    JOptionPane.showMessageDialog(this, messageText);
                }
            } else {
                try {
                    int len;
                    String defaultProfile = this.config.get("default_profile", 0);
                    ClassLoader cl = this.getClass().getClassLoader();
                    InputStreamReader in = new InputStreamReader(cl.getResourceAsStream(defaultProfile));
                    FileWriter out = new FileWriter(new File(profileFileName));
                    char[] buffer = new char[512];
                    while ((len = in.read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                    }
                    in.close();
                    out.close();
                    ConfigXML profile = new ConfigXML(profileFileName);
                    boolean success = false;
                    if (!profile.set("profilename", 0, profileName)) {
                        success = profile.insert("profilename", profileName);
                    }
                    if (!profile.set("username", 0, username)) {
                        success = profile.insert("username", username);
                    }
                    if (!profile.set("organization", 0, org)) {
                        success = profile.insert("organization", org);
                    }
                    if (!profile.set("firstname", 0, this.firstNameField.getText())) {
                        success = profile.insert("firstname", this.firstNameField.getText());
                    }
                    if (!profile.set("lastname", 0, this.lastNameField.getText())) {
                        success = profile.insert("lastname", this.lastNameField.getText());
                    }
                    if (!profile.set("scope", 0, scope)) {
                        success = profile.insert("scope", scope);
                    }
                    StringBuffer dn = new StringBuffer();
                    String uidtag = this.config.get("uid_tag", 0);
                    String orgtag = this.config.get("org_tag", 0);
                    String ldapbase = this.config.get("ldapbase", 0);
                    dn.append(uidtag + "=" + username);
                    dn.append("," + orgtag + "=" + org);
                    dn.append("," + ldapbase);
                    if (!profile.set("dn", 0, dn.toString())) {
                        success = profile.insert("dn", dn.toString());
                    }
                    profile.save();
                    String dataDirName = profile.get("datadir", 0);
                    String dataPath = profilePath + File.separator + dataDirName;
                    File dataDir = new File(dataPath);
                    success = dataDir.mkdir();
                    String cacheDirName = profile.get("cachedir", 0);
                    String cachePath = profilePath + File.separator + cacheDirName;
                    File cacheDir = new File(cachePath);
                    success = cacheDir.mkdir();
                    String tempDirName = profile.get("tempdir", 0);
                    String tempPath = profilePath + File.separator + tempDirName;
                    File tempDir = new File(tempPath);
                    success = tempDir.mkdir();
                    Hashtable<String, String> tokens = new Hashtable<String, String>();
                    tokens.put("SCOPE", profileName);
                    String samplePath = this.config.get("samples_directory", 0);
                    File sampleDir = new File(samplePath);
                    File[] samplesList = this.listFiles(sampleDir);
                    for (int n = 0; n < samplesList.length; ++n) {
                        File srcFile = samplesList[n];
                        if (!srcFile.isFile()) continue;
                        String destDirName = dataPath + File.separator + "jscientist";
                        File destDir = new File(destDirName);
                        destDir.mkdirs();
                        String destName = destDirName + File.separator + srcFile.getName();
                        Log.debug(20, destName);
                        FileUtils.copy(srcFile.getAbsolutePath(), destName, tokens);
                    }
                    this.framework.setProfile(profile);
                    this.setVisible(false);
                    this.dispose();
                }
                catch (IOException ioe) {
                    this.currentScreen = 0;
                    this.layoutScreen();
                    String messageText = "Error creating profile named \"" + profileName + "\".  Please try again.\n";
                    JOptionPane.showMessageDialog(this, messageText);
                }
            }
        } else {
            this.currentScreen = 0;
            this.layoutScreen();
            String messageText = "Some required information was invalid.\n\nPlease check that you have provided a\nprofile name, a user name, an organization,\nand an identifer prefix.\n";
            JOptionPane.showMessageDialog(this, messageText);
        }
    }

    private File[] listFiles(File dir) {
        String[] fileStrings = dir.list();
        int len = fileStrings.length;
        File[] list = new File[len];
        for (int i = 0; i < len; ++i) {
            list[i] = new File(dir, fileStrings[i]);
        }
        return list;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ProfileDialog.this.previousButton) {
                ProfileDialog.this.previousButtonHandler(event);
            } else if (object == ProfileDialog.this.nextButton) {
                ProfileDialog.this.nextButtonHandler(event);
            } else if (object == ProfileDialog.this.cancelButton) {
                ProfileDialog.this.cancelButtonHandler(event);
            }
        }
    }

    class KeyPressActionListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (e.getSource() instanceof JButton) {
                    ((JButton)e.getSource()).doClick();
                } else {
                    ActionEvent event = new ActionEvent(ProfileDialog.this.nextButton, 0, "Next");
                    ProfileDialog.this.nextButtonHandler(event);
                }
            } else if (e.getKeyCode() == 27) {
                ProfileDialog.this.dispose();
                ActionEvent event = new ActionEvent(ProfileDialog.this.cancelButton, 0, "Cancel");
                ProfileDialog.this.cancelButtonHandler(event);
            }
        }
    }
}

