/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.LoginClientInterface;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;

public class LoginCommand
implements Command {
    private Morpho morpho;
    private LoginClientInterface loginClient;

    public LoginCommand(Morpho morpho, LoginClientInterface loginClient) {
        this.morpho = morpho;
        this.loginClient = loginClient;
    }

    public void execute(ActionEvent event) {
        Thread worker = new Thread(){

            public void run() {
                if (LoginCommand.this.morpho != null) {
                    LoginCommand.this.morpho.setPassword(LoginCommand.this.loginClient.getPassword());
                }
                final boolean connected = LoginCommand.this.morpho.logIn();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (connected) {
                            ConfigXML profile = LoginCommand.this.morpho.getProfile();
                            profile.set("searchmetacat", 0, "true");
                            profile.save();
                            Log.debug(12, "LoginCommand: Login successful");
                            LoginCommand.this.loginClient.setLoginSuccessful(true);
                        } else {
                            Log.debug(12, "LoginCommand: Login failed");
                            LoginCommand.this.loginClient.setLoginSuccessful(false);
                        }
                    }
                });
            }
        };
        worker.start();
    }
}

