/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class ConfigXML {
    private Node root;
    private Document doc;
    private String fileName;
    private PrintWriter out;
    private static final String configDirectory = ".morpho";

    public ConfigXML(String filename) throws FileNotFoundException {
        this.fileName = filename;
        DocumentBuilder parser = Morpho.createDomParser();
        File XMLConfigFile = new File(filename);
        FileInputStream fs = new FileInputStream(filename);
        InputSource in = new InputSource(fs);
        try {
            this.doc = parser.parse(in);
            fs.close();
        }
        catch (Exception e1) {
            Log.debug(4, "Parsing " + filename + " threw: " + e1.toString());
            e1.printStackTrace();
        }
        this.root = this.doc.getDocumentElement();
    }

    public ConfigXML(InputStream configStream) throws FileNotFoundException {
        DocumentBuilder parser = Morpho.createDomParser();
        InputSource in = new InputSource(configStream);
        try {
            this.doc = parser.parse(in);
            configStream.close();
        }
        catch (Exception e1) {
            Log.debug(4, "Parsing config file threw: " + e1.toString());
            e1.printStackTrace();
        }
        this.root = this.doc.getDocumentElement();
    }

    private static DocumentBuilder createDomParser() throws Exception {
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            parser = factory.newDocumentBuilder();
            if (parser == null) {
                throw new Exception("Could not create Document parser in MonarchUtil.DocumentBuilder");
            }
        }
        catch (ParserConfigurationException pce) {
            throw new Exception("Could not create Document parser in MonarchUtil.DocumentBuilder: " + pce.getMessage());
        }
        return parser;
    }

    public Vector get(String key) {
        NodeList nl = this.doc.getElementsByTagName(key);
        Vector<String> result = new Vector<String>();
        if (nl.getLength() < 1) {
            return result;
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node cn = nl.item(i).getFirstChild();
            if (cn == null || cn.getNodeType() != 3) continue;
            String temp = cn.getNodeValue();
            result.addElement(temp.trim());
        }
        return result;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Node getRoot() {
        return this.root;
    }

    public String get(String key, int i) {
        NodeList nl = this.doc.getElementsByTagName(key);
        String result = null;
        if (nl.getLength() < 1) {
            return result;
        }
        if (nl.getLength() < i) {
            return result;
        }
        Node cn = nl.item(i).getFirstChild();
        if (cn != null && cn.getNodeType() == 3) {
            result = cn.getNodeValue().trim();
        }
        return result;
    }

    public boolean set(String key, int i, String value) {
        boolean result = false;
        NodeList nl = this.doc.getElementsByTagName(key);
        if (nl.getLength() <= i) {
            result = false;
        } else {
            Node cn = nl.item(i).getFirstChild();
            if (cn == null) {
                Text newText = this.doc.createTextNode(value);
                nl.item(i).appendChild(newText);
            } else if (cn.getNodeType() == 3) {
                cn.setNodeValue(value);
            }
            result = true;
        }
        return result;
    }

    public boolean insert(String key, String value) {
        boolean result = false;
        Element newElem = this.doc.createElement(key);
        Text newText = this.doc.createTextNode(value);
        newElem.appendChild(newText);
        NodeList nl = this.doc.getElementsByTagName(key);
        if (nl.getLength() > 0) {
            Node nnn = nl.item(0);
            Node parent = nnn.getParentNode();
            parent.insertBefore(newElem, nnn);
            result = true;
        } else {
            this.root.appendChild(newElem);
            result = true;
        }
        return result;
    }

    public void addChild(String parentName, int i, String childName, String value) {
        NodeList nl = this.doc.getElementsByTagName(parentName);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                Log.debug(7, "Error setting XMLConfig value: index too large");
            } else {
                Node parent = nl.item(i);
                Element newElem = this.doc.createElement(childName);
                Text newText = this.doc.createTextNode(value);
                newElem.appendChild(newText);
                parent.appendChild(newElem);
            }
        }
    }

    public void removeNode(String nodeName, int i) {
        NodeList nl = this.doc.getElementsByTagName(nodeName);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                Log.debug(7, "Error setting XMLConfig value: index too large");
            } else {
                Node nnn = nl.item(i);
                Node parent = nnn.getParentNode();
                parent.removeChild(nnn);
            }
        }
    }

    public void removeChildren(String parentName, int i) {
        NodeList nl = this.doc.getElementsByTagName(parentName);
        if (nl.getLength() > 0) {
            if (nl.getLength() <= i) {
                Log.debug(7, "Error setting XMLConfig value: index too large");
            } else {
                Node parent = nl.item(i);
                NodeList nlchildren = parent.getChildNodes();
                int numchildren = nlchildren.getLength();
                for (int k = 0; k < numchildren; ++k) {
                    Node temp = nlchildren.item(0);
                    parent.removeChild(temp);
                }
            }
        }
    }

    public Hashtable getHashtable(String parentName, String keyName, String valueName) {
        NodeList children;
        String keyval = "";
        String valval = "";
        Hashtable<String, String> ht = new Hashtable<String, String>();
        NodeList nl = this.doc.getElementsByTagName(parentName);
        if (nl.getLength() > 0 && (children = nl.item(0).getChildNodes()).getLength() > 0) {
            for (int j = 0; j < children.getLength(); ++j) {
                Node ccn;
                Node cn = children.item(j);
                if (cn.getNodeType() == 1 && cn.getNodeName().equalsIgnoreCase(keyName) && (ccn = cn.getFirstChild()) != null && ccn.getNodeType() == 3) {
                    keyval = ccn.getNodeValue();
                }
                if (cn.getNodeType() != 1 || !cn.getNodeName().equalsIgnoreCase(valueName) || (ccn = cn.getFirstChild()) == null || ccn.getNodeType() != 3) continue;
                valval = ccn.getNodeValue();
                ht.put(keyval, valval);
            }
        }
        return ht;
    }

    public void save() {
        this.saveDOM(this.root);
    }

    public void saveDOM(Node nd) {
        File outfile = new File(this.fileName);
        if (!outfile.canWrite()) {
            JOptionPane.showMessageDialog(null, "Cannot Save configuration information to " + this.fileName + " !", "alert", 0);
        } else {
            try {
                this.out = new PrintWriter(new FileWriter(this.fileName));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out.println("<?xml version=\"1.0\"?>");
            this.print(nd, this.out);
            this.out.close();
        }
    }

    public void print(Node node, PrintWriter out) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\"?>");
                this.print(((Document)node).getDocumentElement(), out);
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(XMLUtil.normalize(attr.getNodeValue()));
                    out.print('\"');
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    this.print(children.item(i), out);
                }
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.print("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.print(">\n");
        }
        out.flush();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    public Vector getValuesForPath(String pathstring) {
        Vector<String> val = new Vector<String>();
        if (!pathstring.startsWith("/")) {
            pathstring = "//*/" + pathstring;
        }
        try {
            NodeList nl = null;
            nl = XPathAPI.selectNodeList((Node)this.doc, (String)pathstring);
            if (nl != null && nl.getLength() > 0) {
                for (int k = 0; k < nl.getLength(); ++k) {
                    Node cn = nl.item(k).getFirstChild();
                    if (cn == null || cn.getNodeType() != 3) continue;
                    String temp = cn.getNodeValue().trim();
                    val.addElement(temp);
                }
            }
        }
        catch (Exception e) {
            Log.debug(4, "Error in getValueForPath method");
        }
        return val;
    }

    public NodeList getPathContent(String path) {
        try {
            NodeList docNodeList = XPathAPI.selectNodeList((Node)this.doc, (String)path);
            return docNodeList;
        }
        catch (TransformerException se) {
            System.err.println(se.toString());
            return null;
        }
    }

    public static String getConfigDirectory() {
        return System.getProperty("user.home") + File.separator + configDirectory;
    }

    public void sort(String xsltStylesheet) throws Exception {
        StringWriter resultWriter = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer(new StreamSource(new StringReader(xsltStylesheet)));
        transformer.transform(new DOMSource(this.root), new StreamResult(resultWriter));
        String result = resultWriter.toString();
        DocumentBuilder parser = ConfigXML.createDomParser();
        InputSource in = new InputSource(new StringReader(result));
        this.doc = parser.parse(in);
        this.root = this.doc.getDocumentElement();
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.print(this.root, new PrintWriter(sw));
        return sw.toString();
    }
}

