/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.Triple;
import edu.ucsb.nceas.morpho.datapackage.TripleCollection;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class TripleParser
extends DefaultHandler {
    private Triple triple;
    private TripleCollection collection = new TripleCollection();
    String tag = "";
    boolean instart = true;

    public TripleParser(Reader xml) {
        this.doInit(xml, null);
    }

    public TripleParser(Reader xml, CatalogEntityResolver cer) {
        this.doInit(xml, cer);
    }

    private void doInit(Reader xml, CatalogEntityResolver cer) {
        XMLReader parser = Morpho.createSaxParser(this, this);
        if (parser == null) {
            System.err.println("SAX parser not instantiated properly.");
        }
        try {
            if (cer != null) {
                parser.setEntityResolver(cer);
            }
            parser.parse(new InputSource(xml));
        }
        catch (SAXException e) {
            System.err.println("error parsing data in TripleParser.TripleParser");
            System.err.println(e.getMessage());
            e.printStackTrace(System.out);
        }
        catch (IOException ioe) {
            System.out.println("IO Exception: ");
            ioe.printStackTrace(System.out);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.tag = localName;
        if (localName.equals("triple")) {
            this.triple = new Triple();
        }
        this.instart = true;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (localName.equals("triple")) {
            this.collection.addTriple(this.triple);
        }
        this.instart = false;
    }

    public void characters(char[] ch, int start, int length) {
        if (this.instart) {
            String content = new String(ch, start, length);
            if (this.tag.equals("subject")) {
                this.triple.setSubject(content);
            } else if (this.tag.equals("relationship")) {
                this.triple.setRelationship(content);
            } else if (this.tag.equals("object")) {
                this.triple.setObject(content);
            }
        }
    }

    public TripleCollection getTriples() {
        return this.collection;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: TripleParser <xml_file>");
            return;
        }
        String filename = args[0];
        System.out.println("Parsing " + args[0]);
        try {
            FileReader xml = new FileReader(new File(filename));
            TripleParser tp = new TripleParser(xml);
            System.out.println("Triples are:");
            System.out.println(tp.getTriples().toString());
        }
        catch (Exception e) {
            System.out.println("error in main");
            e.printStackTrace(System.out);
        }
        System.out.println("Done parsing " + args[0]);
    }
}

