/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class DelimiterField
extends JTextField {
    private String delimiter = null;
    private JPanel parent = null;

    public DelimiterField(JPanel container, String delimiter, String value, int columns) {
        super(columns);
        this.parent = container;
        this.delimiter = delimiter;
        this.setValue(value);
    }

    public String getValue() {
        String retVal = "";
        retVal = this.getText();
        return retVal;
    }

    public void setValue(String value) {
        this.setText(value);
    }

    public void setText(String value) {
        super.setText(value);
        this.selectAll();
    }

    protected Document createDefaultModel() {
        return new NoDelimiterDocument();
    }

    protected class NoDelimiterDocument
    extends PlainDocument {
        protected NoDelimiterDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String error = "Your data file uses this character as a delimiter.\nIt cannot be used inside data field!";
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (source[i] != DelimiterField.this.delimiter.charAt(0)) {
                    result[j++] = source[i];
                    continue;
                }
                JOptionPane pane = new JOptionPane(error, 0);
                JDialog dialog = pane.createDialog(DelimiterField.this.parent, "Alert!");
                dialog.setResizable(false);
                dialog.setVisible(true);
                dialog.setModal(true);
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

