/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.EML200DataPackage;
import edu.ucsb.nceas.morpho.datapackage.EML2Beta6DataPackage;
import edu.ucsb.nceas.morpho.datastore.FileSystemDataStore;
import edu.ucsb.nceas.morpho.datastore.MetacatDataStore;
import edu.ucsb.nceas.morpho.editor.DocFrame;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DataPackageFactory {
    protected static String docType = null;
    protected static Morpho morpho = null;

    public static AbstractDataPackage getDataPackage(Reader in, boolean metacat, boolean local) {
        String location = null;
        if (metacat && !local) {
            location = "metacat";
        }
        if (!metacat && local) {
            location = "local";
        }
        if (metacat && local) {
            location = "localmetacat";
        }
        AbstractDataPackage dp = null;
        String type = DataPackageFactory.getDocTypeInfo(in);
        if (type.indexOf("eml://ecoinformatics.org/eml-2.0") > -1) {
            dp = new EML200DataPackage();
            try {
                in.reset();
            }
            catch (IOException ioe) {
                Log.debug(15, "!!ERROR!! Unable reset XML input stream");
            }
            ((AbstractDataPackage)dp).load(new InputSource(in));
        } else if (type.indexOf("eml-dataset-2.0.0beta6") > -1 || type.indexOf("eml-dataset-2.0.0beta4") > -1) {
            dp = new EML2Beta6DataPackage();
        }
        return dp;
    }

    public static AbstractDataPackage getDataPackage(String docid, boolean metacat, boolean local) {
        File file;
        morpho = Morpho.thisStaticInstance;
        if (morpho == null) {
            Morpho.createMorphoInstance();
            morpho = Morpho.thisStaticInstance;
        }
        String location = null;
        if (metacat && !local) {
            location = "metacat";
        }
        if (!metacat && local) {
            location = "local";
        }
        if (metacat && local) {
            location = "localmetacat";
        }
        FileReader in = null;
        if (location.equals("local") || location.equals("localmetacat")) {
            FileSystemDataStore fsds = new FileSystemDataStore(morpho);
            try {
                file = fsds.openFile(docid);
                in = new FileReader(file);
            }
            catch (Exception w) {
                Log.debug(20, "Problem opening file!");
            }
        } else {
            MetacatDataStore mds = new MetacatDataStore(morpho);
            try {
                file = mds.openFile(docid);
                in = new FileReader(file);
            }
            catch (Exception e) {
                Log.debug(20, "Problem opening file from Metacat!");
            }
        }
        AbstractDataPackage dp = null;
        String type = DataPackageFactory.getDocTypeInfo(in);
        Log.debug(40, "DocTypeInfo: " + type);
        try {
            if (in != null) {
                ((Reader)in).close();
            }
        }
        catch (IOException ie) {
            Log.debug(40, "Sorry - Couldn't close the package");
        }
        if (type.indexOf("eml://ecoinformatics.org/eml-2.0") > -1) {
            dp = new EML200DataPackage();
            dp.load(location, docid, morpho);
            dp.setInitialId(docid);
        } else if (type.indexOf("eml-dataset-2.0.0beta6") > -1 || type.indexOf("eml-dataset-2.0.0beta4") > -1) {
            EML2Beta6DataPackage adptemp = new EML2Beta6DataPackage();
            adptemp.setInitialId(docid);
            ((AbstractDataPackage)adptemp).load(location, docid, morpho);
            dp = DataPackageFactory.getDataPackage(adptemp.metadataNode);
            dp.setInitialId(docid);
        }
        return dp;
    }

    public static AbstractDataPackage getDataPackage(Node node) {
        EML200DataPackage dp = null;
        String doctype = DataPackageFactory.getDocType(node);
        if (doctype.indexOf("eml-2.0") > -1) {
            dp = new EML200DataPackage();
            try {
                Node metadataPathNode = XMLUtilities.getXMLAsDOMTreeRootNode((String)"/eml200KeymapConfig.xml");
                dp.setMetadataPath(metadataPathNode);
            }
            catch (Exception e2) {
                Log.debug(20, "getting DOM for Paths threw error: " + e2.toString());
                e2.printStackTrace();
            }
            dp.grammar = "eml:eml";
            dp.metadataNode = node;
        }
        if (dp == null) {
            Log.debug(1, "DOM document type is unknown! (DataPackaqeFactory.getDataPackage)");
        }
        return dp;
    }

    protected static String getDocTypeInfo(Reader in) {
        String temp = DataPackageFactory.getSchemaLine(in, 2);
        if (temp.indexOf("DOCTYPE") > -1) {
            StringTokenizer st;
            if (temp.indexOf("PUBLIC") > -1) {
                StringTokenizer st2 = new StringTokenizer(temp = temp.substring(temp.indexOf("PUBLIC")), " ");
                if (st2.countTokens() > 1) {
                    String temp1 = st2.nextToken();
                    docType = temp1 = st2.nextToken();
                }
            } else if (temp.indexOf("SYSTEM") > -1 && (st = new StringTokenizer(temp = temp.substring(temp.indexOf("SYSTEM")), " ")).countTokens() > 1) {
                String temp1 = st.nextToken();
                docType = temp1 = st.nextToken();
            }
        } else {
            StringTokenizer st = new StringTokenizer(temp, " ");
            String temp1 = st.nextToken();
            int colon_pos = temp1.indexOf(":");
            if (colon_pos > -1) {
                String ns_abrev = temp1.substring(0, colon_pos);
                int ns_dec_pos = temp.indexOf("xmlns:" + ns_abrev + "=\"");
                if (ns_dec_pos > -1) {
                    int len = ("xmlns:" + ns_abrev + "=\"").length();
                    int end = temp.indexOf("\"", ns_dec_pos + len + 1);
                    String ns = temp.substring(ns_dec_pos, end + 1);
                    String ns1 = ns.substring(ns.indexOf("\"") + 1, ns.length() - 1);
                    Log.debug(40, "namespace: " + ns1);
                    docType = ns1;
                }
            } else {
                docType = temp1;
            }
        }
        return docType;
    }

    protected static String getSchemaLine(Reader xml, int linenum) {
        String secondLine = null;
        int count = 0;
        boolean endIndex = false;
        boolean startIndex = false;
        StringBuffer buffer = new StringBuffer();
        boolean comment = false;
        int thirdPreviousCharacter = 63;
        int secondPreviousCharacter = 63;
        int previousCharacter = 63;
        int currentCharacter = 63;
        try {
            while (true) {
                char c = (char)xml.read();
                currentCharacter = c;
                if (c == '\uffffffff') break;
                if (currentCharacter == 45 && previousCharacter == 45 && secondPreviousCharacter == 33 && thirdPreviousCharacter == 60) {
                    --count;
                    buffer = new StringBuffer();
                    comment = true;
                }
                if (comment && currentCharacter == 62 && previousCharacter == 45 && secondPreviousCharacter == 45) {
                    comment = false;
                }
                if (previousCharacter == 60 && !comment) {
                    ++count;
                }
                if (count == linenum && currentCharacter != 62) {
                    buffer.append((char)currentCharacter);
                }
                if (count == linenum && currentCharacter == 62) break;
                thirdPreviousCharacter = secondPreviousCharacter;
                secondPreviousCharacter = previousCharacter;
                previousCharacter = currentCharacter;
            }
            secondLine = buffer.toString();
            Log.debug(25, "the second line string is: " + secondLine);
        }
        catch (Exception e) {
            Log.debug(6, "Sorry - Unable to Open the Requested Data Package!");
            Log.debug(20, "Error in getSchemaLine!");
        }
        return secondLine;
    }

    public static String getDocType(Node rNode) {
        Element rootNode = (Element)rNode;
        Document domDoc = rootNode.getOwnerDocument();
        Log.debug(50, "domDoc is: " + XMLUtilities.getDOMTreeAsString((Node)rootNode));
        String identifier = null;
        if (domDoc.getDoctype() != null) {
            identifier = domDoc.getDoctype().getPublicId();
            Log.debug(50, "getPublicId() gives: " + identifier);
        }
        if ((identifier == null || identifier.trim().equals("")) && (identifier = rootNode.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation")) != null && !identifier.trim().equals("")) {
            identifier = identifier.trim().substring(0, identifier.indexOf(" "));
            Log.debug(50, "getAttributeNS schemaLocation is: " + identifier);
        }
        if (identifier == null || identifier.trim().equals("")) {
            identifier = rootNode.getNamespaceURI();
            Log.debug(50, "rootNode.getNamespaceURI() gives: " + identifier);
        }
        if (identifier == null || identifier.trim().equals("")) {
            identifier = "no identifier";
            Log.debug(50, "no identifier - requesting generic stylesheet");
        }
        return identifier;
    }

    public static void main(String[] args) {
        Object attrRoot = null;
        Object entRoot = null;
        OrderedMap om = new OrderedMap();
        OrderedMap om1 = new OrderedMap();
        AbstractDataPackage adp = null;
        Object entityObject = null;
        Object attributeObject = null;
        try {
            Morpho.createMorphoInstance();
            adp = DataPackageFactory.getDataPackage("jscientist.7.1", false, true);
            Document doc = adp.getMetadataNode().getOwnerDocument();
            Element elem = doc.createElement("temporalCoverage");
            Text txt = doc.createTextNode("when");
            elem.appendChild(txt);
            adp.insertCoverage(elem);
            adp.showPackageSummary();
            Node node = adp.getSubtree("intellectualRights", 0);
            String val = node.getFirstChild().getNodeValue();
            Log.debug(1, "node: " + val);
            node.getFirstChild().setNodeValue("No Rights for YOU!");
            Node delNode = adp.deleteSubtree("intellectualRights", 0);
            Log.debug(1, "delNode: " + delNode);
            Node insNode = adp.insertSubtree("intellectualRights", node, 1);
            Log.debug(1, "insNode: " + insNode);
        }
        catch (Exception w) {
            Log.debug(5, "problem creating ordered map!");
        }
        Log.debug(1, "AbstractDataPackage complete - Will now show in an XML Editor..");
        Node domnode = adp.getMetadataNode();
        DocFrame df = new DocFrame();
        df.setVisible(true);
        df.initDoc(null, domnode, null, null, null);
    }
}

