/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.JDayChooser;
import com.toedter.calendar.JMonthChooser;
import com.toedter.calendar.JYearChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JCalendar
extends JPanel
implements PropertyChangeListener {
    protected JYearChooser yearChooser = null;
    protected JMonthChooser monthChooser = null;
    protected JDayChooser dayChooser = null;
    private Calendar calendar;
    private Locale locale = Locale.getDefault();
    private boolean initialized = false;

    public JCalendar() {
        this(0);
    }

    public JCalendar(int monthSpinner) {
        this.calendar = Calendar.getInstance();
        this.setLayout(new BorderLayout());
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new GridLayout(1, 3));
        this.monthChooser = new JMonthChooser(monthSpinner);
        this.yearChooser = new JYearChooser();
        this.monthChooser.setYearChooser(this.yearChooser);
        myPanel.add(this.monthChooser);
        myPanel.add(this.yearChooser);
        this.dayChooser = new JDayChooser();
        this.dayChooser.addPropertyChangeListener(this);
        this.monthChooser.setDayChooser(this.dayChooser);
        this.monthChooser.addPropertyChangeListener(this);
        this.yearChooser.setDayChooser(this.dayChooser);
        this.yearChooser.addPropertyChangeListener(this);
        this.add((Component)myPanel, "North");
        this.add((Component)this.dayChooser, "Center");
        this.initialized = true;
    }

    private void setCalendar(Calendar c, boolean update) {
        Calendar oldCalendar = this.calendar;
        this.calendar = c;
        if (update) {
            this.yearChooser.setYear(c.get(1));
            this.monthChooser.setMonth(c.get(2));
            this.dayChooser.setDay(c.get(5));
        }
        this.firePropertyChange("calendar", oldCalendar, this.calendar);
    }

    public void setCalendar(Calendar c) {
        this.setCalendar(c, true);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            Locale oldLocale = this.locale;
            this.locale = l;
            this.dayChooser.setLocale(this.locale);
            this.monthChooser.setLocale(this.locale);
            this.firePropertyChange("locale", oldLocale, this.locale);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.dayChooser != null) {
            this.dayChooser.setFont(font);
            this.monthChooser.setFont(font);
            this.yearChooser.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.dayChooser != null) {
            this.dayChooser.setForeground(fg);
            this.monthChooser.setForeground(fg);
            this.yearChooser.setForeground(fg);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.dayChooser != null) {
            this.dayChooser.setBackground(bg);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.calendar != null) {
            Calendar c = (Calendar)this.calendar.clone();
            if (evt.getPropertyName().equals("day")) {
                c.set(5, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("month")) {
                c.set(2, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            } else if (evt.getPropertyName().equals("year")) {
                c.set(1, (Integer)evt.getNewValue());
                this.setCalendar(c, false);
            }
        }
    }

    public String getName() {
        return "JCalendar";
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dayChooser != null) {
            this.dayChooser.setEnabled(enabled);
            this.monthChooser.setEnabled(enabled);
            this.yearChooser.setEnabled(enabled);
        }
    }

    public JDayChooser getDayChooser() {
        return this.dayChooser;
    }

    public JMonthChooser getMonthChooser() {
        return this.monthChooser;
    }

    public JYearChooser getYearChooser() {
        return this.yearChooser;
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JCalendar");
        frame.getContentPane().add(new JCalendar());
        frame.pack();
        frame.setVisible(true);
    }
}

