/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.model;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.io.IOException;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.Shape;
import org.apache.poi.hslf.model.ShapeGroup;
import org.apache.poi.hslf.model.Sheet;
import org.apache.poi.hslf.model.SimpleShape;
import org.apache.poi.hslf.model.TextRun;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.OutlineTextRefAtom;
import org.apache.poi.hslf.record.PPDrawing;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.StyleTextPropAtom;
import org.apache.poi.hslf.record.TextCharsAtom;
import org.apache.poi.hslf.record.TextHeaderAtom;
import org.apache.poi.hslf.usermodel.RichTextRun;

public class TextBox
extends SimpleShape {
    public static final int AnchorTop = 0;
    public static final int AnchorMiddle = 1;
    public static final int AnchorBottom = 2;
    public static final int AnchorTopCentered = 3;
    public static final int AnchorMiddleCentered = 4;
    public static final int AnchorBottomCentered = 5;
    public static final int AnchorTopBaseline = 6;
    public static final int AnchorBottomBaseline = 7;
    public static final int AnchorTopCenteredBaseline = 8;
    public static final int AnchorBottomCenteredBaseline = 9;
    public static final int WrapSquare = 0;
    public static final int WrapByPoints = 1;
    public static final int WrapNone = 2;
    public static final int WrapTopBottom = 3;
    public static final int WrapThrough = 4;
    public static final int AlignLeft = 0;
    public static final int AlignCenter = 1;
    public static final int AlignRight = 2;
    public static final int AlignJustify = 3;
    protected TextRun _txtrun;
    protected EscherTextboxWrapper _txtbox;
    private boolean _missingTextRecords = false;

    protected TextBox(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
        EscherTextboxRecord textbox = (EscherTextboxRecord)Shape.getEscherChild(this._escherContainer, -4083);
        this._txtbox = new EscherTextboxWrapper(textbox);
    }

    public TextBox(Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(parent instanceof ShapeGroup);
    }

    public TextBox() {
        this(null);
    }

    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherContainerRecord spcont = super.createSpContainer(isChild);
        EscherSpRecord spRecord = spcont.getChildById((short)-4086);
        short type = 3234;
        spRecord.setOptions(type);
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(spcont, -4085);
        TextBox.setEscherProperty(opt, (short)128, 0);
        TextBox.setEscherProperty(opt, (short)385, 0x8000004);
        TextBox.setEscherProperty(opt, (short)387, 0x8000000);
        TextBox.setEscherProperty(opt, (short)447, 0x100000);
        TextBox.setEscherProperty(opt, (short)448, 0x8000001);
        TextBox.setEscherProperty(opt, (short)511, 524288);
        TextBox.setEscherProperty(opt, (short)513, 0x8000002);
        this._txtbox = new EscherTextboxWrapper();
        TextHeaderAtom tha = new TextHeaderAtom();
        tha.setParentRecord(this._txtbox);
        this._txtbox.appendChildRecord(tha);
        TextCharsAtom tca = new TextCharsAtom();
        this._txtbox.appendChildRecord(tca);
        StyleTextPropAtom sta = new StyleTextPropAtom(0);
        this._txtbox.appendChildRecord(sta);
        this._txtrun = new TextRun(tha, tca, sta);
        this._txtrun.setText("");
        spcont.addChildRecord((EscherRecord)this._txtbox.getEscherRecord());
        return spcont;
    }

    public String getText() {
        return this._txtrun == null ? null : this._txtrun.getText();
    }

    public void setText(String text) {
        this._txtrun.setText(text);
    }

    protected void afterInsert(Sheet sh) {
        PPDrawing ppdrawing = sh.getPPDrawing();
        ppdrawing.addTextboxWrapper(this._txtbox);
        try {
            this._txtbox.writeOut(null);
        }
        catch (IOException e) {
            throw new HSLFException(e);
        }
        if (this.getAnchor().equals(new Rectangle())) {
            this.resizeToFitText();
        }
    }

    public void resizeToFitText() {
        try {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            RichTextRun rt = this._txtrun.getRichTextRuns()[0];
            int size = rt.getFontSize();
            int style = 0;
            if (rt.isBold()) {
                style |= 1;
            }
            if (rt.isItalic()) {
                style |= 2;
            }
            String fntname = rt.getFontName();
            Font font = new Font(fntname, style, size);
            TextLayout layout = new TextLayout(this.getText(), font, frc);
            int width = Math.round(layout.getAdvance());
            int height = Math.round(layout.getAscent());
            Dimension txsize = new Dimension(width, height);
            Rectangle anchor = this.getAnchor();
            anchor.setSize(txsize);
            this.setAnchor(anchor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getVerticalAlignment() {
        int valign;
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 135);
        if (prop == null) {
            int type = this.getTextRun().getRunType();
            switch (type) {
                case 0: 
                case 6: {
                    valign = 1;
                    break;
                }
                default: {
                    valign = 0;
                    break;
                }
            }
        } else {
            valign = prop.getPropertyValue();
        }
        return valign;
    }

    public void setVerticalAlignment(int align) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)135, align);
    }

    public int getMarginBottom() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 132);
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return val / 12700;
    }

    public void setMarginBottom(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)132, margin * 12700);
    }

    public int getMarginLeft() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 132);
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return val / 12700;
    }

    public void setMarginLeft(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)129, margin * 12700);
    }

    public int getMarginRight() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 131);
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return val / 12700;
    }

    public void setMarginRight(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)131, margin * 12700);
    }

    public int getMarginTop() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 130);
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return val / 12700;
    }

    public void setMarginTop(int margin) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)130, margin * 12700);
    }

    public int getWordWrap() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 133);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setWordWrap(int wrap) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)133, wrap);
    }

    public int getTextId() {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)TextBox.getEscherProperty(opt, 128);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setTextId(int id) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        TextBox.setEscherProperty(opt, (short)128, id);
    }

    public void setBackgroundColor(Color color) {
        EscherOptRecord opt = (EscherOptRecord)TextBox.getEscherChild(this._escherContainer, -4085);
        int rgb = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
        TextBox.setEscherProperty(opt, (short)387, rgb);
    }

    public TextRun getTextRun() {
        return this._txtrun;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
        if (this._txtrun == null) {
            this.initTextRun();
        }
        if (this._txtrun == null) {
            this._missingTextRecords = true;
            return;
        }
        this._missingTextRecords = false;
        this._txtrun.setSheet(sheet);
        RichTextRun[] rt = this._txtrun.getRichTextRuns();
        for (int i = 0; i < rt.length; ++i) {
            rt[i].supplySlideShow(this._sheet.getSlideShow());
        }
    }

    private void initTextRun() {
        OutlineTextRefAtom ota = null;
        Record[] child = this._txtbox.getChildRecords();
        for (int i = 0; i < child.length; ++i) {
            if (!(child[i] instanceof OutlineTextRefAtom)) continue;
            ota = (OutlineTextRefAtom)child[i];
            break;
        }
        Sheet sheet = this.getSheet();
        TextRun[] runs = sheet.getTextRuns();
        if (ota != null) {
            int idx = ota.getTextIndex();
            if (idx < runs.length) {
                this._txtrun = runs[idx];
            }
            if (this._txtrun == null) {
                this.logger.log(5, (Object)("text run not found for OutlineTextRefAtom.TextIndex=" + idx));
            }
        } else {
            int shapeId = this._escherContainer.getChildById((short)-4086).getShapeId();
            if (runs != null) {
                for (int i = 0; i < runs.length; ++i) {
                    if (runs[i].getShapeId() != shapeId) continue;
                    this._txtrun = runs[i];
                    break;
                }
            }
            if (this._txtrun == null) {
                this.logger.log(5, (Object)("text run not found for shapeId=" + shapeId));
            }
        }
    }
}

