/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.awt.font.NFontType1;
import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.awt.Color;
import java.awt.FontFormatException;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Cmd;
import multivalent.std.adaptor.pdf.CryptFilter;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Fonts;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.InputStreamComposite;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.util.Arrayss;
import phelps.util.Version;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compress {
    static final boolean DEBUG = false;
    public static final String VERSION = "2.4 of $Date: 2005/07/26 21:13:18 $";
    public static final String COPYRIGHT = "Copyright (c) 2002 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java [-Xmx128m] tool.pdf.Compress [<options>] <PDF-file-or-directory...>\n\t[-old] [-compact] [-force] [-inplace] [-max]\n\t(data:) [-nopagepiece] [-nostruct] [-nowebcap] [-nooutline]\n\t(fonts:) [-nocore] [-noembed] [-subset]\n\t(images:) [-jpeg]\n\t[-password <password>] [-verbose] [-quiet]";
    private static final int PREDICT_OVERHEAD;
    private static final int PREDICT_COMPACT_WORTHWHILE = 2048;
    private static final int JPEG_OVERHEAD = 300;
    private static final int LOSSY_WORTHWHILE = 5120;
    private static final int COMPACT_OVERHEAD = 714;
    private static final String[] CORE14;
    private static final int[] TTF_KEEP;
    private boolean fold_ = false;
    private boolean fforce_ = false;
    private boolean finplace_ = false;
    private boolean fcompact0_ = false;
    private boolean fcompact_;
    private boolean fstruct_ = true;
    private boolean fwebcap_ = true;
    private boolean fpagepiece_ = true;
    private boolean fjpeg_ = false;
    private boolean fjpeg2000_ = false;
    private boolean falt_ = true;
    private boolean fcore14_ = true;
    private boolean fembed_ = true;
    private boolean fsubset_ = false;
    private boolean foutline_ = true;
    private boolean fverbose_ = false;
    private boolean fmonitor_ = false;
    private boolean fquiet_ = false;
    private PrintStream out_ = PrintStreams.DEVNULL;
    private boolean ftestable_ = false;
    private boolean fpre_ = true;
    private boolean fcontent_ = true;
    private String password_ = null;
    private PDFReader pdfr_;
    private List<String> wacky_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$tool$pdf$Compress;

    public Compress(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Compress(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Compress(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Compress(PDFReader pDFReader) {
    }

    public void setOld(boolean bl) {
        this.fold_ = bl;
    }

    public void setCompact(boolean bl) {
        this.fcompact0_ = bl;
    }

    public void setStruct(boolean bl) {
        this.fstruct_ = bl;
    }

    public void setSubset(boolean bl) {
        this.fsubset_ = bl;
    }

    public void setMax() {
        this.ftestable_ = false;
        this.fold_ = false;
        this.fsubset_ = true;
        this.fjpeg_ = true;
        this.fcompact0_ = true;
        this.fembed_ = false;
        this.fcore14_ = false;
        this.falt_ = false;
        this.fpagepiece_ = false;
        this.fwebcap_ = false;
        this.fstruct_ = false;
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setTestable(boolean bl) {
        this.ftestable_ = bl;
    }

    public void setQuiet(boolean bl) {
        this.fquiet_ = bl;
    }

    public void setVerbose(boolean bl) {
        this.fverbose_ = bl;
    }

    public boolean setPassword(String string) throws IOException {
        return this.pdfr_.setPassword(string);
    }

    public List<String> getWacky() {
        return this.wacky_;
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.compress(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    private Object compress(PDFWriter pDFWriter) throws IOException, ParseException {
        Object object;
        String string;
        long l = System.currentTimeMillis();
        PDFReader pDFReader = this.pdfr_;
        if (!pDFReader.isAuthorized()) {
            throw new ParseException("invalid password");
        }
        Dict dict = (Dict)pDFReader.getTrailer().get("Compress");
        if (!this.fforce_ && dict != null && ((string = (String)dict.get("Filter")) == null && !this.fcompact0_ || "Compact".equals(string) && this.fcompact0_)) {
            this.out_.println("Already compressed.  (Force recompression with -force.)");
            return null;
        }
        long l2 = pDFReader.getRA().length();
        if (!this.fquiet_) {
            this.out_.print(new StringBuffer().append(pDFReader.getURI()).append(", ").append(l2).append(" bytes").toString());
            if (pDFReader.getEncrypt().getStmF() != CryptFilter.IDENTITY) {
                this.out_.print(", encrypted");
            }
            this.out_.println();
            object = pDFReader.getInfo();
            if (object != null) {
                this.out_.println(new StringBuffer().append("PDF ").append(pDFReader.getVersion()).append(", producer=").append(((Dict)object).get("Producer")).append(", creator=").append(((Dict)object).get("Creator")).toString());
            }
        }
        if (this.fmonitor_) {
            this.out_.print(new StringBuffer().append(pDFReader.getObjCnt()).append(" objects / ").append(pDFReader.getPageCnt()).append(" pages").toString());
        }
        this.compress2(pDFWriter);
        if (this.fmonitor_) {
            this.out_.print("write ");
        }
        object = pDFWriter.writePDF();
        long l3 = pDFWriter.getOutputStream().getCount();
        this.pdfr_.close();
        this.pdfr_ = null;
        pDFWriter.close();
        long l4 = System.currentTimeMillis();
        this.out_.println(new StringBuffer().append("=> new length = ").append(l3).append(", saved ").append((l2 - l3) * 100L / l2).append("%, elapsed time = ").append((l4 - l) / 1000L).append(" sec").toString());
        return object;
    }

    private void compress2(PDFWriter pDFWriter) throws IOException, ParseException {
        int n;
        Object object;
        Object object2;
        Object object3;
        this.wacky_ = new ArrayList<String>(5);
        PDFReader pDFReader = this.pdfr_;
        Version version = pDFReader.getVersion();
        long l = pDFReader.getRA().length();
        pDFReader.fault();
        Dict dict = (Dict)pDFWriter.getTrailer().get("Compress");
        if (dict == null) {
            dict = new Dict(5);
            pDFWriter.getTrailer().put("Compress", dict);
            dict.put("LengthO", new Integer((int)l));
            dict.put("SpecO", version.toString());
        }
        boolean bl = this.fcompact_ = this.fcompact0_ && l > l / 4L + 714L;
        if (this.fcompact_) {
            dict.put("Filter", "Compact");
        } else {
            dict.remove("Filter");
        }
        if (this.fold_) {
            pDFReader.setExact(true);
        } else if (!this.fcompact_) {
            pDFWriter.getVersion().setMin(new Version(1L, 5L));
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = pDFReader.getObjCnt();
        for (int i = 1; i < n12; ++i) {
            Dict dict2;
            Object object4;
            Object object52;
            Dict dict3;
            Object object6;
            block55: {
                block58: {
                    block56: {
                        block57: {
                            block54: {
                                object6 = pDFReader.getObject(i);
                                if (COS.OBJECT_DELETED != object6) break block54;
                                ++n4;
                                break block55;
                            }
                            if (COS.CLASS_DICTIONARY != object6.getClass()) break block55;
                            dict3 = (Dict)object6;
                            object3 = pDFReader.getObject(dict3.get("Filter"));
                            Object object7 = object2 = object3 != null ? object3.getClass() : null;
                            if (COS.CLASS_NAME != object2) break block56;
                            if (!"ASCII85Decode".equals(object3) && !"ASCIIHexDecode".equals(object3)) break block57;
                            ++n3;
                            break block58;
                        }
                        if (!"LZWDecode".equals(object3)) break block58;
                        ++n2;
                        break block58;
                    }
                    if (COS.CLASS_ARRAY == object2) {
                        for (Object object52 : (Object[])object3) {
                            if ("ASCII85Decode".equals(object52) || "ASCIIHexDecode".equals(object52)) {
                                ++n3;
                                continue;
                            }
                            if (!"LZWDecode".equals(object52)) continue;
                            ++n2;
                        }
                    }
                }
                if (dict3.get("DATA") != null && dict3.get("Length") instanceof IRef) {
                    ++n7;
                }
                object = pDFReader.getObject(dict3.get("Type"));
                object4 = pDFReader.getObject(dict3.get("Subtype"));
                if (("XObject".equals(object) || object == null) && "Image".equals(object4) && dict3.get("Alternates") != null) {
                    ++n6;
                }
            }
            pDFWriter.getObject(i, true);
            if (COS.CLASS_DICTIONARY != object6.getClass()) continue;
            dict3 = (Dict)object6;
            if (dict3.get("PieceInfo") != null) {
                ++n5;
            }
            object3 = pDFReader.getObject(dict3.get("Filter"));
            object2 = pDFWriter.getObject(dict3.get("Type"));
            object = pDFWriter.getObject(dict3.get("Subtype"));
            if (("XObject".equals(object2) || object2 == null) && "Image".equals(object)) {
                object4 = (byte[])dict3.get("DATA");
                if (object3 == null) {
                    ++n8;
                    n9 += ((Object)object4).length;
                }
                this.recodeImage(dict3, pDFWriter, pDFReader);
                if (object3 != null) continue;
                pDFWriter.deflateStream(dict3, i);
                continue;
            }
            if ("Font".equals(object2) && !this.fembed_) {
                object4 = (Dict)pDFWriter.getObject(dict3.get("FontDescriptor"));
                if (object4 == null) continue;
                ((Dict)object4).remove("FontFile");
                ((Dict)object4).remove("FontFile2");
                ((Dict)object4).remove("FontFile3");
                continue;
            }
            if (!"Font".equals(object2) || !"Type1".equals(object)) continue;
            object4 = (Dict)pDFWriter.getObject(dict3.get("FontDescriptor"));
            Dict dict4 = dict2 = object4 != null ? (Dict)pDFWriter.getObject(((Dict)object4).get("FontFile")) : null;
            if (dict2 == null) continue;
            ++n10;
            object52 = pDFWriter.getObject(dict2.get("Length"));
            if (!(object52 instanceof Number)) continue;
            n11 += ((Number)object52).intValue();
        }
        if (this.fmonitor_) {
            if (n2 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n2).append(" LZW").toString());
            }
            if (n3 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n3).append(" ASCII").toString());
            }
            if (n4 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n4).append(" deleted").toString());
            }
            if (n5 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n5).append(" pagepiece").toString());
            }
            if (n6 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n6).append(" image /Alt").toString());
            }
            if (n7 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n7).append(" /Length IRef").toString());
            }
            if (n8 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n8).append(" raw samples = ").append(n9 / 1024).append("K").toString());
            }
            if (n10 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n10).append(" embedded Type 1 = ").append(n11 / 1024).append("K").toString());
            }
        }
        Dict dict5 = pDFWriter.getCatalog();
        this.strip(dict5, pDFWriter);
        n12 = 0;
        int n13 = pDFReader.getPageCnt();
        for (n = 0; n < n13; ++n) {
            object3 = pDFReader.getPageRef(n + 1);
            object2 = pDFWriter.getObject(object3);
            if (COS.OBJECT_NULL == object2 || object2 == null) continue;
            object = (Dict)object2;
            if ((object2 = ((Dict)object).get("Thumb")) != null) {
                ((Dict)object).remove("Thumb");
                if (COS.CLASS_IREF == object2.getClass()) {
                    pDFWriter.setObject(((IRef)object2).id, COS.OBJECT_DELETED);
                }
                ++n12;
            }
            if (this.ftestable_) continue;
            this.stripLZW((Dict)object, ((Dict)object).get("Contents"), pDFReader, pDFWriter);
        }
        if (this.fmonitor_ && n12 > 0) {
            this.out_.print(new StringBuffer().append(", ").append(n12).append(" thumb").toString());
        }
        this.axeCore14(pDFWriter);
        this.recodeFonts(pDFWriter);
        this.subset(pDFReader, pDFWriter);
        if (this.fmonitor_) {
            this.out_.print(", liftPageTree");
        }
        pDFWriter.liftPageTree();
        this.inline(pDFWriter);
        this.unique(pDFWriter);
        n = pDFWriter.refcntRemove();
        if (n > 0 && this.fmonitor_) {
            this.out_.print(new StringBuffer().append(", ref cnt ").append(n).toString());
        }
        int n14 = n13 = this.fold_ || this.fcompact_ ? 0 : (int)(pDFWriter.makeObjectStreams(0, pDFWriter.getObjCnt()) ? 1 : 0);
        if (this.fmonitor_) {
            this.out_.println();
        }
        if (this.fverbose_) {
            if (pDFReader.getLinearized() > 0) {
                this.out_.println("lost Linearization (aka Fast Web View)");
            }
            if (pDFReader.isRepaired()) {
                this.out_.println("repaired errors");
            }
            if (n2 > 0) {
                this.out_.println("converted LZW to Flate");
            }
            if (n3 > 0) {
                this.out_.println("stripped off verbose ASCII filters");
            }
            if (n4 > 0) {
                this.out_.println("nulled out deleted objects");
            }
            if (n12 > 0) {
                this.out_.println("removed thumbnails (Acrobat can generate on the fly)");
            }
            if (n5 > 0 && !this.fpagepiece_) {
                this.out_.println("removed /PieceInfo");
            }
            if (n6 > 0 && !this.falt_) {
                this.out_.println("remove alternate images");
            }
            if (!this.fold_) {
                this.out_.println("cleaned and modernized");
                if (pDFWriter.getVersion().compareTo(version) > 0 && pDFWriter.getVersion().compareTo(1L, 5L) >= 0) {
                    this.out_.println("\tcross references as stream");
                    if (n13 != 0) {
                        this.out_.println("\tadditional compression via object streams");
                    }
                    this.out_.println("\tnow REQUIRES Multivalent or Acrobat 6 to read (use -old for older PDF)");
                }
            }
        }
        if (!this.fquiet_) {
            if (this.fcompact_) {
                this.out_.println("Compact PDF format -- requires Multivalent to read");
            }
            object3 = new StringBuffer();
            if (this.fold_ && pDFWriter.getVersion().compareTo(1L, 5L) < 0) {
                ((StringBuffer)object3).append(" [omit -old]");
            }
            if (!this.fcompact0_) {
                ((StringBuffer)object3).append(" -compact");
            }
            if (dict5.get("StructTreeRoot") != null) {
                ((StringBuffer)object3).append(" -nostruct");
            }
            if (n8 > 0 && !this.fjpeg_) {
                ((StringBuffer)object3).append(" -jpeg");
            }
            if (dict5.get("SpiderInfo") != null) {
                ((StringBuffer)object3).append(" -nowebcap");
            }
            if (n5 > 0 && this.fpagepiece_) {
                ((StringBuffer)object3).append(" -nopagepiece");
            }
            if (n6 > 0 && this.falt_) {
                ((StringBuffer)object3).append(" -noalt");
            }
            if (((StringBuffer)object3).length() > 0) {
                this.out_.println("additional compression may be possible with:");
                this.out_.println(new StringBuffer().append("\t").append(object3).toString());
            }
        }
    }

    private void strip(Dict dict, PDFWriter pDFWriter) {
        if (!this.fstruct_) {
            dict.remove("StructTreeRoot");
            dict.remove("MarkInfo");
        }
        if (!this.fwebcap_) {
            dict.remove("SpiderInfo");
        }
        if (!this.fpagepiece_) {
            dict.remove("PieceInfo");
        }
        if (!this.foutline_) {
            dict.remove("Outlines");
        }
        if (!this.fpagepiece_) {
            int n = pDFWriter.getObjCnt();
            for (int i = 1; i < n; ++i) {
                Object object = pDFWriter.getCache(i);
                if (COS.CLASS_DICTIONARY != object.getClass()) continue;
                Dict dict2 = (Dict)object;
                dict2.remove("PieceInfo");
            }
        }
    }

    private void stripLZW(Dict dict, Object object, PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        Dict dict2;
        Object[] objectArray;
        if (this.ftestable_ || !this.fcontent_) {
            return;
        }
        Object object2 = pDFWriter.getObject(object);
        if (object2 == null) {
            objectArray = new Object[]{};
        } else if (COS.CLASS_DICTIONARY == object2.getClass()) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        } else {
            objectArray = (Object[])object2;
        }
        Object[] objectArray3 = objectArray;
        int n = objectArray3.length;
        for (int i = 0; i < n; ++i) {
            Dict dict3 = (Dict)pDFWriter.getObject(objectArray3[i]);
            try {
                Object object3 = pDFReader.readCommandArray(objectArray3[i]);
                dict3.put("DATA", pDFWriter.writeCommandArray((Cmd[])object3, false));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Dict dict4 = (Dict)pDFReader.getObject(dict.get("Resources"));
        Dict dict5 = dict2 = dict4 != null ? (Dict)pDFReader.getObject(dict4.get("XObject")) : null;
        if (dict2 != null) {
            for (Object object3 : dict2.values()) {
                Object object4 = pDFReader.getObject(object3);
                if (COS.CLASS_DICTIONARY != object4.getClass()) continue;
                Dict dict6 = (Dict)object4;
                if (!"Form".equals("Subtype")) continue;
                this.stripLZW(dict6, object3, pDFReader, pDFWriter);
            }
        }
    }

    private int unique(PDFWriter pDFWriter) {
        long l = System.currentTimeMillis();
        int n = pDFWriter.getObjCnt();
        Object[] objectArray = pDFWriter.getObjects();
        Class[] classArray = new Class[n];
        for (int i = 1; i < n; ++i) {
            classArray[i] = objectArray[i].getClass();
        }
        long[] lArray = new long[n];
        int[] nArray = new int[n];
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            int n5 = 0;
            objectArray = pDFWriter.getObjects();
            n = pDFWriter.getObjCnt();
            if (!$assertionsDisabled && lArray[0] != 0L) {
                throw new AssertionError();
            }
            for (n4 = 1; n4 < n; ++n4) {
                lArray[n4] = ((long)Compress.sign(objectArray[n4]) << 32) + (long)n4;
            }
            Arrays.sort(lArray, 1, n);
            for (n4 = 1; n4 < n; ++n4) {
                nArray[(int)(lArray[n4] & Integer.MAX_VALUE)] = n4;
            }
            int[] nArray2 = new int[n];
            block4: for (int i = 1; i < n; ++i) {
                nArray2[i] = i;
                Object object = objectArray[i];
                Class clazz = classArray[i];
                if (COS.CLASS_DICTIONARY == clazz && "Page".equals(((Dict)object).get("Type"))) continue;
                int n6 = nArray[i];
                long l2 = lArray[n6] & 0xFFFFFFFF00000000L;
                --n6;
                while (n6 > 0 && (lArray[n6] & l2) == l2) {
                    int n7 = (int)(lArray[n6] & Integer.MAX_VALUE);
                    if (clazz == classArray[n7] && pDFWriter.objEquals(object, objectArray[n7])) {
                        int n8;
                        nArray2[i] = n8 = nArray2[n7];
                        objectArray[i] = objectArray[n8];
                        ++n5;
                        continue block4;
                    }
                    --n6;
                }
            }
            if (n5 <= 0) break;
            int[] nArray3 = pDFWriter.renumberRemove(nArray2);
            for (int i = 1; i < n; ++i) {
                classArray[i - nArray3[i]] = classArray[i];
            }
            if (this.fmonitor_) {
                this.out_.print(n3 == 0 ? new StringBuffer().append(", ").append(n5).append(" dups").toString() : new StringBuffer().append(" + ").append(n5).toString());
            }
            n2 += n5;
            ++n3;
        }
        long l3 = System.currentTimeMillis() - l;
        return n2;
    }

    private static int sign(Object object) {
        int n = 0;
        Class<?> clazz = object.getClass();
        if (COS.OBJECT_NULL == object) {
            n = 0;
        } else if (COS.CLASS_NAME == clazz) {
            n = ((String)object).hashCode();
        } else if (COS.CLASS_STRING == clazz) {
            n = ((StringBuffer)object).length() * 11;
        } else if (COS.CLASS_DATA == clazz) {
            n = ((byte[])object).length << 8;
        } else if (COS.CLASS_BOOLEAN == clazz) {
            n = (Boolean)object != false ? 11 : 7;
        } else if (object instanceof Number) {
            n = ((Number)object).intValue();
        } else if (COS.CLASS_IREF == clazz) {
            n = ((IRef)object).id * 131;
        } else if (COS.CLASS_DICTIONARY == clazz) {
            Dict dict = (Dict)object;
            n += dict.size() * 13;
            for (Map.Entry entry : dict.entrySet()) {
                n += entry.getKey().hashCode();
                n += Compress.sign(entry.getValue());
            }
            n *= dict.size();
        } else if (COS.CLASS_ARRAY == clazz) {
            Object[] objectArray = (Object[])object;
            n += objectArray.length * 7;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                n += Compress.sign(objectArray[i]) * (i + 1);
            }
        }
        return n;
    }

    private int inline(PDFWriter pDFWriter) {
        Object object;
        Serializable serializable;
        int n;
        int n2 = 0;
        int n3 = pDFWriter.getObjCnt();
        Object[] objectArray = pDFWriter.getObjects();
        int[] nArray = pDFWriter.refcnt();
        if (this.fmonitor_) {
            this.out_.print(", inline");
        }
        for (n = 1; n < n3; ++n) {
            Object object2;
            serializable = objectArray[n].getClass();
            if (nArray[n] == 0) continue;
            if (COS.CLASS_ARRAY == serializable) {
                object2 = (Object[])objectArray[n];
                int n4 = ((Object[])object2).length;
                for (int i = 0; i < n4; ++i) {
                    object = this.inlineObj(object2[i], nArray, pDFWriter);
                    if (object == null) continue;
                    object2[i] = object;
                }
                continue;
            }
            if (COS.CLASS_DICTIONARY != serializable) continue;
            object2 = (Dict)objectArray[n];
            for (Map.Entry entry : ((HashMap)object2).entrySet()) {
                object = this.inlineObj(entry.getValue(), nArray, pDFWriter);
                if (object == null) continue;
                entry.setValue(object);
            }
        }
        for (n = 1; n < n3; ++n) {
            if (COS.CLASS_DICTIONARY != objectArray[n].getClass() || nArray[n] == 0 || !"Page".equals(((Dict)(serializable = (Dict)objectArray[n])).get("Type")) || (object = ((Dict)serializable).get("Contents")) == null) continue;
            int n5 = -1;
            if (COS.CLASS_IREF == object.getClass()) {
                n5 = ((IRef)object).id;
                object = objectArray[n5];
            }
            if (COS.CLASS_ARRAY != object.getClass()) continue;
            Object[] objectArray2 = (Object[])object;
            Object[] objectArray3 = new Object[objectArray2.length];
            int n6 = 0;
            byte[] byArray = null;
            int n7 = -1;
            int n8 = 0;
            int n9 = objectArray2.length;
            for (int i = 0; i < n9; ++i) {
                IRef iRef = (IRef)objectArray2[i];
                int n10 = iRef.id;
                objectArray3[n6++] = iRef;
                byte[] byArray2 = (byte[])((Dict)objectArray[n10]).get("DATA");
                if (nArray[n10] == 1 || n7 != -1 && byArray2.length < PDFWriter.PDFOBJREF_OVERHEAD * 2) {
                    if (byArray == null) {
                        byArray = byArray2;
                        n7 = n10;
                        n8 = 1;
                        continue;
                    }
                    int n11 = byArray.length;
                    byArray = Arrayss.resize(byArray, n11 + byArray2.length + 1);
                    byArray[n11] = 32;
                    System.arraycopy(byArray2, 0, byArray, n11 + 1, byArray2.length);
                    --n6;
                    ++n8;
                    continue;
                }
                if (n8 > 1) {
                    ((Dict)objectArray[n7]).put("DATA", byArray);
                }
                byArray = null;
                n7 = -1;
                n8 = 0;
            }
            if (n8 > 1) {
                ((Dict)objectArray[n7]).put("DATA", byArray);
            }
            if (n6 < objectArray2.length) {
                n2 += objectArray2.length - n6;
                if (n6 == 0) {
                    ((Dict)serializable).remove("Contents");
                    continue;
                }
                if (n6 == 1) {
                    ((Dict)serializable).put("Contents", objectArray3[0]);
                    continue;
                }
                ((Dict)serializable).put("Contents", Arrayss.resize(objectArray3, n6));
                continue;
            }
            ((Dict)serializable).put("Contents", objectArray2);
        }
        if (!$assertionsDisabled && pDFWriter.getObjGen(0) != 65535) {
            throw new AssertionError(pDFWriter.getObjGen(0));
        }
        n = pDFWriter.refcntRemove();
        if (!$assertionsDisabled && pDFWriter.getObjGen(0) != 65535) {
            throw new AssertionError();
        }
        if (this.fmonitor_) {
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" ").append(-n).toString());
            }
            if (n2 > 0) {
                this.out_.print(new StringBuffer().append(", ").append(n2).append(" concat").toString());
            }
        }
        return n;
    }

    private Object inlineObj(Object object, int[] nArray, PDFWriter pDFWriter) {
        if (!(object instanceof IRef)) {
            return null;
        }
        int n = ((IRef)object).id;
        object = pDFWriter.getCache(n);
        Class<?> clazz = object.getClass();
        if (COS.OBJECT_NULL == object || COS.CLASS_INTEGER == clazz || COS.CLASS_BOOLEAN == clazz || COS.CLASS_NAME == clazz && ((String)object).length() < PDFWriter.PDFOBJREF_OVERHEAD || COS.CLASS_STRING == clazz && ((StringBuffer)object).length() + 2 < PDFWriter.PDFOBJREF_OVERHEAD || nArray[n] == 1 && (COS.CLASS_NAME == clazz || COS.CLASS_STRING == clazz || COS.CLASS_REAL == clazz)) {
            int n2 = n;
            nArray[n2] = nArray[n2] - 1;
            return object;
        }
        return null;
    }

    private void axeCore14(PDFWriter pDFWriter) throws IOException {
        if (this.fcore14_ || this.ftestable_) {
            return;
        }
        if (this.fmonitor_) {
            this.out_.print(", axeCore14");
        }
        for (int i = 1; i < pDFWriter.getObjCnt(); ++i) {
            String string;
            Object object = pDFWriter.getObject(i, false);
            if (COS.CLASS_DICTIONARY != object.getClass()) continue;
            Dict dict = (Dict)object;
            Object object2 = pDFWriter.getObject(dict.get("Type"));
            Object object3 = pDFWriter.getObject(dict.get("Subtype"));
            if (!"Font".equals(object2) || !"WinAnsiEncoding".equals(pDFWriter.getObject(dict.get("Encoding")))) continue;
            String string2 = (String)pDFWriter.getObject(dict.get("BaseFont"));
            String string3 = string = Fonts.isSubset(string2) ? string2.substring("SIXCAP+".length()) : string2;
            if (this.fcore14_ || string == null || Arrays.binarySearch(CORE14, string) < 0 || dict.get("FontDescriptor") == null) continue;
            dict.remove("FontDescriptor");
            dict.put("BaseFont", string);
        }
    }

    private void recodeFonts(PDFWriter pDFWriter) throws IOException {
    }

    private void subset(PDFReader pDFReader, PDFWriter pDFWriter) throws IOException {
        Dict dict;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n2;
        if (!this.fsubset_ || this.ftestable_) {
            return;
        }
        if (this.fmonitor_) {
            this.out_.print(", subset");
        }
        int n3 = pDFWriter.getObjCnt();
        Dict[] dictArray = new Dict[n3];
        int[] nArray = new int[n3];
        for (n2 = 1; n2 < n3; ++n2) {
            object5 = pDFWriter.getObject(n2, false);
            if (COS.CLASS_DICTIONARY != object5.getClass()) continue;
            Dict dict2 = (Dict)object5;
            Object object6 = pDFWriter.getObject(dict2.get("Type"));
            object4 = pDFWriter.getObject(dict2.get("Subtype"));
            object3 = (String)pDFWriter.getObject(dict2.get("BaseFont"));
            if (!"Font".equals(object6) || Fonts.isSubset((String)object3) || (object2 = (Dict)pDFWriter.getObject(dict2.get("FontDescriptor"))) == null) continue;
            object = ((Dict)object2).get("FontFile");
            if (object != null && ("Type1".equals(object4) || "MMType1".equals(object4))) {
                dictArray[n2] = dict2;
                nArray[n2] = ((IRef)object).id;
                continue;
            }
            object = ((Dict)object2).get("FontFile2");
            if (object != null) {
                nArray[n2] = ((IRef)object).id;
                continue;
            }
            object = ((Dict)object2).get("FontFile3");
            if (object == null) continue;
            nArray[n2] = ((IRef)object).id;
        }
        n2 = 0;
        object5 = new int[n3][];
        int n4 = dictArray.length;
        for (n = 0; n < n4; ++n) {
            if (dictArray[n] == null) continue;
            object5[nArray[n]] = new int[256];
            ++n2;
        }
        n4 = pDFReader.getPageCnt();
        for (n = 0; n < n4; ++n) {
            object4 = pDFReader.getPage(n + 1);
            object3 = (Dict)pDFWriter.getObject(((Dict)object4).get("Resources"));
            if (object3 == null) continue;
            this.subsetCensus(((Dict)object3).get("Font"), ((Dict)object4).get("Contents"), pDFReader, pDFWriter, (int[][])object5, nArray);
            object2 = ((Dict)object3).get("XObject");
            if (object2 == null || (dict = (Dict)pDFWriter.getObject(((Dict)(object = (Dict)pDFWriter.getObject(object2))).get("Resources"))) == null) continue;
            this.subsetCensus(dict.get("Font"), object2, pDFReader, pDFWriter, (int[][])object5, nArray);
        }
        n4 = dictArray.length;
        for (n = 1; n < n4; ++n) {
            object4 = dictArray[n];
            object3 = object5[nArray[n]];
            if (object3 == null) continue;
            object5[nArray[n]] = null;
            object2 = new boolean[256];
            int n5 = 1;
            for (int i = 1; i < 256; ++i) {
                if (object3[i] <= 0) continue;
                object2[i] = true;
                ++n5;
            }
            dict = (Dict)pDFWriter.getObject(((Dict)object4).get("FontDescriptor"));
            IRef iRef = (IRef)dict.get("FontFile");
            Dict dict3 = (Dict)pDFWriter.getObject(iRef);
            try {
                Object object7;
                String string;
                NFontType1 nFontType1 = new NFontType1(null, pDFWriter.getStreamData(dict3));
                this.out_.print(new StringBuffer().append(", ").append(((Dict)object4).get("BaseFont")).append(" ").append(nFontType1.getNumGlyphs()).append(" subset ").append(n5).toString());
                if (this.fmonitor_) {
                    this.out_.print(": ");
                    for (int i = 32; i < 128; ++i) {
                        if (object2[i] == false) continue;
                        this.out_.print((char)i);
                    }
                    this.out_.println();
                }
                if ((string = nFontType1.getName()) != null && !Fonts.isSubset(string)) {
                    object7 = new StringBuffer(7 + string.length());
                    Random random = new Random();
                    for (int i = 0; i < 6; ++i) {
                        ((StringBuffer)object7).append((char)(65 + random.nextInt(26)));
                    }
                    ((StringBuffer)object7).append('+');
                    ((StringBuffer)object7).append(string);
                    string = ((StringBuffer)object7).toString();
                }
                nFontType1 = nFontType1.deriveFont(string, (boolean[])object2);
                object7 = nFontType1.toPFB();
                object7 = Arrayss.resize((byte[])object7, ((byte[])object7).length - NFontType1.PFB_00_LENGTH);
                dict3.put("DATA", object7);
                int n6 = NFontType1.getClen((byte[])object7);
                dict3.put("Length1", Integers.getInteger(n6));
                dict3.put("Length2", Integers.getInteger(((Object)object7).length - n6));
                dict3.put("Length3", Integers.ZERO);
                dict.put("FontName", string);
                ((Dict)object4).put("BaseFont", string);
                continue;
            }
            catch (FontFormatException fontFormatException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void subsetCensus(Object object, Object object2, PDFReader pDFReader, PDFWriter pDFWriter, int[][] nArray, int[] nArray2) throws IOException {
        if (object == null || object2 == null) {
            return;
        }
        Dict dict = (Dict)pDFWriter.getObject(object);
        int[] nArray3 = null;
        int[][] nArrayArray = new int[100][];
        int n = 0;
        for (IRef iRef : dict.values()) {
            Cmd cmd;
            int n2 = nArray2[iRef.id];
            if (n2 == 0) continue;
            InputStreamComposite inputStreamComposite = pDFReader.getInputStream(object2, true);
            while ((cmd = pDFReader.readCommand(inputStreamComposite)) != null) {
                int n3;
                int n4;
                Object[] objectArray;
                String string = cmd.op;
                if ("Tf" == string) {
                    iRef = (IRef)dict.get(cmd.ops[0]);
                    n2 = nArray2[iRef.id];
                    if (nArray[n2] == null) continue;
                    nArray3 = nArray[n2];
                    continue;
                }
                if ("q" == string) {
                    nArrayArray[n++] = nArray3;
                    continue;
                }
                if ("Q" == string) {
                    if (--n < 0) continue;
                    nArray3 = nArrayArray[n];
                    continue;
                }
                if (nArray3 == null) continue;
                if ("Tj" == string) {
                    objectArray = (Object[])cmd.ops[0];
                    n4 = objectArray.length();
                    for (n3 = 0; n3 < n4; ++n3) {
                        char c = objectArray.charAt(n3);
                        nArray3[c] = nArray3[c] + 1;
                    }
                    continue;
                }
                if ("TJ" != string) continue;
                objectArray = (Object[])cmd.ops[0];
                n4 = objectArray.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (COS.CLASS_STRING != objectArray[n3].getClass()) continue;
                    StringBuffer stringBuffer = (StringBuffer)objectArray[n3];
                    int n5 = stringBuffer.length();
                    for (int i = 0; i < n5; ++i) {
                        char c = stringBuffer.charAt(i);
                        nArray3[c] = nArray3[c] + 1;
                    }
                }
            }
            break block0;
        }
    }

    private void recodeImage(Dict dict, PDFWriter pDFWriter, PDFReader pDFReader) throws IOException {
        Object object;
        int n;
        byte[] byArray = (byte[])dict.get("DATA");
        String string = (String)pDFWriter.getObject(dict.get("Filter"));
        int n2 = ((Number)pDFWriter.getObject(dict.get("Width"))).intValue();
        int n3 = ((Number)pDFWriter.getObject(dict.get("Height"))).intValue();
        int n4 = n = pDFWriter.getObject(dict.get("ImageMask")) == Boolean.TRUE ? 1 : ((Number)pDFWriter.getObject(dict.get("BitsPerComponent"))).intValue();
        if (!this.falt_ && (object = pDFReader.getObject(dict.get("Alternates"))) != null) {
            Object[] objectArray = (Object[])object;
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (Object object2 : objectArray) {
                Dict dict2 = (Dict)pDFReader.getObject(object2);
                if (dict2.get("OC") == null) continue;
                arrayList.add(object2);
            }
            if (arrayList.size() == 0) {
                dict.remove("Alternates");
            } else {
                dict.put("Alternates", arrayList.toArray());
            }
        }
        if ("DCTDecode".equals(string)) {
            this.recodeDCTAsRaw(dict, n2, n3, byArray);
        } else if (!"CCITTFaxDecode".equals(string) && string == null) {
            boolean bl = false;
            if (this.fjpeg_) {
                bl = this.recodeRawAsDCT(dict, n2, n3, n, byArray, pDFReader);
            }
            if (!bl && this.fpre_) {
                bl = this.addPredictor(dict, n2, n3, n, byArray, pDFReader);
            }
        }
    }

    private boolean recodeDCTAsRaw(Dict dict, int n, int n2, byte[] byArray) throws IOException {
        if (this.ftestable_) {
            return false;
        }
        int n3 = byArray.length;
        if (n * n2 > n3) {
            return false;
        }
        try {
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("JPEG").next();
            ImageIO.setUseCache(false);
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
            imageReader.setInput(imageInputStream, true);
            BufferedImage bufferedImage = imageReader.read(0);
            imageReader.dispose();
            imageInputStream.close();
            int n4 = bufferedImage.getColorModel().getNumComponents();
            int n5 = n4 * n * n2;
            if (n5 / 2 < n3 && (n4 == 1 || n4 == 3)) {
                byte[] byArray2 = new byte[n5];
                int n6 = 0;
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n7 = bufferedImage.getRGB(j, i);
                        if (n4 == 3) {
                            byArray2[n6++] = (byte)(n7 >> 16);
                            byArray2[n6++] = (byte)(n7 >> 8);
                        }
                        byArray2[n6++] = (byte)n7;
                    }
                }
                dict.put("DATA", byArray2);
                dict.remove("Filter");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recodeRawAsDCT(Dict dict, int n, int n2, int n3, byte[] byArray, PDFReader pDFReader) throws IOException {
        if (this.ftestable_) {
            return false;
        }
        if (n3 != 8 || n < 20 || n2 < 20 || byArray.length < 5420) {
            return false;
        }
        byte[] byArray2 = PDFWriter.maybeDeflateData(byArray);
        int n4 = byArray2.length;
        byArray2 = null;
        if (n4 < 5420) {
            return false;
        }
        InputStreamComposite inputStreamComposite = pDFReader.getInputStream(dict);
        BufferedImage bufferedImage = Images.createImage(dict, inputStreamComposite, new AffineTransform(), Color.WHITE, pDFReader);
        ((InputStream)inputStreamComposite).close();
        if (bufferedImage == null) {
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n * n2);
        boolean bl = false;
        String string = bl ? "JPEG2000" : "JPEG";
        ImageWriter imageWriter = ImageIO.getImageWritersByFormatName(string).next();
        ImageIO.setUseCache(false);
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
        imageWriter.setOutput(imageOutputStream);
        IIOImage iIOImage = new IIOImage(bufferedImage, null, null);
        try {
            imageWriter.write(null, iIOImage, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            boolean bl2 = false;
            return bl2;
        }
        finally {
            imageWriter.dispose();
            imageOutputStream.close();
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        int n5 = n4 - byArray3.length;
        if (n5 > 5120) {
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" jpeg").append(n5).toString());
                if (n5 > 102400) {
                    this.out_.print(new StringBuffer().append("/").append(n).append("x").append(n2).toString());
                }
            }
            dict.put("Filter", "JPEG2000".equals(string) ? "JPXDecode" : "DCTDecode");
            dict.put("DATA", byArray3);
            String string2 = 10 == bufferedImage.getType() || 11 == bufferedImage.getType() ? "DeviceGray" : "DeviceRGB";
            dict.put("ColorSpace", string2);
        }
        return true;
    }

    private boolean addPredictor(Dict dict, int n, int n2, int n3, byte[] byArray, PDFReader pDFReader) throws IOException {
        int n4;
        int n5;
        if (!($assertionsDisabled || dict != null && n >= 1 && n2 >= 1 && byArray != null && byArray.length >= 1)) {
            throw new AssertionError();
        }
        if (n3 != 8 || byArray.length < PREDICT_OVERHEAD + n) {
            return false;
        }
        Object object = pDFReader.getObject(dict.get("ColorSpace"));
        ColorSpace colorSpace = pDFReader.getColorSpace(object, null, null);
        int n6 = colorSpace.getNumComponents();
        if (COS.CLASS_ARRAY == object.getClass() && "Indexed".equals(((Object[])object)[0])) {
            n6 = 1;
        }
        int n7 = n5 = (n6 * n3 + 7) / 8;
        int n8 = n * n2 * n6 * n3 / 8;
        if (!$assertionsDisabled && byArray.length < n8) {
            throw new AssertionError((Object)new StringBuffer().append(byArray.length).append(" != ").append(n).append(" * ").append(n2).append(" * ").append(n6).append(" * ").append(n3).append(" = ").append(n8).toString());
        }
        if (byArray.length - n8 > 1) {
            String string = new StringBuffer().append("extra bytes ").append(n).append("x").append(n2).append("*").append(n6).append("=").append(n8).append(" < ").append(byArray.length).toString();
            this.wacky_.add(string);
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" / ").append(string).toString());
            }
        }
        int n9 = n * n5;
        byte[] byArray2 = new byte[(n9 + 1) * n2];
        int n10 = n9 + n7;
        byte[] byArray3 = new byte[n10];
        byte[] byArray4 = new byte[n10];
        byte[] byArray5 = new byte[n10];
        byte[] byArray6 = new byte[n10];
        byte[] byArray7 = new byte[n10];
        int n11 = 0;
        byArray2[n11++] = 0;
        System.arraycopy(byArray, 0, byArray2, n11, n9);
        n11 += n9;
        int n12 = 1;
        int n13 = n9;
        int n14 = 0 - n7;
        while (n12 < n2) {
            int n15;
            int n16;
            n4 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            System.arraycopy(byArray, n13, byArray3, n7, n9);
            for (n16 = n10 - 1; n16 >= n7; --n16) {
                n4 += byArray3[n16] & 0xFF;
            }
            n16 = n4;
            int n21 = 0;
            byte[] byArray8 = byArray3;
            System.arraycopy(byArray, n13, byArray4, n7, n9);
            int n22 = n7 + n5;
            for (n15 = n10 - 1; n15 >= n22; --n15) {
                int n23 = n15;
                byArray4[n23] = (byte)(byArray4[n23] - (byArray4[n15 - n5] & 0xFF));
                n17 += byArray4[n15] & 0xFF;
            }
            if (n17 < n16) {
                n16 = n17;
                byArray8 = byArray4;
                n21 = 1;
            }
            System.arraycopy(byArray, n13, byArray5, n7, n9);
            for (n15 = n10 - 1; n15 >= n7; --n15) {
                int n24 = n15;
                byArray5[n24] = (byte)(byArray5[n24] - (byArray[n14 + n15] & 0xFF));
                n18 += byArray5[n15] & 0xFF;
            }
            if (n18 < n16) {
                n16 = n18;
                byArray8 = byArray5;
                n21 = 2;
            }
            System.arraycopy(byArray, n13, byArray6, n7, n9);
            for (n15 = n10 - 1; n15 >= n7; --n15) {
                int n25 = n15;
                byArray6[n25] = (byte)(byArray6[n25] - ((byArray6[n15 - n5] & 0xFF) + (byArray[n14 + n15] & 0xFF)) / 2);
                n19 += byArray6[n15] & 0xFF;
            }
            if (n19 < n16) {
                n16 = n19;
                byArray8 = byArray6;
                n21 = 3;
            }
            System.arraycopy(byArray, n13, byArray7, n7, n9);
            for (n15 = n10 - 1; n15 >= n7; --n15) {
                n22 = byArray7[n15 - n5] & 0xFF;
                int n26 = byArray[n14 + n15] & 0xFF;
                int n27 = n15 >= n7 + n5 ? byArray[n14 + n15 - n5] & 0xFF : 0;
                int n28 = n22 + n26 - n27;
                int n29 = Math.abs(n28 - n22);
                int n30 = Math.abs(n28 - n26);
                int n31 = Math.abs(n28 - n27);
                int n32 = n29 <= n30 && n29 <= n31 ? n22 : (n30 <= n31 ? n26 : n27);
                int n33 = n15;
                byArray7[n33] = (byte)(byArray7[n33] - (byte)n32);
                n20 += byArray7[n15] & 0xFF;
            }
            if (n20 < n16) {
                n16 = n20;
                byArray8 = byArray7;
                n21 = 4;
            }
            if (!($assertionsDisabled || n4 >= 0 && n17 >= 0 && n18 >= 0 && n19 >= 0 && n20 >= 0)) {
                throw new AssertionError();
            }
            byArray2[n11++] = n21;
            System.arraycopy(byArray8, n7, byArray2, n11, n9);
            n11 += n9;
            ++n12;
            n13 += n9;
            n14 += n9;
        }
        if (!$assertionsDisabled && n11 != byArray2.length) {
            throw new AssertionError((Object)new StringBuffer().append(n11).append(" != ").append(byArray2.length).toString());
        }
        byte[] byArray9 = PDFWriter.maybeDeflateData(byArray2);
        n13 = byArray9.length;
        n14 = PDFWriter.maybeDeflateData(byArray).length;
        int n34 = byArray2 != byArray9 && n13 + PREDICT_OVERHEAD + 10 + (this.fcompact_ ? 2048 : 0) < n14 ? 1 : (n4 = 0);
        if (n4 != 0) {
            if (this.fmonitor_) {
                this.out_.print(new StringBuffer().append(" pre").append(n14 - n13).toString());
            }
            dict.put("Filter", "FlateDecode");
            dict.put("DATA", byArray9);
            Dict dict2 = new Dict(5);
            dict2.put("Predictor", Integers.getInteger(15));
            if (n6 != 1) {
                dict2.put("Colors", Integers.getInteger(n6));
            }
            dict2.put("Columns", Integers.getInteger(n));
            if (n3 != 8) {
                dict2.put("BitsPerComponent", Integers.getInteger(8));
            }
            dict.put("DecodeParms", dict2);
        }
        return n4 != 0;
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.setOut(System.out);
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (System.getSecurityManager() != null) {
                string = "-compact";
            }
            if (string.startsWith("-force")) {
                this.fforce_ = true;
                continue;
            }
            if (string.startsWith("-old") || string.startsWith("-compat")) {
                this.fold_ = true;
                this.fcompact0_ = false;
                continue;
            }
            if (string.startsWith("-compact") || string.startsWith("-bulk")) {
                this.fcompact0_ = true;
                this.fold_ = false;
                continue;
            }
            if (string.startsWith("-nostruct")) {
                this.fstruct_ = false;
                continue;
            }
            if (string.startsWith("-nowebcap")) {
                this.fwebcap_ = false;
                continue;
            }
            if (string.startsWith("-nopagep")) {
                this.fpagepiece_ = false;
                continue;
            }
            if (string.equals("-jpeg") || string.equals("-jpg")) {
                this.fjpeg_ = true;
                continue;
            }
            if (string.startsWith("-jpeg2") || string.startsWith("-jpg2")) {
                this.fjpeg2000_ = true;
                continue;
            }
            if (string.startsWith("-noalt")) {
                this.falt_ = false;
                continue;
            }
            if (string.startsWith("-nocore")) {
                this.fcore14_ = false;
                continue;
            }
            if (string.startsWith("-subset")) {
                this.setSubset(true);
                continue;
            }
            if (string.startsWith("-noembed")) {
                this.fembed_ = false;
                continue;
            }
            if (string.startsWith("-noout") || string.startsWith("-nobook")) {
                this.foutline_ = false;
                continue;
            }
            if (string.equals("-max") || string.equals("-all")) {
                this.setMax();
                continue;
            }
            if (string.equals("-web")) {
                this.fcore14_ = false;
                this.falt_ = false;
                this.fpagepiece_ = false;
                this.fjpeg_ = true;
                continue;
            }
            if (string.equals("-password")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-inplace")) {
                this.finplace_ = true;
                continue;
            }
            if (string.startsWith("-test")) {
                this.ftestable_ = true;
                continue;
            }
            if (string.equals("-nopre")) {
                this.fpre_ = false;
                continue;
            }
            if (string.equals("-nocs")) {
                this.fcontent_ = false;
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println(new StringBuffer().append("Unknown option: ").append(string).toString());
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        Compress compress = new Compress((PDFReader)null);
        int n = compress.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.canRead() || System.getSecurityManager() != null) continue;
            try {
                boolean bl;
                if (System.getSecurityManager() == null) {
                    compress.pdfr_ = new PDFReader(file);
                }
                if (!(bl = compress.setPassword(compress.password_))) {
                    System.err.println(new StringBuffer().append(file).append(": invalid password").toString());
                    continue;
                }
                String string = file.getPath();
                if (file.getName().toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                compress.writeFile(compress.finplace_ ? file : new File(new StringBuffer().append(string).append("-o.pdf").toString()));
            }
            catch (Exception exception) {
                System.err.println(new StringBuffer().append(file).append(": ").append(exception).toString());
            }
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$tool$pdf$Compress == null ? (class$tool$pdf$Compress = Compress.class$("tool.pdf.Compress")) : class$tool$pdf$Compress).desiredAssertionStatus();
        PREDICT_OVERHEAD = "/DecodeParms<</Predictor 15/Columns10/Colors 3>>>>".length();
        CORE14 = new String[]{"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique", "Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Symbol", "ZapfDingbats", "NimbusRomNo9L-Regu", "NimbusRomNo9L-ReguItal", "NimbusRomNo9L-Medi", "NimbusRomNo9L-MediItal", "NimbusSanL-Regu", "NimbusSanL-Bold", "NimbusSanL-ReguItal", "NimbusSanL-BoldItal", "NimbusMonL-Regu", "NimbusMonL-Bold", "NimbusMonL-ReguObli", "NimbusMonL-BoldObli", "Standard Symbols L", "Dingbats"};
        Arrays.sort(CORE14);
        TTF_KEEP = new int[]{1735162214, 1819239265, 1668112752, 1751474532, 1751672161, 1752003704, 1835104368, 1668707360, 1718642541, 1886545264, 1330851634, 1886352244, 1734439792, 1751412088, 1280594760};
        Arrays.sort(TTF_KEEP);
    }
}

