/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.lang.Maths;
import phelps.lang.StringBuffers;

public class CryptFilter
extends FilterInputStream {
    private SecurityHandler sh_;
    private String CFM_ = "None";
    private byte[] key_ = null;
    private byte[] buf_ = null;
    private int bufi_ = 0;
    private int len_ = -1;
    public static final CryptFilter IDENTITY;
    static final /* synthetic */ boolean $assertionsDisabled;

    CryptFilter(Dict dict, SecurityHandler securityHandler) {
        super(null);
        this.sh_ = securityHandler;
        if (dict != null) {
            if (!$assertionsDisabled && dict.get("Type") != null && !"CryptFilter".equals(dict.get("Type"))) {
                throw new AssertionError();
            }
            Object object = dict.get("CFM");
            String string = this.CFM_ = object != null ? (String)object : "None";
            if (!($assertionsDisabled || "None".equals(this.CFM_) || "V2".equals(this.CFM_))) {
                throw new AssertionError();
            }
            if ("V2".equals(this.CFM_)) {
                object = dict.get("Length");
                int n = object instanceof Number ? ((Number)object).intValue() : 128;
                n = Maths.minmax(40, n, 3072);
                this.key_ = this.sh_.getKey();
                this.sh_ = new SecurityHandlerStandard(this.key_);
            } else if (!$assertionsDisabled && !"None".equals(this.CFM_)) {
                throw new AssertionError();
            }
        }
    }

    private SecurityHandler getSecurityHandler() {
        return this.sh_;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2) {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n + n2 <= byArray.length)) {
            throw new AssertionError();
        }
        this.sh_.decrypt(byArray, n, n2);
        return byArray;
    }

    public byte[] encrypt(byte[] byArray, int n, int n2) {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n + n2 <= byArray.length)) {
            throw new AssertionError();
        }
        this.sh_.encrypt(byArray, n, n2);
        return byArray;
    }

    public void decrypt(StringBuffer stringBuffer) {
        if (!$assertionsDisabled && stringBuffer == null) {
            throw new AssertionError();
        }
        if (SecurityHandler.IDENTITY == this.getSecurityHandler()) {
            return;
        }
        byte[] byArray = StringBuffers.getBytes8(stringBuffer);
        byArray = this.decrypt(byArray, 0, byArray.length);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.setCharAt(i, (char)(byArray[i] & 0xFF));
        }
    }

    public void encrypt(StringBuffer stringBuffer) {
        if (!$assertionsDisabled && stringBuffer == null) {
            throw new AssertionError();
        }
        if (SecurityHandler.IDENTITY == this.getSecurityHandler()) {
            return;
        }
        byte[] byArray = StringBuffers.getBytes8(stringBuffer);
        byArray = this.encrypt(byArray, 0, byArray.length);
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.setCharAt(i, (char)(byArray[i] & 0xFF));
        }
    }

    public CryptFilter reset(int n, int n2) {
        if (!($assertionsDisabled || n >= 1 && n2 >= 0)) {
            throw new AssertionError(n);
        }
        this.sh_.reset(n, n2);
        return this;
    }

    public CryptFilter(CryptFilter cryptFilter, InputStream inputStream, int n, int n2) throws IOException {
        super(inputStream);
        this.buf_ = new byte[8192];
        this.len_ = 0;
        this.sh_ = (SecurityHandler)cryptFilter.sh_.clone();
        this.CFM_ = cryptFilter.CFM_;
        this.key_ = cryptFilter.key_;
        this.sh_.reset(n, n2);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.len_ == -1) {
            return -1;
        }
        if (this.bufi_ < this.len_) {
            int n3 = Math.min(n2, this.len_ - this.bufi_);
            System.arraycopy(this.buf_, this.bufi_, byArray, n, n3);
            this.bufi_ += n3;
            return n3;
        }
        this.fill();
        return this.read(byArray, n, n2);
    }

    public int read() throws IOException {
        if (this.len_ == -1) {
            return -1;
        }
        if (this.bufi_ < this.len_) {
            return this.buf_[this.bufi_++] & 0xFF;
        }
        this.fill();
        return this.read();
    }

    private void fill() throws IOException {
        this.len_ = this.in.read(this.buf_);
        if (this.len_ != -1) {
            this.decrypt(this.buf_, 0, this.len_);
        }
        this.bufi_ = 0;
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        this.len_ = -1;
        super.close();
    }

    public String toString() {
        return this.getSecurityHandler().toString();
    }

    static {
        $assertionsDisabled = !CryptFilter.class.desiredAssertionStatus();
        IDENTITY = new CryptFilter(null, SecurityHandler.IDENTITY);
    }
}

