/*
 * Decompiled with CFR 0.152.
 */
package multivalent.gui;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.INode;
import multivalent.IScrollPane;
import multivalent.Leaf;
import multivalent.Mark;
import multivalent.node.IParaBox;
import multivalent.node.LeafText;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VTextArea
extends IScrollPane {
    static final int FUZZ = 30;
    INode layout_ = null;

    public VTextArea(String string, Map<String, Object> map, INode iNode) {
        this(string, map, iNode, null);
    }

    public VTextArea(String string, Map<String, Object> map, INode iNode, INode iNode2) {
        super(string, map, iNode);
        if (iNode2 == null) {
            iNode2 = new IParaBox("layoutT", null, null);
        }
        this.layout_ = iNode2;
        this.appendChild(iNode2);
        this.fixContent();
        this.setScrollbarShowPolicy((byte)2);
        this.setSizeChars(60, 5);
        this.editable = true;
    }

    protected void fixContent() {
    }

    @Override
    public boolean formatNode(int n, int n2, Context context) {
        this.fixContent();
        int n3 = 0;
        if (this.border.top == 0 && this.border.bottom == 0 && this.border.left == 0 && this.border.right == 0) {
            n3 = 1;
            this.border = INSETS[n3];
        }
        super.formatNode(n - n3 - n3, n2 - n3 - n3, context);
        this.baseline = this.bbox.height;
        return false;
    }

    @Override
    public boolean breakBefore() {
        return false;
    }

    @Override
    public boolean breakAfter() {
        return false;
    }

    @Override
    public void paintNode(Rectangle rectangle, Context context) {
        super.paintNode(rectangle, context);
    }

    @Override
    public boolean eventNode(AWTEvent aWTEvent, Point point) {
        int n = aWTEvent.getID();
        Browser browser = this.getBrowser();
        boolean bl = super.eventNode(aWTEvent, point);
        if (n == 501 && browser.getCurNode() == this) {
            Mark mark = this.findNearestLeaf(point);
            this.getBrowser().getCursorMark().move(mark);
            browser.setCurNode(mark);
        }
        return bl;
    }

    Mark findNearestLeaf(Point point) {
        Mark mark = new Mark();
        int n = Integer.MAX_VALUE;
        int n2 = point.x;
        int n3 = point.y;
        Leaf leaf = this.getLastLeaf().getNextLeaf();
        for (Leaf leaf2 = this.getFirstLeaf(); leaf2 != leaf; leaf2 = leaf2.getNextLeaf()) {
            Point point2 = leaf2.getRelLocation(this);
            int n4 = (point2.x - n2) * (point2.x - n2) + (point2.y - n3) * (point2.y - n3);
            if (n4 >= n) continue;
            mark.leaf = leaf2;
            mark.offset = n2 < point2.x ? 0 : leaf2.size();
        }
        return mark;
    }

    public String getContent() {
        StringBuffer stringBuffer = new StringBuffer(100);
        Leaf leaf = this.getLastLeaf().getNextLeaf();
        for (Leaf leaf2 = this.getFirstLeaf(); leaf2 != leaf; leaf2 = leaf2.getNextLeaf()) {
            if (!(leaf2 instanceof LeafText)) continue;
            stringBuffer.append(leaf2.getName()).append(' ');
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.substring(0);
    }
}

