/*
 * Decompiled with CFR 0.152.
 */
package tool.pdf;

import com.pt.io.FileList;
import com.pt.io.InputUni;
import com.pt.io.InputUniByteArray;
import com.pt.io.InputUniFile;
import com.pt.io.OutputUni;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import multivalent.ParseException;
import multivalent.std.adaptor.pdf.Action;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.PDFReader;
import multivalent.std.adaptor.pdf.PDFWriter;
import multivalent.std.adaptor.pdf.SecurityHandler;
import multivalent.std.adaptor.pdf.SecurityHandlerStandard;
import phelps.io.PrintStreams;
import phelps.lang.Integers;
import phelps.util.Arrayss;
import phelps.util.Units;

public class Split {
    static final boolean DEBUG = false;
    public static final String VERSION = "1.4.1 of $Date: 2005/03/06 06:52:57 $";
    public static final String COPYRIGHT = "Copyright (c) 2003 - 2005  Thomas A. Phelps.  All rights reserved.";
    private static final String USAGE = "java tool.pdf.Split [<options>] <PDF-file>\n\t[-page <range>] [-1] [-doublesided]\n\t[-password <password>] [-verbose] [-quiet]";
    private static final String[] CAT_ZAP = new String[]{"PageLabels", "Threads", "StructTreeRoot", "SpiderInfo", "OpenAction"};
    private String range_ = null;
    private boolean fduplex_ = false;
    private boolean fone_ = false;
    private boolean fverbose_ = false;
    private boolean fquiet_ = false;
    private boolean fmonitor_ = false;
    private PrintStream out_ = PrintStreams.DEVNULL;
    private String password_ = null;
    private PDFReader pdfr_;

    public Split(File file) throws IOException, ParseException {
        this(new InputUniFile(file));
    }

    public Split(byte[] byArray) throws IOException, ParseException {
        this(new InputUniByteArray(byArray));
    }

    public Split(InputUni inputUni) throws IOException, ParseException {
        this(new PDFReader(inputUni));
    }

    public Split(PDFReader pDFReader) {
    }

    public void setOut(PrintStream printStream) {
        this.out_ = printStream != null ? printStream : PrintStreams.DEVNULL;
    }

    public void setRange(String string) {
        this.range_ = string;
    }

    public void setRange(int n, int n2) {
        this.range_ = n + "-" + n2;
    }

    public boolean setPassword(String string) throws IOException {
        boolean bl = this.pdfr_.setPassword(string);
        return bl && this.allow();
    }

    private boolean allow() {
        boolean bl = false;
        SecurityHandler securityHandler = this.pdfr_.getEncrypt().getSecurityHandler();
        if (securityHandler.isAuthorized()) {
            if (securityHandler instanceof SecurityHandlerStandard) {
                SecurityHandlerStandard securityHandlerStandard = (SecurityHandlerStandard)securityHandler;
                int n = securityHandlerStandard.getR();
                int n2 = securityHandlerStandard.getPerm();
                if (n == 2 && (n2 & 8) == 0 || n >= 3 && (n2 & 0x400) == 0) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public int[] getBookmarkPages(int n) throws IOException {
        n = Math.min(n, 1);
        int[] nArray = new int[this.pdfr_.getPageCnt()];
        boolean bl = false;
        return null;
    }

    public void writeFile(File file) throws IOException, ParseException {
        this.writeUni(OutputUni.getInstance(file, null));
    }

    public byte[] writeBytes() throws IOException, ParseException {
        OutputUni outputUni = OutputUni.getInstance(new byte[this.pdfr_.getObjCnt() * 100], null);
        this.writeUni(outputUni);
        return outputUni.toByteArray();
    }

    public void writeUni(OutputUni outputUni) throws IOException, ParseException {
        this.split(new PDFWriter(outputUni, this.pdfr_));
    }

    public PDFReader writePipe() throws IOException, ParseException {
        return null;
    }

    private void writeInteractive(File file, String string) throws IOException, ParseException {
        int[][] nArray;
        String string2 = this.range_;
        String string3 = this.range_;
        int n = this.pdfr_.getPageCnt();
        if (this.fone_) {
            string3 = string3 != null ? string3.replace(';', ',') + "/1" : "/1";
        }
        boolean bl = (nArray = Units.parseRanges(string3, 1, n)).length == 1;
        int n2 = 1;
        int[][] nArray2 = nArray;
        int n3 = nArray2.length;
        for (int i = 0; i < n3; ++i) {
            Object object;
            Object object2;
            int[] nArray3 = nArray2[i];
            String string4 = string + "-x" + (bl ? "" : Integer.toString(n2++));
            if (this.fduplex_) {
                object2 = new int[(nArray3.length + 1) / 2];
                object = new int[((int[])object2).length];
                int n4 = 0;
                int n5 = nArray3.length;
                int n6 = 0;
                while (n4 < n5) {
                    object2[n6] = nArray3[n4];
                    object[n6] = n4 + 1 < n5 ? nArray3[n4 + 1] : 0;
                    n4 += 2;
                    ++n6;
                }
                File file2 = new File(file, string4 + "-fronts.pdf");
                if (this.fverbose_) {
                    this.out_.println(file2);
                }
                this.setRange(Units.toRange(object2));
                PDFWriter pDFWriter = new PDFWriter(file2, this.pdfr_, false);
                this.split(pDFWriter);
                this.pdfr_.reset();
                file2 = new File(file, string4 + "-backs.pdf");
                if (this.fverbose_) {
                    this.out_.println(file2);
                }
                this.setRange(Units.toRange(object));
                pDFWriter = new PDFWriter(file2, this.pdfr_, false);
                this.split(pDFWriter);
            } else {
                object2 = new File(file, string4 + ".pdf");
                if (this.fverbose_) {
                    this.out_.println(object2);
                }
                this.setRange(Units.toRange(nArray3));
                object = new PDFWriter((File)object2, this.pdfr_, false);
                this.split((PDFWriter)object);
            }
            if (this.fmonitor_) {
                this.out_.println(this.pdfr_.countCached() + " cached of " + this.pdfr_.getObjCnt() + " total objects");
            }
            this.pdfr_.reset();
        }
        this.close();
        this.range_ = string3;
    }

    private Object split(PDFWriter pDFWriter) throws IOException, ParseException {
        if (!this.allow()) {
            throw new ParseException("Don't have permission to 'assemble' -- try OWNER password");
        }
        if (this.range_ != null && this.range_.indexOf(59) != -1) {
            throw new ParseException("multiple ranges not supported -- use multiple writeXXX() invocations");
        }
        this.split2(pDFWriter);
        Object object = pDFWriter.writePDF();
        pDFWriter.close();
        return object;
    }

    private void split2(PDFWriter pDFWriter) throws IOException, ParseException {
        Dict dict;
        Object object;
        pDFWriter.setPassword(this.password_);
        int n = this.pdfr_.getPageCnt();
        int[] nArray = Units.parseRange(this.range_, 1, n);
        Dict dict2 = null;
        ArrayList<IRef> arrayList = new ArrayList<IRef>(n);
        boolean[] blArray = new boolean[n + 1];
        int[] nArray2 = nArray;
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            Dict dict3;
            IRef iRef;
            int n3 = nArray2[i];
            if (n3 <= 0) {
                if (dict2 == null) {
                    dict2 = new Dict(5);
                    dict2.put("Type", "Page");
                    object = this.pdfr_.getPage(1);
                    dict2.put("MediaBox", ((Dict)object).get("MediaBox"));
                    Dict dict4 = new Dict();
                    dict4.put("DATA", new byte[0]);
                    dict2.put("Contents", pDFWriter.addObject(dict4));
                }
                iRef = pDFWriter.addObject(dict2);
                dict3 = dict2;
            } else {
                iRef = this.pdfr_.getPageRef(n3);
                dict3 = this.pdfr_.getPage(n3);
                dict3 = (Dict)pDFWriter.getObject(iRef);
                if (!blArray[n3]) {
                    blArray[n3] = true;
                } else {
                    if (this.fmonitor_) {
                        System.out.println(" dup" + n3);
                    }
                    iRef = pDFWriter.addObject(new Dict(dict3));
                }
            }
            arrayList.add(iRef);
            dict3.remove("B");
        }
        for (int i = 1; i <= n; ++i) {
            if (blArray[i]) continue;
            pDFWriter.setObject(this.pdfr_.getPageRef((int)i).id, COS.OBJECT_NULL);
        }
        Dict dict5 = pDFWriter.getCatalog();
        Dict dict6 = (Dict)pDFWriter.getObject(dict5.get("Names"));
        Dict dict7 = dict = dict6 != null ? (Dict)pDFWriter.getObject(dict6.get("Dests")) : null;
        if (dict != null) {
            this.cleanNamedDests(dict, pDFWriter);
        }
        Object object2 = CAT_ZAP;
        int n4 = ((String[])object2).length;
        for (int i = 0; i < n4; ++i) {
            object = object2[i];
            dict5.remove((String)object);
        }
        object2 = pDFWriter.getObject(dict5.get("Outlines"));
        if (object2 != null && COS.CLASS_DICTIONARY == object2.getClass()) {
            Dict dict8 = (Dict)object2;
            this.winnowOutline(dict8, pDFWriter);
            IRef iRef = (IRef)dict8.get("First");
            object = (IRef)dict8.get("Last");
            if (iRef == null) {
                dict5.remove("Outlines");
            } else if (((Number)dict8.get("Count")).intValue() < 0) {
                dict8.remove("Count");
            }
        }
        if (dict5.get("AcroForm") != null) {
            boolean[] blArray2 = new boolean[n + 1];
            boolean bl = false;
            boolean bl2 = false;
            block3: for (int i = 1; i <= n; ++i) {
                Dict dict9 = this.pdfr_.getPage(i);
                Object[] objectArray = (Object[])this.pdfr_.getObject(dict9.get("Annots"));
                if (objectArray == null) continue;
                int n5 = objectArray.length;
                for (int j = 0; j < n5; ++j) {
                    Dict dict10 = (Dict)this.pdfr_.getObject(objectArray[j]);
                    if (!"Widget".equals(this.pdfr_.getObject(dict10.get("Subtype")))) continue;
                    blArray2[i] = true;
                    if (blArray[i]) {
                        bl = true;
                        continue block3;
                    }
                    bl2 = true;
                    continue block3;
                }
            }
            if (!bl) {
                dict5.remove("AcroForm");
            } else if (bl2) {
                int n6;
                this.out_.println("WARNING: split off pages have some but not all pages of an interactive form");
                int[] nArray3 = new int[n + 1];
                int n7 = 0;
                for (n6 = 1; n6 <= n; ++n6) {
                    if (!blArray2[n6] || !blArray[n6]) continue;
                    nArray3[n7++] = n6;
                }
                if (n7 > 0) {
                    this.out_.println("   pages with form: " + Units.toRange(Arrayss.resize(nArray3, n7)));
                }
                n7 = 0;
                for (n6 = 1; n6 <= n; ++n6) {
                    if (!blArray2[n6] || blArray[n6]) continue;
                    nArray3[n7++] = n6;
                }
                if (n7 > 0) {
                    this.out_.println("   pages without form: " + Units.toRange(Arrayss.resize(nArray3, n7)));
                }
            }
        }
        pDFWriter.resetPageTree(arrayList);
        pDFWriter.refcntRemove();
        pDFWriter.liftPageTree();
    }

    private Object cleanNamedDests(Object object, PDFWriter pDFWriter) throws IOException {
        Object object2 = null;
        if (COS.CLASS_DICTIONARY != (object = pDFWriter.getObject(object)).getClass()) {
            return object2;
        }
        Dict dict = (Dict)object;
        if (dict.get("Kids") != null) {
            Object[] objectArray = (Object[])pDFWriter.getObject(dict.get("Kids"));
            int n = 0;
            int n2 = objectArray.length;
            for (int i = 0; i < n2; ++i) {
                if (this.cleanNamedDests(objectArray[i], pDFWriter) != COS.OBJECT_NULL) continue;
                objectArray[i] = COS.OBJECT_NULL;
                ++n;
            }
            if (n == objectArray.length) {
                object2 = COS.OBJECT_NULL;
            } else if (n > 0) {
                Object[] objectArray2 = (Object[])pDFWriter.getObject(dict.get("Limits"));
                int n3 = objectArray.length;
                for (n2 = 0; n2 < n3 && objectArray[n2] == COS.OBJECT_NULL; ++n2) {
                }
                for (n3 = objectArray.length - 1; n3 >= 0 && objectArray[n3] == COS.OBJECT_NULL; --n3) {
                }
                Object[] objectArray3 = Arrayss.subset(objectArray, n2, n3 - n2 + 1);
                dict.put("Kids", objectArray3);
            }
        } else if (dict.get("Names") != null) {
            Object[] objectArray = (Object[])pDFWriter.getObject(dict.get("Names"));
            int n = 0;
            int n4 = objectArray.length;
            for (int i = 0; i < n4; i += 2) {
                if (this.cleanNamedDests(objectArray[i + 1], pDFWriter) != COS.OBJECT_NULL) continue;
                Object object3 = COS.OBJECT_NULL;
                objectArray[i + 1] = object3;
                objectArray[i] = object3;
                ++n;
            }
            if (n == objectArray.length / 2) {
                object2 = COS.OBJECT_NULL;
            } else if (n > 0) {
                Object[] objectArray4 = (Object[])pDFWriter.getObject(dict.get("Limits"));
                int n5 = objectArray.length;
                for (n4 = 0; n4 < n5 && objectArray[n4 + 1] == COS.OBJECT_NULL; n4 += 2) {
                }
                for (n5 = objectArray.length - 2; n5 >= 0 && n5 > n4 && objectArray[n5 + 1] == COS.OBJECT_NULL; n5 -= 2) {
                }
                Object[] objectArray5 = new Object[n5 - n4 + 2];
                System.arraycopy(objectArray, n4, objectArray5, 0, n5 - n4 + 2);
                dict.put("Names", objectArray5);
            }
        } else {
            Object[] objectArray;
            Object object4 = dict.get("D");
            if (object4 != null && COS.CLASS_ARRAY == object4.getClass() && (objectArray = (Object[])object4).length > 0 && COS.CLASS_IREF == objectArray[0].getClass()) {
                object2 = pDFWriter.getObject(objectArray[0]);
            }
        }
        return object2;
    }

    private void cleanLinks() {
    }

    private int winnowOutline(Dict dict, PDFWriter pDFWriter) throws IOException {
        Object object;
        int n = 0;
        IRef iRef = (IRef)dict.get("First");
        Object object2 = pDFWriter.getObject(iRef);
        if (object2 != null) {
            object = new ArrayList(20);
            Dict dict2 = (Dict)object2;
            while (dict2 != null) {
                int n2 = this.winnowOutline(dict2, pDFWriter);
                if (dict2.get("First") != null || dict2.get("A") != null || dict2.get("Dest") != null) {
                    object.add(iRef);
                    object2 = pDFWriter.getObject(dict.get("Count"));
                    if (object2 instanceof Number && ((Number)object2).intValue() >= 0) {
                        n += n2;
                    }
                    ++n;
                } else {
                    pDFWriter.setObject(iRef.id, COS.OBJECT_NULL);
                }
                iRef = (IRef)dict2.get("Next");
                dict2 = (Dict)pDFWriter.getObject(iRef);
            }
            int n3 = object.size();
            if (n3 == 0) {
                dict.remove("First");
                dict.remove("Last");
                dict.remove("Count");
            } else {
                int n4;
                iRef = (IRef)object.get(0);
                dict.put("First", iRef);
                IRef iRef2 = null;
                for (n4 = 0; n4 < n3; ++n4) {
                    IRef iRef3 = n4 + 1 < n3 ? (IRef)object.get(n4 + 1) : null;
                    Dict dict3 = (Dict)pDFWriter.getObject(iRef);
                    if (iRef2 != null) {
                        dict3.put("Prev", iRef2);
                    } else {
                        dict3.remove("Prev");
                    }
                    if (iRef3 != null) {
                        dict3.put("Next", iRef3);
                    } else {
                        dict3.remove("Next");
                    }
                    iRef2 = iRef;
                    iRef = iRef3;
                }
                dict.put("Last", iRef2);
                object2 = pDFWriter.getObject(dict.get("Count"));
                n4 = object2 instanceof Number && ((Number)object2).intValue() >= 0 ? 1 : 0;
                dict.put("Count", Integers.getInteger(n4 != 0 ? n : -n));
                if (n4 == 0) {
                    n = 0;
                }
            }
        }
        if ((object2 = dict.get("Dest")) != null) {
            object = Action.resolveNamedDest(object2, this.pdfr_);
            if (COS.CLASS_ARRAY == object.getClass()) {
                object = ((Object[])object)[0];
            }
            if (object == null || COS.OBJECT_NULL == pDFWriter.getObject(object)) {
                dict.remove("Dest");
            }
        }
        if ((object2 = dict.get("A")) != null && "GoTo".equals(pDFWriter.getObject(((Dict)(object = (Dict)pDFWriter.getObject(object2))).get("S")))) {
            Object object3 = Action.resolveNamedDest(pDFWriter.getObject(((Dict)object).get("D")), this.pdfr_);
            if (object3 != null && COS.CLASS_ARRAY == object3.getClass()) {
                object3 = ((Object[])object3)[0];
            }
            if (COS.OBJECT_NULL == pDFWriter.getObject(object3)) {
                dict.remove("A");
            }
        }
        if (dict.get("First") != null && dict.get("Dest") != null && dict.get("A") != null) {
            object = (Dict)pDFWriter.getObject(dict.get("First"));
            object2 = ((Dict)object).get("Dest");
            if (object2 != null) {
                ((Dict)object).put("Dest", object2);
            }
            if ((object2 = ((Dict)object).get("A")) != null) {
                ((Dict)object).put("A", object2);
            }
        }
        return n;
    }

    public void close() throws IOException {
        this.pdfr_.close();
    }

    private int commandLine(String[] stringArray) {
        String string;
        int n;
        this.out_ = System.out;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && (string = stringArray[n]).startsWith("-"); ++n) {
            if ((string = string.toLowerCase()).startsWith("--")) {
                string = string.substring(1);
            }
            if (string.startsWith("-page") || string.startsWith("-range")) {
                this.setRange(stringArray[++n]);
                continue;
            }
            if (string.startsWith("-double") || string.startsWith("-duplex")) {
                this.fduplex_ = true;
                continue;
            }
            if (string.equals("-1") || string.equals("-l")) {
                this.fone_ = true;
                this.fduplex_ = false;
                continue;
            }
            if (string.startsWith("-pass")) {
                this.password_ = stringArray[++n];
                continue;
            }
            if (string.startsWith("-verb")) {
                this.fverbose_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-mon")) {
                this.fverbose_ = true;
                this.fmonitor_ = true;
                this.fquiet_ = false;
                continue;
            }
            if (string.startsWith("-q")) {
                this.fquiet_ = true;
                this.fverbose_ = false;
                this.fmonitor_ = false;
                continue;
            }
            if (string.startsWith("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (string.startsWith("-h")) {
                System.out.println(USAGE);
                System.exit(0);
                continue;
            }
            System.err.println("Unknown option: " + string);
            System.err.println(USAGE);
            System.exit(1);
        }
        if (n == n2) {
            System.err.println(USAGE);
            System.exit(0);
        }
        if (this.range_ == null) {
            if (this.fduplex_ || this.fone_) {
                this.setRange("all");
            } else {
                System.err.println("must set -page <range> (or -1 or -doublesided)");
                System.exit(1);
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Split split = new Split((PDFReader)null);
        int n = split.commandLine(stringArray);
        Iterator<File> iterator = new FileList(stringArray, n, COS.FILTER).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (System.getSecurityManager() != null) continue;
            try {
                split.pdfr_ = new PDFReader(file);
                boolean bl = split.setPassword(split.password_);
                if (!bl) {
                    System.err.println(file + ": try OWNER password");
                    continue;
                }
                String string = file.getName();
                if (string.toLowerCase().endsWith(".pdf")) {
                    string = string.substring(0, string.length() - 4);
                }
                split.writeInteractive(file.getParentFile(), string);
            }
            catch (Exception exception) {
                System.err.println(file + ": " + exception);
                System.exit(1);
            }
        }
        System.exit(0);
    }
}

