/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import java.io.IOException;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.Function;
import multivalent.std.adaptor.pdf.PDFReader;

class Exponential
extends Function {
    static final float[] C0_DEFAULT;
    static final float[] C1_DEFAULT;
    float[] C0_;
    float[] C1_;
    double N_;
    static final /* synthetic */ boolean $assertionsDisabled;

    Exponential(Dict dict, PDFReader pDFReader) throws IOException {
        super(dict, pDFReader);
        this.C0_ = this.toFloatArray((Object[])pDFReader.getObject(dict.get("C0")), C0_DEFAULT);
        this.C1_ = this.toFloatArray((Object[])pDFReader.getObject(dict.get("C1")), C1_DEFAULT);
        this.N_ = ((Number)pDFReader.getObject(dict.get("N"))).floatValue();
    }

    public int getN() {
        return this.C0_.length;
    }

    public void compute(float[] fArray, float[] fArray2) {
        this.clip(fArray, this.domain_);
        float f = fArray[0];
        if (!$assertionsDisabled && this.getM() > fArray.length) {
            throw new AssertionError((Object)(this.getM() + " ==? " + fArray.length));
        }
        int n = this.getN();
        if (!$assertionsDisabled && n != fArray2.length) {
            throw new AssertionError((Object)(n + " vs " + fArray2.length));
        }
        float[] fArray3 = this.C0_;
        float[] fArray4 = this.C1_;
        if (this.N_ == 1.0) {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = fArray3[i] + f * (fArray4[i] - fArray3[i]);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray2[i] = fArray3[i] + (float)Math.pow(f, this.N_) * (fArray4[i] - fArray3[i]);
            }
        }
        if (this.range_ != null) {
            this.clip(fArray2, this.range_);
        }
    }

    static {
        $assertionsDisabled = !Exponential.class.desiredAssertionStatus();
        C0_DEFAULT = new float[]{0.0f};
        C1_DEFAULT = new float[]{1.0f};
    }
}

