/*
 * Decompiled with CFR 0.152.
 */
package multivalent.devel;

import com.pt.awt.NFont;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import multivalent.Behavior;
import multivalent.Browser;
import multivalent.CLGeneral;
import multivalent.Context;
import multivalent.ContextListener;
import multivalent.CursorMark;
import multivalent.Document;
import multivalent.ESISNode;
import multivalent.EventListener;
import multivalent.INode;
import multivalent.IScrollPane;
import multivalent.Layer;
import multivalent.Mark;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import multivalent.VObject;
import multivalent.gui.VCheckbox;
import multivalent.gui.VScrollbar;
import multivalent.node.Fixed;
import multivalent.node.IVBox;
import multivalent.node.LeafText;
import multivalent.node.LeafUnicode;
import multivalent.node.Root;
import phelps.lang.Booleans;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowDocTree
extends Behavior
implements EventListener {
    public static final String MSG_SHOW = "showDocTree";
    public static final String MSG_SHOWROOT = "showDocTree/Root";
    public static final String MSG_SET_SHOWLEAF = "showDocTree/setShowLeaf";
    static Color guideColor = new Color(224, 224, 224);
    static NFont FONT_PLAIN = NFont.getInstance("Times", 400, 2, 10.0f);
    static NFont FONT_BOLD = NFont.getInstance(FONT_PLAIN.getFamily(), 700, FONT_PLAIN.getFlags(), FONT_PLAIN.getSize());
    static int displayH_ = (int)Math.ceil(FONT_PLAIN.getSize());
    static INode popup_ = new IVBox("menu", null, null);
    Node[] nodes_ = null;
    boolean[] nvalid_ = null;
    Document obsdoc_ = null;
    Document showdoc_ = null;
    int oldvsbmin_;
    int oldvsbmax_;
    int oldvsbval_;
    boolean showLeaf_ = true;
    Node selnode_ = null;
    int lcnt_;
    int icnt_;
    int iscnt_;
    int txtcnt_;
    int txtlen_;
    int txtmax_;
    List<String> stats_ = new ArrayList<String>(10);

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if ("createWidget/Debug" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            Document document = browser.getCurDocument();
            if (document != null) {
                VCheckbox vCheckbox = (VCheckbox)this.createUI("checkbox", "Show Doc Tree", new SemanticEvent(browser, MSG_SHOW, document), iNode, null, false);
                VCheckbox vCheckbox2 = (VCheckbox)this.createUI("checkbox", "Show Root Tree", new SemanticEvent(browser, MSG_SHOWROOT, document), iNode, null, false);
                if (this.showdoc_ != null) {
                    boolean bl = this.showdoc_ == this.getRoot();
                    vCheckbox.setState(!bl);
                    vCheckbox2.setState(bl);
                }
                VCheckbox vCheckbox3 = (VCheckbox)this.createUI("checkbox", "Show Leaves in Tree Dumps", "event showDocTree/setShowLeaf", iNode, null, false);
                vCheckbox3.setState(this.showLeaf_);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Browser browser = this.getBrowser();
        if ("closeDocument" == string && this.obsdoc_ != null) {
            this.obsdoc_.deleteObserver(this);
            this.showdoc_ = null;
            this.obsdoc_ = null;
        } else if (MSG_SET_SHOWLEAF == string) {
            this.showLeaf_ = Booleans.parseBoolean(semanticEvent.getArg(), !this.showLeaf_);
            if (this.showdoc_ != null) {
                browser.eventq(this.showdoc_ == this.getRoot() ? MSG_SHOWROOT : MSG_SHOW, this.obsdoc_);
                this.showdoc_ = null;
            }
        } else if (MSG_SHOW == string || MSG_SHOWROOT == string) {
            Node node;
            Node node2;
            if (this.obsdoc_ != null) {
                this.obsdoc_.deleteObserver(this);
                node2 = this.obsdoc_.getVsb();
                ((VScrollbar)node2).setMinMax(this.oldvsbmin_, this.oldvsbmax_);
                ((VScrollbar)node2).setValue(this.oldvsbval_);
            }
            this.nodes_ = null;
            this.nvalid_ = null;
            node2 = (Document)semanticEvent.getArg();
            Node node3 = node = MSG_SHOW == string ? node2 : this.getRoot();
            if (node == this.showdoc_) {
                this.showdoc_ = null;
                this.obsdoc_ = null;
                this.selnode_ = null;
                node2.deleteObserver(this);
            } else {
                Node node4;
                this.obsdoc_ = node2;
                this.showdoc_ = node;
                this.txtmax_ = 0;
                this.txtlen_ = 0;
                this.txtcnt_ = 0;
                this.iscnt_ = 0;
                this.icnt_ = 0;
                this.lcnt_ = 0;
                ArrayList<Node> arrayList = new ArrayList<Node>(1000);
                this.listNodes(this.showdoc_, arrayList);
                int n = arrayList.size();
                if (n > 0) {
                    this.nodes_ = new Node[n];
                    this.nvalid_ = new boolean[n];
                    for (int i = 0; i < n; ++i) {
                        this.nodes_[i] = node4 = (Node)arrayList.get(i);
                        this.nvalid_[i] = true;
                    }
                }
                this.stats_.clear();
                this.stats_.add(new StringBuffer().append(this.icnt_ + this.lcnt_).append(" total Nodes").toString());
                if (this.icnt_ > 0) {
                    this.stats_.add(new StringBuffer().append(this.icnt_).append(" INode, avg ").append(this.iscnt_ / this.icnt_).append(" children").toString());
                }
                if (this.lcnt_ > 0) {
                    this.stats_.add(new StringBuffer().append(this.lcnt_).append(" Leaf").toString());
                }
                if (this.txtcnt_ > 0) {
                    this.stats_.add(new StringBuffer().append(this.txtcnt_).append(" LeafText, avg=").append(this.txtlen_ / this.txtcnt_).append(", max=").append(this.txtmax_).toString());
                }
                VScrollbar vScrollbar = ((IScrollPane)node2).getVsb();
                node4 = ((IScrollPane)node2).getHsb();
                this.oldvsbmin_ = vScrollbar.getMin();
                this.oldvsbmax_ = vScrollbar.getMax();
                this.oldvsbval_ = vScrollbar.getValue();
                vScrollbar.setMinMax(0, displayH_ * n);
                vScrollbar.setValid(false);
                vScrollbar.formatBeforeAfter(((Document)node2).bbox.width, ((Document)node2).bbox.height, ((Document)node2).getStyleSheet().getContext());
                ((VScrollbar)node4).setValue(((VScrollbar)node4).getMin());
                CursorMark cursorMark = browser.getCursorMark();
                Span span = browser.getSelectionSpan();
                this.selnode_ = cursorMark.isSet() ? cursorMark.getMark().leaf : (span.isSet() ? span.getStart().leaf : null);
                if (this.selnode_ != null) {
                    if (!this.showLeaf_) {
                        this.selnode_ = this.selnode_.getParentNode();
                    }
                    for (int i = 0; i < n; ++i) {
                        if (this.selnode_ != this.nodes_[i]) continue;
                        vScrollbar.setValue(displayH_ * Math.max(i - 10, 0));
                        break;
                    }
                }
                node2.addObserver(this);
            }
            browser.repaint(100L);
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    public void listNodes(Node node, List<Node> list) {
        if (node.isStruct()) {
            list.add(node);
            INode iNode = (INode)node;
            int n = iNode.size();
            for (int i = 0; i < n; ++i) {
                this.listNodes(iNode.childAt(i), list);
            }
            ++this.icnt_;
            this.iscnt_ += iNode.size();
        } else {
            if (this.showLeaf_) {
                list.add(node);
            }
            ++this.lcnt_;
            if (node instanceof LeafText) {
                ++this.txtcnt_;
                this.txtlen_ += node.size();
                this.txtmax_ = Math.max(this.txtmax_, node.size());
            }
        }
    }

    @Override
    public boolean eventBefore(AWTEvent aWTEvent, Point point, Node node) {
        return point == null || point.x <= this.obsdoc_.bbox.width - VScrollbar.SIZE || aWTEvent.getID() != 501;
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        MouseEvent mouseEvent;
        int n = aWTEvent.getID();
        if (n == 501 && (mouseEvent = (MouseEvent)aWTEvent).getModifiers() == 4) {
            List<ContextListener> list;
            Node node2 = this.nodes_[point.y / displayH_];
            popup_.removeAllChildren();
            ArrayList<Object> arrayList = new ArrayList<Object>(10);
            INode iNode = node2.getParentNode();
            arrayList.add(new StringBuffer().append("parent = ").append(iNode != null ? iNode.getName() : "(null)").append(", class=").append(node2.getClass().getName()).toString());
            int n2 = arrayList.size();
            if (arrayList.size() > n2) {
                arrayList.add(n2, "*** Warnings ***");
            }
            if ((list = node2.getActivesAt(-1)).size() > 0) {
                arrayList.add("*** Actives ***");
            }
            arrayList.addAll(list);
            if (arrayList.size() == 0) {
                arrayList.add("(No details)");
            }
            int n3 = arrayList.size();
            for (int i = 0; i < n3; ++i) {
                new LeafUnicode(arrayList.get(i).toString(), null, popup_);
            }
            Browser browser = this.getBrowser();
            Root root = this.getRoot();
            CLGeneral cLGeneral = new CLGeneral();
            cLGeneral.setBackground(Color.WHITE);
            ShowDocTree.popup_.bbox.setLocation(mouseEvent.getX() + displayH_, mouseEvent.getY() + 10);
            root.appendChild(popup_);
            browser.repaint();
            browser.setGrab(this);
        }
        return false;
    }

    @Override
    public void event(AWTEvent aWTEvent) {
        int n = aWTEvent.getID();
        if (n == 502 || n == 506) {
            Browser browser = this.getBrowser();
            browser.releaseGrab(this);
            popup_.remove();
            if (n == 506) {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                browser.eventq(mouseEvent2);
            } else {
                browser.repaint(100L);
            }
        }
    }

    protected int drawStringWidth(Graphics2D graphics2D, String string, int n, int n2, Color color, NFont nFont) {
        int n3 = (int)nFont.stringAdvance(string).getX();
        if (color != null) {
            graphics2D.setColor(color);
            graphics2D.fillRect(n, n2 - displayH_ + 3, n3, displayH_);
            graphics2D.setColor(Color.BLACK);
        }
        nFont.drawString(graphics2D, string, n, n2);
        return n3;
    }

    @Override
    public boolean paintAfter(Context context, Node node) {
        Rectangle rectangle = this.obsdoc_.bbox;
        int n = this.obsdoc_.getHsb().getValue();
        int n2 = this.obsdoc_.getVsb().getValue();
        Graphics2D graphics2D = context.g;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(n, n2, rectangle.width - VScrollbar.SIZE, rectangle.height);
        graphics2D.setColor(guideColor);
        for (int i = 0; i < 150; i += 14) {
            graphics2D.drawLine(n + i, n2, n + i, n2 + rectangle.height);
        }
        NFont nFont = FONT_PLAIN;
        int n3 = (int)(nFont.getSize() * 1.2f);
        int n4 = (int)nFont.getAscent();
        int n5 = this.nodes_.length;
        int n6 = n2 / n3;
        int n7 = (n2 + rectangle.height) / n3 + 1;
        graphics2D.setColor(Color.BLACK);
        StringBuffer stringBuffer = new StringBuffer(200);
        if (n6 < n5) {
            int n8;
            int n9;
            Node node2;
            int n10 = 0;
            for (node2 = this.nodes_[n6]; node2 != this.showdoc_; node2 = node2.getParentNode()) {
                ++n10;
            }
            Node node3 = null;
            int n11 = Math.min(n7, n5);
            for (n9 = n6; n9 < n11; ++n9) {
                int n12;
                int n13;
                Map<String, Object> map;
                Object object;
                Cloneable cloneable;
                INode iNode;
                node2 = this.nodes_[n9];
                n8 = node2.isStruct();
                INode iNode2 = iNode = n8 != 0 ? (INode)node2 : null;
                if (node2.getParentNode() == node3) {
                    ++n10;
                } else if (node3 != null) {
                    for (Node node4 = node3; node4 != this.showdoc_ && node4 == node4.getParentNode().getLastChild(); node4 = node4.getParentNode()) {
                        --n10;
                    }
                }
                int n14 = n10 * 7;
                int n15 = n9 * n3 + n4;
                Color color = null;
                if (!this.nvalid_[n9]) {
                    color = Color.RED;
                } else if (node2 == this.selnode_) {
                    color = Color.LIGHT_GRAY;
                }
                if (color != null) {
                    graphics2D.setColor(color);
                    graphics2D.fillRect(n, n15 - n3 + 3, rectangle.width, 15);
                    graphics2D.setColor(Color.BLACK);
                }
                stringBuffer.setLength(0);
                nFont = n8 != 0 ? FONT_BOLD : FONT_PLAIN;
                String string = node2.getName();
                if (string != null) {
                    stringBuffer.append(string.length() < 40 ? string : string.substring(0, 40));
                }
                stringBuffer.append(" / ");
                String string2 = node2.getClass().getName();
                int n16 = string2.lastIndexOf(46);
                stringBuffer.append(n16 != -1 ? string2.substring(n16 + 1) : string2);
                stringBuffer.append(" / ").append(node2.size());
                stringBuffer.append("  #").append(node2.childNum());
                n14 += this.drawStringWidth(graphics2D, stringBuffer.substring(0), n14, n15, null, nFont);
                color = null;
                stringBuffer.setLength(0);
                n14 = n14 < 200 ? 200 : n14 + 10;
                nFont = FONT_PLAIN;
                Rectangle rectangle2 = node2.bbox;
                stringBuffer.append(rectangle2.width).append("x").append(rectangle2.height).append("@(").append(rectangle2.x).append(",").append(rectangle2.y).append(") + ").append(node2.baseline);
                if (node2 instanceof Fixed) {
                    cloneable = ((Fixed)((Object)node2)).getIbbox();
                    stringBuffer.append(", F");
                    if (rectangle2.width != cloneable.width) {
                        stringBuffer.append(new StringBuffer().append("  w!=").append(cloneable.width).toString());
                    }
                    if (rectangle2.height != cloneable.height) {
                        stringBuffer.append(new StringBuffer().append("  h!=").append(cloneable.height).toString());
                    }
                }
                color = rectangle2.x >= 0 && rectangle2.y >= 0 && rectangle2.x + rectangle2.width <= rectangle.width && rectangle2.y + rectangle2.height <= rectangle.height ? null : Color.RED;
                n14 += this.drawStringWidth(graphics2D, stringBuffer.substring(0), n14, n15, color, nFont) + 20;
                color = null;
                stringBuffer.setLength(0);
                if (n8 != 0) {
                    cloneable = iNode.margin;
                    if (cloneable != INode.INSETS_ZERO) {
                        if (((Insets)cloneable).top == ((Insets)cloneable).bottom && ((Insets)cloneable).left == ((Insets)cloneable).right && ((Insets)cloneable).top == ((Insets)cloneable).left) {
                            stringBuffer.append("mar ").append(((Insets)cloneable).left);
                        } else {
                            stringBuffer.append("mar x:").append(((Insets)cloneable).left).append(',').append(((Insets)cloneable).right).append(", y:").append(((Insets)cloneable).top).append(',').append(((Insets)cloneable).bottom);
                        }
                    }
                    if ((object = iNode.padding) != INode.INSETS_ZERO) {
                        if (((Insets)object).top == ((Insets)object).bottom && ((Insets)object).left == ((Insets)object).right && ((Insets)object).top == ((Insets)object).left) {
                            stringBuffer.append(stringBuffer.length() > 0 ? " / " : "").append("pad ").append(((Insets)object).left);
                        } else {
                            stringBuffer.append(stringBuffer.length() > 0 ? " / " : "").append("pad x:").append(((Insets)object).left).append(',').append(((Insets)object).right).append(", y:").append(((Insets)object).top).append(',').append(((Insets)object).bottom);
                        }
                    }
                }
                if (stringBuffer.length() > 0) {
                    n14 += this.drawStringWidth(graphics2D, stringBuffer.substring(0), n14, n15, color, nFont) + 20;
                }
                if (!node2.isValid()) {
                    n14 += this.drawStringWidth(graphics2D, "INVALID", n14, n15, null, nFont) + 20;
                }
                if (n14 < 325) {
                    n14 = 325;
                }
                stringBuffer.setLength(0);
                int n17 = node2.sizeSticky();
                if (n17 > 0) {
                    color = n17 == 0 ? Color.ORANGE : (n8 != 0 ? Color.GREEN : null);
                    n14 += this.drawStringWidth(graphics2D, "Stickies: ", n14, n15, color, nFont);
                }
                for (int i = 0; i < n17; ++i) {
                    stringBuffer.setLength(0);
                    if (i > 0) {
                        n14 += this.drawStringWidth(graphics2D, " / ", n14, n15, color, nFont);
                    }
                    color = null;
                    Mark mark = node2.getSticky(i);
                    map = mark.getOwner();
                    if (n8 != 0) {
                        stringBuffer.append('|');
                    } else {
                        stringBuffer.append(mark.offset);
                        if (map instanceof Span) {
                            Span span = (Span)((Object)map);
                            stringBuffer.append(span.getStart() == mark ? (char)'<' : '/');
                        }
                    }
                    if (map != null) {
                        if (map instanceof Behavior) {
                            stringBuffer.append(((VObject)((Object)map)).getName());
                        } else {
                            stringBuffer.append(map);
                        }
                    }
                    n14 += this.drawStringWidth(graphics2D, stringBuffer.substring(0), n14, n15, color, nFont);
                }
                if (n17 > 0) {
                    n14 += 20;
                }
                color = null;
                stringBuffer.setLength(0);
                object = node2.getObservers();
                int n18 = n13 = object == null ? 0 : object.size();
                if (n13 > 0) {
                    stringBuffer.append("Observers: ");
                }
                for (int i = 0; i < n13; ++i) {
                    stringBuffer.append(((Behavior)object.get(i)).getName()).append(" / ");
                }
                Color color2 = color = node2 != this.showdoc_ ? Color.GREEN : null;
                if (n13 > 0) {
                    n14 += this.drawStringWidth(graphics2D, stringBuffer.substring(0, stringBuffer.length() - 3), n14, n15, color, nFont) + 20;
                }
                color = null;
                stringBuffer.setLength(0);
                map = node2.getAttributes();
                int n19 = n12 = map == null ? 0 : map.size();
                if (n12 > 0) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        stringBuffer.append(entry.getKey()).append('=').append(entry.getValue()).append(", ");
                    }
                }
                if (n12 > 0) {
                    n14 += this.drawStringWidth(graphics2D, stringBuffer.substring(0, stringBuffer.length() - 2), n14, n15, color, nFont) + 20;
                }
                node3 = node2;
            }
            n9 = n2 + 100;
            n8 = this.stats_.size();
            for (n11 = 0; n11 < n8; ++n11) {
                nFont.drawString(graphics2D, this.stats_.get(n11), rectangle.width - 200 + n, n9 + n11 * n3);
            }
        }
        return false;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
    }
}

