/*
 * Decompiled with CFR 0.152.
 */
package com.pt.awt.font;

import com.pt.awt.font.NFontSimple;
import com.pt.awt.font.SfntDirectory;
import com.pt.io.RandomAccess;
import com.pt.io.RandomAccessByteArray;
import com.pt.lang.Mac;
import java.awt.FontFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import phelps.util.Arrayss;

public abstract class NFontSfnt
extends NFontSimple {
    public static final int TAG_TTCF;
    public static final String FORMAT = "sfnt";
    private static final long TIME_BASE_DIFF;
    private static final byte[] TABLE_EMPTY;
    RandomAccess ra_;
    int version_;
    long raoff_;
    private SfntDirectory[] tabledir_;
    byte[] data_;
    int offset_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFontSfnt(URL uRL) throws FontFormatException, IOException {
        super(uRL);
        this.getRA();
        this.ra_.seek(0L);
        try {
            this.parseFile();
            this.parse();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.releaseRA();
        }
    }

    public NFontSfnt(URL uRL, byte[] byArray) throws FontFormatException, IOException {
        super(uRL);
        this.ra_ = new RandomAccessByteArray(byArray, "r");
        this.parseFile();
        this.parse();
    }

    void parseFile() throws FontFormatException, IOException {
        this.data_ = this.readRaw(this.raoff_, 12);
        this.offset_ = 0;
        this.version_ = (int)this.readUint32();
    }

    void parse() throws FontFormatException, IOException {
        this.data_ = this.readRaw(this.raoff_, 12);
        this.offset_ = 4;
        int n = this.readUint16();
        if (!$assertionsDisabled && n < 1) {
            throw new AssertionError(n);
        }
        this.data_ = this.readRaw(this.raoff_ + 12L, n * 4 * 4);
        this.offset_ = 0;
        this.tabledir_ = new SfntDirectory[n];
        if (!($assertionsDisabled || n > 0 && n < 1000)) {
            throw new AssertionError(n);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)this.readUint32();
            int n4 = (int)this.readUint32();
            int n5 = (int)this.readUint32();
            int n6 = (int)this.readUint32();
            if (n6 <= 0) continue;
            this.tabledir_[n2++] = new SfntDirectory(n3, n4, n5, n6);
        }
        this.tabledir_ = (SfntDirectory[])Arrayss.resize(this.tabledir_, n2);
    }

    void getRA() throws IOException {
        if (this.ra_ == null) {
            if (!$assertionsDisabled && this.getSource() == null) {
                throw new AssertionError();
            }
            this.ra_ = NFontSfnt.getMultiplex().getRA(this, this.getSource());
        }
    }

    void releaseRA() {
        if (this.ra_ != null && !(this.ra_ instanceof RandomAccessByteArray)) {
            NFontSfnt.getMultiplex().releaseRA(this.ra_);
            this.ra_ = null;
        }
    }

    public SfntDirectory[] getTables() {
        return (SfntDirectory[])this.tabledir_.clone();
    }

    public SfntDirectory getTableDirectory(String string) {
        return this.getTableDirectory(Mac.intTag(string));
    }

    public SfntDirectory getTableDirectory(int n) {
        SfntDirectory[] sfntDirectoryArray = this.tabledir_;
        int n2 = sfntDirectoryArray.length;
        for (int i = 0; i < n2; ++i) {
            SfntDirectory sfntDirectory = sfntDirectoryArray[i];
            if (n != sfntDirectory.tag) continue;
            return sfntDirectory;
        }
        return null;
    }

    public byte[] getTable(int n) {
        return this.getTable(n, 0, Integer.MAX_VALUE);
    }

    public byte[] getTable(String string) {
        return this.getTable(Mac.intTag(string));
    }

    public byte[] getTable(int n, int n2, int n3) {
        return this.getTable(this.getTableDirectory(n), n2, n3);
    }

    public byte[] getTable(String string, int n, int n2) {
        return this.getTable(Mac.intTag(string), n, n2);
    }

    public byte[] getTable(SfntDirectory sfntDirectory, int n, int n2) {
        byte[] byArray = TABLE_EMPTY;
        if (sfntDirectory != null) {
            if (sfntDirectory.data != null) {
                byArray = sfntDirectory.data;
            } else {
                try {
                    boolean bl = this.ra_ == null;
                    this.getRA();
                    byArray = this.readRaw((TAG_TTCF == this.version_ ? 0L : this.raoff_) + (long)sfntDirectory.offset + (long)n, Math.min(sfntDirectory.length, n2));
                    if (bl) {
                        this.releaseRA();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.data_ = byArray;
        this.offset_ = 0;
        return this.data_;
    }

    byte[] readRaw(long l, int n) throws IOException {
        if (!$assertionsDisabled && this.ra_ == null) {
            throw new AssertionError();
        }
        if (n <= 0) {
            return TABLE_EMPTY;
        }
        byte[] byArray = new byte[n];
        this.ra_.seek(l);
        this.ra_.readFully(byArray);
        return byArray;
    }

    public int getTableSize(int n) {
        SfntDirectory sfntDirectory = this.getTableDirectory(n);
        return sfntDirectory != null ? sfntDirectory.length : -1;
    }

    public int getTableSize(String string) {
        return this.getTableSize(Mac.intTag(string));
    }

    public void setTable(int n, byte[] byArray) {
        SfntDirectory sfntDirectory = this.getTableDirectory(n);
        if (sfntDirectory == null) {
            this.tabledir_ = (SfntDirectory[])Arrayss.resize(this.tabledir_, this.tabledir_.length + 1);
            this.tabledir_[this.tabledir_.length - 1] = new SfntDirectory(n, byArray);
        } else {
            sfntDirectory.setData(byArray);
        }
    }

    public void deleteTable(int n) {
        SfntDirectory sfntDirectory = this.getTableDirectory(n);
        if (sfntDirectory != null) {
            SfntDirectory sfntDirectory2 = this.tabledir_[this.tabledir_.length - 1];
            if (sfntDirectory != sfntDirectory2) {
                this.tabledir_[Arrayss.indexOf((Object[])this.tabledir_, (Object)sfntDirectory)] = sfntDirectory2;
            }
            this.tabledir_ = (SfntDirectory[])Arrayss.resize(this.tabledir_, this.tabledir_.length - 1);
        }
    }

    public static int checksum(byte[] byArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = byArray.length;
        while (n3 + 3 < n4) {
            n = (byArray[n3] & 0xFF) << 24 | (byArray[n3 + 1] & 0xFF) << 16 | (byArray[n3 + 2] & 0xFF) << 8 | byArray[n3 + 3] & 0xFF;
            n2 += n;
            n3 += 4;
        }
        if (n3 < n4) {
            n = 0;
            int n5 = 0;
            while (n3 < n4) {
                n5 = n5 << 8 | byArray[n3] & 0xFF;
                ++n3;
                ++n;
            }
            while (n < 4) {
                n5 <<= 8;
                ++n;
            }
            n2 += n5;
        }
        return n2;
    }

    public int readUint8() {
        int n = this.data_[this.offset_] & 0xFF;
        ++this.offset_;
        return n;
    }

    public int readInt8() {
        byte by = this.data_[this.offset_];
        ++this.offset_;
        return by;
    }

    public int readUint16() {
        int n = (this.data_[this.offset_] & 0xFF) << 8 | this.data_[this.offset_ + 1] & 0xFF;
        this.offset_ += 2;
        return n;
    }

    public int readInt16() {
        int n = this.data_[this.offset_] << 8 | this.data_[this.offset_ + 1] & 0xFF;
        this.offset_ += 2;
        return n;
    }

    public long readUint32() {
        long l = ((long)this.data_[this.offset_] & 0xFFL) << 24 | (long)((this.data_[this.offset_ + 1] & 0xFF) << 16) | (long)((this.data_[this.offset_ + 2] & 0xFF) << 8) | (long)(this.data_[this.offset_ + 3] & 0xFF);
        this.offset_ += 4;
        return l;
    }

    public int readInt32() {
        int n = this.data_[this.offset_] << 24 | (this.data_[this.offset_ + 1] & 0xFF) << 16 | (this.data_[this.offset_ + 2] & 0xFF) << 8 | this.data_[this.offset_ + 3] & 0xFF;
        this.offset_ += 4;
        return n;
    }

    public float readFixed() {
        int n = this.readInt16();
        float f = (float)this.readUint16() / 65536.0f;
        return (float)n + (n >= 0 ? f : -f);
    }

    public float readF2Dot14() {
        int n = this.readInt16();
        return (float)(n >> 14) + (float)(n & 0x3FFF) / 16384.0f;
    }

    public long readDateTime() {
        long l = this.readUint32() << 32 | this.readUint32();
        if (l > 0L) {
            l -= TIME_BASE_DIFF;
        }
        return l *= 1000L;
    }

    public String readStringPascal() {
        int n = this.readUint8();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)(this.data_[this.offset_++] & 0xFF));
        }
        return stringBuffer.toString();
    }

    String readString(int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (n + n2 > this.data_.length) {
            n2 = this.data_.length - n;
        }
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuffer.append((char)(this.data_[n3 + n] & 0xFF));
        }
        if (n2 > 0 && stringBuffer.charAt(0) == '\u0000' && (n2 & 1) == 0) {
            n3 = n2 / 2;
            int n4 = 0;
            int n5 = 1;
            while (n4 < n3) {
                stringBuffer.setCharAt(n4, stringBuffer.charAt(n5));
                ++n4;
                n5 += 2;
            }
            stringBuffer.setLength(n3);
        }
        return stringBuffer.toString();
    }

    String readString16(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2 / 2);
        for (int i = 0; i < n2; i += 2) {
            stringBuffer.append((char)((this.data_[i + n] & 0xFF) << 8 | this.data_[i + n + 1] & 0xFF));
        }
        return stringBuffer.toString();
    }

    public int getOffset() {
        return this.offset_;
    }

    public void setOffset(int n) {
        this.offset_ = n;
    }

    public void skip(int n) {
        this.offset_ += n;
    }

    public byte[] toByteArray() throws IOException {
        SfntDirectory sfntDirectory;
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6 = this.tabledir_.length;
        if (n6 == 0) {
            return TABLE_EMPTY;
        }
        int[] nArray = new int[n6];
        int n7 = 0;
        int n8 = 0;
        for (n5 = 0; n5 < n6; ++n5) {
            int n9;
            object = this.tabledir_[n5];
            if (((SfntDirectory)object).length == 0) continue;
            nArray[n7++] = ((SfntDirectory)object).tag;
            n4 = (n9 = ((SfntDirectory)object).length) % 4;
            n3 = n9 + (n4 == 0 ? 0 : 4 - n4);
            ((SfntDirectory)object).checkSum = NFontSfnt.checksum(this.getTable((SfntDirectory)object, 0, n9));
            ((SfntDirectory)object).padlen = n3;
            n8 += n3;
        }
        nArray = Arrayss.resize(nArray, n7);
        Arrays.sort(nArray);
        n6 = n7;
        n5 = 12 + n6 * 16;
        if (!$assertionsDisabled && n5 % 4 != 0) {
            throw new AssertionError();
        }
        object = new ByteArrayOutputStream(n5 + n8);
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
        dataOutputStream.writeInt(this.version_);
        dataOutputStream.writeShort(n6);
        n4 = (int)(Math.log(n6) / Math.log(2.0));
        n3 = (1 << n4) * 16;
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeShort(n4);
        dataOutputStream.writeShort(n6 * 16 - n3);
        int n10 = n5;
        for (n2 = 0; n2 < n6; ++n2) {
            n = nArray[n2];
            sfntDirectory = this.getTableDirectory(n);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(sfntDirectory.checkSum);
            dataOutputStream.writeInt(n10);
            dataOutputStream.writeInt(sfntDirectory.length);
            n10 += sfntDirectory.padlen;
        }
        for (n2 = 0; n2 < n6; ++n2) {
            n = nArray[n2];
            sfntDirectory = this.getTableDirectory(n);
            byte[] byArray = this.getTable(sfntDirectory, 0, Integer.MAX_VALUE);
            dataOutputStream.write(byArray);
            int n11 = sfntDirectory.padlen;
            for (int i = sfntDirectory.length; i < n11; ++i) {
                dataOutputStream.write(0);
            }
        }
        dataOutputStream.flush();
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    static {
        $assertionsDisabled = !NFontSfnt.class.desiredAssertionStatus();
        TAG_TTCF = Mac.intTag("ttcf");
        Calendar calendar = Calendar.getInstance();
        calendar.set(1904, 0, 1);
        TIME_BASE_DIFF = (0L - calendar.getTimeInMillis()) / 1000L;
        TABLE_EMPTY = new byte[0];
    }
}

