/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.DocInfo;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;
import phelps.net.URIs;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkSpan
extends Span {
    public static final String ATTR_URI = "uri";
    public static final byte STATE_LINK = 0;
    public static final byte STATE_VISITED = 1;
    public static final byte STATE_HOVER = 2;
    public static final byte STATE_ACTIVE = 3;
    public static final String MSG_COPY_LINK = "copyLink";
    protected Object target_ = null;
    private String msg_ = null;
    private boolean seen_ = false;
    private static Cursor curin;
    private byte state_ = 0;
    private static int x0_;
    private static int y0_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$std$span$HyperlinkSpan;

    public void setSeen(boolean bl) {
        this.seen_ = bl;
        this.setState((byte)0);
    }

    protected void setState(byte by) {
        if (!($assertionsDisabled || by >= 0 && by <= 3)) {
            throw new AssertionError();
        }
        this.state_ = 0 == by && this.seen_ ? (byte)1 : by;
    }

    public byte getState() {
        return this.state_;
    }

    public Object getTarget() {
        return this.target_;
    }

    public URI getURI() {
        return (URI)this.target_;
    }

    public void setTarget(Object object) {
        this.target_ = object;
    }

    public void setMessage(String string) {
        this.msg_ = string;
    }

    public void setURI(String string) {
        this.target_ = null;
        if (string == null) {
            return;
        }
        try {
            URI uRI = this.getDocument().getURI();
            URI uRI2 = uRI != null ? uRI.resolve(string) : new URI(string);
            this.setTarget(uRI2);
            this.putAttr(ATTR_URI, uRI2.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        context.underline = this.state_ == 3 || this.target_ == null ? Color.RED : Color.BLUE;
        context.foreground = context.underline;
        return false;
    }

    @Override
    public int getPriority() {
        return 10150;
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.target_ = this.getAttr(ATTR_URI, "(no target)");
    }

    @Override
    public ESISNode save() {
        this.putAttr(ATTR_URI, this.target_.toString());
        return super.save();
    }

    @Override
    public boolean eventAfter(AWTEvent aWTEvent, Point point, Node node) {
        MouseEvent mouseEvent;
        Browser browser = this.getBrowser();
        int n = aWTEvent.getID();
        MouseEvent mouseEvent2 = mouseEvent = 500 <= n && n <= 507 ? (MouseEvent)aWTEvent : null;
        if (n == 504) {
            curin = browser.getCursor();
            browser.setCursor(Cursor.getPredefinedCursor(12));
            String string = this.msg_ != null ? this.msg_ : new StringBuffer().append("Go to ").append(this.target_ instanceof URI ? this.getDocument().getURI().relativize((URI)this.target_).toString() : this.target_.toString()).toString();
            this.setState((byte)2);
            browser.eventq("showStatus", string);
            this.repaint(100L);
        } else if (n == 505) {
            this.setState((byte)0);
            if (browser == null && aWTEvent.getSource() instanceof Browser) {
                browser = (Browser)aWTEvent.getSource();
            }
            if (browser != null) {
                browser.setCursor(curin);
                browser.eventq("showStatus", "");
            }
            this.repaint(100L);
        } else if (n == 501) {
            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                return false;
            }
            if (this.state_ == 3) {
                this.setState((byte)0);
                this.repaint(100L);
                return false;
            }
            this.setState((byte)3);
            this.repaint();
            x0_ = mouseEvent.getX();
            y0_ = mouseEvent.getY();
            browser.setGrab(this);
            return true;
        }
        return super.eventAfter(aWTEvent, point, node);
    }

    @Override
    public void event(AWTEvent aWTEvent) {
        if (!$assertionsDisabled && aWTEvent == null) {
            throw new AssertionError();
        }
        int n = aWTEvent.getID();
        Browser browser = this.getBrowser();
        if (n == 506) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            if (Math.abs(n2 - x0_) > 5 || Math.abs(n3 - y0_) > 5) {
                browser.releaseGrab(this);
                browser.event(new MouseEvent((Component)mouseEvent.getSource(), 501, mouseEvent.getWhen() + 1L, 16, x0_, y0_, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
            }
        } else if (n == 502) {
            this.setSeen(true);
            browser.releaseGrab(this);
            this.go();
        }
    }

    public void go() {
        Browser browser = this.getBrowser();
        if (this.target_ != null) {
            if (this.target_ instanceof SemanticEvent) {
                browser.eventq((SemanticEvent)this.target_);
            } else {
                browser.eventq("openDocument", this.target_);
            }
        }
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (this == semanticEvent.getIn() && "createWidget/DOCPOPUP" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            if (this.isEditable()) {
                this.createUI("button", "Edit Link URL", new SemanticEvent(browser, "editSpan", this, this, null), iNode, "EDIT", false);
            }
            this.createUI("button", "Copy Link to Clipboard", new SemanticEvent(browser, MSG_COPY_LINK, this, this, null), iNode, "SAVE", false);
            if (this.target_ instanceof URI) {
                DocInfo docInfo = new DocInfo((URI)this.target_);
                docInfo.window = "_NEW";
                this.createUI("button", "Open in New Window", new SemanticEvent(browser, "openDocument", docInfo, null, null), iNode, "SPECIFIC", false);
                docInfo = new DocInfo((URI)this.target_);
                docInfo.window = "Aux";
                this.createUI("button", "Open in Shared Window", new SemanticEvent(browser, "openDocument", docInfo, null, null), iNode, "SPECIFIC", false);
            }
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if (this == semanticEvent.getIn()) {
            if ("formData" == string) {
                Map map = (Map)object;
                if (map != null && map.get("cancel") == null) {
                    Span span;
                    String string2 = (String)map.get(ATTR_URI);
                    if (string2 == null) {
                        return true;
                    }
                    this.setTarget(URIs.decode(string2));
                    Browser browser = this.getBrowser();
                    if (!this.isSet() && (span = browser.getSelectionSpan()).isSet()) {
                        this.move(span);
                    }
                }
                return true;
            }
            if (MSG_COPY_LINK == string) {
                StringSelection stringSelection = new StringSelection(this.getTarget().toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public String toString() {
        return new StringBuffer().append("Hyperlink:").append(this.target_).toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$std$span$HyperlinkSpan == null ? (class$multivalent$std$span$HyperlinkSpan = HyperlinkSpan.class$("multivalent.std.span.HyperlinkSpan")) : class$multivalent$std$span$HyperlinkSpan).desiredAssertionStatus();
        curin = null;
    }
}

