/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import com.pt.awt.NFont;
import java.util.Map;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Span;
import phelps.lang.Floats;
import phelps.lang.Integers;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontSpan
extends Span {
    public static final String ATTR_FAMILY = "family";
    public static final String ATTR_SIZE = "size";
    public static final String ATTR_WEIGHT = "weight";
    public static final String ATTR_FLAGS = "flags";
    public String family = null;
    public float size = -1.0f;
    public int weight = -1;
    public int flags = -1;
    public NFont spot = null;

    @Override
    public boolean appearance(Context context, boolean bl) {
        if (this.family != null) {
            context.family = this.family;
        }
        if ((double)this.size > 0.0) {
            context.size = this.size;
        }
        if (this.weight != -1) {
            context.weight = this.weight;
        }
        if (this.flags != -1) {
            context.flags = this.flags;
        }
        if (this.spot != null) {
            context.spot = this.spot;
        }
        return false;
    }

    @Override
    public ESISNode save() {
        this.putAttr(ATTR_FAMILY, this.family);
        if ((double)this.size > 0.0) {
            this.putAttr(ATTR_SIZE, Float.toString(this.size));
        }
        if (this.weight >= 0) {
            this.putAttr(ATTR_WEIGHT, Integer.toString(this.weight));
        }
        if (this.flags >= 0) {
            this.putAttr(ATTR_FLAGS, Integer.toString(this.flags));
        }
        return super.save();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.family = this.getAttr(ATTR_FAMILY, null);
        this.size = Floats.parseFloat(this.getAttr(ATTR_SIZE), 0.0f);
        this.weight = Integers.parseInt(this.getAttr(ATTR_WEIGHT), -1);
        this.flags = Integers.parseInt(this.getAttr(ATTR_FLAGS), -1);
    }
}

