/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.span;

import java.util.Map;
import multivalent.Behavior;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.Layer;
import multivalent.Leaf;
import multivalent.Span;
import multivalent.std.span.ActionSpan;
import multivalent.std.span.LabelSpan;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIUSpan
extends ActionSpan {
    public static final String ATTR_TYPE = "type";
    static final int BOLD = 0;
    static final int ITALIC = 1;
    static final int UNDERLINE = 2;
    static final String[] biuString_;
    int biu_;
    LabelSpan label_ = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$multivalent$std$span$BIUSpan;

    public void setType(char c) {
        if (!($assertionsDisabled || '\u0000' <= c && c <= '\u0002')) {
            throw new AssertionError();
        }
        this.biu_ = this.char2off(c);
    }

    int char2off(char c) {
        switch (c) {
            case 'B': 
            case 'b': {
                return 0;
            }
            case 'I': 
            case 'i': {
                return 1;
            }
            case 'U': 
            case 'u': {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        context.underline = this.getLayer().getAnnoColor();
        return false;
    }

    @Override
    public void moveq(Leaf leaf, int n, Leaf leaf2, int n2) {
        super.moveq(leaf, n, leaf2, n2);
        this.label_.moveq(leaf, n, leaf, n + 1);
    }

    @Override
    public void destroy() {
        if (this.label_ != null) {
            this.label_.destroy();
        }
        this.label_ = null;
        super.destroy();
    }

    @Override
    public boolean action() {
        String string;
        switch (this.biu_) {
            case 0: {
                string = "BoldSpan";
                break;
            }
            case 1: {
                string = "ItalicSpan";
                break;
            }
            case 2: {
                string = "UnderlineSpan";
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            Span span = (Span)Behavior.getInstance(this.getName(), string, null, this.getLayer());
            span.moveq(this);
        }
        this.destroy();
        return true;
    }

    @Override
    public ESISNode save() {
        this.putAttr(ATTR_TYPE, biuString_[this.biu_]);
        return super.save();
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        String string = this.getAttr(ATTR_TYPE);
        this.biu_ = string == null ? 0 : this.char2off(string.charAt(0));
        if (this.label_ == null) {
            this.label_ = (LabelSpan)Behavior.getInstance(this.getName(), "LabelSpan", null, layer.getDocument().getLayer("<scratch>"));
        }
        this.label_.setLabel(new StringBuffer().append(biuString_[this.biu_]).append(" region").toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$multivalent$std$span$BIUSpan == null ? (class$multivalent$std$span$BIUSpan = BIUSpan.class$("multivalent.std.span.BIUSpan")) : class$multivalent$std$span$BIUSpan).desiredAssertionStatus();
        biuString_ = new String[]{"Boldface", "Italicize", "Underline"};
    }
}

