/*
 * Decompiled with CFR 0.152.
 */
package multivalent.std.adaptor.pdf;

import com.pt.awt.font.NFontType1;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import multivalent.Meta;
import multivalent.std.adaptor.pdf.COS;
import multivalent.std.adaptor.pdf.Dict;
import multivalent.std.adaptor.pdf.IRef;
import multivalent.std.adaptor.pdf.Images;
import multivalent.std.adaptor.pdf.PDFReader;
import phelps.lang.Integers;
import phelps.util.Arrayss;
import phelps.util.Version;

class Normalize {
    private static final Integer INTEGER0;
    private static final Integer INTEGER1;
    private static final Double REAL0;
    private static final Double REAL1;
    static final Object[] A01;
    static final Object[] A10;
    static final Object[] A010101;
    static final Object[] A01010101;
    static final Object[] A01f;
    static final Object[] A10f;
    static final Object[] A010101f;
    static final Object[] A01010101f;
    static final Object[] A001;
    static final Object[] A000;
    static final Object[] A000f;
    static final Object[] A111f;
    static final Object[] A100f;
    static final Object[] A010f;
    static final Object[] A001f;
    static final Object[] A100100;
    static final Object[] A100100f;
    private static final String[] KEYS_TRAILER;
    private static final String[] KEYS_CATALOG;
    private static final String[] KEYS_PAGES;
    private static final String[] KEYS_PAGE;
    private static final Object[] DEF_PAGE;
    private static final Object[] DEF_PAGES;
    private static final Object[] DEF_VIEWER;
    private static final Object[] DEF_ANNOT;
    private static final Object[] DEF_ANNOT_BS;
    private static final Object[] DEF_ANNOT_TEXT;
    private static final Object[] DEF_ANNOT_LINK;
    private static final Object[] DEF_ANNOT_FREETEXT;
    private static final Object[] DEF_ANNOT_LINE;
    private static final Object[] DEF_ANNOT_STAMP;
    private static final Object[] DEF_ANNOT_POPUP;
    private static final Object[] DEF_ANNOT_FILEATTACHMENT;
    private static final Object[] DEF_ANNOT_SOUND;
    private static final Object[] DEF_ANNOT_MOVIE;
    private static final Object[] DEF_ANNOT_WIDGET;
    private static final Object[] DEF_FONT;
    private static final Object[] DEF_FONTDESCRIPTOR;
    private static final Object[] DEF_XOBJECT;
    private static final Object[] DEF_IMAGE_FAX;
    private static final Object[] DEF_IMAGE_DCT;
    private static final Object[] DEF_FORM;
    private static final Object[] DEF_ACTION;
    private static final Object[] DEF_PATTERN;
    private static final Object[] DEF_FILESPEC;
    private static final Object[] DEF_FILE_EMBEDDED;
    private static final Object[] DEF_CRYPTFILTER;
    private static final Object[] DEF_CRYPTFILTER_DP;
    private static final Object[] DEF_OCG;
    private static final Object[] DEF_OCMD;
    private static final Object[] DEF_CATALOG;
    private PDFReader pdfr_;
    static final /* synthetic */ boolean $assertionsDisabled;

    Normalize(PDFReader pDFReader) {
        if (!$assertionsDisabled && pDFReader == null) {
            throw new AssertionError();
        }
        this.pdfr_ = pDFReader;
    }

    private Object getObject(Object object) throws IOException {
        return this.pdfr_.getObject(object);
    }

    public void normalizeDoc(Dict dict) throws IOException {
        Dict dict2;
        Object object;
        if (!$assertionsDisabled && dict == null) {
            throw new AssertionError();
        }
        PDFReader pDFReader = this.pdfr_;
        pDFReader.getVersion().setMin(new Version("1.1"));
        Dict dict3 = pDFReader.getTrailer();
        Object[] objectArray = (Object[])pDFReader.getObject(dict3.get("ID"));
        if (objectArray == null) {
            objectArray = new Object[2];
            objectArray[0] = objectArray[1] = COS.createID(pDFReader.getURI(), pDFReader.getInfo());
        }
        dict3.put("ID", objectArray);
        Object object2 = this.getObject(dict.get("Version"));
        if (object2 != null) {
            pDFReader.getVersion().setMin(new Version((String)object2));
            dict.remove("Version");
        }
        if (COS.OBJECT_NULL != (object = this.getObject(dict.get("Pages"))) && (dict2 = (Dict)object) != null && (object2 = this.getObject(dict2.get("Rotate"))) != null && ((Number)object2).intValue() % 360 == 0) {
            dict2.remove("Rotate");
        }
    }

    public void normalizeObject(Object object) throws IOException {
        Dict dict;
        Object object2;
        if (COS.CLASS_DICTIONARY != object.getClass()) {
            return;
        }
        Dict dict2 = (Dict)object;
        String string = (String)this.getObject(dict2.get("Type"));
        String string2 = (String)this.getObject(dict2.get("Subtype"));
        Object object3 = null;
        if (dict2.get("DATA") != null) {
            if (dict2.get("F") != null) {
                Meta.sampledata("external file " + object);
                dict2.remove("Filter");
                dict2.remove("DecodeParms");
                dict2.put("Length", INTEGER0);
                this.simplifyArray1(dict2, "FFilter");
                this.simplifyArray1(dict2, "FDecodeParms");
            } else {
                this.simplifyArray1(dict2, "Filter");
                object2 = dict2.remove("DP");
                if (object2 != null && dict2.get("DecodeParms") == null) {
                    dict2.put("DecodeParms", object2);
                }
                this.simplifyArray1(dict2, "DecodeParms");
            }
        }
        if (string != null) {
            if ("Page".equals(string)) {
                this.cleanDict(dict2, KEYS_PAGE, DEF_PAGE);
                object3 = dict2.get("Resources");
                this.simplifyArray1(dict2, "Contents");
            } else if ("Pages".equals(string)) {
                this.cleanDict(dict2, KEYS_PAGES, DEF_PAGES);
                object3 = dict2.get("Resources");
            } else if ("Annot".equals(string)) {
                this.cleanDict(dict2, null, DEF_ANNOT);
                Object[] objectArray = (Object[])this.getObject(dict2.get("Border"));
                if (Arrays.equals(A000, objectArray)) {
                    dict2.put("Border", A000);
                }
                if (!"Screen".equals(string2)) {
                    dict2.remove("P");
                }
                if ("Text".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_TEXT);
                } else if ("Link".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_LINK);
                    object2 = this.getObject(dict2.get("A"));
                    if (object2 != null) {
                        dict2.remove("Dest");
                        Dict dict3 = (Dict)object2;
                        if ("GoTo".equals(dict3.get("S")) && (object2 = dict3.get("D")) != null && dict3.size() == 2) {
                            dict2.remove("A");
                            dict2.put("Dest", object2);
                        }
                    }
                } else if ("FreeText".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_FREETEXT);
                } else if ("Line".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_LINE);
                } else if ("Stamp".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_STAMP);
                } else if ("Popup".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_POPUP);
                } else if ("FileAttachment".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_FILEATTACHMENT);
                } else if ("Sound".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_SOUND);
                } else if ("Movie".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_MOVIE);
                } else if ("Widget".equals(string2)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_WIDGET);
                }
            } else if (!"Bead".equals(string)) {
                if ("Font".equals(string)) {
                    Dict dict4;
                    this.cleanDict(dict2, null, DEF_FONT);
                    if ("Type3".equals(string2)) {
                        object3 = dict2.get("Resources");
                    }
                    if ((dict4 = (Dict)this.getObject(dict2.get("FontDescriptor"))) != null) {
                        Dict dict5;
                        IRef iRef;
                        this.cleanDict(dict4, null, DEF_FONTDESCRIPTOR);
                        if ("Type1".equals(string2) || "MMType1".equals(string2)) {
                            iRef = (IRef)dict4.get("FontFile");
                            if (iRef != null) {
                                dict5 = (Dict)this.getObject(iRef);
                                dict4.remove("FontFile2");
                                dict4.remove("FontFile3");
                                this.pdfr_.setObject(iRef.id, dict5);
                            } else {
                                dict4.remove("FontFile");
                                dict4.remove("FontFile2");
                                iRef = (IRef)dict4.get("FontFile3");
                                dict5 = (Dict)this.getObject(iRef);
                                if (dict5 != null) {
                                    string2 = (String)this.getObject(dict5.get("Subtype"));
                                    if (!$assertionsDisabled && !"Type1C".equals(string2)) {
                                        throw new AssertionError();
                                    }
                                    dict5.remove("Length1");
                                    dict5.remove("Length2");
                                    dict5.remove("Length3");
                                    this.pdfr_.setObject(iRef.id, dict5);
                                }
                            }
                        } else if ("TrueType".equals(string2) || "CIDFontType2".equals(string2)) {
                            dict4.remove("FontFile");
                            iRef = (IRef)dict4.get("FontFile2");
                            dict4.remove("FontFile3");
                            dict5 = (Dict)this.getObject(iRef);
                            if (dict5 != null) {
                                dict5.remove("Length2");
                                dict5.remove("Length3");
                                this.pdfr_.setObject(iRef.id, dict5);
                            }
                        } else {
                            dict4.remove("FontFile");
                            dict4.remove("Fontfile2");
                            iRef = (IRef)dict4.get("FontFile3");
                            dict5 = (Dict)this.getObject(iRef);
                            if (dict5 != null) {
                                dict5.remove("Length2");
                                dict5.remove("Length3");
                                this.pdfr_.setObject(iRef.id, dict5);
                            }
                        }
                        if (dict5 != null) {
                            this.pdfr_.objCache_[iRef.id] = dict5;
                        }
                        if ("Type1".equals(string2) && dict5 != null) {
                            int n = this.pdfr_.getObjInt(dict5.get("Length1"));
                            int n2 = this.pdfr_.getObjInt(dict5.get("Length2"));
                            int n3 = this.pdfr_.getObjInt(dict5.get("Length3"));
                            if (n3 > 0) {
                                dict5.put("Length3", INTEGER0);
                                byte[] byArray = this.pdfr_.getStreamData(iRef, false, true);
                                if (byArray.length > n + n2) {
                                    byArray = Arrayss.resize(byArray, n + n2);
                                    dict5.put("DATA", byArray);
                                }
                            }
                        }
                    }
                } else if ("Type1U".equals(dict2.get("Type"))) {
                    dict2.remove("Type");
                    int n = this.pdfr_.getObjInt(dict2.get("Length1"));
                    int n4 = this.pdfr_.getObjInt(dict2.get("Length2"));
                    byte[] byArray = this.pdfr_.getStreamData(dict2, false, true);
                    if (!$assertionsDisabled && byArray.length < n + n4) {
                        throw new AssertionError((Object)(byArray.length + " < " + n + "+" + n4 + " in " + dict2));
                    }
                    byArray = NFontType1.toPFB(byArray);
                } else if ("XObject".equals(string)) {
                    this.cleanDict(dict2, null, DEF_XOBJECT);
                    if ("Image".equals(string2)) {
                        Object[] objectArray;
                        this.hardcode(dict2, "Width");
                        this.hardcode(dict2, "Height");
                        this.hardcode(dict2, "BitsPerComponent");
                        object2 = this.getObject(dict2.get("ImageMask"));
                        if (object2 == Boolean.TRUE) {
                            dict2.remove("BitsPerComponent");
                            dict2.remove("Mask");
                            dict2.remove("ColorSpace");
                        } else {
                            dict2.remove("ImageMask");
                        }
                        Object object4 = this.getObject(dict2.get("ColorSpace"));
                        object2 = this.getObject(dict2.get("Decode"));
                        if (object4 != null && object2 != null) {
                            objectArray = (Object[])object2;
                            if (("DeviceGray".equals(object4) || "CalGray".equals(object4) || "Separation".equals(object4)) && (Arrays.equals(A01, objectArray) || Arrays.equals(A01f, objectArray)) || ("DeviceRGB".equals(object4) || "CalRGB".equals(object4)) && (Arrays.equals(A010101, objectArray) || Arrays.equals(A010101f, objectArray)) || "DeviceCYMK".equals(object4) && (Arrays.equals(A01010101, objectArray) || Arrays.equals(A01010101f, objectArray))) {
                                dict2.remove("Decode");
                            }
                        }
                        objectArray = Images.getDecodeParms(dict2, this.pdfr_);
                        String string3 = Images.getFilter(dict2, this.pdfr_);
                        if ("CCITTFaxDecode".equals(string3)) {
                            this.cleanDict((Dict)objectArray, null, DEF_IMAGE_FAX);
                            object2 = this.getObject(dict2.get("Decode"));
                            if (object2 != null) {
                                if (Arrays.equals(A01, (Object[])object2)) {
                                    dict2.remove("Decode");
                                } else if (Arrays.equals(A10, (Object[])object2)) {
                                    dict2.put("Decode", A10);
                                }
                            }
                        } else if ("DCTDecode".equals(string3)) {
                            this.cleanDict((Dict)objectArray, null, DEF_IMAGE_DCT);
                        }
                        if (objectArray != null && objectArray.size() == 0) {
                            dict2.remove("DecodeParms");
                        }
                    } else if ("Form".equals(string2)) {
                        this.cleanDict(dict2, null, DEF_FORM);
                        object3 = dict2.get("Resources");
                    }
                } else if ("Border".equals(string)) {
                    this.cleanDict(dict2, null, DEF_ANNOT_BS);
                } else if ("Action".equals(string)) {
                    this.cleanDict(dict2, null, DEF_ACTION);
                } else if ("Pattern".equals(string)) {
                    this.cleanDict(dict2, null, DEF_PATTERN);
                    object3 = dict2.get("Resources");
                } else if ("Filespec".equals(string)) {
                    this.cleanDict(dict2, null, DEF_FILESPEC);
                } else if ("EmbeddedFile".equals(string)) {
                    this.cleanDict(dict2, null, DEF_FILE_EMBEDDED);
                } else if ("CryptFilter".equals(string)) {
                    this.cleanDict(dict2, null, DEF_CRYPTFILTER);
                } else if ("CryptFilterDecodeParms".equals(string)) {
                    this.cleanDict(dict2, null, DEF_CRYPTFILTER_DP);
                } else if ("OCG".equals(string)) {
                    this.cleanDict(dict2, null, DEF_OCG);
                } else if ("OCMD".equals(string)) {
                    this.cleanDict(dict2, null, DEF_OCMD);
                } else if ("XRef".equals(string)) {
                    this.cleanDict(dict2, KEYS_TRAILER, null);
                } else if ("Catalog".equals(string)) {
                    Dict dict6;
                    this.cleanDict(dict2, KEYS_CATALOG, DEF_CATALOG);
                    object2 = this.getObject(dict2.get("Outlines"));
                    Dict dict7 = dict6 = object2 != COS.OBJECT_NULL ? (Dict)object2 : null;
                    if (dict6 != null && (object2 = dict6.get("Count")) != null && this.pdfr_.getObjInt(object2) == 0) {
                        dict2.remove("Outlines");
                        dict6 = null;
                    }
                    if ("UseOutlines".equals(this.getObject(dict2.get("PageMode"))) && dict6 == null) {
                        dict2.remove("PageMode");
                    }
                    Dict dict8 = (Dict)this.getObject(dict2.get("ViewerPreferences"));
                    this.cleanDict(dict8, null, DEF_VIEWER);
                    if (dict8 != null && dict8.size() == 0) {
                        dict2.remove("ViewerPreferences");
                    }
                    Dict dict9 = this.pdfr_.getInfo();
                    this.cleanDict(dict9, null, null);
                } else if (dict2.get("FunctionType") != null) {
                    // empty if block
                }
            }
        }
        if ((object2 = this.getObject(object3)) != null && COS.CLASS_DICTIONARY == object2.getClass() && (object2 = (dict = (Dict)object2).remove("ProcSet")) != null) {
            this.pdfr_.getVersion().setMin(new Version("1.4"));
        }
        this.hardcode(dict2, "Type");
        this.hardcode(dict2, "Subtype");
    }

    private void hardcode(Dict dict, String string) throws IOException {
        Object object = dict.get(string);
        if (object != null && COS.CLASS_IREF == object.getClass()) {
            dict.put(string, this.getObject(object));
        }
    }

    private void simplifyArray1(Dict dict, String string) throws IOException {
        Object[] objectArray;
        Object object;
        Object object2 = dict.get(string);
        if (object2 != null && COS.CLASS_ARRAY == (object = this.getObject(object2)).getClass() && (objectArray = (Object[])object).length == 1) {
            dict.put(string, objectArray[0]);
        }
    }

    private void cleanDict(Dict dict, String[] stringArray, Object[] objectArray) throws IOException {
        Object object;
        if (dict == null) {
            return;
        }
        if (stringArray != null) {
            Iterator iterator = dict.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                object = (String)entry.getKey();
                if ("Metadata".equals(object) || Arrays.binarySearch(stringArray, object) >= 0) continue;
                iterator.remove();
            }
        }
        if (objectArray != null) {
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Object object2;
                object = objectArray[i];
                Object object3 = objectArray[i + 1];
                if (object3 != null && !object3.equals(object2 = this.getObject(dict.get(object))) && (object3.getClass() != COS.CLASS_ARRAY || !Arrays.equals((Object[])object3, (Object[])object2))) continue;
                dict.remove(object);
            }
        }
    }

    static {
        $assertionsDisabled = !Normalize.class.desiredAssertionStatus();
        INTEGER0 = Integers.ZERO;
        INTEGER1 = Integers.ONE;
        REAL0 = PDFReader.getReal(0.0);
        REAL1 = PDFReader.getReal(1.0);
        A01 = new Object[]{INTEGER0, INTEGER1};
        A10 = new Object[]{INTEGER1, INTEGER0};
        A010101 = new Object[]{INTEGER0, INTEGER1, INTEGER0, INTEGER1, INTEGER0, INTEGER1};
        A01010101 = new Object[]{INTEGER0, INTEGER1, INTEGER0, INTEGER1, INTEGER0, INTEGER1, INTEGER0, INTEGER1};
        A01f = new Object[]{REAL0, REAL1};
        A10f = new Object[]{REAL0, REAL1};
        A010101f = new Object[]{REAL0, REAL1, REAL0, REAL1, REAL0, REAL1};
        A01010101f = new Object[]{REAL0, REAL1, REAL0, REAL1, REAL0, REAL1, REAL0, REAL1};
        A001 = new Object[]{INTEGER0, INTEGER0, INTEGER1};
        A000 = new Object[]{INTEGER0, INTEGER0, INTEGER0};
        A000f = new Object[]{REAL0, REAL0, REAL0};
        A111f = new Object[]{REAL1, REAL1, REAL1};
        A100f = new Object[]{REAL1, REAL0, REAL0};
        A010f = new Object[]{REAL0, REAL1, REAL0};
        A001f = new Object[]{REAL0, REAL0, REAL1};
        A100100 = new Object[]{INTEGER1, INTEGER0, INTEGER0, INTEGER1, INTEGER0, INTEGER0};
        A100100f = new Object[]{REAL0, REAL0, REAL1, REAL0, REAL0, REAL1};
        KEYS_TRAILER = new String[]{"Size", "Prev", "Root", "Encrypt", "Info", "ID", "Compress"};
        KEYS_CATALOG = new String[]{"Type", "Version", "Pages", "PageLabels", "Names", "Dests", "ViewerPreferences", "PageLayout", "PageMode", "Outlines", "Threads", "OpenAction", "AA", "URI", "AcroForm", "Metadata", "StructTreeRoot", "MarkInfo", "Lang", "SpiderInfo", "OutputIntents", "PieceInfo", "OCProperties", "Perms"};
        KEYS_PAGES = new String[]{"Type", "Parent", "Kids", "Count", "Resources", "MediaBox", "CropBox", "Rotate"};
        KEYS_PAGE = new String[]{"Type", "Parent", "LastModified", "Resources", "MediaBox", "CropBox", "BleedBox", "TrimBox", "ArtBox", "BoxColorInfo", "Contents", "Rotate", "Group", "Thumb", "B", "Dur", "Trans", "Annots", "AA", "Metadata", "PieceInfo", "StructParents", "ID", "PZ", "SeparationInfo"};
        Object[] objectArray = new Object[]{KEYS_TRAILER, KEYS_CATALOG, KEYS_PAGES, KEYS_PAGE};
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Arrays.sort((String[])objectArray[i]);
        }
        DEF_PAGE = new Object[0];
        DEF_PAGES = new Object[0];
        DEF_VIEWER = new Object[]{"HideToolbar", Boolean.FALSE, "HideMenubar", Boolean.FALSE, "HideWindowUI", Boolean.FALSE, "FitWindow", Boolean.FALSE, "CenterWindow", Boolean.FALSE, "DisplayDocTitle", Boolean.FALSE, "NonFullScreenPageMode", "UseNone", "Direction", "L2R", "ViewArea", "CropBox", "ViewClip", "CropBox", "PrintArea", "CropBox", "PrintClip", "CropBox"};
        DEF_ANNOT = new Object[]{"Type", null, "Flags", INTEGER0, "Border", A001, "CA", REAL1};
        DEF_ANNOT_BS = new Object[]{"Type", null, "W", INTEGER1, "S", "S"};
        DEF_ANNOT_TEXT = new Object[]{"Open", Boolean.FALSE, "Name", "Note"};
        DEF_ANNOT_LINK = new Object[]{"H", "I"};
        DEF_ANNOT_FREETEXT = new Object[]{"Q", INTEGER0};
        DEF_ANNOT_LINE = new Object[]{"LE", new Object[]{"None", "None"}};
        DEF_ANNOT_STAMP = new Object[]{"Name", "Draft"};
        DEF_ANNOT_POPUP = new Object[]{"Open", Boolean.FALSE};
        DEF_ANNOT_FILEATTACHMENT = new Object[]{"Name", "PushPin"};
        DEF_ANNOT_SOUND = new Object[]{"Name", "Speaker"};
        DEF_ANNOT_MOVIE = new Object[]{"A", Boolean.TRUE};
        DEF_ANNOT_WIDGET = new Object[]{"H", "P"};
        DEF_FONT = new Object[]{"Name", null};
        DEF_FONTDESCRIPTOR = new Object[]{"Leading", INTEGER0, "XHeight", INTEGER0, "StemH", INTEGER0, "AvgWidth", INTEGER0, "MaxWidth", INTEGER0, "MissingWidth", INTEGER0};
        DEF_XOBJECT = new Object[]{"Type", null, "Name", null};
        DEF_IMAGE_FAX = new Object[]{"K", INTEGER0, "EndOfLine", Boolean.FALSE, "EncodedByteAlign", Boolean.FALSE, "Columns", new Integer(1728), "Rows", INTEGER0, "EndOfBlock", Boolean.TRUE, "BlackIs1", Boolean.FALSE, "DamagedRowsBeforeError", INTEGER0};
        DEF_IMAGE_DCT = new Object[]{"ColorTransform", INTEGER1};
        DEF_FORM = new Object[]{"Type", null, "FormType", INTEGER1, "Matrix", A100100};
        DEF_ACTION = new Object[]{"Type", null};
        DEF_PATTERN = new Object[]{"Type", null, "Matrix", A100100};
        DEF_FILESPEC = new Object[]{"V", Boolean.FALSE};
        DEF_FILE_EMBEDDED = new Object[]{"Type", "EmbeddedFile"};
        DEF_CRYPTFILTER = new Object[]{"Type", "CryptFilter", "CFM", "None", "Length", Integers.getInteger(128), "AuthEvent", "DocOpen"};
        DEF_CRYPTFILTER_DP = new Object[]{"Type", "CryptFilterDecodeParms"};
        DEF_OCG = new Object[]{"Intent", "View"};
        DEF_OCMD = new Object[]{"P", "AnyOn"};
        DEF_CATALOG = new Object[]{"PageLayout", "SinglePage", "PageMode", "UseNone"};
    }
}

