/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.span;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Point;
import java.util.Map;
import multivalent.Browser;
import multivalent.Context;
import multivalent.ESISNode;
import multivalent.INode;
import multivalent.Layer;
import multivalent.Node;
import multivalent.SemanticEvent;
import multivalent.Span;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FBISpan
extends Span {
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_REASON = "reason";
    private String comment_;
    private String reason_;

    public void setReason(String string) {
        this.reason_ = string != null ? string : "";
        this.putAttr(ATTR_REASON, this.reason_);
    }

    public void setComment(String string) {
        this.comment_ = string != null ? string : null;
        this.putAttr(ATTR_COMMENT, this.comment_);
    }

    @Override
    public boolean appearance(Context context, boolean bl) {
        context.foreground = context.background = Color.BLACK;
        return false;
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean semanticEventBefore(SemanticEvent semanticEvent, String string) {
        if (super.semanticEventBefore(semanticEvent, string)) {
            return true;
        }
        if (this == semanticEvent.getIn() && "createWidget/DOCPOPUP" == string) {
            INode iNode = (INode)semanticEvent.getOut();
            Browser browser = this.getBrowser();
            if (this.isEditable()) {
                this.createUI("button", "Edit Redaction Metadata", new SemanticEvent(browser, "editSpan", this, this, null), iNode, "EDIT", false);
            }
        }
        return false;
    }

    @Override
    public boolean eventBefore(AWTEvent aWTEvent, Point point, Node node) {
        Browser browser = this.getBrowser();
        int n = aWTEvent.getID();
        if (n == 504) {
            browser.eventq("showStatus", new StringBuffer().append("Removed for reason ").append(this.reason_).append(this.comment_ != null ? new StringBuffer().append(" (").append(this.comment_.substring(0, Math.min(40, this.comment_.length()))).append(")").toString() : "").toString());
        } else if (n == 505) {
            browser.eventq("showStatus", "");
        }
        return false;
    }

    @Override
    public boolean semanticEventAfter(SemanticEvent semanticEvent, String string) {
        Object object = semanticEvent.getArg();
        if (this == semanticEvent.getIn() && "formData" == string) {
            Map map = (Map)object;
            if (map != null && map.get("cancel") == null) {
                this.setComment((String)map.get(ATTR_COMMENT));
                this.setReason((String)map.get(ATTR_REASON));
            }
            return true;
        }
        return super.semanticEventAfter(semanticEvent, string);
    }

    @Override
    public void restore(ESISNode eSISNode, Map<String, Object> map, Layer layer) {
        super.restore(eSISNode, map, layer);
        this.reason_ = this.getAttr(ATTR_REASON, "(no reason)");
        this.comment_ = this.getAttr(ATTR_COMMENT, "");
    }
}

