/*
 * Decompiled with CFR 0.152.
 */
package com.pt.io;

import com.pt.io.RandomAccess;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import phelps.lang.Maths;

public class RandomAccessFileBuffered
extends RandomAccessFile
implements RandomAccess {
    private File file_;
    private byte[] buf_;
    private int bufi_;
    private long fp_ = 0L;
    private int limit_ = 0;
    private boolean dirty_ = false;
    private long length_ = -1L;
    private long fp0_ = 0L;
    private long length0_ = Long.MAX_VALUE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RandomAccessFileBuffered(File file, String string) throws FileNotFoundException {
        this(file, string, 8192);
    }

    public RandomAccessFileBuffered(File file, String string, int n) throws FileNotFoundException {
        super(file, string);
        int n2;
        this.file_ = file;
        int n3 = n2 = 1 < n ? n : 32768;
        if ("r".equals(string)) {
            try {
                n2 = (int)Math.min((long)n2, this.length());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.buf_ = new byte[n2];
        this.limit_ = 0;
        this.bufi_ = 0;
    }

    public void slice(long l, long l2) throws IOException {
        this.length();
        l = Maths.minmax(0L, l, this.length_);
        if (l2 < 0L) {
            l2 = this.length_ - l;
        } else if (l > 0L || l2 < Long.MAX_VALUE) {
            l2 = Maths.minmax(0L, l2, this.length_ - l);
        }
        if (l != this.fp0_ || l2 != this.length0_) {
            this.invalidate();
            this.fp0_ = l;
            this.length0_ = l2;
            this.seek(0L);
        }
    }

    void invalidate() throws IOException {
        this.flush();
        this.fp_ += (long)this.bufi_;
        this.limit_ = 0;
        this.bufi_ = 0;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n2 + n <= byArray.length)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.limit_ != -1 && this.limit_ < this.bufi_) {
            throw new AssertionError((Object)(this.limit_ + " < " + this.bufi_));
        }
        int n4 = Math.min(this.limit_ - this.bufi_, n2);
        if (n4 > 0) {
            System.arraycopy(this.buf_, this.bufi_, byArray, n, n4);
            this.bufi_ += n4;
            n3 = n4;
        } else if (n2 == 0) {
            n3 = 0;
        } else if (this.limit_ == -1) {
            n3 = -1;
        } else {
            if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                throw new AssertionError();
            }
            this.invalidate();
            long l = this.length() - this.getFilePointer();
            this.limit_ = l > 0L ? super.read(this.buf_, 0, (int)Math.min((long)this.buf_.length, l)) : -1;
            n3 = this.read(byArray, n, n2);
        }
        if (!$assertionsDisabled && n3 != -1 && n3 < 1 && n2 != 0) {
            throw new AssertionError();
        }
        return n3;
    }

    public int read() throws IOException {
        int n;
        if (this.bufi_ < this.limit_) {
            n = this.buf_[this.bufi_++] & 0xFF;
        } else if (this.limit_ == -1) {
            n = -1;
        } else {
            if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                throw new AssertionError();
            }
            this.invalidate();
            long l = this.length() - this.getFilePointer();
            int n2 = this.limit_ = l > 0L ? super.read(this.buf_, 0, (int)Math.min((long)this.buf_.length, l)) : -1;
            if (!$assertionsDisabled && this.limit_ == 0) {
                throw new AssertionError((Object)(this.file_ + " @ " + super.getFilePointer()));
            }
            n = this.read();
        }
        return n;
    }

    public void writeString8(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.write(string.charAt(i));
        }
    }

    public void writeString16(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (!($assertionsDisabled || byArray != null && n >= 0 && n2 >= 0 && n + n2 <= byArray.length)) {
            throw new AssertionError();
        }
        if (n2 <= 0) {
            return;
        }
        int n3 = Math.min(this.buf_.length - this.bufi_, n2);
        if (n3 > 0) {
            System.arraycopy(byArray, n, this.buf_, this.bufi_, n3);
            this.bufi_ += n3;
            this.limit_ = Math.max(this.bufi_, this.limit_);
            this.dirty_ = true;
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                throw new AssertionError();
            }
            this.invalidate();
            if (n2 < this.buf_.length) {
                this.write(byArray, n, n2);
            } else {
                if (!$assertionsDisabled && this.fp_ != super.getFilePointer()) {
                    throw new AssertionError((Object)(this.fp_ + " != " + super.getFilePointer()));
                }
                super.write(byArray, n, n2);
                this.fp_ += (long)n2;
            }
        }
        if (this.fp_ + (long)this.bufi_ > this.length_) {
            this.length_ = this.fp_ + (long)this.bufi_;
        }
    }

    public void write(int n) throws IOException {
        if (this.bufi_ >= this.limit_) {
            if (this.limit_ < this.buf_.length) {
                if (this.limit_ == -1) {
                    this.limit_ = 0;
                }
                if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                    throw new AssertionError();
                }
                ++this.limit_;
            } else {
                if (!$assertionsDisabled && this.bufi_ != this.limit_) {
                    throw new AssertionError();
                }
                this.invalidate();
                this.limit_ = 1;
            }
        }
        this.buf_[this.bufi_++] = (byte)n;
        this.dirty_ = true;
        if (this.fp_ + (long)this.bufi_ > this.length_) {
            this.length_ = this.fp_ + (long)this.bufi_;
        }
    }

    public void flush() throws IOException {
        if (!this.dirty_) {
            return;
        }
        super.seek(this.fp_);
        super.write(this.buf_, 0, this.limit_);
        this.dirty_ = false;
    }

    public long getFilePointer() throws IOException {
        return this.fp_ - this.fp0_ + (long)(this.limit_ >= 0 ? this.bufi_ : 0);
    }

    public void setLength(long l) throws IOException {
        if (!$assertionsDisabled && l < 0L) {
            throw new AssertionError(l);
        }
        if (l == this.length()) {
            return;
        }
        this.invalidate();
        super.setLength(l);
        this.length_ = l;
        if (this.fp_ > l) {
            this.fp_ = l;
        }
        super.seek(this.fp_);
    }

    public long length() throws IOException {
        if (this.length_ < 0L) {
            this.length_ = super.length();
        }
        return this.length0_ == Long.MAX_VALUE ? this.length_ : this.length0_;
    }

    public int skipBytes(int n) throws IOException {
        if (n < 0) {
            throw new IOException("negative skip " + n);
        }
        long l = this.getFilePointer();
        this.seek(Math.min(l + (long)n, this.length()));
        return (int)(this.getFilePointer() - l);
    }

    public void seek(long l) throws IOException {
        if ((l += this.fp0_) < 0L) {
            l = 0L;
        }
        if (this.fp_ <= l && l < this.fp_ + (long)this.limit_) {
            this.bufi_ = (int)(l - this.fp_);
        } else {
            long l2 = this.fp_;
            long l3 = this.length_;
            int n = this.limit_;
            this.invalidate();
            int n2 = this.buf_.length;
            if (n2 >= 8192 && l < l3) {
                long l4 = l / 8192L * 8192L;
                int n3 = (int)Math.min((long)n2, l3 - l4);
                int n4 = 0;
                if (l4 < l2 && l2 < l4 + (long)n3 && l4 + (long)n3 < l2 + (long)n) {
                    if (!$assertionsDisabled && n2 <= 8192) {
                        throw new AssertionError(n2);
                    }
                    n4 = (int)(l4 + (long)n3 - l2);
                    n3 = (int)(l2 - l4);
                    System.arraycopy(this.buf_, 0, this.buf_, n3, n4);
                }
                super.seek(l4);
                this.fp_ = l4;
                this.readFully(this.buf_, 0, n3);
                this.fp_ = l4;
                this.limit_ = n3 + n4;
                this.bufi_ = (int)(l - l4);
            } else {
                super.seek(l);
                this.fp_ = l;
            }
        }
        if (!($assertionsDisabled || this.fp_ + (long)this.bufi_ == l && this.bufi_ >= 0)) {
            throw new AssertionError((Object)(this.fp_ + " + 0.." + this.bufi_ + ".." + this.limit_ + " != " + l));
        }
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    static {
        $assertionsDisabled = !RandomAccessFileBuffered.class.desiredAssertionStatus();
    }
}

