/*
 * Decompiled with CFR 0.152.
 */
package com.pt.doc;

import com.pt.doc.Tag;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import phelps.io.Files;
import phelps.util.HashMaps;

public class ParserXML {
    public static final Object TYPE_TAG_OPEN;
    public static final Object TYPE_TAG_CLOSED;
    public static final Object TYPE_CONTENT;
    public static final Object TYPE_ENTITY;
    public static final Object TYPE_COMMENT;
    public static final Object TYPE_PI;
    public static final Object TYPE_DOCTYPE;
    private static final int CHAR_INVALID = -2;
    private static Map<String, String> ENTITY_PREDEFINED;
    private Reader r_;
    private boolean fstrict_ = false;
    private boolean fpreserve_ = true;
    private boolean ffix_ = false;
    private boolean fcomment_ = false;
    private List stack_ = new ArrayList(10);
    private Object type_ = null;
    private Object next_ = null;
    private Object nexttype_ = null;
    private boolean nextempty_ = false;
    private int unread_ = -2;
    private char[] buf_;
    private int bufi_;
    private int buflen_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ParserXML(Reader reader) throws IOException {
        this.r_ = reader;
        this.buf_ = new char[8192];
        this.buflen_ = 0;
        this.bufi_ = 0;
        this.next();
    }

    public ParserXML(File file) throws IOException {
        this(new FileReader(file));
    }

    public void setStrict(boolean bl) {
        this.fstrict_ = bl;
    }

    public void setPreserveWhitespace(boolean bl) {
        this.fpreserve_ = bl;
    }

    public void setFix(boolean bl) {
        this.ffix_ = bl;
    }

    public void setReturnComments(boolean bl) {
        this.fcomment_ = bl;
    }

    public boolean hasNext() {
        return this.next_ != null;
    }

    public Object next() throws IOException {
        Object object = this.next_;
        this.type_ = this.nexttype_;
        if (this.nextempty_) {
            if (!$assertionsDisabled && this.type_ != TYPE_TAG_OPEN) {
                throw new AssertionError();
            }
            this.nextempty_ = false;
            this.next_ = new Tag(((Tag)object).getGI());
            this.nexttype_ = TYPE_TAG_CLOSED;
            return object;
        }
        this.skipSpace();
        int n = this.read();
        if (-1 == n) {
            this.next_ = null;
            this.nexttype_ = null;
        } else if (60 == n) {
            n = this.read();
            if (33 == n) {
                n = this.read();
                if (45 == n) {
                    this.read();
                    this.skipSpace();
                    StringBuffer stringBuffer = new StringBuffer(30);
                    while ((n = this.read()) != -1) {
                        if (n == 62 && stringBuffer.length() >= 2 && stringBuffer.charAt(stringBuffer.length() - 1) == '-' && stringBuffer.charAt(stringBuffer.length() - 2) == '-') {
                            stringBuffer.setLength(stringBuffer.length() - 2);
                            break;
                        }
                        stringBuffer.append((char)n);
                    }
                    this.next_ = stringBuffer.toString();
                    this.nexttype_ = TYPE_COMMENT;
                } else {
                    StringBuffer stringBuffer = new StringBuffer(80);
                    stringBuffer.append((char)n);
                    while ((n = this.read()) != -1 && n != 62) {
                        stringBuffer.append((char)n);
                    }
                    this.next_ = stringBuffer.toString();
                    this.nexttype_ = TYPE_DOCTYPE;
                }
            } else if (47 == n) {
                StringBuffer stringBuffer = new StringBuffer(10);
                while ((n = this.read()) != -1 && n != 62 && !this.isSpace(n)) {
                    stringBuffer.append((char)n);
                }
                this.unread(n);
                this.next_ = new Tag(stringBuffer.toString());
                this.nexttype_ = TYPE_TAG_CLOSED;
                this.skipSpace();
                this.read();
            } else if (Character.isSpace((char)n) && this.ffix_) {
                this.next_ = "<";
                this.nexttype_ = TYPE_CONTENT;
                this.unread(n);
            } else {
                StringBuffer stringBuffer = new StringBuffer(10);
                if (63 == n) {
                    this.nexttype_ = TYPE_PI;
                } else {
                    this.nexttype_ = TYPE_TAG_OPEN;
                    stringBuffer.append((char)n);
                }
                while ((n = this.read()) != -1 && n != 62 && n != 47 && !this.isSpace(n)) {
                    stringBuffer.append((char)n);
                }
                this.unread(n);
                String string = stringBuffer.toString();
                HashMap<String, String> hashMap = new HashMap<String, String>(5);
                while (true) {
                    this.skipSpace();
                    n = this.read();
                    if (62 == n) break;
                    if (47 == n) {
                        this.nextempty_ = false;
                        this.skipSpace();
                        this.read();
                        break;
                    }
                    if (63 == n) {
                        if (!$assertionsDisabled && TYPE_PI != this.nexttype_) {
                            throw new AssertionError();
                        }
                        this.skipSpace();
                        this.read();
                        break;
                    }
                    stringBuffer = new StringBuffer(10);
                    stringBuffer.append((char)n);
                    while ((n = this.read()) != -1 && n != 61 && !this.isSpace(n)) {
                        stringBuffer.append((char)n);
                    }
                    this.unread(n);
                    String string2 = stringBuffer.toString();
                    this.skipSpace();
                    n = this.read();
                    if (61 == n) {
                        this.skipSpace();
                        n = this.read();
                        stringBuffer = new StringBuffer(10);
                        if (39 == n) {
                            while ((n = this.read()) != -1 && n != 39) {
                                stringBuffer.append((char)n);
                            }
                            if (!$assertionsDisabled && 39 != n) {
                                throw new AssertionError();
                            }
                        } else if (34 == n) {
                            while ((n = this.read()) != -1 && n != 34) {
                                stringBuffer.append((char)n);
                            }
                            if (!$assertionsDisabled && 34 != n) {
                                throw new AssertionError();
                            }
                        } else {
                            stringBuffer.append((char)n);
                            while ((n = this.read()) != -1 && !this.isSpace(n) && n != 62) {
                                stringBuffer.append((char)n);
                            }
                            this.unread(n);
                        }
                        hashMap.put(string2, stringBuffer.toString());
                        continue;
                    }
                    this.unread(n);
                    hashMap.put(string2, string2);
                }
                this.next_ = new Tag(string, hashMap);
                if (TYPE_TAG_OPEN != this.nexttype_ && !$assertionsDisabled && TYPE_PI != this.nexttype_) {
                    throw new AssertionError();
                }
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer(400);
            stringBuffer.append((char)n);
            while ((n = this.read()) != -1) {
                if (n == 60) {
                    this.unread(n);
                    break;
                }
                stringBuffer.append((char)n);
            }
            this.next_ = this.normalize(stringBuffer).toString();
            this.nexttype_ = TYPE_CONTENT;
        }
        return object;
    }

    private StringBuffer normalize(StringBuffer stringBuffer) {
        if (stringBuffer.indexOf("&") != -1) {
            StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length());
            int n = stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                char c = stringBuffer.charAt(i);
                if (c == '&' && i + 1 < n) {
                    c = stringBuffer.charAt(i + 1);
                    int n2 = stringBuffer.indexOf(";", i + 1);
                    if ((c == '#' || Character.isLetter(c) || c == '_' || c == ':') && n2 != -1) {
                        stringBuffer2.append(this.resolve(stringBuffer.substring(i, n2)));
                        i = n2 + 1 - 1;
                        continue;
                    }
                    if (!this.ffix_) continue;
                    stringBuffer2.append('&');
                    continue;
                }
                if (c == '\r') {
                    stringBuffer2.append('\n');
                    if (i + 1 >= n || stringBuffer.charAt(i + 1) != '\n') continue;
                    ++i;
                    continue;
                }
                stringBuffer2.append(c);
            }
            stringBuffer = stringBuffer2;
        } else if (stringBuffer.indexOf("\r") != -1) {
            int n = 0;
            int n3 = stringBuffer.length();
            for (int i = 0; i < n3; ++i) {
                char c = stringBuffer.charAt(i);
                if (c == '\r') {
                    stringBuffer.setCharAt(i, '\n');
                    ++n;
                    if (i + 1 >= n3 || stringBuffer.charAt(i + 1) != '\n') continue;
                    ++i;
                    continue;
                }
                stringBuffer.setCharAt(i, c);
                ++n;
            }
            stringBuffer.setLength(n);
        }
        return stringBuffer;
    }

    private String resolve(String string) {
        char c = string.charAt(0);
        int n = string.length();
        if (c == '#') {
            int n2;
            int n3 = 10;
            int n4 = 1;
            if (n4 < n && string.charAt(n4) == 'x') {
                n3 = 16;
                ++n4;
            }
            try {
                n2 = Integer.parseInt(string.substring(n4), n3);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 32;
            }
            String string2 = String.valueOf((char)n2);
        } else {
            String string3 = ENTITY_PREDEFINED.get(string);
            if (string3 == null) {
                string3 = string;
            }
        }
        return string;
    }

    public Object getType() {
        return this.type_;
    }

    private void skipSpace() throws IOException {
        int n;
        while ((n = this.read()) != -1 && this.isSpace(n)) {
        }
        this.unread(n);
    }

    private boolean isSpace(int n) {
        return n == 32 || n == 9 || n == 13 || n == 10;
    }

    private int read() throws IOException {
        int n;
        if (-2 != this.unread_) {
            n = this.unread_;
            this.unread_ = -2;
        } else if (this.bufi_ < this.buflen_) {
            n = this.buf_[this.bufi_++];
        } else if (this.buflen_ == -1) {
            n = -1;
        } else {
            this.buflen_ = this.r_.read(this.buf_);
            this.bufi_ = 0;
            n = this.read();
        }
        return n;
    }

    private void unread(int n) {
        if (!$assertionsDisabled && this.unread_ != -2) {
            throw new AssertionError();
        }
        this.unread_ = n;
    }

    public void close() throws IOException {
        this.r_.close();
        this.r_ = null;
        this.buf_ = null;
    }

    public static void main(String[] stringArray) throws IOException {
        ParserXML parserXML = new ParserXML(Files.getFile("~/Library/Preferences/com.adobe.Acrobat.Pro.plist"));
        while (parserXML.hasNext()) {
            Object object = parserXML.next();
            System.out.println(parserXML.getType() + ": |" + object + "|");
        }
        parserXML.close();
    }

    static {
        $assertionsDisabled = !ParserXML.class.desiredAssertionStatus();
        TYPE_TAG_OPEN = "open";
        TYPE_TAG_CLOSED = "closed";
        TYPE_CONTENT = "content";
        TYPE_ENTITY = "entity";
        TYPE_COMMENT = "comment";
        TYPE_PI = "pi";
        TYPE_DOCTYPE = "doctype";
        ENTITY_PREDEFINED = HashMaps.create(new String[]{"lt", "<", "gt", ">", "amp", "&", "apos", "'", "quote", "\""});
    }
}

