/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLUtil {
    public static String normalize(Object ss) {
        String s = "";
        s = (String)ss;
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    continue block7;
                }
                case '>': {
                    str.append("&gt;");
                    continue block7;
                }
                case '&': {
                    if (i + 1 < len - 1 && s.charAt(i + 1) == '#') {
                        str.append("&#");
                        ch = s.charAt(i += 2);
                        while (i < len && ch != ';') {
                            str.append(ch);
                            ch = s.charAt(++i);
                        }
                        str.append(';');
                        continue block7;
                    }
                    if (i + 4 < len && s.charAt(i + 1) == 'a' && s.charAt(i + 2) == 'm' && s.charAt(i + 3) == 'p' && s.charAt(i + 4) == ';') {
                        str.append("&amp;");
                        i += 4;
                        continue block7;
                    }
                    if (i + 3 < len && s.charAt(i + 1) == 'l' && s.charAt(i + 2) == 't' && s.charAt(i + 3) == ';') {
                        str.append("&lt;");
                        i += 3;
                        continue block7;
                    }
                    if (i + 3 < len && s.charAt(i + 1) == 'g' && s.charAt(i + 2) == 't' && s.charAt(i + 3) == ';') {
                        str.append("&gt;");
                        i += 3;
                        continue block7;
                    }
                    if (i + 5 < len && s.charAt(i + 1) == 'q' && s.charAt(i + 2) == 'u' && s.charAt(i + 3) == 'o' && s.charAt(i + 4) == 't' && s.charAt(i + 5) == ';') {
                        str.append("&quot;");
                        i += 5;
                        continue block7;
                    }
                    if (i + 5 < len && s.charAt(i + 1) == 'a' && s.charAt(i + 2) == 'p' && s.charAt(i + 3) == 'o' && s.charAt(i + 4) == 's' && s.charAt(i + 5) == ';') {
                        str.append("&apos;");
                        i += 5;
                        continue block7;
                    }
                    str.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    str.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    str.append("&apos;");
                    continue block7;
                }
                default: {
                    if (ch < '\u0080' && ch > '\u001f') {
                        str.append(ch);
                        continue block7;
                    }
                    if (ch < ' ') {
                        if (ch == '\n') {
                            str.append(ch);
                        }
                        if (ch == '\r') {
                            str.append(ch);
                        }
                        if (ch != '\t') continue block7;
                        str.append(ch);
                        continue block7;
                    }
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                }
            }
        }
        String temp = str.toString();
        if ((temp = temp.trim()).length() < 1) {
            temp = " ";
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDOMTreeAsString(Node node) {
        if (node == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(baos);
        try {
            XMLUtil.print(node, printWriter);
        }
        catch (Exception e) {
            String msg = "getDOMTreeAsString() - unexpected Exception: " + e + "\n";
            printWriter.println(msg);
            e.printStackTrace(printWriter);
        }
        finally {
            try {
                printWriter.flush();
                baos.flush();
                baos.close();
                printWriter.close();
            }
            catch (IOException iOException) {}
        }
        return baos.toString();
    }

    public static void print(Node node, PrintWriter out) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                out.println("<?xml version=\"1.0\"?>");
                XMLUtil.print(((Document)node).getDocumentElement(), out);
                out.flush();
                break;
            }
            case 1: {
                out.print('<');
                out.print(node.getNodeName());
                Attr[] attrs = XMLUtil.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    out.print(' ');
                    out.print(attr.getNodeName());
                    out.print("=\"");
                    out.print(XMLUtil.normalize(attr.getNodeValue()));
                    out.print('\"');
                }
                out.print('>');
                NodeList children = node.getChildNodes();
                if (children == null) break;
                int len = children.getLength();
                for (int i = 0; i < len; ++i) {
                    XMLUtil.print(children.item(i), out);
                }
                break;
            }
            case 5: {
                out.print('&');
                out.print(node.getNodeName());
                out.print(';');
                break;
            }
            case 4: {
                out.print("<![CDATA[");
                out.print(node.getNodeValue());
                out.print("]]>");
                break;
            }
            case 3: {
                out.print(XMLUtil.normalize(node.getNodeValue()));
                break;
            }
            case 7: {
                out.print("<?");
                out.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    out.print(' ');
                    out.print(data);
                }
                out.print("?>");
                break;
            }
        }
        if (type == 1) {
            out.print("</");
            out.print(node.getNodeName());
            out.print(">\n");
        }
        out.flush();
    }

    protected static Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    public static String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        if (attributes == null) {
            return null;
        }
        Node n = attributes.getNamedItem(attributeName);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }
}

