/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.util;

import com.arbortext.catalog.Catalog;
import com.arbortext.catalog.CatalogEntityResolver;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DBValidate {
    static int WARNING = 0;
    static int ERROR = 1;
    static int FATAL_ERROR = 2;
    private Morpho morpho = null;
    private ConfigXML config = null;
    XMLReader parser;
    ErrorStorer ef;
    String xml_doc;

    public DBValidate(String parserName) {
        try {
            this.parser = XMLReaderFactory.createXMLReader(parserName);
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (Exception e) {
            Log.debug(20, "Could not create parser in DBValidate.DBValidate");
        }
    }

    public DBValidate(String parserName, Morpho morpho) {
        this(parserName);
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        CatalogEntityResolver cer = new CatalogEntityResolver();
        try {
            Catalog myCatalog = new Catalog();
            myCatalog.loadSystemCatalogs();
            String catalogPath = this.config.get("local_catalog_path", 0);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL catalogURL = cl.getResource(catalogPath);
            myCatalog.parseCatalog(catalogURL.toString());
            cer.setCatalog(myCatalog);
        }
        catch (Exception e) {
            Log.debug(20, "Problem creating Catalog in DBValidate.DBValidate");
        }
        this.parser.setEntityResolver(cer);
    }

    public boolean validate(String doc) {
        this.xml_doc = doc;
        this.ef = new ErrorStorer();
        this.ef.resetErrors();
        this.parser.setErrorHandler(this.ef);
        try {
            this.parser.parse(this.createURL(this.xml_doc).toString());
        }
        catch (IOException e) {
            System.out.println("IOException:Could not parse :" + this.xml_doc + " from DBValidate.validate");
            ParseError eip = null;
            eip = new ParseError("", 0, 0, "IOException:Could not parse :" + this.xml_doc);
            if (this.ef.errorNodes == null) {
                this.ef.errorNodes = new Vector();
            }
            this.ef.errorNodes.addElement(eip);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.ef == null || this.ef.getErrorNodes() == null || this.ef.getErrorNodes().size() <= 0;
    }

    public boolean validateString(String xmldoc) {
        this.ef = new ErrorStorer();
        this.ef.resetErrors();
        this.parser.setErrorHandler(this.ef);
        InputSource is = new InputSource(new StringReader(xmldoc));
        try {
            this.parser.parse(is);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            Log.debug(20, "Error in parsing in DBValidate.validateString");
        }
        return this.ef == null || this.ef.getErrorNodes() == null || this.ef.getErrorNodes().size() <= 0;
    }

    public String returnErrors() {
        StringBuffer errorstring = new StringBuffer();
        errorstring.append("<?xml version=\"1.0\" ?>\n");
        if (this.ef != null && this.ef.getErrorNodes() != null && this.ef.getErrorNodes().size() > 0) {
            Vector errors = this.ef.getErrorNodes();
            errorstring.append("<validationerrors>\n");
            Enumeration e = errors.elements();
            while (e.hasMoreElements()) {
                errorstring.append(((ParseError)e.nextElement()).toXML());
            }
            errorstring.append("</validationerrors>\n");
        } else {
            errorstring.append("<valid />\n");
        }
        return errorstring.toString();
    }

    private URL createURL(String name) throws Exception {
        try {
            URL u = new URL(name);
            return u;
        }
        catch (MalformedURLException ex) {
            URL u = new URL("file:" + new File(name).getAbsolutePath());
            return u;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: java DBValidate <xmlfile or URL>");
            System.exit(0);
        }
    }

    class ParseError {
        String fileName;
        int lineNo;
        int charOffset;
        String msg;

        public ParseError(String fileName, int lineNo, int charOffset, String msg) {
            this.fileName = fileName;
            this.lineNo = lineNo;
            this.charOffset = charOffset;
            this.msg = msg;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNo() {
            return this.lineNo;
        }

        public int getCharOffset() {
            return this.charOffset;
        }

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String s) {
            this.msg = s;
        }

        public String toXML() {
            StringBuffer err = new StringBuffer();
            err.append("<error>\n");
            err.append("<filename>").append(this.getFileName()).append("</filename>\n");
            err.append("<line>").append(this.getLineNo()).append("</line>\n");
            err.append("<offset>").append(this.getCharOffset()).append("</offset>\n");
            err.append("<message>").append(this.getMsg()).append("</message>\n");
            err.append("</error>\n");
            return err.toString();
        }
    }

    class ErrorStorer
    implements ErrorHandler {
        Vector errorNodes = null;

        public Vector getErrorNodes() {
            return this.errorNodes;
        }

        public Object getError() {
            if (this.errorNodes == null) {
                return null;
            }
            return this.errorNodes;
        }

        public void resetErrors() {
            if (this.errorNodes != null) {
                this.errorNodes.removeAllElements();
            }
        }

        public void warning(SAXParseException ex) {
            this.handleError(ex, WARNING);
        }

        public void error(SAXParseException ex) {
            this.handleError(ex, ERROR);
        }

        public void fatalError(SAXParseException ex) throws SAXException {
            this.handleError(ex, FATAL_ERROR);
        }

        private void handleError(SAXParseException ex, int type) {
            if (this.errorNodes == null) {
                this.errorNodes = new Vector();
            }
            ParseError eip = null;
            eip = new ParseError(ex.getSystemId(), ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
            this.errorNodes.addElement(eip);
        }
    }
}

