/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.query.BasicNode;
import edu.ucsb.nceas.morpho.query.HeadResultSet;
import edu.ucsb.nceas.morpho.query.LocalQuery;
import edu.ucsb.nceas.morpho.query.QueryGroup;
import edu.ucsb.nceas.morpho.query.QueryTerm;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.query.ResultSet;
import edu.ucsb.nceas.morpho.query.ResultsetHandler;
import edu.ucsb.nceas.morpho.query.SynchronizeVector;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.StateChangeEvent;
import edu.ucsb.nceas.morpho.util.StateChangeMonitor;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Query
extends DefaultHandler {
    private boolean containsExtendedSQL = false;
    private String meta_file_id;
    private String queryTitle;
    private Vector returnDocList = new Vector();
    private Vector filterDocList = new Vector();
    private Vector returnFieldList = new Vector();
    private Vector ownerList = new Vector();
    private Vector siteList = new Vector();
    private QueryGroup rootQG = null;
    private Stack elementStack;
    private Stack queryStack;
    private String currentValue;
    private String currentPathexpr;
    private String parserName = null;
    private String accNumberSeparator = null;
    private Morpho morpho = null;
    private ConfigXML config = null;
    private boolean searchMetacat = true;
    private boolean searchLocal = true;

    public Query(Reader queryspec, Morpho morpho) {
        this(morpho);
        this.elementStack = new Stack();
        this.queryStack = new Stack();
        XMLReader parser = Morpho.createSaxParser(this, this);
        if (parser == null) {
            Log.debug(1, "SAX parser not instantiated properly.");
        }
        try {
            parser.parse(new InputSource(queryspec));
        }
        catch (IOException ioe) {
            Log.debug(4, "Error reading the query during parsing.");
        }
        catch (SAXException e) {
            Log.debug(4, "Error parsing Query (" + e.getClass().getName() + ").");
            Log.debug(4, e.getMessage());
        }
    }

    public Query(String queryspec, Morpho morpho) {
        this(new StringReader(queryspec), morpho);
    }

    public Query(Morpho morpho) {
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        this.loadConfigurationParameters();
    }

    public boolean containsExtendedSQL() {
        return this.containsExtendedSQL;
    }

    public String getIdentifier() {
        return this.meta_file_id;
    }

    public void setIdentifier(String id) {
        this.meta_file_id = id;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    public void setQueryTitle(String title) {
        this.queryTitle = title;
    }

    public Vector getReturnDocList() {
        return this.returnDocList;
    }

    public void setReturnDocList(Vector returnDocList) {
        this.returnDocList = returnDocList;
    }

    public Vector getFilterDocList() {
        return this.filterDocList;
    }

    public void setFilterDocList(Vector filterDocList) {
        this.filterDocList = filterDocList;
    }

    public Vector getReturnFieldList() {
        return this.returnFieldList;
    }

    public void setReturnFieldList(Vector returnFieldList) {
        this.returnFieldList = returnFieldList;
    }

    public Vector getOwnerList() {
        return this.ownerList;
    }

    public void setOwnerList(Vector ownerList) {
        this.ownerList = ownerList;
    }

    public Vector getSiteList() {
        return this.siteList;
    }

    public void setSiteList(Vector siteList) {
        this.siteList = siteList;
    }

    public boolean getSearchMetacat() {
        return this.searchMetacat;
    }

    public void setSearchMetacat(boolean searchMetacat) {
        this.searchMetacat = searchMetacat;
    }

    public boolean getSearchLocal() {
        return this.searchLocal;
    }

    public void setSearchLocal(boolean searchLocal) {
        this.searchLocal = searchLocal;
    }

    public QueryGroup getQueryGroup() {
        return this.rootQG;
    }

    public void setQueryGroup(QueryGroup qg) {
        this.rootQG = qg;
    }

    public Morpho getMorpho() {
        return this.morpho;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        BasicNode currentNode = new BasicNode(localName);
        if (atts != null) {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                currentNode.setAttribute(atts.getLocalName(i), atts.getValue(i));
            }
        }
        this.elementStack.push(currentNode);
        if (currentNode.getTagName().equals("querygroup")) {
            QueryGroup currentGroup = new QueryGroup(currentNode.getAttribute("operator"));
            if (this.rootQG == null) {
                Log.debug(30, "Created root query group.");
                this.rootQG = currentGroup;
            } else {
                QueryGroup parentGroup = (QueryGroup)this.queryStack.peek();
                parentGroup.addChild(currentGroup);
            }
            this.queryStack.push(currentGroup);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        BasicNode leaving = (BasicNode)this.elementStack.pop();
        if (leaving.getTagName().equals("queryterm")) {
            boolean isCaseSensitive = new Boolean(leaving.getAttribute("casesensitive"));
            QueryTerm currentTerm = null;
            currentTerm = this.currentPathexpr == null ? new QueryTerm(isCaseSensitive, leaving.getAttribute("searchmode"), this.currentValue) : new QueryTerm(isCaseSensitive, leaving.getAttribute("searchmode"), this.currentValue, this.currentPathexpr);
            QueryGroup currentGroup = (QueryGroup)this.queryStack.peek();
            currentGroup.addChild(currentTerm);
            this.currentValue = null;
            this.currentPathexpr = null;
        } else if (leaving.getTagName().equals("querygroup")) {
            QueryGroup leavingGroup = (QueryGroup)this.queryStack.pop();
        }
    }

    public void characters(char[] ch, int start, int length) {
        String inputString = new String(ch, start, length);
        BasicNode currentNode = (BasicNode)this.elementStack.peek();
        String currentTag = currentNode.getTagName();
        if (currentTag.equals("meta_file_id")) {
            this.meta_file_id = inputString;
        } else if (currentTag.equals("local_search")) {
            this.searchLocal = inputString.equals("true");
        } else if (currentTag.equals("network_search")) {
            this.searchMetacat = inputString.equals("true");
        } else if (currentTag.equals("querytitle")) {
            this.queryTitle = inputString;
        } else if (currentTag.equals("value")) {
            this.currentValue = inputString;
        } else if (currentTag.equals("pathexpr")) {
            this.currentPathexpr = inputString;
        } else if (currentTag.equals("returndoctype")) {
            this.returnDocList.addElement(inputString);
        } else if (currentTag.equals("filterdoctype")) {
            this.filterDocList.addElement(inputString);
        } else if (currentTag.equals("returnfield")) {
            this.returnFieldList.addElement(inputString);
            this.containsExtendedSQL = true;
        } else if (currentTag.equals("owner")) {
            this.ownerList.addElement(inputString);
        } else if (currentTag.equals("site")) {
            this.siteList.addElement(inputString);
        }
    }

    public String printSQL(boolean useXMLIndex) {
        String current;
        boolean first;
        Enumeration en;
        StringBuffer self = new StringBuffer();
        self.append("SELECT docid,docname,doctype,");
        self.append("date_created, date_updated, rev ");
        self.append("FROM xml_documents WHERE docid IN (");
        self.append(this.rootQG.printSQL(useXMLIndex));
        self.append(") ");
        if (!this.filterDocList.isEmpty()) {
            boolean firstdoctype = true;
            self.append(" AND (");
            en = this.filterDocList.elements();
            while (en.hasMoreElements()) {
                String currentDoctype = (String)en.nextElement();
                if (firstdoctype) {
                    firstdoctype = false;
                    self.append(" doctype = '" + currentDoctype + "'");
                    continue;
                }
                self.append(" OR doctype = '" + currentDoctype + "'");
            }
            self.append(") ");
        }
        if (!this.ownerList.isEmpty()) {
            first = true;
            self.append(" AND (");
            en = this.ownerList.elements();
            while (en.hasMoreElements()) {
                current = (String)en.nextElement();
                if (first) {
                    first = false;
                    self.append(" user_owner = '" + current + "'");
                    continue;
                }
                self.append(" OR user_owner = '" + current + "'");
            }
            self.append(") ");
        }
        if (!this.siteList.isEmpty()) {
            first = true;
            self.append(" AND (");
            en = this.siteList.elements();
            while (en.hasMoreElements()) {
                current = (String)en.nextElement();
                if (first) {
                    first = false;
                    self.append(" SUBSTR(docid, 1, INSTR(docid, '" + this.accNumberSeparator + "')-1) = '" + current + "'");
                    continue;
                }
                self.append(" OR SUBSTR(docid, 1, INSTR(docid, '" + this.accNumberSeparator + "')-1) = '" + current + "'");
            }
            self.append(") ");
        }
        return self.toString();
    }

    public String toXml() {
        String current;
        String currentDoctype;
        Enumeration en;
        StringBuffer self = new StringBuffer();
        self.append("<?xml version=\"1.0\"?>\n");
        self.append("<pathquery version=\"1.2\">\n");
        if (this.meta_file_id != null) {
            self.append("  <meta_file_id>" + this.meta_file_id + "</meta_file_id>\n");
        }
        self.append("  <local_search>" + this.searchLocal + "</local_search>\n");
        self.append("  <network_search>" + this.searchMetacat + "</network_search>\n");
        if (this.queryTitle != null) {
            self.append("  <querytitle>" + this.queryTitle + "</querytitle>\n");
        }
        if (!this.returnDocList.isEmpty()) {
            en = this.returnDocList.elements();
            while (en.hasMoreElements()) {
                currentDoctype = (String)en.nextElement();
                self.append("  <returndoctype>" + currentDoctype + "</returndoctype>\n");
            }
        }
        if (!this.filterDocList.isEmpty()) {
            en = this.filterDocList.elements();
            while (en.hasMoreElements()) {
                currentDoctype = (String)en.nextElement();
                self.append("  <filterdoctype>" + currentDoctype + "</filterdoctype>\n");
            }
        }
        if (!this.returnFieldList.isEmpty()) {
            en = this.returnFieldList.elements();
            while (en.hasMoreElements()) {
                current = (String)en.nextElement();
                self.append("  <returnfield>" + current + "</returnfield>\n");
            }
        }
        if (!this.ownerList.isEmpty()) {
            en = this.ownerList.elements();
            while (en.hasMoreElements()) {
                current = (String)en.nextElement();
                self.append("  <owner>" + current + "</owner>\n");
            }
        }
        if (!this.siteList.isEmpty()) {
            en = this.siteList.elements();
            while (en.hasMoreElements()) {
                current = (String)en.nextElement();
                self.append("  <site>" + current + "</site>\n");
            }
        }
        self.append(this.rootQG.toXml(2));
        self.append("</pathquery>\n");
        return self.toString();
    }

    public String printExtendedSQL(String doclist) {
        StringBuffer self = new StringBuffer();
        self.append("select xml_nodes.docid, xml_index.path, xml_nodes.nodedata ");
        self.append("from xml_index, xml_nodes where xml_index.nodeid=");
        self.append("xml_nodes.parentnodeid and (xml_index.path like '");
        boolean firstfield = true;
        for (int i = 0; i < this.returnFieldList.size(); ++i) {
            if (firstfield) {
                firstfield = false;
                self.append((String)this.returnFieldList.elementAt(i));
                self.append("' ");
                continue;
            }
            self.append("or xml_index.path like '");
            self.append((String)this.returnFieldList.elementAt(i));
            self.append("' ");
        }
        self.append(") AND xml_nodes.docid in (");
        self.append(doclist);
        self.append(")");
        self.append(" AND xml_nodes.nodetype = 'TEXT'");
        return self.toString();
    }

    public static String printRelationSQL(String docid) {
        StringBuffer self = new StringBuffer();
        self.append("select subject, relationship, object, subdoctype, ");
        self.append("objdoctype from xml_relation ");
        self.append("where subject like '").append(docid).append("'");
        return self.toString();
    }

    public static String printPackageSQL() {
        StringBuffer self = new StringBuffer();
        self.append("select z.nodedata, x.nodedata, y.nodedata from ");
        self.append("(select nodeid, parentnodeid from xml_index where path like ");
        self.append("'package/relation/subject') s, (select nodeid, parentnodeid ");
        self.append("from xml_index where path like ");
        self.append("'package/relation/relationship') rel, ");
        self.append("(select nodeid, parentnodeid from xml_index where path like ");
        self.append("'package/relation/object') o, ");
        self.append("xml_nodes x, xml_nodes y, xml_nodes z ");
        self.append("where s.parentnodeid = rel.parentnodeid ");
        self.append("and rel.parentnodeid = o.parentnodeid ");
        self.append("and x.parentnodeid in rel.nodeid ");
        self.append("and y.parentnodeid in o.nodeid ");
        self.append("and z.parentnodeid in s.nodeid ");
        return self.toString();
    }

    public static String printPackageSQL(String docid) {
        StringBuffer self = new StringBuffer();
        self.append("select z.nodedata, x.nodedata, y.nodedata from ");
        self.append("(select nodeid, parentnodeid from xml_index where path like ");
        self.append("'package/relation/subject') s, (select nodeid, parentnodeid ");
        self.append("from xml_index where path like ");
        self.append("'package/relation/relationship') rel, ");
        self.append("(select nodeid, parentnodeid from xml_index where path like ");
        self.append("'package/relation/object') o, ");
        self.append("xml_nodes x, xml_nodes y, xml_nodes z ");
        self.append("where s.parentnodeid = rel.parentnodeid ");
        self.append("and rel.parentnodeid = o.parentnodeid ");
        self.append("and x.parentnodeid in rel.nodeid ");
        self.append("and y.parentnodeid in o.nodeid ");
        self.append("and z.parentnodeid in s.nodeid ");
        self.append("and z.docid like '").append(docid).append("'");
        return self.toString();
    }

    public static String printPackageSQL(String subDocidURL, String objDocidURL) {
        StringBuffer self = new StringBuffer();
        self.append("select z.nodedata, x.nodedata, y.nodedata from ");
        self.append("(select nodeid, parentnodeid from xml_index where path like ");
        self.append("'package/relation/subject') s, (select nodeid, parentnodeid ");
        self.append("from xml_index where path like ");
        self.append("'package/relation/relationship') rel, ");
        self.append("(select nodeid, parentnodeid from xml_index where path like ");
        self.append("'package/relation/object') o, ");
        self.append("xml_nodes x, xml_nodes y, xml_nodes z ");
        self.append("where s.parentnodeid = rel.parentnodeid ");
        self.append("and rel.parentnodeid = o.parentnodeid ");
        self.append("and x.parentnodeid in rel.nodeid ");
        self.append("and y.parentnodeid in o.nodeid ");
        self.append("and z.parentnodeid in s.nodeid ");
        self.append("and (z.nodedata like '");
        self.append(subDocidURL);
        self.append("' or y.nodedata like '");
        self.append(objDocidURL);
        self.append("')");
        return self.toString();
    }

    public static String printGetDocByDoctypeSQL(String docid) {
        StringBuffer self = new StringBuffer();
        self.append("SELECT docid,docname,doctype,");
        self.append("date_created, date_updated ");
        self.append("FROM xml_documents WHERE docid IN (");
        self.append(docid).append(")");
        return self.toString();
    }

    public String toString() {
        return this.toXml();
    }

    private InputStream queryMetacat() {
        Log.debug(30, "(2.1) Executing metacat query...");
        InputStream queryResult = null;
        Properties prop = new Properties();
        prop.put("action", "squery");
        prop.put("query", this.toXml());
        prop.put("qformat", "xml");
        try {
            queryResult = this.morpho.getMetacatInputStream(prop);
        }
        catch (Exception w) {
            Log.debug(1, "Error in submitting structured query");
            Log.debug(1, w.getMessage());
        }
        Log.debug(30, "(2.3) Metacat output is:\n" + queryResult);
        Log.debug(30, "(2.4) Done Executing metacat query...");
        return queryResult;
    }

    public ResultSet execute() {
        HeadResultSet results = null;
        Log.debug(30, "(1) Executing result set...");
        HeadResultSet metacatResults = null;
        if (this.searchMetacat) {
            Log.debug(30, "(2) Executing metacat query...");
            metacatResults = new HeadResultSet(this, "metacat", this.queryMetacat(), this.morpho);
        }
        Log.debug(30, "(2.5) Executing result set...");
        ResultSet localResults = null;
        if (this.searchLocal) {
            Log.debug(30, "(3) Executing local query...");
            LocalQuery lq = new LocalQuery(this, this.morpho);
            localResults = lq.execute();
        }
        if (!this.searchLocal) {
            results = metacatResults;
        } else if (!this.searchMetacat) {
            results = localResults;
        } else {
            ((ResultSet)metacatResults).merge(localResults);
            results = metacatResults;
        }
        return results;
    }

    public void displaySearchResult(final MorphoFrame resultWindow, final ResultPanel resultDisplayPanel, final boolean sort, final int sortIndex, final String sortOder, final boolean showSearchNumber, final StateChangeEvent stateEvent) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                resultWindow.setBusy(true);
                resultDisplayPanel.setEnableMouseListener(false);
                if (!Query.this.searchLocal) {
                    Log.debug(30, "(3) Executing metacat query...");
                    HeadResultSet localResult = null;
                    Query.this.doMetacatSearchDisplay(resultDisplayPanel, Query.this.morpho, localResult);
                } else if (!Query.this.searchMetacat) {
                    Log.debug(30, "(2) Executing local query...");
                    Query.this.doLocalSearchDisplay(resultDisplayPanel, Query.this.morpho);
                } else {
                    Log.debug(30, "(2) Executing both local and metacat query...");
                    HeadResultSet localResult = Query.this.doLocalSearchDisplay(resultDisplayPanel, Query.this.morpho);
                    Query.this.doMetacatSearchDisplay(resultDisplayPanel, Query.this.morpho, localResult);
                }
                if (sort) {
                    resultDisplayPanel.sortTable(sortIndex, sortOder);
                }
                if (stateEvent != null) {
                    StateChangeMonitor.getInstance().notifyStateChange(stateEvent);
                }
                return null;
            }

            public void finished() {
                if (showSearchNumber) {
                    resultWindow.setMessage(resultDisplayPanel.getResultSet().getRowCount() + " data sets found");
                }
                resultDisplayPanel.setEnableMouseListener(true);
                resultWindow.setBusy(false);
            }
        };
        worker.start();
    }

    private void doMetacatSearchDisplay(ResultPanel resultDisplayPanel, Morpho morpho, HeadResultSet localResult) {
        SynchronizeVector dataVector = new SynchronizeVector();
        String source = "metacat";
        ResultsetHandler handler = new ResultsetHandler(this.queryMetacat(), dataVector, morpho, source);
        Thread parserThread = new Thread(handler);
        parserThread.start();
        Vector allResults = new Vector();
        int length = 0;
        while (!handler.isDone()) {
            Vector partResult = dataVector.getVector();
            for (int i = 0; i < partResult.size(); ++i) {
                allResults.add(partResult.elementAt(i));
            }
            if (allResults.size() <= length) continue;
            resultDisplayPanel.resetResultsVector(allResults);
            length = allResults.size();
        }
        if (localResult != null) {
            localResult.merge(allResults);
            resultDisplayPanel.resetResultsVector(localResult.getResultsVector());
        }
    }

    private HeadResultSet doLocalSearchDisplay(ResultPanel resultDisplayPanel, Morpho morpho) {
        Query query = this;
        LocalQuery lq = new LocalQuery(query, morpho);
        HeadResultSet localResults = (HeadResultSet)lq.execute();
        resultDisplayPanel.setResultSet(localResults);
        return localResults;
    }

    public void save() throws IOException {
        ConfigXML profile = this.morpho.getProfile();
        Query query = this;
        String queriesDirName = query.config.getConfigDirectory() + File.separator + this.config.get("profile_directory", 0) + File.separator + profile.get("profilename", 0) + File.separator + profile.get("queriesdir", 0);
        File queriesDir = new File(queriesDirName);
        if (!queriesDir.exists()) {
            queriesDir.mkdirs();
        }
        File queryFile = new File(queriesDir, this.getIdentifier());
        FileWriter output = new FileWriter(queryFile);
        output.write(this.toXml());
        output.close();
    }

    private void loadConfigurationParameters() {
        ConfigXML profile = this.morpho.getProfile();
        this.parserName = this.config.get("saxparser", 0);
        this.accNumberSeparator = profile.get("separator", 0);
        String searchMetacatString = profile.get("searchmetacat", 0);
        this.searchMetacat = new Boolean(searchMetacatString);
        String searchLocalString = profile.get("searchlocal", 0);
        this.searchLocal = new Boolean(searchLocalString);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Log.debug(1, "Wrong number of arguments!!!");
            Log.debug(1, "USAGE: java Query [-noindex] <xmlfile>");
            return;
        }
        int i = 0;
        boolean useXMLIndex = true;
        if (args[i].equals("-noindex")) {
            useXMLIndex = false;
            ++i;
        }
        String xmlfile = args[i];
        try {
            Morpho morpho = new Morpho(new ConfigXML("lib/config.xml"));
            FileReader xml = new FileReader(new File(xmlfile));
            Query qspec = new Query(xml, morpho);
            Log.debug(9, qspec.toXml());
        }
        catch (IOException e) {
            Log.debug(4, e.getMessage());
        }
    }
}

