/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.query.SynchronizeDialog;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;

public class OpenSynchronizeDialogCommand
implements Command {
    private OpenDialogBox openDialog = null;

    public OpenSynchronizeDialogCommand() {
    }

    public OpenSynchronizeDialogCommand(OpenDialogBox myDialog) {
        this.openDialog = myDialog;
    }

    public void execute(ActionEvent event) {
        ResultPanel resultPane = null;
        MorphoFrame frame = null;
        boolean parentIsOpenDialog = false;
        String selectDocId = null;
        boolean inNetwork = false;
        boolean inLocal = false;
        String frameType = null;
        if (this.openDialog != null) {
            parentIsOpenDialog = true;
            resultPane = this.openDialog.getResultPanel();
            frame = this.openDialog.getParentFrame();
        } else {
            frame = UIController.getInstance().getCurrentActiveWindow();
            if (frame != null) {
                resultPane = RefreshCommand.getResultPanelFromMorphoFrame(frame);
            }
        }
        if (resultPane != null) {
            selectDocId = resultPane.getSelectedId();
            inNetwork = resultPane.getMetacatLocation();
            inLocal = resultPane.getLocalLocation();
            frameType = "searchResultFrame";
        } else {
            DataPackageInterface dataPackage = null;
            try {
                ServiceController services = ServiceController.getInstance();
                ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
                dataPackage = (DataPackageInterface)((Object)provider);
            }
            catch (ServiceNotHandledException snhe) {
                Log.debug(6, snhe.getMessage());
                return;
            }
            selectDocId = dataPackage.getDocIdFromMorphoFrame(frame);
            inNetwork = dataPackage.isDataPackageInNetwork(frame);
            inLocal = dataPackage.isDataPackageInLocal(frame);
            frameType = "dataPackageFrame";
        }
        if (!(selectDocId == null || selectDocId.equals("") || inLocal && inNetwork)) {
            if (!inLocal && !inNetwork) {
                Log.debug(1, "Cannot synchronize unsaved package!");
                return;
            }
            SynchronizeDialog synchronizeDialog = null;
            synchronizeDialog = parentIsOpenDialog ? new SynchronizeDialog(this.openDialog, frame, selectDocId, inLocal, inNetwork) : new SynchronizeDialog(frame, frameType, selectDocId, inLocal, inNetwork);
            synchronizeDialog.setModal(true);
            synchronizeDialog.setVisible(true);
        }
    }
}

