/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.query;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.SwingWorker;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.query.OpenDialogBox;
import edu.ucsb.nceas.morpho.query.RefreshCommand;
import edu.ucsb.nceas.morpho.query.ResultPanel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.event.ActionEvent;

public class OpenPreviousVersionCommand
implements Command {
    private OpenDialogBox dialog = null;
    private MorphoFrame morphoFrame = null;
    private ResultPanel resultPane = null;
    private Morpho morpho = null;
    String packageName = null;
    int version = -1;
    boolean metacatLoc = false;
    boolean localLoc = false;
    DataPackageInterface dataPackage = null;

    public OpenPreviousVersionCommand(OpenDialogBox box, Morpho myMorpho) {
        this.dialog = box;
        this.morpho = myMorpho;
    }

    public void execute(ActionEvent event) {
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            this.dataPackage = (DataPackageInterface)((Object)provider);
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
            return;
        }
        if (this.dialog != null) {
            this.morphoFrame = this.dialog.getParentFrame();
            this.resultPane = this.dialog.getResultPanel();
        } else {
            this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
            this.resultPane = RefreshCommand.getResultPanelFromMorphoFrame(this.morphoFrame);
        }
        if (this.resultPane != null) {
            this.packageName = this.resultPane.getPackageName();
            this.version = this.resultPane.getPreviousVersions();
            this.metacatLoc = this.resultPane.getMetacatLocation();
            this.localLoc = this.resultPane.getLocalLocation();
        } else {
            String docId = this.dataPackage.getDocIdFromMorphoFrame(this.morphoFrame);
            this.localLoc = this.dataPackage.isDataPackageInLocal(this.morphoFrame);
            this.packageName = ResultPanel.getIdWithoutVersion(docId);
            this.version = ResultPanel.getNumberOfPrevVersions(docId);
        }
        if (this.packageName != null && !this.packageName.equals("") && this.version != -1) {
            if (this.dialog != null) {
                this.dialog.setVisible(false);
                this.dialog.dispose();
                this.dialog = null;
            }
            this.doOpenPreviousVersion(this.packageName, this.version, this.morpho, this.localLoc, this.morphoFrame);
        }
    }

    private void doOpenPreviousVersion(final String name, final int vers, final Morpho myMorpho, final boolean inLocal, final MorphoFrame frame) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                if (frame != null) {
                    frame.setBusy(true);
                }
                OpenPreviousVersionCommand.this.dataPackage.createOpenPreviousVersionDialog(name, vers, myMorpho, inLocal);
                return null;
            }

            public void finished() {
                if (frame != null) {
                    frame.setBusy(false);
                }
            }
        };
        worker.start();
    }
}

