/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.metadisplay;

import edu.ucsb.nceas.morpho.plugins.metadisplay.HTMLPanel;
import edu.ucsb.nceas.morpho.plugins.metadisplay.HeaderPanel;
import edu.ucsb.nceas.morpho.plugins.metadisplay.MetaDisplay;
import edu.ucsb.nceas.morpho.plugins.metadisplay.PathElementInterface;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class MetaDisplayUI
extends JPanel {
    private HTMLPanel htmlPanel;
    private final HeaderPanel header;
    private final MetaDisplay controller;
    private static final Border focusedBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, UISettings.FOCUSED_BORDER_COLOR);
    private static final Border unfocusedBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, UISettings.UNFOCUSED_BORDER_COLOR);

    public MetaDisplayUI(MetaDisplay controller) {
        this.controller = controller;
        this.header = new HeaderPanel(controller);
        try {
            this.htmlPanel = new HTMLPanel(controller);
        }
        catch (IOException ioe) {
            Log.debug(5, "Error trying to create MetaData display pane: " + ioe);
            ioe.printStackTrace();
        }
        this.initLayout();
        this.initFocusBorder();
    }

    private void initLayout() {
        JScrollPane htmlScroll = new JScrollPane(this.htmlPanel);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.header, "North");
        this.add((Component)htmlScroll, "Center");
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private void initFocusBorder() {
        this.setBorder(unfocusedBorder);
    }

    public void addToPath(PathElementInterface pathElement) {
    }

    public void setHTML(String html) {
        this.getHTMLPanel().setHTML(html);
    }

    protected HeaderPanel getHeader() {
        return this.header;
    }

    protected HTMLPanel getHTMLPanel() {
        return this.htmlPanel;
    }
}

