/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.ReferenceSelectionEvent;
import edu.ucsb.nceas.morpho.datapackage.ReferencesHandler;
import edu.ucsb.nceas.morpho.datapackage.ReferencesListener;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PartyPage
extends AbstractUIPage {
    private final String EMPTY_STRING = "";
    private String pageID = "PARTY_CREATOR";
    private final String nextPageID = "";
    private final String title = "Party Page";
    private final String subtitle = "";
    private final String pageNumber = "";
    private static final Dimension PARTY_2COL_LABEL_DIMS = new Dimension(70, 20);
    private static final Dimension PARTY_HALF_LABEL_DIMS = new Dimension(350, 20);
    private static final Dimension PARTY_FULL_LABEL_DIMS = new Dimension(700, 20);
    private String backupXPath;
    private String roleString = "";
    private final String[] ROLE_ARRAY = new String[]{"", "Originator", "Content Provider", "Principal Investigator", "Editor", "Publisher", "Processor", "Custodian/Steward", "Author", "Metadata Provider", "Distributor", "User"};
    private JLabel roleLabel;
    private JComboBox rolePickList;
    private JTextField salutationField;
    private JTextField firstNameField;
    private JLabel lastNameLabel;
    private JTextField lastNameField;
    private JLabel organizationLabel;
    private JTextField organizationField;
    private JLabel positionNameLabel;
    private JPanel warningPanel;
    private JLabel warningLabel;
    private JTextField positionNameField;
    private JTextField address1Field;
    private JTextField address2Field;
    private JTextField cityField;
    private JTextField stateField;
    private JTextField zipField;
    private JTextField countryField;
    private JTextField phoneField;
    private JTextField faxField;
    private JTextField emailField;
    private JTextField urlField;
    private JPanel rolePanel;
    private JPanel middlePanel;
    private JPanel checkBoxPanel;
    private JComboBox refsDropdown;
    public JLabel pageDescriptionLabel;
    public JPanel listPanel;
    private ReferencesHandler referencesHandler;
    private final String PARTY_GENERIC_NAME = "parties";
    private final String[] REFSHANDLER_SURROGATE_STRING = new String[]{"/individualName/givenName", " ", "/individualName/surName", " ", "/organizationName", " ", "/positionName"};
    private boolean backupExists = false;
    protected boolean editingOriginalRef = false;
    private String referenceIdString;
    private String referencesNodeIDString;
    private boolean editingAllowed = true;
    private boolean rolePicklistShouldBeHidden = false;
    private final String[] checkBoxArray = new String[]{"Do you want to edit the above information?"};
    private OrderedMap returnMap = new OrderedMap();
    OrderedMap previousValuesMap = new OrderedMap();

    public PartyPage(String role) {
        this.pageID = role;
        this.referencesHandler = new ReferencesHandler("parties", this.REFSHANDLER_SURROGATE_STRING);
        this.initRolePanel();
        this.setRole(role);
        this.init();
    }

    private void init() {
        this.pageDescriptionLabel = WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>&nbsp;&nbsp;" + this.roleString + " Details</b></font>", 1);
        this.middlePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.middlePanel, "Center");
        this.middlePanel.setLayout(new BoxLayout(this.middlePanel, 1));
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(this.pageDescriptionLabel);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        final PartyPage instance = this;
        ReferencesListener refsDropdownListener = new ReferencesListener(){

            public void referenceSelected(ReferenceSelectionEvent event) {
                String eventRefID = event.getReferenceID();
                if (eventRefID == null) {
                    PartyPage.this.referencesNodeIDString = null;
                    instance.setEditable(PartyPage.this.restoreFromPreviousValues());
                    PartyPage.this.checkBoxPanel.setVisible(false);
                    Log.debug(45, "ReferencesListener got NULL eventRefID");
                } else {
                    Log.debug(45, "ReferencesListener got eventRefID=" + eventRefID);
                    WidgetFactory.unhiliteComponent(PartyPage.this.lastNameLabel);
                    WidgetFactory.unhiliteComponent(PartyPage.this.organizationLabel);
                    WidgetFactory.unhiliteComponent(PartyPage.this.positionNameLabel);
                    PartyPage.this.warningPanel.setVisible(false);
                    WidgetFactory.unhiliteComponent(PartyPage.this.warningLabel);
                    String rxp = "/" + event.getSubtreeRootNodeName().trim() + "/";
                    short location = event.getLocation();
                    switch (location) {
                        case 10: {
                            Log.debug(45, "ReferencesListener - location=CURRENT_DATA_PACKAGE");
                            PartyPage.this.referencesNodeIDString = eventRefID;
                            PartyPage.this.editingAllowed = instance.setPageData(event.getXPathValsMap(), rxp);
                            instance.setEditable(false);
                            PartyPage.this.checkBoxPanel.setVisible(true);
                            Log.debug(45, " ...setting page data to: " + event.getXPathValsMap());
                            break;
                        }
                        case 20: {
                            Log.debug(45, "ReferencesListener - location=DIFFERENT_DATA_PACKAGE");
                            PartyPage.this.referencesNodeIDString = null;
                            PartyPage.this.editingAllowed = true;
                            instance.setEditable(true);
                            instance.setPageData(event.getXPathValsMap(), rxp);
                            PartyPage.this.checkBoxPanel.setVisible(false);
                            Log.debug(45, " ...setting page data to: " + event.getXPathValsMap());
                            break;
                        }
                        default: {
                            Log.debug(45, "ReferencesListener - location NOT RECOGNIZED!! - " + location);
                        }
                    }
                }
            }
        };
        this.listPanel = WidgetFactory.makePanel(1);
        JLabel listLabel = WidgetFactory.makeLabel("You can pick from one of the earlier entries that you have made.", false);
        this.setPrefMinMaxSizes(listLabel, PARTY_HALF_LABEL_DIMS);
        this.listPanel.add(listLabel);
        this.listPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        Container topLevelContainer = this;
        while (topLevelContainer.getParent() != null) {
            topLevelContainer = topLevelContainer.getParent();
        }
        if (!(topLevelContainer instanceof Frame)) {
            topLevelContainer = null;
        }
        this.refsDropdown = this.referencesHandler.getJComboBox(UIController.getInstance().getCurrentAbstractDataPackage(), refsDropdownListener, (Frame)topLevelContainer);
        this.listPanel.add(this.refsDropdown);
        this.middlePanel.add(this.listPanel);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.rolePanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(this.rolePanel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel salutationPanel = WidgetFactory.makePanel(1);
        salutationPanel.add(WidgetFactory.makeLabel("Salutation:", false));
        this.salutationField = WidgetFactory.makeOneLineTextField();
        salutationPanel.add(this.salutationField);
        salutationPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(salutationPanel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel firstNamePanel = WidgetFactory.makePanel(1);
        firstNamePanel.add(WidgetFactory.makeLabel("First Name:", false));
        this.firstNameField = WidgetFactory.makeOneLineTextField();
        firstNamePanel.add(this.firstNameField);
        firstNamePanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(firstNamePanel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel reqPanel = new JPanel();
        reqPanel.setLayout(new BoxLayout(reqPanel, 0));
        JPanel reqInfoPanel = new JPanel();
        reqInfoPanel.setLayout(new BoxLayout(reqInfoPanel, 1));
        JPanel reqWarningPanel = new JPanel();
        reqWarningPanel.setLayout(new BoxLayout(reqWarningPanel, 1));
        reqWarningPanel.add(WidgetFactory.makeHalfSpacer());
        JLabel warn1Label = new JLabel(" One of");
        warn1Label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        warn1Label.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        reqWarningPanel.add(warn1Label);
        JLabel warn2Label = new JLabel("    the");
        warn2Label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        warn2Label.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        reqWarningPanel.add(warn2Label);
        JLabel warn3Label = new JLabel("  three");
        warn3Label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        warn3Label.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        reqWarningPanel.add(warn3Label);
        JLabel warn4Label = new JLabel("required");
        warn4Label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        warn4Label.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        reqWarningPanel.add(warn4Label);
        reqWarningPanel.add(WidgetFactory.makeDefaultSpacer());
        reqPanel.add(reqWarningPanel);
        JLabel bracketLabel = new JLabel("{");
        bracketLabel.setFont(new Font("Sans-Serif", 0, 40));
        bracketLabel.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        bracketLabel.setBorder(new EmptyBorder(0, 0, 15, 0));
        reqPanel.add(bracketLabel);
        JPanel lastNamePanel = WidgetFactory.makePanel(1);
        this.lastNameLabel = WidgetFactory.makeLabel("Last Name:", true);
        lastNamePanel.add(this.lastNameLabel);
        this.lastNameField = WidgetFactory.makeOneLineTextField();
        lastNamePanel.add(this.lastNameField);
        lastNamePanel.setBorder(new EmptyBorder(0, 0, 0, 40));
        reqInfoPanel.add(lastNamePanel);
        reqInfoPanel.add(WidgetFactory.makeHalfSpacer());
        JPanel organizationPanel = WidgetFactory.makePanel(1);
        this.organizationLabel = WidgetFactory.makeLabel("Organization:", true);
        organizationPanel.add(this.organizationLabel);
        this.organizationField = WidgetFactory.makeOneLineTextField();
        organizationPanel.add(this.organizationField);
        organizationPanel.setBorder(new EmptyBorder(0, 0, 0, 40));
        reqInfoPanel.add(organizationPanel);
        reqInfoPanel.add(WidgetFactory.makeHalfSpacer());
        JPanel positionNamePanel = WidgetFactory.makePanel(1);
        this.positionNameLabel = WidgetFactory.makeLabel("Position Name:", true);
        positionNamePanel.add(this.positionNameLabel);
        this.positionNameField = WidgetFactory.makeOneLineTextField();
        positionNamePanel.add(this.positionNameField);
        positionNamePanel.setBorder(new EmptyBorder(0, 0, 0, 40));
        reqInfoPanel.add(positionNamePanel);
        reqInfoPanel.add(WidgetFactory.makeHalfSpacer());
        reqPanel.add((Component)reqInfoPanel, "Center");
        this.middlePanel.add(reqPanel);
        JPanel address1Panel = WidgetFactory.makePanel(1);
        address1Panel.add(WidgetFactory.makeLabel("Address 1:", false));
        this.address1Field = WidgetFactory.makeOneLineTextField();
        address1Panel.add(this.address1Field);
        address1Panel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(address1Panel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel address2Panel = WidgetFactory.makePanel(1);
        address2Panel.add(WidgetFactory.makeLabel("Address 2:", false));
        this.address2Field = WidgetFactory.makeOneLineTextField();
        address2Panel.add(this.address2Field);
        address2Panel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(address2Panel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel cityStatePanel = WidgetFactory.makePanel(1);
        cityStatePanel.add(WidgetFactory.makeLabel("City:", false));
        this.cityField = WidgetFactory.makeOneLineTextField();
        cityStatePanel.add(this.cityField);
        cityStatePanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel stateLabel = WidgetFactory.makeLabel("State:", false);
        this.setPrefMinMaxSizes(stateLabel, PARTY_2COL_LABEL_DIMS);
        cityStatePanel.add(stateLabel);
        this.stateField = WidgetFactory.makeOneLineTextField();
        cityStatePanel.add(this.stateField);
        cityStatePanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(cityStatePanel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel zipCountryPanel = WidgetFactory.makePanel(1);
        zipCountryPanel.add(WidgetFactory.makeLabel("Postal Code:", false));
        this.zipField = WidgetFactory.makeOneLineTextField();
        zipCountryPanel.add(this.zipField);
        zipCountryPanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel countryLabel = WidgetFactory.makeLabel("Country:", false);
        this.setPrefMinMaxSizes(countryLabel, PARTY_2COL_LABEL_DIMS);
        zipCountryPanel.add(countryLabel);
        this.countryField = WidgetFactory.makeOneLineTextField();
        zipCountryPanel.add(this.countryField);
        zipCountryPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(zipCountryPanel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel phoneFaxPanel = WidgetFactory.makePanel(1);
        phoneFaxPanel.add(WidgetFactory.makeLabel("Phone:", false));
        this.phoneField = WidgetFactory.makeOneLineTextField();
        phoneFaxPanel.add(this.phoneField);
        phoneFaxPanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel faxLabel = WidgetFactory.makeLabel("Fax:", false);
        this.setPrefMinMaxSizes(faxLabel, PARTY_2COL_LABEL_DIMS);
        phoneFaxPanel.add(faxLabel);
        this.faxField = WidgetFactory.makeOneLineTextField();
        phoneFaxPanel.add(this.faxField);
        phoneFaxPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(phoneFaxPanel);
        this.middlePanel.add(WidgetFactory.makeHalfSpacer());
        JPanel emailUrlPanel = WidgetFactory.makePanel(1);
        emailUrlPanel.add(WidgetFactory.makeLabel("Email:", false));
        this.emailField = WidgetFactory.makeOneLineTextField();
        emailUrlPanel.add(this.emailField);
        emailUrlPanel.add(WidgetFactory.makeDefaultSpacer());
        JLabel urlLabel = WidgetFactory.makeLabel("Online URL:", false);
        this.setPrefMinMaxSizes(urlLabel, PARTY_2COL_LABEL_DIMS);
        emailUrlPanel.add(urlLabel);
        this.urlField = WidgetFactory.makeOneLineTextField();
        emailUrlPanel.add(this.urlField);
        emailUrlPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(emailUrlPanel);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        this.warningPanel = WidgetFactory.makePanel(1);
        this.warningLabel = WidgetFactory.makeLabel("Warning: at least one of the three entries is required: Last Name, Position Name or Organization", true);
        this.warningPanel.add(this.warningLabel);
        this.warningPanel.setVisible(false);
        this.setPrefMinMaxSizes(this.warningLabel, PARTY_FULL_LABEL_DIMS);
        this.warningPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(this.warningPanel);
        this.middlePanel.add(WidgetFactory.makeDefaultSpacer());
        ItemListener editCheckBoxListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Log.debug(45, "got check box command: " + e.getStateChange());
                if (e.getStateChange() == 2) {
                    instance.setEditable(false);
                } else if (e.getStateChange() == 1) {
                    Object[] optionArray = new String[]{"Edit original", "Copy original and edit", "Cancel"};
                    JOptionPane optPane = new JOptionPane();
                    optPane.setOptions(optionArray);
                    optPane.setMessage("Do you want to :\nEdit the original entry (and therefore change all entries that refer to the original), or \nCreate a copy of the original and edit that?");
                    optPane.createDialog(instance, "Select an option...").show();
                    Object selectedValue = optPane.getValue();
                    if (selectedValue == optionArray[0]) {
                        instance.setEditable(true);
                        PartyPage.this.editingOriginalRef = true;
                    } else if (selectedValue == optionArray[1]) {
                        instance.setEditable(true);
                        PartyPage.this.referencesNodeIDString = null;
                        PartyPage.this.referenceIdString = null;
                        PartyPage.this.editingOriginalRef = false;
                    } else {
                        JCheckBox source = (JCheckBox)e.getSource();
                        source.setSelected(false);
                        instance.setEditable(false);
                        PartyPage.this.editingOriginalRef = false;
                    }
                }
                instance.validate();
                instance.repaint();
            }
        };
        this.checkBoxPanel = WidgetFactory.makeCheckBoxPanel(this.checkBoxArray, -1, editCheckBoxListener);
        this.checkBoxPanel.setBorder(new EmptyBorder(0, 60, 0, 40));
        this.middlePanel.add(this.checkBoxPanel);
        this.checkBoxPanel.setVisible(false);
    }

    private void initRolePanel() {
        this.rolePanel = WidgetFactory.makePanel(1);
        this.roleLabel = WidgetFactory.makeLabel("Role:", true);
    }

    private void setRole(String role) {
        this.rolePickList = null;
        this.rolePanel.removeAll();
        if (role.equals("PARTY_CREATOR")) {
            this.roleString = "Owner";
            this.backupXPath = "/creator";
            this.rolePicklistShouldBeHidden = true;
        } else if (role.equals("PARTY_CONTACT")) {
            this.roleString = "Contact";
            this.backupXPath = "/contact";
            this.rolePicklistShouldBeHidden = true;
        } else if (role.equals("PARTY_CITATION_AUTHOR")) {
            this.roleString = "Author";
            this.backupXPath = "/creator";
            this.rolePicklistShouldBeHidden = true;
        } else if (role.equals("PARTY_ASSOCIATED")) {
            this.roleString = "Associated Party";
            this.backupXPath = "/associatedParty";
        } else if (role.equals("PARTY_PERSONNEL")) {
            this.roleString = "Personnel";
            this.backupXPath = "/personnel";
        }
        this.referencesHandler.setDisplayName(this.roleString);
        if (this.rolePicklistShouldBeHidden) {
            return;
        }
        this.rolePanel.add(this.roleLabel);
        this.rolePickList = WidgetFactory.makePickList(this.ROLE_ARRAY, true, 0, new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
            }
        });
        this.rolePanel.add(this.rolePickList);
    }

    public void setEditable(boolean editable) {
        this.salutationField.setEditable(editable);
        this.firstNameField.setEditable(editable);
        this.lastNameField.setEditable(editable);
        this.organizationField.setEditable(editable);
        this.positionNameField.setEditable(editable);
        this.address1Field.setEditable(editable);
        this.address2Field.setEditable(editable);
        this.cityField.setEditable(editable);
        this.stateField.setEditable(editable);
        this.zipField.setEditable(editable);
        this.countryField.setEditable(editable);
        this.phoneField.setEditable(editable);
        this.faxField.setEditable(editable);
        this.emailField.setEditable(editable);
        this.urlField.setEditable(editable);
        this.checkBoxPanel.setVisible(!editable && this.editingAllowed);
    }

    private void setPrefMinMaxSizes(JComponent component, Dimension dims) {
        WidgetFactory.setPrefMaxSizes(component, dims);
        component.setMinimumSize(dims);
    }

    private String getCurrentPickListRole() {
        if (this.rolePickList == null) {
            return "";
        }
        String pickListRole = (String)this.rolePickList.getSelectedItem();
        return pickListRole != null ? pickListRole.trim() : "";
    }

    public boolean onAdvanceAction() {
        String positionName;
        String lastName;
        boolean lastNameOK = false;
        boolean organizationOK = false;
        boolean positionOK = false;
        if (this.rolePickList != null) {
            if (this.notNullAndNotEmpty(this.getCurrentPickListRole())) {
                WidgetFactory.unhiliteComponent(this.roleLabel);
            } else {
                WidgetFactory.hiliteComponent(this.roleLabel);
                this.rolePickList.requestFocus();
                return false;
            }
        }
        if (this.notNullAndNotEmpty(lastName = this.lastNameField.getText().trim())) {
            lastNameOK = true;
        }
        if ((this.notNullAndNotEmpty(this.salutationField.getText().trim()) || this.notNullAndNotEmpty(this.firstNameField.getText().trim())) && !lastNameOK) {
            WidgetFactory.hiliteComponent(this.lastNameLabel);
            this.lastNameLabel.requestFocus();
            this.warningLabel.setText("Warning: If you provide a salutation and/or first name, a last name must also be provided");
            this.warningPanel.setVisible(true);
            WidgetFactory.hiliteComponent(this.warningLabel);
            return false;
        }
        String organization = this.organizationField.getText().trim();
        if (this.notNullAndNotEmpty(organization)) {
            organizationOK = true;
        }
        if (this.notNullAndNotEmpty(positionName = this.positionNameField.getText().trim())) {
            positionOK = true;
        }
        if (!(lastNameOK || organizationOK || positionOK)) {
            WidgetFactory.hiliteComponent(this.lastNameLabel);
            WidgetFactory.hiliteComponent(this.organizationLabel);
            WidgetFactory.hiliteComponent(this.positionNameLabel);
            this.warningLabel.setText("Warning: at least one of the three entries is required: Last Name, Position Name or Organization");
            this.warningPanel.setVisible(true);
            WidgetFactory.hiliteComponent(this.warningLabel);
            return false;
        }
        WidgetFactory.unhiliteComponent(this.lastNameLabel);
        WidgetFactory.unhiliteComponent(this.organizationLabel);
        WidgetFactory.unhiliteComponent(this.positionNameLabel);
        this.warningPanel.setVisible(false);
        WidgetFactory.unhiliteComponent(this.warningLabel);
        String urlstring = this.urlField.getText();
        if (this.notNullAndNotEmpty(urlstring.trim()) && !this.isURL(urlstring)) {
            Log.debug(1, "The Online URL '" + urlstring + "' is not valid!");
            return false;
        }
        if (this.isReference()) {
            if (this.editingOriginalRef) {
                String backupReferencesNodeIDString = this.referencesNodeIDString;
                this.referencesNodeIDString = null;
                ArrayList<String> ignoreList = new ArrayList<String>();
                ignoreList.add("/thisXPathRootWillGetReplaced/role");
                ReferencesHandler.updateOriginalReferenceSubtree(UIController.getInstance().getCurrentAbstractDataPackage(), backupReferencesNodeIDString, this.getPageData("/thisXPathRootWillGetReplaced"), ignoreList);
                String backupRole = this.getCurrentPickListRole();
                this.clearAllFields();
                this.referencesNodeIDString = backupReferencesNodeIDString;
                this.addAndSetRole(backupRole);
                Log.debug(45, "PartyPage - editingOriginalRef... referencesNodeIDString=" + this.referencesNodeIDString);
            }
        } else {
            this.getRefID();
        }
        this.rememberPreviousValues();
        Log.debug(45, "\nfinished onAdvanceAction for page ID: " + this.getPageID());
        return true;
    }

    private boolean isReference() {
        return this.referencesNodeIDString != null;
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
        this.referencesHandler.updateJComboBox(UIController.getInstance().getCurrentAbstractDataPackage(), this.refsDropdown, this.getRefID());
        if (!this.backupExists) {
            this.rememberPreviousValues();
        } else {
            this.editingAllowed = this.restoreFromPreviousValues();
        }
        this.setEditable(!this.isReference());
        this.editingOriginalRef = false;
        Log.debug(45, "PartyPage.onLoadAction() - isReference() = " + this.isReference());
    }

    protected String getRefID() {
        if (this.notNullAndNotEmpty(this.referenceIdString)) {
            return this.referenceIdString;
        }
        AbstractDataPackage abs = UIController.getInstance().getCurrentAbstractDataPackage();
        if (abs == null) {
            Log.debug(45, "*** ERROR - PartyPage.getRefID() can't get AbsDataPkg");
            return "";
        }
        this.referenceIdString = abs.getNewUniqueReferenceID();
        return this.referenceIdString;
    }

    protected String getReferencesNodeIDString() {
        if (this.notNullAndNotEmpty(this.referencesNodeIDString)) {
            return this.referencesNodeIDString;
        }
        return "";
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Party Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    public List getSurrogate() {
        String country;
        String zip;
        String state;
        String city;
        String address2;
        String organization;
        String positionName;
        String lastName;
        String firstName;
        ArrayList<String> surrogate = new ArrayList<String>();
        StringBuffer partyBuff = new StringBuffer();
        String salutation = this.salutationField.getText().trim();
        if (this.notNullAndNotEmpty(salutation)) {
            partyBuff.append(salutation);
            partyBuff.append(" ");
        }
        if (this.notNullAndNotEmpty(firstName = this.firstNameField.getText().trim())) {
            partyBuff.append(firstName);
            partyBuff.append(" ");
        }
        if (this.notNullAndNotEmpty(lastName = this.lastNameField.getText().trim())) {
            partyBuff.append(lastName);
        }
        if (this.notNullAndNotEmpty(positionName = this.positionNameField.getText().trim())) {
            this.appendCommaIfNeeded(partyBuff);
            partyBuff.append(positionName);
        }
        if (this.notNullAndNotEmpty(organization = this.organizationField.getText().trim())) {
            this.appendCommaIfNeeded(partyBuff);
            partyBuff.append(organization);
        }
        surrogate.add(partyBuff.toString());
        if (this.rolePickList != null) {
            StringBuffer roleBuff = new StringBuffer(this.roleString);
            if (this.notNullAndNotEmpty(this.getCurrentPickListRole())) {
                roleBuff.append(" (");
                roleBuff.append(this.getCurrentPickListRole());
                roleBuff.append(")");
            }
            surrogate.add(roleBuff.toString());
        } else {
            surrogate.add(this.roleString);
        }
        StringBuffer addressBuff = new StringBuffer();
        String address1 = this.address1Field.getText().trim();
        if (this.notNullAndNotEmpty(address1)) {
            addressBuff.append(address1);
        }
        if (this.notNullAndNotEmpty(address2 = this.address2Field.getText().trim())) {
            this.appendCommaIfNeeded(addressBuff);
            addressBuff.append(address2);
        }
        if (this.notNullAndNotEmpty(city = this.cityField.getText().trim())) {
            this.appendCommaIfNeeded(addressBuff);
            addressBuff.append(city);
        }
        if (this.notNullAndNotEmpty(state = this.stateField.getText().trim())) {
            this.appendCommaIfNeeded(addressBuff);
            addressBuff.append(state);
        }
        if (this.notNullAndNotEmpty(zip = this.zipField.getText().trim())) {
            this.appendCommaIfNeeded(addressBuff);
            addressBuff.append(zip);
        }
        if (this.notNullAndNotEmpty(country = this.countryField.getText().trim())) {
            this.appendCommaIfNeeded(addressBuff);
            addressBuff.append(country);
        }
        surrogate.add(addressBuff.toString());
        return surrogate;
    }

    private void appendCommaIfNeeded(StringBuffer buff) {
        int lastIndex = buff.length() - 1;
        if (lastIndex > -1 && (buff.charAt(lastIndex) != ' ' || buff.charAt(lastIndex - 1) != ',')) {
            buff.append(", ");
        }
    }

    private boolean notNullAndNotEmpty(String arg) {
        return arg != null && !arg.equals("");
    }

    public OrderedMap getPageData() {
        throw new UnsupportedOperationException("PartyPage -> getPageData() method not implemented!");
    }

    public OrderedMap getPageData(String rootXPath) {
        this.returnMap.clear();
        String nextText = null;
        if (this.isReference()) {
            this.returnMap.put((Object)(rootXPath + "/references[1]"), (Object)this.referencesNodeIDString);
            if (this.editingOriginalRef && this.rolePickList != null && this.getCurrentPickListRole().length() > 0) {
                this.returnMap.put((Object)(rootXPath + "/role[1]"), (Object)this.getCurrentPickListRole());
            }
            Log.debug(45, "getPageData(" + rootXPath + ") Setting /references to " + this.referencesNodeIDString);
        } else {
            this.returnMap.put((Object)(rootXPath + "/@id"), (Object)this.getRefID());
            Log.debug(45, "getPageData(" + rootXPath + ") setting refID /@id as " + this.referenceIdString);
            nextText = this.salutationField.getText().trim();
            if (this.notNullAndNotEmpty(nextText)) {
                this.returnMap.put((Object)(rootXPath + "/individualName/salutation[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.firstNameField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/individualName/givenName[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.lastNameField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/individualName/surName[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.organizationField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/organizationName[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.positionNameField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/positionName[1]"), (Object)nextText);
            }
            int dpPredct = 1;
            nextText = this.address1Field.getText().trim();
            if (this.notNullAndNotEmpty(nextText)) {
                this.returnMap.put((Object)(rootXPath + "/address/deliveryPoint[" + dpPredct + "]"), (Object)nextText);
                ++dpPredct;
            }
            if (this.notNullAndNotEmpty(nextText = this.address2Field.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/address/deliveryPoint[" + dpPredct + "]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.cityField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/address/city[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.stateField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/address/administrativeArea[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.zipField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/address/postalCode[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.countryField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/address/country[1]"), (Object)nextText);
            }
            int phnPredct = 1;
            nextText = this.phoneField.getText().trim();
            if (this.notNullAndNotEmpty(nextText)) {
                this.returnMap.put((Object)(rootXPath + "/phone[" + phnPredct + "]"), (Object)nextText);
                this.returnMap.put((Object)(rootXPath + "/phone[" + phnPredct + "]/@phonetype"), (Object)"voice");
                ++phnPredct;
            }
            if (this.notNullAndNotEmpty(nextText = this.faxField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/phone[" + phnPredct + "]"), (Object)nextText);
                this.returnMap.put((Object)(rootXPath + "/phone[" + phnPredct + "]/@phonetype"), (Object)"fax");
            }
            if (this.notNullAndNotEmpty(nextText = this.emailField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/electronicMailAddress[1]"), (Object)nextText);
            }
            if (this.notNullAndNotEmpty(nextText = this.urlField.getText().trim())) {
                this.returnMap.put((Object)(rootXPath + "/onlineUrl[1]"), (Object)nextText);
            }
        }
        if (!this.editingOriginalRef && this.rolePickList != null && this.getCurrentPickListRole().length() > 0) {
            this.returnMap.put((Object)(rootXPath + "/role[1]"), (Object)this.getCurrentPickListRole());
        }
        return this.returnMap;
    }

    public boolean setPageData(OrderedMap map, String rootXPath) {
        boolean canHandleAllData;
        Log.debug(45, "PartyPage.setPageData() called with rootXPath = " + rootXPath + "\n Map = \n" + map);
        if (rootXPath != null && rootXPath.trim().length() > 0) {
            while (rootXPath.endsWith("/")) {
                rootXPath = rootXPath.substring(0, rootXPath.length() - 1);
            }
        }
        this.clearAllFields();
        if (map == null) {
            return true;
        }
        String xpathRootNoPredicates = XMLUtilities.removeAllPredicates((String)rootXPath);
        Log.debug(45, "PartyPage.setPageData() xpathRootNoPredicates = " + xpathRootNoPredicates);
        map = this.keepOnlyLastPredicateInKeys(map);
        String scope = (String)map.get((Object)(xpathRootNoPredicates + "/@scope"));
        if (scope != null) {
            map.remove((Object)(xpathRootNoPredicates + "/@scope"));
        }
        this.getRoleFromMapAndRemove(map, xpathRootNoPredicates);
        String ref = (String)map.get((Object)(xpathRootNoPredicates + "/references[1]"));
        if (ref == null) {
            ref = (String)map.get((Object)(xpathRootNoPredicates + "/references"));
        }
        Log.debug(45, "/references ref = (" + ref + ")");
        if (this.notNullAndNotEmpty(ref)) {
            map = this.getMapForRefID(ref);
            if (map != null) {
                this.referencesNodeIDString = ref;
                Iterator it = map.keySet().iterator();
                if (it.hasNext()) {
                    rootXPath = (String)it.next();
                    while (rootXPath.startsWith("/")) {
                        rootXPath = rootXPath.substring(1);
                    }
                    int firstSlashIdx = rootXPath.indexOf("/");
                    if (firstSlashIdx > -1) {
                        rootXPath = rootXPath.substring(0, firstSlashIdx);
                    }
                    rootXPath = "/" + rootXPath;
                    xpathRootNoPredicates = XMLUtilities.removeAllPredicates((String)rootXPath);
                    Log.debug(45, "PartyPage.setPageData() got a referenced party; new rootXPath = " + xpathRootNoPredicates);
                }
                map = this.keepOnlyLastPredicateInKeys(map);
                this.getRoleFromMapAndRemove(map, xpathRootNoPredicates);
            } else {
                Log.debug(15, "** ERROR: PartyPage.setPageData() - got a null map back  from AbsDataPkg when asking for reference: " + ref);
                return false;
            }
        }
        Log.debug(45, "PartyPage.setPageData() - map with only last predicates: \n" + map);
        String id = (String)map.get((Object)(xpathRootNoPredicates + "/@id"));
        if (id != null) {
            this.referenceIdString = (String)map.get((Object)(xpathRootNoPredicates + "/@id"));
            map.remove((Object)(xpathRootNoPredicates + "/@id"));
        } else {
            this.referenceIdString = this.getRefID();
        }
        String nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/individualName/salutation[1]"));
        if (nextVal != null) {
            this.salutationField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/individualName/salutation[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/individualName/givenName[1]"))) != null) {
            this.firstNameField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/individualName/givenName[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/individualName/surName[1]"))) != null) {
            this.lastNameField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/individualName/surName[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/organizationName[1]"))) != null) {
            this.organizationField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/organizationName[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/positionName[1]"))) != null) {
            this.positionNameField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/positionName[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/address/deliveryPoint[1]"))) != null) {
            this.address1Field.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/address/deliveryPoint[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/address/deliveryPoint[2]"))) != null) {
            this.address2Field.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/address/deliveryPoint[2]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/address/city[1]"))) != null) {
            this.cityField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/address/city[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/address/administrativeArea[1]"))) != null) {
            this.stateField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/address/administrativeArea[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/address/postalCode[1]"))) != null) {
            this.zipField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/address/postalCode[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/address/country[1]"))) != null) {
            this.countryField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/address/country[1]"));
        }
        nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/phone[1]"));
        String type = (String)map.get((Object)(xpathRootNoPredicates + "/phone[1]/@phonetype"));
        if (nextVal != null) {
            if (type != null) {
                if (type.equals("voice")) {
                    this.phoneField.setText(nextVal);
                }
                if (type.equals("fax")) {
                    this.faxField.setText(nextVal);
                }
                map.remove((Object)(xpathRootNoPredicates + "/phone[1]/@phonetype"));
            }
            map.remove((Object)(xpathRootNoPredicates + "/phone[1]"));
        }
        nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/phone[2]"));
        type = (String)map.get((Object)(xpathRootNoPredicates + "/phone[2]/@phonetype"));
        if (nextVal != null) {
            if (type != null) {
                if (type.equals("voice")) {
                    this.phoneField.setText(nextVal);
                }
                if (type.equals("fax")) {
                    this.faxField.setText(nextVal);
                }
                map.remove((Object)(xpathRootNoPredicates + "/phone[2]/@phonetype"));
            }
            map.remove((Object)(xpathRootNoPredicates + "/phone[2]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/electronicMailAddress[1]"))) != null) {
            this.emailField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/electronicMailAddress[1]"));
        }
        if ((nextVal = (String)map.get((Object)(xpathRootNoPredicates + "/onlineUrl[1]"))) != null) {
            this.urlField.setText(nextVal);
            map.remove((Object)(xpathRootNoPredicates + "/onlineUrl[1]"));
        }
        if (!(canHandleAllData = map.isEmpty())) {
            Log.debug(20, "PartyPage.setPageData returning FALSE! Map still contains:" + map);
        }
        if (this.isReference()) {
            this.editingAllowed = canHandleAllData;
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        return canHandleAllData;
    }

    private void getRoleFromMapAndRemove(OrderedMap map, String xpathRootNoPredicates) {
        String role;
        if (this.rolePickList != null && (role = (String)map.get((Object)(xpathRootNoPredicates + "/role[1]"))) != null && this.addAndSetRole(role)) {
            map.remove((Object)(xpathRootNoPredicates + "/role[1]"));
        }
    }

    private OrderedMap keepOnlyLastPredicateInKeys(OrderedMap map) {
        OrderedMap newMap = new OrderedMap();
        for (String key : map.keySet()) {
            String val = (String)map.get((Object)key);
            String firstPart = null;
            String lastPart = null;
            int lastOpenBracketIndex = key.lastIndexOf("[");
            if (lastOpenBracketIndex > -1 && lastOpenBracketIndex < key.length() && key.indexOf("@id") < 0 && key.indexOf("@scope") < 0) {
                firstPart = XMLUtilities.removeAllPredicates((String)key.substring(0, lastOpenBracketIndex));
                lastPart = key.substring(lastOpenBracketIndex);
                newMap.put((Object)(firstPart + lastPart), (Object)val);
                continue;
            }
            newMap.put((Object)XMLUtilities.removeAllPredicates((String)key), (Object)val);
        }
        return newMap;
    }

    private OrderedMap getMapForRefID(String ref) {
        if (!this.notNullAndNotEmpty(ref)) {
            return null;
        }
        OrderedMap mapForRefID = null;
        AbstractDataPackage abs = UIController.getInstance().getCurrentAbstractDataPackage();
        if (abs == null) {
            Log.debug(45, "*** ERROR - PartyPage.getMapForRefID() can't get AbstractDataPkg");
            return null;
        }
        Log.debug(45, "*** doing abs.getSubtreeAtReference(" + ref + ")");
        Node referencedPartyNode = abs.getSubtreeAtReference(ref);
        if (referencedPartyNode != null) {
            Node[] children = XMLUtilities.getNodeListAsNodeArray((NodeList)referencedPartyNode.getChildNodes());
            for (int idx = 0; idx < children.length; ++idx) {
                if (!children[idx].getNodeName().equals("role")) continue;
                children[idx].getParentNode().removeChild(children[idx]);
            }
        } else {
            Log.debug(45, "*** ERROR - PartyPage.getMapForRefID() can't get referenced party");
            return null;
        }
        mapForRefID = XMLUtilities.getDOMTreeAsXPathMap((Node)referencedPartyNode);
        Log.debug(45, "PartyPage.getMapForRefID() returning referenced map " + mapForRefID);
        return mapForRefID;
    }

    private void rememberPreviousValues() {
        this.previousValuesMap.clear();
        this.previousValuesMap = this.getPageData(this.backupXPath);
        this.backupExists = true;
        Log.debug(45, "\n\nPartyPage.rememberPreviousValues() remembering: \n \nMap = " + this.previousValuesMap);
    }

    private boolean restoreFromPreviousValues() {
        Log.debug(45, "\n\nPartyPage.restoreFromPreviousValues() restoring: \n \nMap = " + this.previousValuesMap);
        if (this.previousValuesMap.isEmpty()) {
            return true;
        }
        boolean canHandleAllData = this.setPageData(this.previousValuesMap, this.backupXPath);
        return canHandleAllData;
    }

    private boolean addAndSetRole(String role) {
        if (this.rolePickList == null) {
            return false;
        }
        if (this.rolePicklistShouldBeHidden) {
            return true;
        }
        this.rolePickList.setSelectedItem(role);
        if (this.rolePickList.getSelectedItem() != role) {
            this.rolePickList.addItem(role);
        }
        this.rolePickList.setSelectedItem(role);
        return true;
    }

    private void clearAllFields() {
        if (this.rolePickList != null) {
            this.rolePickList.setSelectedItem("");
        }
        this.salutationField.setText("");
        this.firstNameField.setText("");
        this.lastNameField.setText("");
        this.organizationField.setText("");
        this.positionNameField.setText("");
        this.address1Field.setText("");
        this.address2Field.setText("");
        this.cityField.setText("");
        this.stateField.setText("");
        this.zipField.setText("");
        this.countryField.setText("");
        this.phoneField.setText("");
        this.faxField.setText("");
        this.emailField.setText("");
        this.urlField.setText("");
    }

    private boolean isURL(String urltext) {
        boolean ret = true;
        try {
            URL url = new URL(urltext);
            if (url == null) {
                ret = false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return ret;
    }
}

