/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.Access;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AccessProgressThread;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AccessTreeModel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AccessTreeNodeObject;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.JTreeTable;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.QueryMetacatThread;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.HyperlinkButton;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AccessPage
extends AbstractUIPage {
    private final String pageID = "ACCESS_PAGE";
    private final String nextPageID = "";
    private final String pageNumber = "";
    private final String title = "Access Page";
    private final String subtitle = "";
    private final String EMPTY_STRING = "";
    protected JTree accessTree;
    private JPanel bottomPanel;
    private JPanel topPanel;
    private JPanel middlePanel;
    protected JTextField dnField;
    private JButton refreshButton;
    private JLabel warnLabel;
    private JLabel introLabel;
    private JLabel accessDesc1;
    private JLabel accessDesc2;
    private String userAccessType = new String("  Allow");
    protected String userAccess = new String("Read");
    protected JComboBox typeComboBox;
    protected JComboBox accessComboBox;
    private JScrollPane accessTreePane;
    protected AccessProgressThread pbt = null;
    private String accessListFilePath = "./lib/accesslist.xml";
    public JTreeTable treeTable = null;
    private QueryMetacatThread queryMetacat = null;
    private boolean queryMetacatCancelled;
    private String userDN = null;
    private String userName = null;
    private String userEmail = null;
    private String userOrg = null;
    private boolean alreadyGeneratedfromDocumentationMenu = false;
    private ConfigXML config;
    private Vector orgList;
    private final String[] accessTypeText = new String[]{"  Allow", "  Deny"};
    private final String[] accessText = new String[]{"  Read", "  Read & Write", "  Read, Write & Change Permissions", "  All"};
    public boolean accessIsAllow = true;
    private String xPathRoot = "/eml:eml/dataset/access";
    private OrderedMap returnMap = new OrderedMap();

    public void setQueryMetacatCancelled(boolean queryMetacatCancelled) {
        this.queryMetacatCancelled = queryMetacatCancelled;
    }

    public AccessPage() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.topPanel = new JPanel();
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.add(WidgetFactory.makeHalfSpacer());
        this.topPanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        JLabel desc = WidgetFactory.makeHTMLLabel("<font size=\"4\"><b>Define Access:</b></font>", 1);
        this.topPanel.add(desc);
        this.topPanel.add(WidgetFactory.makeHalfSpacer());
        this.introLabel = WidgetFactory.makeHTMLLabel("<b>Select a user or group from the list below:</b>", 1);
        this.topPanel.add(this.introLabel);
        this.add((Component)this.topPanel, "North");
        this.middlePanel = new JPanel();
        this.middlePanel.setLayout(new BorderLayout());
        this.middlePanel.setBorder(new EmptyBorder(25, 30, 20, 25));
        this.add((Component)this.middlePanel, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 1));
        this.bottomPanel.add(WidgetFactory.makeHalfSpacer());
        JPanel accessDefinitionPanel = new JPanel();
        accessDefinitionPanel.setLayout(new BorderLayout());
        JLabel accessDefinitionLabel = WidgetFactory.makeHTMLLabel("<b>&nbsp;Description of access levels:</b><ul><li>Read: Able to view data package.</li><li>Read & Write: Able to view and modify data package.</li><li>Read, Write & Change Permissions: Able to view and modify datapackage, and modify access permissions.</li><li>All: Able to do everything (this is the same as Read, Write & Change Permissions)</li></ul>", 5);
        this.warnLabel = WidgetFactory.makeLabel("", true);
        accessDefinitionPanel.add((Component)accessDefinitionLabel, "Center");
        accessDefinitionPanel.add((Component)this.warnLabel, "South");
        this.bottomPanel.add(accessDefinitionPanel);
        this.bottomPanel.setBorder(new EmptyBorder(0, 20, 15, 40));
        this.add((Component)this.bottomPanel, "South");
        if (Access.accessTreeNode != null && Access.accessTreeMetacatServerName.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) == 0) {
            this.displayTree(Access.accessTreeNode);
        }
        this.config = Morpho.getConfiguration();
        this.orgList = this.config.get("organization");
    }

    protected void generateAccessTree() {
        Document doc = null;
        doc = this.getDocumentFromFile();
        if (doc == null) {
            this.pbt = new AccessProgressThread(this);
            this.pbt.start();
            this.pbt.setCustomCancelAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    Log.debug(45, "\nAccessPage: CustomCancelAction called");
                    AccessPage.this.cancelGetDocumentFromMetacat();
                }
            });
            this.getDocumentFromMetacat();
        } else {
            DefaultMutableTreeNode treeNode = this.getTreeFromDocument(doc);
            this.displayTree(treeNode);
        }
    }

    protected Document getDocumentFromFile() {
        ConfigXML accessXML = null;
        try {
            accessXML = new ConfigXML(this.accessListFilePath);
            Document doc = accessXML.getDocument();
            NodeList nl = doc.getElementsByTagName("server");
            if (nl.getLength() < 1) {
                Log.debug(45, "No server nodes found in accesslist.xml");
                return null;
            }
            Node cn = null;
            Node serverNode = null;
            for (int i = 0; i < nl.getLength(); ++i) {
                cn = nl.item(i).getFirstChild();
                if (cn == null || cn.getNodeType() != 3 || cn.getNodeValue().compareTo(Morpho.thisStaticInstance.getMetacatURLString()) != 0) continue;
                serverNode = cn;
            }
            if (serverNode == null) {
                Log.debug(45, "No server nodes found with current metacat server name found in accesslist.xml");
                return null;
            }
            serverNode = serverNode.getParentNode().getParentNode();
            Node deepClone = serverNode.cloneNode(true);
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document tempDoc = impl.createDocument("", "principals", null);
            Node importedClone = tempDoc.importNode(deepClone, true);
            Element tempRoot = tempDoc.getDocumentElement();
            tempRoot.appendChild(importedClone);
            return tempDoc;
        }
        catch (FileNotFoundException e) {
            Log.debug(10, "accesslist.xml not found in /lib/ directory.");
            Log.debug(45, "Exception in AccessPage class in getDocumentfromFile(). Exception:" + e.getClass());
            Log.debug(45, e.getMessage());
            try {
                String xmlSource = "<?xml version=\"1.0\"?>\n<accesslist></accesslist>\n";
                byte[] buf = xmlSource.getBytes();
                FileOutputStream f1 = new FileOutputStream(this.accessListFilePath);
                ((OutputStream)f1).write(buf);
                ((OutputStream)f1).close();
            }
            catch (Exception e1) {
                Log.debug(10, "Unable to create accesslist.xml in /lib/");
                Log.debug(45, "Exception in AccessPage class in getDocumentfromFile(). Exception:" + e1.getClass());
                Log.debug(45, e1.getMessage());
            }
            return null;
        }
        catch (Exception e) {
            Log.debug(45, "Exception in AccessPage class in getDocumentfromFile(). Exception:" + e.getClass());
            Log.debug(45, e.getMessage());
            return null;
        }
    }

    protected void getDocumentFromMetacat() {
        if (this.pbt != null) {
            this.pbt.setProgressBarString("Contacting Metacat Server for Access information....");
        }
        this.queryMetacatCancelled = false;
        this.queryMetacat = new QueryMetacatThread(this);
        this.queryMetacat.start();
    }

    private void insertDocInAccessList(Document doc) {
        ConfigXML accessXML = null;
        boolean fileExists = false;
        try {
            accessXML = new ConfigXML("./lib/accesslist.xml");
            fileExists = true;
        }
        catch (FileNotFoundException e) {
            Log.debug(10, "accesslist.xml not found in /lib/ directory.");
            Log.debug(45, "Exception in AccessPage class in getDocumentfromFile(). Exception:" + e.getClass());
            Log.debug(45, e.getMessage());
        }
        try {
            Document doc1;
            NodeList nl;
            if (!fileExists) {
                try {
                    String xmlSource = "<?xml version=\"1.0\"?>\n<accesslist></accesslist>\n";
                    byte[] buf = xmlSource.getBytes();
                    FileOutputStream f1 = new FileOutputStream(this.accessListFilePath);
                    ((OutputStream)f1).write(buf);
                    ((OutputStream)f1).close();
                }
                catch (Exception e1) {
                    Log.debug(10, "Unable to create accesslist.xml in /lib/");
                    Log.debug(45, "Exception in AccessPage class in getDocumentfromFile(). Exception:" + e1.getClass());
                    Log.debug(45, e1.getMessage());
                }
                accessXML = new ConfigXML("./lib/accesslist.xml");
            }
            if ((nl = (doc1 = accessXML.getDocument()).getElementsByTagName("server")).getLength() < 1) {
                Log.debug(45, "No server nodes found in accesslist.xml. Inserting new entry for current document in the document");
                this.insertNewEntryInAccessList(accessXML, doc);
                return;
            }
            Node cn = null;
            Node serverNode = null;
            for (int i = 0; i < nl.getLength(); ++i) {
                cn = nl.item(i).getFirstChild();
                if (cn == null || cn.getNodeType() != 3 || cn.getNodeValue().compareTo(Morpho.thisStaticInstance.getMetacatURLString()) != 0) continue;
                serverNode = cn;
            }
            if (serverNode == null) {
                this.insertNewEntryInAccessList(accessXML, doc);
            } else {
                this.modifyOldEntryInAccessList(accessXML, doc);
            }
        }
        catch (Exception e) {
            Log.debug(10, "Exception in AccessPage class in insertDocInAccessList(). Exception:" + e.getClass());
            Log.debug(10, e.getMessage());
        }
    }

    private void insertNewEntryInAccessList(ConfigXML accessXML, Document doc) {
        Log.debug(10, "Inserting a new entry in accesslist.xml");
        Document doc1 = accessXML.getDocument();
        Node node = doc1.getFirstChild();
        Element result = doc1.createElement("result");
        Element server = doc1.createElement("server");
        Text serverName = doc1.createTextNode(Morpho.thisStaticInstance.getMetacatURLString());
        Element principalNode = doc.getDocumentElement();
        if (principalNode.getNodeName().compareTo("principals") != 0) {
            return;
        }
        Node deepClone = principalNode.cloneNode(true);
        Node principals = doc1.importNode(deepClone, true);
        server.appendChild(serverName);
        result.appendChild(server);
        result.appendChild(principals);
        node.appendChild(result);
        accessXML.save();
    }

    private void modifyOldEntryInAccessList(ConfigXML accessXML, Document doc) {
        Log.debug(10, "Modifying an old entry in accesslist.xml");
        Document doc1 = accessXML.getDocument();
        Node node = doc1.getFirstChild();
        Element result = doc1.createElement("result");
        Element server = doc1.createElement("server");
        Text serverName = doc1.createTextNode(Morpho.thisStaticInstance.getMetacatURLString());
        Element principalNode = doc.getDocumentElement();
        if (principalNode.getNodeName().compareTo("principals") != 0) {
            return;
        }
        NodeList nl = doc1.getElementsByTagName("server");
        for (int count = 0; count < nl.getLength(); ++count) {
            Node tempNode = nl.item(count);
            String value = tempNode.getFirstChild().getNodeValue();
            if (value == null || value.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) != 0) continue;
            Node listNode = tempNode.getParentNode();
            listNode.getParentNode().removeChild(listNode);
        }
        Node deepClone = principalNode.cloneNode(true);
        Node principals = doc1.importNode(deepClone, true);
        server.appendChild(serverName);
        result.appendChild(server);
        result.appendChild(principals);
        node.appendChild(result);
        accessXML.save();
    }

    protected void parseInputStream(InputStream queryResult) {
        this.pbt.setProgressBarString("Creating Access tree from information received....");
        try {
            DocumentBuilder parser = Morpho.createDomParser();
            Document doc = parser.parse(queryResult);
            DefaultMutableTreeNode treeNode = this.getTreeFromDocument(doc);
            this.insertDocInAccessList(doc);
            this.displayTree(treeNode);
        }
        catch (Exception e) {
            Log.debug(10, "Unable to parse the reply from Metacat server.");
            Log.debug(10, "Exception in AccessPage class in parseInputStream().Exception: " + e.getClass());
            Log.debug(10, e.getMessage());
            if (Access.accessTreeNode != null && Access.accessTreeMetacatServerName.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) == 0) {
                Log.debug(10, "Retrieving access information from Metacat server failed. Displaying the old access information.");
                this.displayTree(Access.accessTreeNode);
            }
            this.displayDNPanel();
        }
        this.pbt.exitProgressBarThread();
    }

    protected void displayDNPanel() {
        JPanel panel = null;
        panel = WidgetFactory.makePanel(1);
        JLabel dnLabel = WidgetFactory.makeLabel("Distinguished Name", false);
        panel.add(dnLabel);
        this.dnField = WidgetFactory.makeOneLineTextField();
        this.dnField.setBackground(Color.white);
        if (this.userDN != null) {
            this.dnField.setText(this.userDN);
        }
        panel.add(this.dnField);
        panel.setBorder(new EmptyBorder(0, 5, 0, 20));
        this.middlePanel.add((Component)panel, "Center");
        this.middlePanel.add((Component)this.getAccessControlPanel(true, "Retrieve the user list ..."), "South");
        this.introLabel.setText("Specify a Distinguished Name in text field below:");
        this.middlePanel.revalidate();
        this.middlePanel.repaint();
        this.typeComboBox.setEnabled(true);
        this.accessComboBox.setEnabled(true);
    }

    private JPanel getAccessControlPanel(boolean withRefreshLink, String refreshString) {
        this.accessDesc1 = WidgetFactory.makeLabel(" selected user(s)", false);
        this.accessDesc2 = WidgetFactory.makeLabel("   access", false);
        ItemListener accessTypeListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Log.debug(45, "got itemStateChanged command in access type list");
                if (e.getItem().toString().compareTo(AccessPage.this.accessTypeText[0]) == 0) {
                    AccessPage.this.userAccessType = "  Allow";
                    AccessPage.this.accessIsAllow = true;
                } else if (e.getItem().toString().compareTo(AccessPage.this.accessTypeText[1]) == 0) {
                    AccessPage.this.userAccessType = "  Deny ";
                    AccessPage.this.accessIsAllow = false;
                }
            }
        };
        this.typeComboBox = WidgetFactory.makePickList(this.accessTypeText, false, 0, accessTypeListener);
        this.typeComboBox.setEnabled(false);
        if (this.userAccessType.compareTo("  Deny ") == 0) {
            this.typeComboBox.setSelectedIndex(1);
        }
        ItemListener accessListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Log.debug(45, "got itemStateChanged command in access list");
                if (e.getItem().toString().compareTo(AccessPage.this.accessText[0]) == 0) {
                    AccessPage.this.userAccess = "Read";
                } else if (e.getItem().toString().compareTo(AccessPage.this.accessText[1]) == 0) {
                    AccessPage.this.userAccess = "Read & Write";
                } else if (e.getItem().toString().compareTo(AccessPage.this.accessText[2]) == 0) {
                    AccessPage.this.userAccess = "Read, Write & Change Permissions";
                } else if (e.getItem().toString().compareTo(AccessPage.this.accessText[3]) == 0) {
                    AccessPage.this.userAccess = "All";
                }
            }
        };
        this.accessComboBox = WidgetFactory.makePickList(this.accessText, false, 0, accessListener);
        this.accessComboBox.setEnabled(false);
        if (this.userAccess.compareTo("Read & Write") == 0) {
            this.accessComboBox.setSelectedIndex(1);
        } else if (this.userAccess.compareTo("Read, Write & Change Permissions") == 0) {
            this.accessComboBox.setSelectedIndex(2);
        } else if (this.userAccess.compareTo("All") == 0) {
            this.accessComboBox.setSelectedIndex(3);
        }
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        controlPanel.setBorder(new EmptyBorder(25, 0, 0, 0));
        controlPanel.add(this.typeComboBox);
        controlPanel.add(this.accessDesc1);
        controlPanel.add(this.accessComboBox);
        controlPanel.add(this.accessDesc2);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(WidgetFactory.makeHalfSpacer(), "North");
        if (withRefreshLink) {
            final AccessPage accessP = this;
            GUIAction refreshListAction = new GUIAction(refreshString, null, new Command(){

                public void execute(ActionEvent ae) {
                    Log.debug(45, "got action performed command from Referesh button");
                    AccessPage.this.refreshButton.setEnabled(false);
                    AccessPage.this.typeComboBox.setEnabled(false);
                    AccessPage.this.accessComboBox.setEnabled(false);
                    AccessPage.this.middlePanel.removeAll();
                    AccessPage.this.middlePanel.revalidate();
                    AccessPage.this.middlePanel.repaint();
                    AccessPage.this.pbt = new AccessProgressThread(accessP);
                    AccessPage.this.pbt.start();
                    AccessPage.this.pbt.setCustomCancelAction(new AbstractAction(){

                        public void actionPerformed(ActionEvent e) {
                            Log.debug(45, "\nAccess: CustomAddAction called");
                            AccessPage.this.cancelGetDocumentFromMetacat();
                        }
                    });
                    AccessPage.this.getDocumentFromMetacat();
                }
            });
            this.refreshButton = new HyperlinkButton(refreshListAction);
            panel.add((Component)this.refreshButton, "East");
        }
        panel.add((Component)controlPanel, "South");
        return panel;
    }

    protected void cancelGetDocumentFromMetacat() {
        if (Access.accessTreeNode != null && Access.accessTreeMetacatServerName.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) == 0) {
            Log.debug(10, "Retrieving access information from Metacat server cancelled. Using the old access tree.");
            this.displayTree(Access.accessTreeNode);
        } else {
            this.displayDNPanel();
        }
        this.setQueryMetacatCancelled(true);
    }

    protected void displayTree(DefaultMutableTreeNode treeNode) {
        this.accessTreePane = null;
        this.dnField = null;
        this.middlePanel.removeAll();
        if (treeNode != null) {
            this.treeTable = new JTreeTable(new AccessTreeModel(treeNode));
            this.accessTreePane = new JScrollPane(this.treeTable);
            this.accessTreePane.setPreferredSize(new Dimension(500, 500));
            if (this.userDN != null) {
                int rowCount;
                for (int count = rowCount = this.treeTable.getRowCount(); count > 0; --count) {
                    this.treeTable.expandIt(count - 1);
                }
                boolean dnFound = false;
                rowCount = this.treeTable.getRowCount();
                for (int count = 0; count < rowCount && !dnFound; ++count) {
                    Object o = this.treeTable.getValueAt(count, 0);
                    if (!(o instanceof AccessTreeNodeObject)) continue;
                    AccessTreeNodeObject nodeOb = (AccessTreeNodeObject)o;
                    if (nodeOb.nodeType != 2 && nodeOb.nodeType != 3 || nodeOb.getDN().compareTo(this.userDN) != 0) continue;
                    this.treeTable.setRowSelectionInterval(count, count);
                    this.treeTable.scrollRectToVisible(this.treeTable.getCellRect(count - 5 > 0 ? count - 5 : 0, 0, true));
                    dnFound = true;
                }
                if (!dnFound) {
                    this.displayDNPanel();
                    return;
                }
            }
        }
        if (this.accessTreePane == null) {
            this.displayDNPanel();
            return;
        }
        this.middlePanel.add((Component)this.accessTreePane, "Center");
        this.middlePanel.add((Component)this.getAccessControlPanel(true, "Refresh the user list..."), "South");
        this.middlePanel.revalidate();
        this.middlePanel.repaint();
        this.typeComboBox.setEnabled(true);
        this.accessComboBox.setEnabled(true);
    }

    protected DefaultMutableTreeNode getTreeFromDocument(Document doc) {
        DefaultMutableTreeNode treeNode = null;
        DefaultMutableTreeNode topNode = new DefaultMutableTreeNode("Access Tree                        ");
        NodeList nl = null;
        if (doc != null) {
            nl = doc.getElementsByTagName("authSystem");
            if (nl != null) {
                this.createSubTree(nl, topNode);
            }
            treeNode = topNode;
        }
        if (treeNode != null) {
            Access.accessTreeNode = treeNode;
            Access.accessTreeMetacatServerName = Morpho.thisStaticInstance.getMetacatURLString();
        } else {
            Log.debug(1, "Unable to retrieve access tree. The old list will be displayed again");
        }
        return Access.accessTreeNode;
    }

    DefaultMutableTreeNode createSubTree(NodeList nl, DefaultMutableTreeNode top) {
        AccessTreeNodeObject nodeObject2 = null;
        DefaultMutableTreeNode tempTreeNode = null;
        ArrayList<AccessTreeNodeObject> userList = new ArrayList<AccessTreeNodeObject>();
        String org = null;
        for (int count = 0; count < nl.getLength(); ++count) {
            Node tempNode = nl.item(count);
            boolean done = false;
            while (!done) {
                if (tempNode.getNodeName().compareTo("authSystem") == 0) {
                    nodeObject2 = new AccessTreeNodeObject(tempNode.getAttributes().getNamedItem("URI").getNodeValue(), 1);
                    if (tempNode.getAttributes().getNamedItem("organization") != null) {
                        org = tempNode.getAttributes().getNamedItem("organization").getNodeValue();
                        nodeObject2.setOrganization(org);
                        if (!this.orgList.contains(org)) {
                            this.config.insert("organization", org);
                        }
                    }
                    tempTreeNode = new DefaultMutableTreeNode();
                    tempTreeNode.setUserObject(nodeObject2);
                    tempTreeNode = this.createSubTree(tempNode.getChildNodes(), tempTreeNode);
                    top.add(tempTreeNode);
                    done = true;
                    continue;
                }
                if (tempNode.getNodeName().compareTo("group") == 0) {
                    DefaultMutableTreeNode tempUserNode = null;
                    NodeList nl2 = tempNode.getChildNodes();
                    nodeObject2 = null;
                    AccessTreeNodeObject groupNodeObject = new AccessTreeNodeObject(2);
                    tempTreeNode = new DefaultMutableTreeNode();
                    ArrayList<AccessTreeNodeObject> userInGroupList = new ArrayList<AccessTreeNodeObject>();
                    for (int i = 0; i < nl2.getLength(); ++i) {
                        Node node = nl2.item(i);
                        if (node.getNodeName().compareTo("groupname") == 0) {
                            groupNodeObject.setDN(node.getFirstChild().getNodeValue());
                        } else if (node.getNodeName().compareTo("description") == 0) {
                            groupNodeObject.setDescription(node.getFirstChild().getNodeValue());
                        } else if (node.getNodeName().compareTo("user") == 0) {
                            NodeList nl3 = node.getChildNodes();
                            nodeObject2 = new AccessTreeNodeObject(3);
                            for (int j = 0; j < nl3.getLength(); ++j) {
                                Node node1 = nl3.item(j);
                                if (node1.getNodeName().compareTo("username") == 0) {
                                    nodeObject2.setDN(node1.getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (node1.getNodeName().compareTo("name") == 0) {
                                    nodeObject2.setName(node1.getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (node1.getNodeName().compareTo("email") == 0) {
                                    nodeObject2.setEmail(node1.getFirstChild().getNodeValue());
                                    continue;
                                }
                                if (node1.getNodeName().compareTo("organization") != 0) continue;
                                if (node1.getFirstChild().getNodeValue().compareTo("null") != 0) {
                                    nodeObject2.setOrganization(node1.getFirstChild().getNodeValue());
                                    continue;
                                }
                                String value = nodeObject2.getDN();
                                if (value != null && value.indexOf("o=") > -1) {
                                    value = value.substring(value.indexOf("o=") + 2);
                                    value = value.substring(0, value.indexOf(","));
                                } else {
                                    value = "";
                                }
                                nodeObject2.setOrganization(value);
                            }
                            userInGroupList.add(nodeObject2);
                        }
                        tempTreeNode.setUserObject(groupNodeObject);
                    }
                    Collections.sort(userInGroupList);
                    for (AccessTreeNodeObject nodeObject2 : userInGroupList) {
                        tempUserNode = new DefaultMutableTreeNode();
                        tempUserNode.setUserObject(nodeObject2);
                        tempTreeNode.add(tempUserNode);
                    }
                    top.add(tempTreeNode);
                    done = true;
                    continue;
                }
                if (tempNode.getNodeName().compareTo("user") == 0) {
                    NodeList nl2 = tempNode.getChildNodes();
                    nodeObject2 = null;
                    nodeObject2 = new AccessTreeNodeObject(3);
                    for (int j = 0; j < nl2.getLength(); ++j) {
                        Node node1 = nl2.item(j);
                        if (node1.getNodeName().compareTo("username") == 0) {
                            nodeObject2.setDN(node1.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (node1.getNodeName().compareTo("name") == 0) {
                            nodeObject2.setName(node1.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (node1.getNodeName().compareTo("email") == 0) {
                            nodeObject2.setEmail(node1.getFirstChild().getNodeValue());
                            continue;
                        }
                        if (node1.getNodeName().compareTo("organization") != 0) continue;
                        if (node1.getFirstChild().getNodeValue().compareTo("null") != 0) {
                            nodeObject2.setOrganization(node1.getFirstChild().getNodeValue());
                            continue;
                        }
                        String value = nodeObject2.getDN();
                        if (value != null && value.indexOf("o=") > -1) {
                            if ((value = value.substring(value.indexOf("o=") + 2)).indexOf(",") > -1) {
                                value = value.substring(0, value.indexOf(","));
                            }
                        } else {
                            value = "";
                        }
                        nodeObject2.setOrganization(value);
                    }
                    userList.add(nodeObject2);
                    done = true;
                    continue;
                }
                if (tempNode.hasChildNodes()) {
                    tempNode = tempNode.getFirstChild();
                    continue;
                }
                done = true;
            }
        }
        Collections.sort(userList);
        for (AccessTreeNodeObject nodeObject2 : userList) {
            tempTreeNode = new DefaultMutableTreeNode();
            tempTreeNode.setUserObject(nodeObject2);
            top.add(tempTreeNode);
        }
        return top;
    }

    public boolean onAdvanceAction() {
        if (this.dnField == null) {
            int[] i = this.treeTable.getSelectedRows();
            if (i.length == 0) {
                this.warnLabel.setText("Warning: Invalid input. Please make a selection.");
                return false;
            }
            for (int j = 0; j < i.length; ++j) {
                Object o = this.treeTable.getValueAt(i[j], 0);
                if (!(o instanceof AccessTreeNodeObject)) continue;
                AccessTreeNodeObject nodeOb = (AccessTreeNodeObject)o;
                if (nodeOb.nodeType == 2 || nodeOb.nodeType == 3) {
                    this.warnLabel.setText("");
                    if (this.userDN != null) {
                        this.alreadyGeneratedfromDocumentationMenu = true;
                        this.userDN = nodeOb.getDN();
                    }
                    return true;
                }
                this.warnLabel.setText("Warning: Invalid input. Please select a user or a group.");
                return false;
            }
        } else {
            if (this.dnField.getText().trim().compareTo("") != 0) {
                this.warnLabel.setText("");
                if (this.userDN != null) {
                    this.alreadyGeneratedfromDocumentationMenu = true;
                    this.userDN = this.dnField.getText().trim();
                }
                return true;
            }
            this.warnLabel.setText("Warning: Distinguished Name field can not be empty.");
        }
        return false;
    }

    public List getSurrogate() {
        ArrayList surrogate = new ArrayList();
        if (this.dnField == null) {
            if (this.treeTable != null) {
                int[] i = this.treeTable.getSelectedRows();
                for (int j = 0; j < i.length; ++j) {
                    ArrayList<String> sub_surrogate;
                    Object o = this.treeTable.getValueAt(i[j], 0);
                    if (!(o instanceof AccessTreeNodeObject)) continue;
                    AccessTreeNodeObject nodeOb = (AccessTreeNodeObject)o;
                    if (nodeOb.nodeType == 2) {
                        sub_surrogate = new ArrayList<String>();
                        sub_surrogate.add(" " + nodeOb.toString().trim());
                        String value = nodeOb.getDN();
                        if (value != null && value.indexOf("o=") > 0) {
                            value = value.substring(value.indexOf("o=") + 2);
                            value = value.substring(0, value.indexOf(","));
                        } else {
                            value = "";
                        }
                        sub_surrogate.add(" " + value);
                        if (nodeOb.getDescription() != null && nodeOb.getDescription().compareTo("") != 0) {
                            sub_surrogate.add(" " + nodeOb.getDescription().trim());
                        } else {
                            sub_surrogate.add("");
                        }
                        sub_surrogate.add(" " + this.userAccessType + "   " + this.userAccess.trim());
                        surrogate.add(sub_surrogate);
                        continue;
                    }
                    if (nodeOb.nodeType != 3) continue;
                    sub_surrogate = new ArrayList();
                    sub_surrogate.add(" " + nodeOb.toString().trim());
                    if (nodeOb.getOrganization() != null && nodeOb.getOrganization().compareTo("") != 0) {
                        sub_surrogate.add(" " + nodeOb.getOrganization().trim());
                    } else {
                        sub_surrogate.add("");
                    }
                    if (nodeOb.getEmail() != null && nodeOb.getEmail().compareTo("") != 0) {
                        sub_surrogate.add(" " + nodeOb.getEmail().trim());
                    } else {
                        sub_surrogate.add("");
                    }
                    sub_surrogate.add(" " + this.userAccessType + "   " + this.userAccess.trim());
                    surrogate.add(sub_surrogate);
                }
            }
        } else {
            ArrayList<String> sub_surrogate = new ArrayList<String>();
            if (this.userName == null) {
                String userOrg = this.dnField.getText().trim();
                if (userOrg != null && userOrg.indexOf("o=") > 0) {
                    userOrg = userOrg.substring(userOrg.indexOf("o=") + 2);
                    userOrg = userOrg.substring(0, userOrg.indexOf(","));
                } else {
                    userOrg = "";
                }
                sub_surrogate.add(" " + this.dnField.getText().trim());
                sub_surrogate.add(" " + userOrg);
                sub_surrogate.add(" ");
            } else {
                sub_surrogate.add(this.userName);
                sub_surrogate.add(" " + this.userOrg);
                sub_surrogate.add(this.userEmail);
            }
            sub_surrogate.add(" " + this.userAccessType + "   " + this.userAccess.trim());
            surrogate.add(sub_surrogate);
        }
        return surrogate;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String xPathRoot) {
        this.returnMap.clear();
        if (this.dnField == null) {
            int[] i = this.treeTable.getSelectedRows();
            for (int j = 0; j < i.length; ++j) {
                Object o = this.treeTable.getValueAt(i[j], 0);
                if (!(o instanceof AccessTreeNodeObject)) continue;
                AccessTreeNodeObject nodeOb = (AccessTreeNodeObject)o;
                this.returnMap.put((Object)(xPathRoot + "/principal[" + (j + 1) + "]"), (Object)nodeOb.getDN());
            }
        } else {
            this.returnMap.put((Object)(xPathRoot + "/principal"), (Object)this.dnField.getText().trim());
        }
        if (this.userAccess.compareTo("Read") == 0) {
            this.returnMap.put((Object)(xPathRoot + "/permission"), (Object)"read");
        } else if (this.userAccess.compareTo("Read & Write") == 0) {
            this.returnMap.put((Object)(xPathRoot + "/permission[1]"), (Object)"read");
            this.returnMap.put((Object)(xPathRoot + "/permission[2]"), (Object)"write");
        } else if (this.userAccess.compareTo("Read, Write & Change Permissions") == 0) {
            this.returnMap.put((Object)(xPathRoot + "/permission[1]"), (Object)"read");
            this.returnMap.put((Object)(xPathRoot + "/permission[2]"), (Object)"write");
            this.returnMap.put((Object)(xPathRoot + "/permission[3]"), (Object)"changePermission");
        } else if (this.userAccess.compareTo("All") == 0) {
            this.returnMap.put((Object)(xPathRoot + "/permission"), (Object)"all");
        }
        return this.returnMap;
    }

    public void onRewindAction() {
    }

    public void onLoadAction() {
        if (this.userDN != null && !this.alreadyGeneratedfromDocumentationMenu) {
            if (Access.accessTreeNode == null || Access.accessTreeMetacatServerName.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) != 0) {
                this.generateAccessTree();
            } else if (Access.accessTreeNode != null && Access.accessTreeMetacatServerName.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) == 0) {
                this.displayTree(Access.accessTreeNode);
            }
        } else if (Access.accessTreeNode == null || Access.accessTreeMetacatServerName.compareTo(Morpho.thisStaticInstance.getMetacatURLString()) != 0) {
            this.generateAccessTree();
        }
    }

    public String getPageID() {
        return this.pageID;
    }

    public String getTitle() {
        return "Access Page";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        this.getClass();
        return "";
    }

    public String getPageNumber() {
        return "";
    }

    public boolean isQueryMetacatCancelled() {
        return this.queryMetacatCancelled;
    }

    public boolean setPageData(OrderedMap map, String xPathRoot) {
        Log.debug(45, "AccessPage.setPageData() called with xPathRoot = " + xPathRoot + "\n Map = \n" + map);
        if (xPathRoot != null && xPathRoot.trim().length() > 0) {
            this.xPathRoot = xPathRoot;
        }
        int access = 0;
        this.userAccessType = xPathRoot.indexOf("allow") > -1 ? "  Allow" : "  Deny ";
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(45, "Access:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            nextXPath = nextXPath.substring(nextXPath.lastIndexOf(this.xPathRoot) + this.xPathRoot.length() + 1);
            Log.debug(45, "Access: TRIMMED nextXPath   = " + nextXPath);
            if (nextXPath.startsWith("permission") || nextXPath.startsWith("/permission")) {
                if (nextVal.compareTo("read") == 0) {
                    access |= 1;
                } else if (nextVal.compareTo("write") == 0) {
                    access |= 2;
                } else if (nextVal.compareTo("changePermission") == 0) {
                    access |= 4;
                } else if (nextVal.compareTo("all") == 0) {
                    access |= 8;
                } else {
                    Log.debug(20, "Unknown access type received in setPageData() in AccessPage.java");
                }
                toDeleteList.add(nextXPathObj);
                continue;
            }
            if (!nextXPath.startsWith("principal") && !nextXPath.startsWith("/principal")) continue;
            if (this.userDN == null) {
                this.userDN = (String)nextValObj;
                ConfigXML accessXML = null;
                try {
                    Vector userorg;
                    Vector useremail;
                    accessXML = new ConfigXML(this.accessListFilePath);
                    Vector username = accessXML.getValuesForPath("username[.='" + (String)nextValObj + "']/../name");
                    if (username.size() > 0) {
                        this.userName = (String)username.get(0);
                    }
                    if ((useremail = accessXML.getValuesForPath("username[.='" + (String)nextValObj + "']/../email")).size() > 0) {
                        this.userEmail = (String)useremail.get(0);
                    }
                    if ((userorg = accessXML.getValuesForPath("username[.='" + (String)nextValObj + "']/../organization")).size() > 0) {
                        this.userOrg = (String)userorg.get(0);
                    }
                }
                catch (Exception e) {}
            } else {
                Log.debug(10, "AccessPage.setPageData returning FALSE! Principal contains multiple DNs. Multiple are not supported in Access Wizard screen yet.");
                return false;
            }
            toDeleteList.add(nextXPathObj);
        }
        Log.debug(45, "Access type found to be" + access);
        if (access == 3) {
            this.userAccess = "Read & Write";
        } else if (access == 7) {
            this.userAccess = "Read, Write & Change Permissions";
        } else if (access == 8) {
            this.userAccess = "All";
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(10, "AccessPage.setPageData returning FALSE! Map still contains:" + map);
        }
        this.displayDNPanel();
        return returnVal;
    }
}

