/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.MetadataObject;
import edu.ucsb.nceas.morpho.framework.DataPackageInterface;
import edu.ucsb.nceas.morpho.framework.EditorInterface;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.StatusBar;
import edu.ucsb.nceas.morpho.plugins.ServiceController;
import edu.ucsb.nceas.morpho.plugins.ServiceNotHandledException;
import edu.ucsb.nceas.morpho.plugins.ServiceProvider;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;

public class UIController {
    private static UIController controller;
    private static Morpho morpho;
    private static MorphoFrame currentActiveWindow;
    private static Hashtable guiActionClones;
    private static Hashtable windowList;
    private static Hashtable actionCloneWindowAssociation;
    private static Vector orderedMenuList;
    private static Hashtable orderedMenuActions;
    private static Vector toolbarList;
    private static Hashtable subMenuAndPath;
    private static int count;
    private static int windowXcoord;
    private static int windowYcoord;
    private static int windowXcoordUpperBound;
    private static int windowYcoordUpperBound;
    private static int WIN_CASCADE_MOD_X;
    private static int WIN_CASCADE_MOD_Y;
    public static final String SEPARATOR_PRECEDING = "separator_preceding";
    public static final String SEPARATOR_FOLLOWING = "separator_following";
    public static final String PULL_RIGHT_MENU = "pull_right_menu";
    public static final String YES = "yes";
    public static final String MENU_PATH = "menu_path";
    private AbstractDataPackage wizardTempDataPackage = null;

    private UIController(Morpho morpho) {
        UIController.morpho = morpho;
        windowList = new Hashtable();
        actionCloneWindowAssociation = new Hashtable();
        guiActionClones = new Hashtable();
        orderedMenuList = new Vector();
        orderedMenuActions = new Hashtable();
        toolbarList = new Vector();
        subMenuAndPath = new Hashtable();
    }

    public static UIController initialize(Morpho morpho) {
        if (controller == null) {
            controller = new UIController(morpho);
        }
        return controller;
    }

    public static UIController getInstance() {
        return controller;
    }

    public MorphoFrame addWindow(String windowName) {
        String title = "Untitled";
        if (windowName != null) {
            title = windowName;
        }
        Log.debug(30, "Adding window: " + title);
        MorphoFrame window = MorphoFrame.getInstance();
        window.setTitle(title);
        this.registerWindow(window);
        this.updateStatusBar(window.getStatusBar());
        this.setCurrentActiveWindow(window);
        this.setWindowLocation(window);
        window.toFront();
        ++count;
        return window;
    }

    public MorphoFrame addHiddenWindow(String windowName) {
        String title = "Untitled";
        if (windowName != null) {
            title = windowName;
        }
        Log.debug(30, "Adding window: " + title);
        MorphoFrame window = MorphoFrame.getHiddenInstance();
        window.setTitle(title);
        this.registerWindow(window);
        this.updateStatusBar(window.getStatusBar());
        this.setCurrentActiveWindow(window);
        this.setWindowLocation(window);
        window.toFront();
        ++count;
        return window;
    }

    private void setWindowLocation(MorphoFrame window) {
        if (count == 0) {
            this.initWindowCoords(window);
            Log.debug(45, "UIController.initWindowCoords(): windowXcoordUpperBound=" + windowXcoordUpperBound);
            Log.debug(45, "UIController.initWindowCoords(): windowYcoordUpperBound=" + windowYcoordUpperBound);
            Log.debug(45, "UIController.initWindowCoords(): WIN_CASCADE_MOD_X=" + WIN_CASCADE_MOD_X);
            Log.debug(45, "UIController.initWindowCoords(): WIN_CASCADE_MOD_Y=" + WIN_CASCADE_MOD_Y);
        }
        if (count != 1) {
            if (WIN_CASCADE_MOD_X > 0) {
                windowXcoord = windowXcoordUpperBound + (windowXcoord - windowXcoordUpperBound + 25) % WIN_CASCADE_MOD_X;
            }
            if (WIN_CASCADE_MOD_Y > 0) {
                windowYcoord = windowYcoordUpperBound + (windowYcoord - windowYcoordUpperBound + 25) % WIN_CASCADE_MOD_Y;
            }
        }
        Log.debug(45, "UIController.setWindowLocation(): (" + windowXcoord + ", " + windowYcoord + ")");
        window.setLocation(windowXcoord, windowYcoord);
    }

    public void updateWindow(MorphoFrame window, String title) {
        String oldTitle = window.getTitle();
        if (title == null || title.equals(oldTitle)) {
            return;
        }
        this.removeWindow(window);
        window.setTitle(title);
        this.putFrameIntoWindowList(window);
        if (this.getCurrentActiveWindow() == null) {
            this.setCurrentActiveWindow(window);
        }
    }

    public void removeWindow(MorphoFrame window) {
        this.removeWindowWithoutCheckingEmpty(window);
        if (windowList.isEmpty()) {
            morpho.exitApplication();
        }
    }

    private void removeWindowWithoutCheckingEmpty(MorphoFrame window) {
        MorphoFrame savedWindow;
        Log.debug(50, "Removing window.");
        GUIAction currentAction = null;
        Enumeration keys = windowList.keys();
        while (keys.hasMoreElements() && (savedWindow = (MorphoFrame)windowList.get(currentAction = (GUIAction)keys.nextElement())) != window) {
            currentAction = null;
        }
        this.removeGuiAction(currentAction);
        if (this.getCurrentActiveWindow() == window) {
            this.setCurrentActiveWindow(null);
        }
        int cnt = 0;
        GUIAction currentAction1 = null;
        Enumeration keys1 = actionCloneWindowAssociation.keys();
        Vector<GUIAction> matches = new Vector<GUIAction>();
        while (keys1.hasMoreElements()) {
            currentAction1 = (GUIAction)keys1.nextElement();
            MorphoFrame sWindow = (MorphoFrame)windowList.get(currentAction1);
            if (sWindow != window) continue;
            matches.addElement(currentAction1);
            Log.debug(10, "found matching window!" + cnt++);
        }
        Enumeration en = matches.elements();
        while (en.hasMoreElements()) {
            actionCloneWindowAssociation.remove((GUIAction)en.nextElement());
            Log.debug(10, "removed window" + cnt++);
        }
        try {
            windowList.remove(currentAction);
            Log.debug(10, "removed from window list");
            System.gc();
        }
        catch (NullPointerException npe2) {
            Log.debug(20, "Window already removed from registry.");
        }
    }

    public void removeAllWindows() {
        Enumeration frameList = windowList.elements();
        while (frameList.hasMoreElements()) {
            MorphoFrame frame = (MorphoFrame)frameList.nextElement();
            this.removeWindowWithoutCheckingEmpty(frame);
            frame.dispose();
            Object var2_2 = null;
        }
        count = 0;
    }

    public Vector removeCleanWindows() {
        Vector<MorphoFrame> res = new Vector<MorphoFrame>();
        Enumeration frameList = windowList.elements();
        while (frameList.hasMoreElements()) {
            MorphoFrame frame = (MorphoFrame)frameList.nextElement();
            if (frame.isDirty()) {
                res.addElement(frame);
                continue;
            }
            this.removeWindowWithoutCheckingEmpty(frame);
            frame.dispose();
            Object var3_3 = null;
        }
        count = res.size();
        return res;
    }

    public void addGuiAction(GUIAction action) {
        Vector<GUIAction> cloneList = new Vector<GUIAction>();
        guiActionClones.put(action, cloneList);
        Enumeration windows = windowList.elements();
        while (windows.hasMoreElements()) {
            MorphoFrame window = (MorphoFrame)windows.nextElement();
            GUIAction clone = action.cloneAction();
            cloneList.addElement(clone);
            actionCloneWindowAssociation.put(clone, window);
            window.addGuiAction(clone);
        }
    }

    public void removeGuiAction(GUIAction action) {
        Vector cloneList = (Vector)guiActionClones.get(action);
        guiActionClones.remove(action);
        for (int i = 0; i < cloneList.size(); ++i) {
            GUIAction clone = (GUIAction)cloneList.elementAt(i);
            MorphoFrame window = UIController.getMorphoFrameContainingGUIAction(clone);
            window.removeGuiAction(clone);
        }
    }

    public static MorphoFrame getMorphoFrameContainingGUIAction(GUIAction clone) {
        if (clone == null || actionCloneWindowAssociation == null) {
            return null;
        }
        return (MorphoFrame)actionCloneWindowAssociation.get(clone);
    }

    public static GUIAction getGUIActionCloneUsedByMorphoFrame(GUIAction action, MorphoFrame frame) {
        if (action == null || frame == null) {
            return null;
        }
        Vector cloneList = (Vector)guiActionClones.get(action);
        for (int i = 0; i < cloneList.size(); ++i) {
            GUIAction clone = (GUIAction)cloneList.elementAt(i);
            if ((MorphoFrame)actionCloneWindowAssociation.get(clone) != frame) continue;
            return clone;
        }
        return null;
    }

    public void refreshWindows() {
        Enumeration windows = windowList.elements();
        while (windows.hasMoreElements()) {
            ((MorphoFrame)windows.nextElement()).validate();
        }
    }

    public void updateAllStatusBars() {
        Enumeration windows = windowList.elements();
        while (windows.hasMoreElements()) {
            StatusBar statusBar = ((MorphoFrame)windows.nextElement()).getStatusBar();
            this.updateStatusBar(statusBar);
        }
    }

    public void setCurrentActiveWindow(MorphoFrame window) {
        currentActiveWindow = window;
    }

    public MorphoFrame getCurrentActiveWindow() {
        return currentActiveWindow;
    }

    public AbstractDataPackage getCurrentAbstractDataPackage() {
        if (this.isWizardRunning()) {
            Log.debug(45, "\n\n***********************************getCurrentAbstractDataPackage() - isWizardRunning() == true. pkg = \n" + this.wizardTempDataPackage);
            return this.wizardTempDataPackage;
        }
        MorphoFrame morphoFrame = this.getCurrentActiveWindow();
        if (morphoFrame == null) {
            Log.debug(20, "UIController.getCurrentAbstractDataPackage() - morphoFrame==null, returning NULL");
            return null;
        }
        return morphoFrame.getAbstractDataPackage();
    }

    public AbstractDataPackage getCurrentExistingAbstractDataPackage() {
        MorphoFrame morphoFrame = this.getCurrentActiveWindow();
        if (morphoFrame == null) {
            Log.debug(20, "UIController.getCurrentAbstractDataPackage() - morphoFrame==null, returning NULL");
            return null;
        }
        return morphoFrame.getAbstractDataPackage();
    }

    public void setWizardIsRunning(AbstractDataPackage tempDataPackage) {
        this.wizardTempDataPackage = tempDataPackage;
    }

    public void setWizardNotRunning() {
        this.wizardTempDataPackage = null;
    }

    public boolean isWizardRunning() {
        return this.wizardTempDataPackage != null;
    }

    public static Morpho getMorpho() {
        return morpho;
    }

    public void launchEditorAtSubtreeForCurrentFrame(String subtreeRootNodeName, int subtreeRootIndex) {
        EditorInterface editor = null;
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(EditorInterface.class);
            editor = (EditorInterface)((Object)provider);
        }
        catch (Exception ee) {
            Log.debug(0, "Error acquiring editor plugin: " + ee.getMessage());
            ee.printStackTrace();
            return;
        }
        DataViewContainerPanel panel = null;
        MetadataObject adp = null;
        MorphoFrame frame = this.getCurrentActiveWindow();
        if (frame != null) {
            panel = frame.getDataViewContainerPanel();
        }
        if (panel != null) {
            adp = panel.getAbstractDataPackage();
        }
        Document thisdoc = adp.getMetadataNode().getOwnerDocument();
        String id = ((AbstractDataPackage)adp).getPackageId();
        String location = ((AbstractDataPackage)adp).getLocation();
        editor.openEditor(thisdoc, id, location, panel, subtreeRootNodeName, subtreeRootIndex);
    }

    private void registerWindow(MorphoFrame window) {
        if (window == null) {
            Log.debug(50, "Window is null, create failed!");
        }
        Enumeration actionList = guiActionClones.keys();
        while (actionList.hasMoreElements()) {
            GUIAction action = (GUIAction)actionList.nextElement();
            Log.debug(50, "Cloning action: " + action.toString());
            GUIAction clone = action.cloneAction();
            Vector cloneList = (Vector)guiActionClones.get(action);
            cloneList.addElement(clone);
            actionCloneWindowAssociation.put(clone, window);
            Log.debug(50, "Clone menu name is: " + clone.getMenuName());
            window.addGuiAction(clone);
        }
        this.putFrameIntoWindowList(window);
    }

    private void putFrameIntoWindowList(MorphoFrame window) {
        String title = window.getTitle();
        Command command = new Command(){

            public void execute(ActionEvent e) {
                JMenuItem source = (JMenuItem)e.getSource();
                Action firedAction = source.getAction();
                GUIAction original = ((GUIAction)firedAction).getOriginalAction();
                MorphoFrame window1 = (MorphoFrame)windowList.get(original);
                window1.toFront();
            }
        };
        GUIAction action = new GUIAction(title, null, command);
        action.setMenu("Window", 5);
        action.setToolTipText("Select Window");
        windowList.put(action, window);
        this.addGuiAction(action);
    }

    private void updateStatusBar(StatusBar statusBar) {
        statusBar.setConnectStatus(morpho.getNetworkStatus());
        statusBar.setLoginStatus(morpho.isConnected() && morpho.getNetworkStatus());
        statusBar.setSSLStatus(morpho.getSslStatus());
    }

    private static JMenuBar createMenuBar() {
        return null;
    }

    private static void createMenuItems(String menuName, JMenu currentMenu) {
        Vector currentActions = (Vector)orderedMenuActions.get(menuName);
        UIController.registerActionToMenu(currentMenu, currentActions);
        Log.debug(50, "Creating menu items for: " + menuName + " (" + currentActions.size() + " actions)");
    }

    private static void createMenuItemsCopy(String menuName, JMenu currentMenu) {
        Vector currentActions = (Vector)orderedMenuActions.get(menuName);
        Log.debug(20, "Creating menu items for: " + menuName + " (" + currentActions.size() + " actions)");
        for (int j = 0; j < currentActions.size(); ++j) {
            Action currentAction = (Action)currentActions.elementAt(j);
            JMenuItem currentItem = null;
            String hasDefaultSep = (String)currentAction.getValue("Default");
            Integer itemPosition = (Integer)currentAction.getValue("menuPosition");
            int menuPos = itemPosition != null ? itemPosition : -1;
            menuPos = -1;
            if (menuPos >= 0) {
                Log.debug(50, "Inserting Action as menu item.");
                int menuCount = currentMenu.getMenuComponentCount();
                if (menuPos > menuCount) {
                    menuPos = menuCount;
                }
                if (hasDefaultSep != null && hasDefaultSep.equals(SEPARATOR_PRECEDING)) {
                    currentMenu.insertSeparator(menuPos++);
                }
                currentItem = currentMenu.insert(currentAction, menuPos);
                currentItem.setAccelerator((KeyStroke)currentAction.getValue("AcceleratorKey"));
                if (hasDefaultSep == null || !hasDefaultSep.equals(SEPARATOR_FOLLOWING)) continue;
                currentMenu.insertSeparator(++menuPos);
                continue;
            }
            Log.debug(50, "Appending Action as menu item.");
            if (hasDefaultSep != null && hasDefaultSep.equals(SEPARATOR_PRECEDING)) {
                currentMenu.addSeparator();
            }
            currentItem = currentMenu.add(currentAction);
            currentItem.setAccelerator((KeyStroke)currentAction.getValue("AcceleratorKey"));
            if (hasDefaultSep == null || !hasDefaultSep.equals(SEPARATOR_FOLLOWING)) continue;
            currentMenu.addSeparator();
        }
    }

    private static void registerActionToMenu(JMenu currentMenu, Vector actions) {
        boolean pullRightMenuFlag = false;
        JMenu currentPullRightMenu = null;
        Vector<Action> subMenuActions = null;
        JMenuItem currentItem = null;
        if (currentMenu == null || actions.size() == 0) {
            return;
        }
        for (int j = 0; j < actions.size(); ++j) {
            int menuPos;
            Action currentAction = (Action)actions.elementAt(j);
            String pullRightMenu = (String)currentAction.getValue(PULL_RIGHT_MENU);
            if (pullRightMenu != null && pullRightMenu.equals(YES)) {
                Log.debug(50, "in submenu ");
                String pullRightMenuPath = (String)currentAction.getValue(MENU_PATH);
                Log.debug(50, "Pull right Menu path: " + pullRightMenuPath);
                pullRightMenuFlag = true;
                currentPullRightMenu = new JMenu(currentAction);
                subMenuActions = new Vector<Action>();
                for (int i = 0; i < actions.size(); ++i) {
                    Action current = (Action)actions.elementAt(i);
                    String actionMenuPath = (String)current.getValue(MENU_PATH);
                    if (actionMenuPath == null || current == currentAction || !actionMenuPath.startsWith(pullRightMenuPath)) continue;
                    Log.debug(50, "Action path : " + actionMenuPath);
                    subMenuActions.add(current);
                }
                subMenuAndPath.put(currentPullRightMenu, pullRightMenuPath);
            } else {
                String actionPath = (String)currentAction.getValue(MENU_PATH);
                String paramterMenuPath = (String)subMenuAndPath.get(currentMenu);
                if (paramterMenuPath != null && actionPath != null && !paramterMenuPath.equals(actionPath)) continue;
            }
            String hasDefaultSep = (String)currentAction.getValue("Default");
            Integer itemPosition = (Integer)currentAction.getValue("menuPosition");
            int n = menuPos = itemPosition != null ? itemPosition : -1;
            if (menuPos >= 0) {
                Log.debug(50, "Inserting Action as menu item.");
                int menuCount = currentMenu.getMenuComponentCount();
                if (menuPos > menuCount) {
                    menuPos = menuCount;
                }
                if (hasDefaultSep != null && hasDefaultSep.equals(SEPARATOR_PRECEDING)) {
                    currentMenu.insertSeparator(menuPos);
                    ++menuPos;
                }
                if (pullRightMenuFlag) {
                    UIController.registerActionToMenu(currentPullRightMenu, subMenuActions);
                    currentItem = currentMenu.insert(currentPullRightMenu, menuPos);
                } else {
                    currentItem = currentMenu.insert(currentAction, menuPos);
                    currentItem.setAccelerator((KeyStroke)currentAction.getValue("AcceleratorKey"));
                }
                if (hasDefaultSep == null || !hasDefaultSep.equals(SEPARATOR_FOLLOWING)) continue;
                currentMenu.insertSeparator(++menuPos);
                continue;
            }
            Log.debug(50, "Appending Action as menu item.");
            if (hasDefaultSep != null && hasDefaultSep.equals(SEPARATOR_PRECEDING)) {
                currentMenu.addSeparator();
            }
            if (pullRightMenuFlag) {
                UIController.registerActionToMenu(currentPullRightMenu, subMenuActions);
                currentItem = currentMenu.add(currentPullRightMenu);
            } else {
                currentItem = currentMenu.add(currentAction);
                currentItem.setAccelerator((KeyStroke)currentAction.getValue("AcceleratorKey"));
            }
            if (hasDefaultSep == null || !hasDefaultSep.equals(SEPARATOR_FOLLOWING)) continue;
            currentMenu.addSeparator();
        }
    }

    private static boolean isSubMenuPathExisted(String path) {
        boolean flag = false;
        Enumeration menuPath = subMenuAndPath.elements();
        while (menuPath.hasMoreElements()) {
            String existedPath = (String)menuPath.nextElement();
            if (!existedPath.equals(path)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void initWindowCoords(MorphoFrame frame) {
        int fHeight;
        int yQttyTopLeft;
        int fWidth = frame.getWidth();
        windowXcoord = (UISettings.CLIENT_SCREEN_WIDTH - fWidth) / 2;
        int xQttyTopLeft = windowXcoord / 25;
        int qttyTopLeft = xQttyTopLeft > (yQttyTopLeft = (windowYcoord = (UISettings.CLIENT_SCREEN_HEIGHT - 100 - (fHeight = frame.getHeight())) / 2) / 25) ? yQttyTopLeft : xQttyTopLeft;
        windowXcoordUpperBound = windowXcoord - qttyTopLeft * 25;
        windowYcoordUpperBound = windowYcoord - qttyTopLeft * 25;
        int loRightXcoord = windowXcoord + fWidth;
        int loRightYcoord = windowYcoord + fHeight;
        int xQttyLoRt = (UISettings.CLIENT_SCREEN_WIDTH - loRightXcoord) / 25;
        int yQttyLoRt = (UISettings.CLIENT_SCREEN_HEIGHT - loRightYcoord) / 25;
        int qttyLoRt = xQttyLoRt > yQttyLoRt ? yQttyLoRt : xQttyLoRt;
        int modInt = qttyTopLeft + qttyLoRt;
        WIN_CASCADE_MOD_X = modInt * 25;
        WIN_CASCADE_MOD_Y = modInt * 25;
        if (WIN_CASCADE_MOD_X > 0) {
            windowXcoord -= 25;
        }
        if (WIN_CASCADE_MOD_Y > 0) {
            windowYcoord -= 25;
        }
    }

    public static void showNewPackageNoLocChange(AbstractDataPackage adp) {
        UIController.showNewPackage_base(adp);
    }

    public static void showNewPackage(AbstractDataPackage adp) {
        adp.setLocation("");
        UIController.showNewPackage_base(adp);
    }

    private static void showNewPackage_base(AbstractDataPackage adp) {
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        Point pos = morphoFrame.getLocation();
        Dimension size = morphoFrame.getSize();
        try {
            ServiceController services = ServiceController.getInstance();
            ServiceProvider provider = services.getServiceProvider(DataPackageInterface.class);
            DataPackageInterface dataPackage = (DataPackageInterface)((Object)provider);
            dataPackage.openHiddenNewDataPackage(adp, null);
            UIController controller = UIController.getInstance();
            MorphoFrame newMorphoFrame = controller.getCurrentActiveWindow();
            newMorphoFrame.setLocation(pos);
            newMorphoFrame.setSize(size);
            newMorphoFrame.setVisible(true);
            morphoFrame.setVisible(false);
            controller.removeWindow(morphoFrame);
            morphoFrame.dispose();
        }
        catch (ServiceNotHandledException snhe) {
            Log.debug(6, snhe.getMessage());
            morphoFrame.setVisible(true);
        }
    }

    static {
        count = 0;
    }
}

