/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.framework;

import HTTPClient.NVPair;
import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.framework.MultipartForm;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Properties;

public class HttpMessage {
    private URL servlet = null;
    private String argString = null;
    private static String cookie = null;
    private OutputStream out = null;
    private URLConnection con = null;

    public HttpMessage(URL servlet) {
        this.servlet = servlet;
    }

    public InputStream sendGetMessage() throws IOException {
        return this.sendGetMessage(null);
    }

    public InputStream sendGetMessage(Properties args) throws IOException {
        this.argString = "";
        if (args != null) {
            this.argString = "?" + this.toEncodedString(args);
        }
        URL url = new URL(this.servlet.toExternalForm() + this.argString);
        this.con = url.openConnection();
        this.con.setUseCaches(false);
        return this.con.getInputStream();
    }

    private void openPostConnection() throws IOException {
        this.con = this.servlet.openConnection();
        Log.debug(20, "HTTP Handler class is: " + this.con.getClass().getName());
        if (cookie != null) {
            int k = cookie.indexOf(";");
            if (k > 0) {
                cookie = cookie.substring(0, k);
            }
            this.con.setRequestProperty("Cookie", cookie);
        }
        this.con.setRequestProperty("User-Agent", "Morpho/" + Morpho.VERSION);
        this.con.setDoInput(true);
        this.con.setDoOutput(true);
        this.con.setUseCaches(false);
    }

    public InputStream sendPostData(Properties args, Properties fileNames) throws IOException {
        this.openPostConnection();
        int len = args.size();
        NVPair[] opts = new NVPair[len];
        Enumeration<?> names = args.propertyNames();
        for (int i = 0; i < len; ++i) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            opts[i] = new NVPair(name, value);
        }
        len = fileNames.size();
        NVPair[] data = new NVPair[len];
        Enumeration<?> dataNames = fileNames.propertyNames();
        for (int i = 0; i < len; ++i) {
            String name = (String)dataNames.nextElement();
            String value = fileNames.getProperty(name);
            data[i] = new NVPair(name, value);
        }
        MultipartForm myform = new MultipartForm(opts, data);
        ((HttpURLConnection)this.con).setRequestMethod("POST");
        String ctype = myform.getContentType();
        ((HttpURLConnection)this.con).setRequestProperty("Content-Type", ctype);
        long contentLength = myform.getLength();
        ((HttpURLConnection)this.con).setRequestProperty("Content-Length", new Long(contentLength).toString());
        this.out = this.con.getOutputStream();
        myform.writeEncodedMultipartForm(this.out);
        InputStream res = this.closePostConnection();
        return res;
    }

    public InputStream sendPostData(Properties args) throws IOException {
        this.openPostConnection();
        this.out = new DataOutputStream(this.con.getOutputStream());
        Enumeration<?> names = args.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            this.sendNameValuePair(name, value);
            if (!names.hasMoreElements()) continue;
            ((DataOutputStream)this.out).writeBytes("&");
            this.out.flush();
        }
        InputStream res = this.closePostConnection();
        return res;
    }

    private void sendNameValuePair(String name, String data) throws IOException {
        Log.debug(15, "Name: " + name + " => " + data);
        ((DataOutputStream)this.out).writeBytes(URLEncoder.encode(name));
        ((DataOutputStream)this.out).writeBytes("=");
        ((DataOutputStream)this.out).writeBytes(URLEncoder.encode(data));
        this.out.flush();
    }

    private InputStream closePostConnection() throws IOException {
        int k;
        InputStream response = this.con.getInputStream();
        String temp = this.con.getHeaderField("Set-Cookie");
        if (temp != null && (k = (cookie = temp).indexOf(";")) > 0) {
            cookie = cookie.substring(0, k);
        }
        this.out.close();
        return response;
    }

    public InputStream sendPostMessage() throws IOException {
        return this.sendPostMessage(null);
    }

    public InputStream sendPostMessage(Properties args) throws IOException {
        return this.sendPostData(args);
    }

    private String toEncodedString(Properties args) {
        StringBuffer buf = new StringBuffer();
        Enumeration<?> names = args.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = args.getProperty(name);
            buf.append(URLEncoder.encode(name) + "=" + URLEncoder.encode(value));
            if (!names.hasMoreElements()) continue;
            buf.append("&");
        }
        return buf.toString();
    }

    public static String getCookie() {
        return cookie;
    }

    public static void setCookie(String newCookie) {
        cookie = newCookie;
    }
}

