/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.editor;

import edu.ucsb.nceas.morpho.editor.DocFrame;
import edu.ucsb.nceas.morpho.editor.NodeInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class XMLPanels
extends Component {
    public JPanel topPanel;
    public DefaultMutableTreeNode doc;
    public DefaultTreeModel treeModel = null;
    public JTree tree = null;
    public DocFrame container = null;
    private boolean defaultPanel = true;
    private int numPanels = 0;
    Hashtable nodeMap;
    boolean refLock = false;

    public XMLPanels() {
        this(null);
    }

    public XMLPanels(DefaultMutableTreeNode node) {
        this.doc = node;
        this.topPanel = new JPanel();
        this.nodeMap = new Hashtable();
        this.init();
    }

    public XMLPanels(DefaultMutableTreeNode node, int defaultWidth) {
        this.doc = node;
        this.nodeMap = new Hashtable();
        this.topPanel = new JPanel();
        this.topPanel.setSize(new Dimension(defaultWidth, 300));
        this.init();
    }

    public void setTreeModel(DefaultTreeModel tm) {
        this.treeModel = tm;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }

    public void setContainer(DocFrame df) {
        this.container = df;
    }

    void init() {
        if (this.doc == null) {
            return;
        }
        NodeInfo info = (NodeInfo)this.doc.getUserObject();
        this.topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(info.toString()), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        String temp = info.getRootEditor();
        if (temp != null) {
            try {
                Object[] Args = new Object[]{this.doc};
                Class[] ArgsClass = new Class[]{DefaultMutableTreeNode.class};
                Class<?> componentDefinition = Class.forName(temp);
                Constructor<?> ArgsConstructor = componentDefinition.getConstructor(ArgsClass);
                Object obj = XMLPanels.createObject(ArgsConstructor, Args);
                if (obj != null) {
                    this.topPanel.add((Component)obj);
                }
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
            }
            catch (NoSuchMethodException e) {
                System.out.println(e);
            }
        }
        this.refLock = false;
        this.doPanels(this.doc, this.topPanel);
    }

    void doPanels(DefaultMutableTreeNode node, JPanel panel) {
        String temp;
        boolean locked = false;
        NodeInfo inf = (NodeInfo)node.getUserObject();
        DefaultMutableTreeNode refsNode = this.getRefsNode(node);
        if (refsNode != null) {
            DefaultMutableTreeNode referencedNode;
            this.refLock = true;
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)refsNode.getRoot();
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)refsNode.getFirstChild();
            NodeInfo kidni = (NodeInfo)kid.getUserObject();
            String referencedId = kidni.getPCValue();
            node = referencedNode = this.getReferencedNode(root, referencedId);
            inf = (NodeInfo)node.getUserObject();
        }
        if ((temp = inf.getEditor()) != null && temp.indexOf("LockedPanel") > -1) {
            locked = true;
            temp = null;
        }
        if (temp != null) {
            try {
                Object[] Args = new Object[]{node};
                Class[] ArgsClass = new Class[]{DefaultMutableTreeNode.class};
                Class<?> componentDefinition = Class.forName(temp);
                Constructor<?> ArgsConstructor = componentDefinition.getConstructor(ArgsClass);
                Object obj = XMLPanels.createObject(ArgsConstructor, Args);
                if (obj != null) {
                    panel.add((Component)obj);
                }
            }
            catch (ClassNotFoundException e) {
                System.out.println(e);
            }
            catch (NoSuchMethodException e) {
                System.out.println(e);
            }
        } else {
            panel.add(this.getDataPanel(node, locked || this.refLock));
            Enumeration<TreeNode> nodes = node.children();
            while (nodes.hasMoreElements()) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)nodes.nextElement();
                NodeInfo info = (NodeInfo)nd.getUserObject();
                if (info.name.equals("#PCDATA")) continue;
                if (info.name.indexOf("CHOICE") < 0 && info.name.indexOf("SEQUENCE") < 0) {
                    JPanel new_panel = new JPanel();
                    String borderTitle = info.toString();
                    if (this.refLock) {
                        borderTitle = borderTitle + ":     (REFERENCE)";
                    }
                    new_panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(borderTitle), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
                    ++this.numPanels;
                    if (this.numPanels < 500) {
                        new_panel.setLayout(new BoxLayout(new_panel, 1));
                        panel.add(new_panel);
                        this.doPanels(nd, new_panel);
                        continue;
                    }
                    String message = "<html><p>List Terminated Due to Large Size!<br>";
                    message = message + "Click on SubNodes in the Outline on the Left to Edit those Items</html>";
                    JLabel trunc = new JLabel(message);
                    panel.add(trunc);
                    break;
                }
                this.doPanels(nd, panel);
            }
        }
        this.defaultPanel = true;
    }

    JPanel getDataPanel(DefaultMutableTreeNode node, boolean locked) {
        String helpString;
        int panelWidth = this.topPanel.getWidth() - 40;
        JPanel jp = new JPanel();
        jp.setLayout(new BoxLayout(jp, 1));
        jp.setAlignmentX(0.0f);
        JPanel jp1 = new JPanel();
        jp1.setLayout(new BoxLayout(jp1, 1));
        jp1.setAlignmentX(0.0f);
        JPanel jp2 = new JPanel();
        jp2.setLayout(new BoxLayout(jp2, 1));
        jp2.setAlignmentX(0.0f);
        jp1.setMaximumSize(new Dimension(panelWidth, 45));
        jp1.setPreferredSize(new Dimension(panelWidth, 45));
        jp2.setMaximumSize(new Dimension(panelWidth, 25));
        jp.add(jp1);
        jp.add(jp2);
        NodeInfo info = (NodeInfo)node.getUserObject();
        StringBuffer name = new StringBuffer();
        if (info.getHelp() != null) {
            name.append(info.getHelp());
        }
        if ((helpString = name.toString()).length() == 0) {
            jp1.setMaximumSize(new Dimension(panelWidth, 2));
            jp1.setPreferredSize(new Dimension(panelWidth, 2));
        }
        if (helpString.length() > 0) {
            JScrollPane jsp = new JScrollPane();
            jsp.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            JTextArea jta = new JTextArea();
            jta.setFont(new Font("Dialog", 0, 10));
            jta.setLineWrap(true);
            jta.setWrapStyleWord(true);
            jta.setEditable(false);
            jta.setEnabled(false);
            jta.setBackground(jp1.getBackground());
            jsp.getViewport().add(jta);
            jp1.add(jsp);
            jta.setText(helpString);
            jta.setCaretPosition(0);
        }
        Enumeration<TreeNode> nodes = node.children();
        String txt = "";
        DefaultMutableTreeNode nd = null;
        while (nodes.hasMoreElements()) {
            nd = (DefaultMutableTreeNode)nodes.nextElement();
            NodeInfo info1 = (NodeInfo)nd.getUserObject();
            if (!info1.name.equals("#PCDATA") || !(txt = info1.getPCValue()).equals("")) continue;
            txt = " ";
        }
        if (txt.length() > 0) {
            JTextField jtf1 = new JTextField();
            jtf1.setPreferredSize(new Dimension(panelWidth, 19));
            jp2.add(jtf1);
            this.nodeMap.put(jtf1, nd);
            jtf1.addFocusListener(new dfhFocus());
            jtf1.setText(txt.trim());
            jtf1.setEnabled(!locked);
        }
        return jp;
    }

    int pixelsFromTop(JComponent comp) {
        int dist = 0;
        JComponent parent = (JComponent)comp.getParent();
        dist += comp.getY();
        while (parent != this.topPanel) {
            comp = parent;
            parent = (JComponent)comp.getParent();
            dist += comp.getY();
        }
        return dist;
    }

    public static Object createObject(Constructor constructor, Object[] arguments) {
        Object object = null;
        try {
            object = constructor.newInstance(arguments);
            return object;
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return object;
    }

    private DefaultMutableTreeNode getReferencedNode(DefaultMutableTreeNode root, String id) {
        Enumeration<TreeNode> enumeration = root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode curNode = (DefaultMutableTreeNode)enumeration.nextElement();
            NodeInfo curni = (NodeInfo)curNode.getUserObject();
            String idval = curni.getAttrValue("id");
            if (idval == null || !idval.equals(id)) continue;
            return curNode;
        }
        return null;
    }

    private DefaultMutableTreeNode getRefsNode(DefaultMutableTreeNode node) {
        DefaultMutableTreeNode ret = null;
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode kid = (DefaultMutableTreeNode)enumeration.nextElement();
            if (kid == null) {
                return ret;
            }
            String name = ((NodeInfo)kid.getUserObject()).getName();
            if (!name.equals("references")) continue;
            if (kid.getChildCount() < 1) {
                return ret;
            }
            DefaultMutableTreeNode textNode = (DefaultMutableTreeNode)kid.getFirstChild();
            String tname = ((NodeInfo)textNode.getUserObject()).getName();
            if (tname.equalsIgnoreCase("#PCDATA")) {
                String val = textNode.toString().trim();
                if (val == null || val.equals("")) {
                    return ret;
                }
                return kid;
            }
            return ret;
        }
        return ret;
    }

    class dfhFocus
    extends FocusAdapter {
        dfhFocus() {
        }

        public void focusLost(FocusEvent event) {
            Object object = event.getSource();
            if (object instanceof JTextField) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)XMLPanels.this.nodeMap.get(object);
                JTextField textField = (JTextField)object;
                if (!textField.getText().trim().equals("")) {
                    NodeInfo cni = null;
                    for (DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)nd.getParent(); parentNode != null; parentNode = (DefaultMutableTreeNode)parentNode.getParent()) {
                        cni = (NodeInfo)parentNode.getUserObject();
                        if (!cni.isCheckbox() && !cni.isChoice() || cni.isSelected()) continue;
                        cni.setSelected(true);
                    }
                    if (XMLPanels.this.container != null) {
                        // empty if block
                    }
                    if (XMLPanels.this.tree != null) {
                        XMLPanels.this.tree.repaint();
                    }
                }
                NodeInfo info = (NodeInfo)nd.getUserObject();
                String temp = ((JTextField)object).getText().trim();
                ((JTextField)object).setText(temp);
                info.setPCValue(temp);
                if (XMLPanels.this.treeModel != null) {
                    // empty if block
                }
            }
        }

        public void focusGained(FocusEvent event) {
            Object object = event.getSource();
            if (object instanceof JTextField) {
                int dist = XMLPanels.this.pixelsFromTop((JComponent)object);
                XMLPanels.this.topPanel.scrollRectToVisible(new Rectangle(0, dist, 50, 50));
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)XMLPanels.this.nodeMap.get(object);
                DefaultMutableTreeNode prevnd = nd.getPreviousNode();
                if (XMLPanels.this.container != null) {
                    XMLPanels.this.container.setTreeValueFlag(false);
                    TreePath tp = new TreePath(prevnd.getPath());
                    XMLPanels.this.tree.setSelectionPath(tp);
                    XMLPanels.this.tree.scrollPathToVisible(tp);
                }
            }
        }
    }

    class dfhAction
    implements ActionListener {
        dfhAction() {
        }

        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object instanceof JTextField) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)XMLPanels.this.nodeMap.get(object);
                NodeInfo info = (NodeInfo)nd.getUserObject();
                String temp = ((JTextField)object).getText().trim();
                ((JTextField)object).setText(temp);
                info.setPCValue(temp);
                if (XMLPanels.this.treeModel != null) {
                    XMLPanels.this.treeModel.reload();
                }
            }
        }
    }
}

