/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datastore;

import edu.ucsb.nceas.morpho.Morpho;
import edu.ucsb.nceas.morpho.datapackage.PackageUtil;
import edu.ucsb.nceas.morpho.datastore.CacheAccessException;
import edu.ucsb.nceas.morpho.datastore.DataStoreInterface;
import edu.ucsb.nceas.morpho.framework.ConfigXML;
import edu.ucsb.nceas.morpho.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.util.Hashtable;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DataStore
implements DataStoreInterface {
    private Morpho morpho;
    private ConfigXML config;
    protected String datadir;
    protected String separator;
    protected String cachedir;
    protected String tempdir;

    public DataStore(Morpho morpho) {
        this.morpho = morpho;
        this.config = morpho.getConfiguration();
        ConfigXML profile = morpho.getProfile();
        DataStore dataStore = this;
        String profileDirName = dataStore.config.getConfigDirectory() + File.separator + this.config.get("profile_directory", 0) + File.separator + profile.get("profilename", 0);
        this.datadir = profileDirName + File.separator + profile.get("datadir", 0);
        this.tempdir = profileDirName + File.separator + profile.get("tempdir", 0);
        this.cachedir = profileDirName + File.separator + profile.get("cachedir", 0);
        this.separator = profile.get("separator", 0);
        this.separator = this.separator.trim();
    }

    public void debug(int code, String message) {
        Log.debug(code, message);
    }

    protected String parseId(String id) {
        String path = new String();
        path = id.substring(0, id.indexOf("."));
        path = path + "/" + id.substring(id.indexOf(this.separator) + 1, id.length());
        return path;
    }

    protected String parseIdFromMessage(String message) {
        int docidIndex = message.indexOf("<docid>") + 1;
        int afterDocidIndex = docidIndex + 6;
        String docid = message.substring(afterDocidIndex, message.indexOf("<", afterDocidIndex));
        this.debug(11, "docid in parseIdFromMessage: " + docid);
        return docid;
    }

    protected String insertIdInFile(File file, String id) {
        NodeList idNL;
        Document doc;
        String catalogPath = this.config.get("local_catalog_path", 0);
        try {
            doc = PackageUtil.getDoc(file, catalogPath);
        }
        catch (Exception e) {
            this.debug(20, "Error getting a DOM rep. of file.  This is probably a data file: " + file.getPath() + " : " + e.getMessage());
            return null;
        }
        DocumentType dt = doc.getDoctype();
        String doctype = dt.getPublicId();
        Hashtable docatts = PackageUtil.getConfigFileTypeAttributes(this.morpho, "xmlfiletype");
        Hashtable h = (Hashtable)docatts.get(doctype);
        if (h == null) {
            return null;
        }
        if (h.get("idpath") == null) {
            return null;
        }
        String idpath = (String)h.get("idpath");
        try {
            idNL = XPathAPI.selectNodeList((Node)doc, (String)idpath);
        }
        catch (Exception ee) {
            this.debug(0, "Error XPath searching file: " + file.getPath() + " : " + ee.getMessage());
            return null;
        }
        String idNodeName = idpath.substring(idpath.lastIndexOf("/") + 1, idpath.length()).trim();
        this.debug(19, "idNodeName: " + idNodeName);
        if (idNL.getLength() != 0) {
            for (int i = 0; i < idNL.getLength(); ++i) {
                Node n = idNL.item(i);
                String nname = n.getNodeName();
                if (!nname.equals(idNodeName)) continue;
                if (n.getFirstChild() != null) {
                    n.getFirstChild().setNodeValue(id);
                    continue;
                }
                Text txtnode = doc.createTextNode(id);
                n.appendChild(txtnode);
            }
        }
        return PackageUtil.printDoctype(doc) + PackageUtil.print(doc.getDocumentElement());
    }

    public abstract File openFile(String var1) throws FileNotFoundException, CacheAccessException;

    public abstract File saveFile(String var1, Reader var2) throws Exception;

    public abstract File newFile(String var1, Reader var2) throws Exception;

    public abstract boolean deleteFile(String var1) throws Exception;
}

