/*
 * Decompiled with CFR 0.152.
 */
package tmap_30.map;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import tmap_30.map.MapConstants;
import tmap_30.map.MapGrid;
import tmap_30.map.MapRegion;
import tmap_30.map.MapTool;
import tmap_30.map.MaxZoomException;
import tmap_30.map.MinZoomException;

public class MapCanvas
extends Canvas
implements MapConstants {
    MapScroller scroller;
    Image base_image;
    Image gray_image;
    Dimension offDimension;
    Image offImage;
    Graphics offGraphics;
    int width;
    int height;
    int clip_width;
    int clip_height;
    double image_scaling = 1.0;
    Rectangle imageRect = new Rectangle(0, 0, 0, 0);
    private boolean scrollSuspended;
    private int slow_delta = 1;
    private int fast_delta = 5;
    public boolean pan_down = false;
    public boolean pan_down_fast = false;
    public boolean pan_left = false;
    public boolean pan_left_fast = false;
    public boolean pan_right = false;
    public boolean pan_right_fast = false;
    public boolean pan_up = false;
    public boolean pan_up_fast = false;
    public boolean tool_driven = true;
    public double zoom_factor = 1.4;
    public double max_img_scaling = 4.0;
    public double min_img_scaling = 0.25;
    public MapTool[] toolArray;
    public MapRegion[] regionArray;
    private int selected_tool;
    public MapGrid grid;

    public boolean panning() {
        boolean bl = false;
        if (this.tool_driven) {
            if (this.getTool().pan_left) {
                if (this.getTool().pan_left_fast) {
                    this.scroll_X(this.fast_delta);
                } else {
                    this.scroll_X(this.slow_delta);
                }
                bl = true;
            } else if (this.getTool().pan_right) {
                if (this.getTool().pan_right_fast) {
                    this.scroll_X(-this.fast_delta);
                } else {
                    this.scroll_X(-this.slow_delta);
                }
                bl = true;
            }
            if (this.getTool().pan_down) {
                if (this.getTool().pan_down_fast) {
                    this.scroll_Y(-this.fast_delta);
                } else {
                    this.scroll_Y(-this.slow_delta);
                }
                bl = true;
            } else if (this.getTool().pan_up) {
                if (this.getTool().pan_up_fast) {
                    this.scroll_Y(this.fast_delta);
                } else {
                    this.scroll_Y(this.slow_delta);
                }
                bl = true;
            }
        } else {
            if (this.pan_left) {
                if (this.pan_left_fast) {
                    this.scroll_X(this.fast_delta);
                } else {
                    this.scroll_X(this.slow_delta);
                }
                bl = true;
            } else if (this.pan_right) {
                if (this.pan_right_fast) {
                    this.scroll_X(-this.fast_delta);
                } else {
                    this.scroll_X(-this.slow_delta);
                }
                bl = true;
            }
            if (this.pan_down) {
                if (this.pan_down_fast) {
                    this.scroll_Y(-this.fast_delta);
                } else {
                    this.scroll_Y(-this.slow_delta);
                }
                bl = true;
            } else if (this.pan_up) {
                if (this.pan_up_fast) {
                    this.scroll_Y(this.fast_delta);
                } else {
                    this.scroll_Y(this.slow_delta);
                }
                bl = true;
            }
            this.getTool().setUser_XY();
        }
        return bl;
    }

    public MapCanvas(Image image, int n, int n2, MapTool[] mapToolArray, MapGrid mapGrid) {
        this.base_image = image;
        this.width = n;
        this.height = n2;
        this.toolArray = mapToolArray;
        this.grid = mapGrid;
        this.grid.setCanvasWidth(n);
        GrayFilter grayFilter = new GrayFilter();
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), grayFilter);
        this.gray_image = this.createImage(filteredImageSource);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.gray_image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("MapCanvas: " + interruptedException);
        }
        if (mediaTracker.isErrorID(1)) {
            System.out.println("MapCanvas: Error creating gray image.");
        }
        this.scale_image_to_fit();
        this.scroller = new MapScroller();
        this.scroller.setPriority(1);
        this.scroller.start();
    }

    public MapCanvas(Image image, int n, int n2, MapTool[] mapToolArray, MapGrid mapGrid, int n3, int n4, double d) {
        this.base_image = image;
        this.width = n;
        this.height = n2;
        this.toolArray = mapToolArray;
        this.grid = mapGrid;
        this.grid.setCanvasWidth(n);
        GrayFilter grayFilter = new GrayFilter();
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), grayFilter);
        this.gray_image = this.createImage(filteredImageSource);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(this.gray_image, 1);
        try {
            mediaTracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("MapCanvas: " + interruptedException);
        }
        if (mediaTracker.isErrorID(1)) {
            System.out.println("MapCanvas: Error creating gray image.");
        }
        this.position_and_scale_image(n3, n4, d);
        this.scroller = new MapScroller();
        this.scroller.setPriority(1);
        this.scroller.start();
    }

    public synchronized void update(Graphics graphics) {
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension;
        this.offDimension = dimension = this.size();
        this.offImage = this.createImage(dimension.width, dimension.height);
        this.offGraphics = this.offImage.getGraphics();
        this.offGraphics.setColor(Color.gray);
        this.offGraphics.fillRect(0, 0, this.width, this.height);
        this.offGraphics.clipRect(0, 0, this.clip_width, this.clip_height);
        this.offGraphics.drawImage(this.gray_image, this.imageRect.x, this.imageRect.y, this.imageRect.width, this.imageRect.height, this);
        this.offGraphics.drawImage(this.gray_image, this.imageRect.x + this.imageRect.width, this.imageRect.y, this.imageRect.width, this.imageRect.height, this);
        double d = this.grid.domain_X[1] - this.grid.domain_X[0];
        double d2 = this.getTool().range_X[1] - this.getTool().range_X[0];
        if (Math.abs(d) == Math.abs(d2)) {
            n2 = 0;
            n = this.clip_width;
        } else {
            n2 = this.grid.userToPixel_X(this.getTool().range_X[0]);
            n = this.grid.userToPixel_X(this.getTool().range_X[1]);
        }
        if (n < n2) {
            if (n2 > this.clip_width) {
                n2 = 0;
            } else {
                n = this.clip_width;
            }
        }
        int n3 = n - n2;
        int n4 = this.grid.userToPixel_Y(this.getTool().range_Y[1]);
        int n5 = this.grid.userToPixel_Y(this.getTool().range_Y[0]);
        int n6 = n5 - n4;
        this.offGraphics.clipRect(n2, n4, n3, n6);
        this.offGraphics.drawImage(this.base_image, this.imageRect.x, this.imageRect.y, this.imageRect.width, this.imageRect.height, this);
        this.offGraphics.drawImage(this.base_image, this.imageRect.x + this.imageRect.width, this.imageRect.y, this.imageRect.width, this.imageRect.height, this);
        this.offGraphics.clipRect(0, 0, this.clip_width, this.clip_height);
        int n7 = 0;
        while (n7 < this.toolArray.length) {
            this.toolArray[n7].draw(this.offGraphics);
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.regionArray.length) {
            this.regionArray[n8].draw(this.offGraphics);
            ++n8;
        }
        graphics.clipRect(0, 0, this.width, this.height);
        graphics.drawImage(this.offImage, 0, 0, this);
    }

    public synchronized void scroll_X(int n) {
        int n2 = n;
        this.imageRect.x += n;
        if (this.grid.modulo_X) {
            if (this.imageRect.x <= -this.imageRect.width) {
                this.imageRect.x += this.imageRect.width;
            }
            if (this.imageRect.x > 0) {
                this.imageRect.x -= this.imageRect.width;
            }
        } else {
            if (this.imageRect.x + this.imageRect.width < this.width) {
                this.imageRect.x = this.width - this.imageRect.width;
                n2 = 0;
            }
            if (this.imageRect.x > 0) {
                this.imageRect.x = 0;
                n2 = 0;
            }
        }
        int n3 = 0;
        while (n3 < this.selected_tool) {
            if (this.grid.modulo_X) {
                if (this.toolArray[n3].x + n2 + this.toolArray[n3].width < 0) {
                    n2 += this.imageRect.width;
                }
                if (this.toolArray[n3].x + n2 > this.width) {
                    n2 -= this.imageRect.width;
                }
            }
            this.toolArray[n3].setLocation(this.toolArray[n3].x + n2, this.toolArray[n3].y);
            ++n3;
        }
        int n4 = this.selected_tool + 1;
        while (n4 < this.toolArray.length) {
            if (this.grid.modulo_X) {
                if (this.toolArray[n4].x + n2 + this.toolArray[n4].width < 0) {
                    n2 += this.imageRect.width;
                }
                if (this.toolArray[n4].x + n2 > this.width) {
                    n2 -= this.imageRect.width;
                }
            }
            this.toolArray[n4].setLocation(this.toolArray[n4].x + n2, this.toolArray[n4].y);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.regionArray.length) {
            if (this.grid.modulo_X) {
                if (this.regionArray[n5].x + n2 + this.regionArray[n5].width < 0) {
                    n2 += this.imageRect.width;
                }
                if (this.regionArray[n5].x + n2 > this.width) {
                    n2 -= this.imageRect.width;
                }
            }
            this.regionArray[n5].setLocation(this.regionArray[n5].x + n2, this.regionArray[n5].y);
            ++n5;
        }
    }

    public synchronized void scroll_Y(int n) {
        int n2 = n;
        this.imageRect.y += n;
        if (this.imageRect.y + this.imageRect.height < this.height) {
            this.imageRect.y = this.height - this.imageRect.height;
            n2 = 0;
        }
        if (this.imageRect.y > 0) {
            this.imageRect.y = 0;
            n2 = 0;
        }
        int n3 = 0;
        while (n3 < this.selected_tool) {
            this.toolArray[n3].setLocation(this.toolArray[n3].x, this.toolArray[n3].y + n2);
            ++n3;
        }
        int n4 = this.selected_tool + 1;
        while (n4 < this.toolArray.length) {
            this.toolArray[n4].setLocation(this.toolArray[n4].x, this.toolArray[n4].y + n2);
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.regionArray.length) {
            this.regionArray[n5].setLocation(this.regionArray[n5].x, this.regionArray[n5].y + n2);
            ++n5;
        }
    }

    public synchronized void suspend_scrolling() {
        this.scroller.suspend();
    }

    public synchronized void resume_scrolling() {
        this.scroller.resume();
    }

    private Frame getFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return (Frame)container;
    }

    public synchronized boolean mouseMove(Event event, int n, int n2) {
        int n3 = this.getTool().mouseMove(n, n2);
        this.getFrame().setCursor(n3);
        return false;
    }

    public synchronized boolean mouseDown(Event event, int n, int n2) {
        this.getTool().mouseDown(n, n2);
        if (this.getTool().is_active()) {
            this.repaint();
        }
        return false;
    }

    public synchronized boolean mouseDrag(Event event, int n, int n2) {
        this.getTool().mouseDrag(n, n2);
        if (this.getTool().is_active()) {
            this.repaint();
        }
        return false;
    }

    public synchronized boolean mouseUp(Event event, int n, int n2) {
        this.getTool().mouseUp(n, n2);
        this.repaint();
        return false;
    }

    public synchronized void zoom_in() throws MaxZoomException, MinZoomException {
        this.zoom(this.zoom_factor);
    }

    public synchronized void zoom_out() throws MaxZoomException, MinZoomException {
        this.zoom(1.0 / this.zoom_factor);
    }

    public synchronized void zoom(double d) throws MaxZoomException, MinZoomException {
        Dimension dimension;
        this.getGraphics();
        double d2 = this.image_scaling;
        this.offDimension = dimension = this.size();
        this.offImage = this.createImage(dimension.width, dimension.height);
        this.offGraphics = this.offImage.getGraphics();
        if (this.image_scaling * d > this.max_img_scaling) {
            this.zoom(this.max_img_scaling / this.image_scaling);
            throw new MaxZoomException();
        }
        if (this.image_scaling * d < this.min_img_scaling - 0.01) {
            this.zoom(this.min_img_scaling / this.image_scaling);
            throw new MinZoomException();
        }
        this.image_scaling *= d;
        d = this.image_scaling / d2;
        this.imageRect.width = (int)((double)this.base_image.getWidth(this) * this.image_scaling);
        this.imageRect.height = (int)((double)this.base_image.getHeight(this) * this.image_scaling);
        this.clip_width = this.imageRect.width < this.width ? this.imageRect.width : this.width;
        this.clip_height = this.imageRect.height < this.height ? this.imageRect.height : this.height;
        int n = 0;
        while (n < this.toolArray.length) {
            this.toolArray[n].applyClipRect(0, 0, this.clip_width, this.clip_height);
            ++n;
        }
        this.center_tool(d);
        this.repaint();
    }

    public void center_tool(double d) {
        double[] dArray = new double[this.regionArray.length];
        double[] dArray2 = new double[this.regionArray.length];
        int n = 0;
        while (n < this.regionArray.length) {
            dArray[n] = this.regionArray[n].user_X;
            dArray2[n] = this.regionArray[n].user_Y;
            ++n;
        }
        double[] dArray3 = new double[this.toolArray.length];
        double[] dArray4 = new double[this.toolArray.length];
        int n2 = 0;
        while (n2 < this.toolArray.length) {
            dArray3[n2] = this.toolArray[n2].user_X[0];
            dArray4[n2] = this.toolArray[n2].user_Y[1];
            ++n2;
        }
        if (this.imageRect.width >= this.width) {
            this.imageRect.x = (int)((double)(this.width / 2) - (double)(this.getTool().x + this.getTool().width / 2 - this.imageRect.x) * d);
            this.imageRect.y = (int)((double)(this.height / 2) - (double)(this.getTool().y + this.getTool().height / 2 - this.imageRect.y) * d);
        } else {
            this.imageRect.x = (int)((double)(this.imageRect.width / 2) - (double)(this.getTool().x + this.getTool().width / 2 - this.imageRect.x) * d);
            this.imageRect.y = (int)((double)(this.imageRect.height / 2) - (double)(this.getTool().y + this.getTool().height / 2 - this.imageRect.y) * d);
        }
        int n3 = 0;
        while (n3 < this.toolArray.length) {
            this.toolArray[n3].width = (int)((double)this.toolArray[n3].width * d);
            this.toolArray[n3].height = (int)((double)this.toolArray[n3].height * d);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.regionArray.length) {
            this.regionArray[n4].width = (int)((double)this.regionArray[n4].width * d);
            this.regionArray[n4].height = (int)((double)this.regionArray[n4].height * d);
            ++n4;
        }
        if (!this.grid.modulo_X) {
            if (this.imageRect.width >= this.width) {
                if (this.imageRect.width + this.imageRect.x < this.width) {
                    this.imageRect.x = this.width - this.imageRect.width;
                }
                this.imageRect.x = this.imageRect.x > 0 ? 0 : this.imageRect.x;
            } else {
                this.imageRect.x = 0;
            }
        }
        if (this.imageRect.height >= this.height) {
            if (this.imageRect.height + this.imageRect.y < this.height) {
                this.imageRect.y = this.height - this.imageRect.height;
            }
            this.imageRect.y = this.imageRect.y > 0 ? 0 : this.imageRect.y;
        } else {
            this.imageRect.y = 0;
        }
        this.scroll_X(0);
        this.scroll_Y(0);
        this.clip_width = this.imageRect.width < this.width ? this.imageRect.width : this.width;
        this.clip_height = this.imageRect.height < this.height ? this.imageRect.height : this.height;
        int n5 = 0;
        while (n5 < this.toolArray.length) {
            this.toolArray[n5].applyClipRect(0, 0, this.clip_width, this.clip_height);
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.toolArray.length) {
            this.toolArray[n6].setUserLocation(dArray3[n6], dArray4[n6]);
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.regionArray.length) {
            this.regionArray[n7].setUserLocation(dArray[n7], dArray2[n7]);
            ++n7;
        }
    }

    public int getSelected() {
        return this.selected_tool;
    }

    public MapTool getTool() {
        return this.toolArray[this.selected_tool];
    }

    public MapTool getTool(int n) {
        return this.toolArray[n];
    }

    public void newToolFromOld(int n, MapTool mapTool, MapTool mapTool2) {
        int n2 = 0;
        mapTool.setGrid(this.grid);
        mapTool.setRange_X(mapTool2.range_X[0], mapTool2.range_X[1]);
        mapTool.setRange_Y(mapTool2.range_Y[0], mapTool2.range_Y[1]);
        mapTool.setUser_X(mapTool2.user_X[0], mapTool2.user_X[1]);
        mapTool.setUser_Y(mapTool2.user_Y[0], mapTool2.user_Y[1]);
        mapTool.setSnapping(mapTool2.getSnap_X(), mapTool2.getSnap_Y());
        mapTool.drawHandles = mapTool2.drawHandles;
        this.toolArray[n] = mapTool;
        this.toolArray[n].applyClipRect(0, 0, this.clip_width, this.clip_height);
        n2 = this.getTool().check_for_zero_range();
        if (n2 == 1 || n2 == 3) {
            this.toolArray[n].setUser_X();
        }
        if (n2 == 2 || n2 == 3) {
            this.toolArray[n].setUser_Y();
        }
        this.toolArray[n].saveHandles();
    }

    public void setTool(int n, MapTool mapTool) {
        this.toolArray[n] = mapTool;
        this.toolArray[n].setGrid(this.grid);
        this.toolArray[n].applyClipRect(0, 0, this.clip_width, this.clip_height);
        this.toolArray[n].setUser_XY();
        this.toolArray[n].check_for_zero_range();
        this.toolArray[n].setUser_XY();
        if (n == this.selected_tool) {
            this.toolArray[n].drawHandles = true;
        }
        this.toolArray[n].saveHandles();
    }

    public void setToolArray(MapTool[] mapToolArray) {
        this.toolArray = mapToolArray;
        this.selected_tool = 0;
        mapToolArray[this.selected_tool].drawHandles = true;
        int n = 0;
        while (n < mapToolArray.length) {
            mapToolArray[n].setGrid(this.grid);
            mapToolArray[n].applyClipRect(0, 0, this.clip_width, this.clip_height);
            mapToolArray[n].setUser_XY();
            ++n;
        }
    }

    public void selectTool(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.toolArray[n2].drawHandles = false;
            ++n2;
        }
        this.toolArray[n].drawHandles = true;
        int n3 = n + 1;
        while (n3 < this.toolArray.length) {
            this.toolArray[n3].drawHandles = false;
            ++n3;
        }
        if (this.toolArray[n].getDelta_X() != 0.0) {
            this.grid.setDelta_X(this.toolArray[n].getDelta_X());
        }
        if (this.toolArray[n].getDelta_Y() != 0.0) {
            this.grid.setDelta_Y(this.toolArray[n].getDelta_Y());
        }
        this.selected_tool = n;
        this.repaint();
    }

    public void setRegionArray(MapRegion[] mapRegionArray) {
        this.regionArray = mapRegionArray;
        int n = 0;
        while (n < mapRegionArray.length) {
            mapRegionArray[n].setGrid(this.grid);
            mapRegionArray[n].setUserLocation();
            ++n;
        }
    }

    public void setGrid(MapGrid mapGrid) {
        this.grid = mapGrid;
        this.grid.imageRect = this.imageRect;
        int n = 0;
        while (n < this.toolArray.length) {
            this.toolArray[n].setGrid(this.grid);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.regionArray.length) {
            this.regionArray[n2].setGrid(mapGrid);
            ++n2;
        }
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.base_image = image;
        } else {
            System.out.println("null image passed to MapCanvas.  Reusing previous image.");
        }
        this.scale_image_to_fit();
        this.getGraphics();
        this.repaint();
    }

    public Image get_image() {
        return this.base_image;
    }

    public String get_internals() {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.imageRect.x) + " " + this.imageRect.y + " " + this.image_scaling + " " + this.min_img_scaling + " " + this.max_img_scaling);
        return stringBuffer.toString();
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    void scale_image_to_fit() {
        double d = 1.0;
        double d2 = 1.0;
        d = (double)this.height / (double)this.base_image.getHeight(this);
        double d3 = this.image_scaling = d < (d2 = (double)this.width / (double)this.base_image.getWidth(this)) ? d : d2;
        if (this.image_scaling < 0.1) {
            System.out.println("image scaling = " + this.image_scaling + ", being reset to 0.1.");
            this.image_scaling = 0.1;
        }
        this.min_img_scaling = this.image_scaling;
        this.imageRect.x = 0;
        this.imageRect.y = 0;
        this.imageRect.width = (int)((double)this.base_image.getWidth(this) * this.image_scaling);
        this.imageRect.height = (int)((double)this.base_image.getHeight(this) * this.image_scaling);
        this.grid.imageRect = this.imageRect;
        this.clip_width = this.imageRect.width < this.width ? this.imageRect.width : this.width;
        this.clip_height = this.imageRect.height < this.height ? this.imageRect.height : this.height;
    }

    void position_and_scale_image(int n, int n2, double d) {
        this.image_scaling = d;
        this.imageRect.x = n;
        this.imageRect.y = n2;
        this.imageRect.width = (int)((double)this.base_image.getWidth(this) * this.image_scaling);
        this.imageRect.height = (int)((double)this.base_image.getHeight(this) * this.image_scaling);
        int n3 = 0;
        while (n3 < this.toolArray.length) {
            this.toolArray[n3].grid.imageRect = this.imageRect;
            ++n3;
        }
        this.clip_width = this.imageRect.width < this.width ? this.imageRect.width : this.width;
        this.clip_height = this.imageRect.height < this.height ? this.imageRect.height : this.height;
    }

    class GrayFilter
    extends RGBImageFilter {
        public GrayFilter() {
            MapCanvas.this = MapCanvas.this;
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            int n4 = n3 & 0xFF000000;
            int n5 = (n3 & 0xFF0000) >> 16;
            int n6 = (n3 & 0xFF00) >> 8;
            int n7 = n3 & 0xFF;
            int n8 = 128 + (int)(0.075 * (double)n5 + 0.145 * (double)n6 + 0.027 * (double)n7);
            return n4 | n8 << 16 | n8 << 8 | n8;
        }
    }

    class MapScroller
    extends Thread {
        int sleep_milliseconds = 50;

        public void set_sleep_milliseconds(int n) {
            this.sleep_milliseconds = n;
        }

        public void run() {
            while (true) {
                if (MapCanvas.this.panning()) {
                    MapCanvas.this.repaint();
                }
                Thread.yield();
                try {
                    Thread.sleep(this.sleep_milliseconds);
                }
                catch (InterruptedException interruptedException) {}
                Thread.yield();
            }
        }

        MapScroller() {
            MapCanvas.this = MapCanvas.this;
        }
    }
}

