/*
 * Decompiled with CFR 0.152.
 */
package com.arashpayan.filetree;

import com.arashpayan.filetree.Constants;
import com.arashpayan.filetree.FileTreeListener;
import com.arashpayan.filetree.FileTreeNode;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import javax.swing.JFileChooser;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FileTree
extends JTree {
    protected DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel fileTreeModel;
    protected FileSystemView fsv;
    protected boolean showHiddenFiles;
    protected boolean showFiles;
    protected boolean allowDelete;
    protected boolean navigateOSXApps;

    public FileTree() {
        super(new DefaultTreeModel(new DefaultMutableTreeNode("root")));
        this.fileTreeModel = (DefaultTreeModel)this.treeModel;
        this.showHiddenFiles = false;
        this.showFiles = true;
        this.navigateOSXApps = false;
        this.initComponents();
        this.initListeners();
    }

    public DefaultTreeModel getFileTreeModel() {
        return this.fileTreeModel;
    }

    public File getSelectedFile() {
        TreePath treePath = this.getSelectionPath();
        if (treePath == null) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        FileTreeNode fileTreeNode = (FileTreeNode)treeNode.getUserObject();
        return fileTreeNode.file;
    }

    public File[] getSelectedFiles() {
        TreePath[] treePaths = this.getSelectionPaths();
        if (treePaths == null) {
            return null;
        }
        File[] files = new File[treePaths.length];
        for (int i = 0; i < treePaths.length; ++i) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePaths[i].getLastPathComponent();
            FileTreeNode fileTreeNode = (FileTreeNode)treeNode.getUserObject();
            files[i] = fileTreeNode.file;
        }
        return files;
    }

    private void initComponents() {
        if (Constants.isWindows) {
            this.fsv = FileSystemView.getFileSystemView();
        }
        this.initRoot();
        this.setCellRenderer(new FileTreeCellRenderer());
        this.setEditable(false);
    }

    private void initListeners() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                TreePath path = event.getPath();
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                treeNode.removeAllChildren();
                FileTree.this.populateSubTree(treeNode);
                FileTree.this.fileTreeModel.nodeStructureChanged(treeNode);
            }
        });
        FileTreeListener ftl = new FileTreeListener(this);
        this.addMouseListener(ftl);
    }

    private void initRoot() {
        File[] roots = null;
        roots = Constants.isWindows ? this.fsv.getRoots() : File.listRoots();
        if (roots.length == 1) {
            this.rootNode = new DefaultMutableTreeNode(new FileTreeNode(roots[0]));
            this.populateSubTree(this.rootNode);
        } else if (roots.length > 1) {
            this.rootNode = new DefaultMutableTreeNode("Computer");
            for (File root : roots) {
                this.rootNode.add(new DefaultMutableTreeNode(root));
            }
        } else {
            this.rootNode = new DefaultMutableTreeNode("Error");
        }
        this.fileTreeModel.setRoot(this.rootNode);
    }

    public boolean isDeleteEnabled() {
        return this.allowDelete;
    }

    public boolean isNavigateOSXApps() {
        return this.navigateOSXApps;
    }

    public boolean isShowFiles() {
        return this.showFiles;
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    private void populateSubTree(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof FileTreeNode) {
            FileTreeNode fileTreeNode = (FileTreeNode)userObject;
            Object[] files = fileTreeNode.file.listFiles();
            Arrays.sort(files);
            for (Object file : files) {
                if (((File)file).isFile() && !this.showFiles || !this.showHiddenFiles && ((File)file).isHidden()) continue;
                FileTreeNode subFile = new FileTreeNode((File)file);
                DefaultMutableTreeNode subNode = new DefaultMutableTreeNode(subFile);
                if (((File)file).isDirectory() && (!Constants.isOSX || this.navigateOSXApps || !((File)file).getName().endsWith(".app"))) {
                    subNode.add(new DefaultMutableTreeNode("Fake"));
                }
                node.add(subNode);
            }
        }
    }

    public void setCurrentFile(File currFile) {
        if (currFile == null || !currFile.exists()) {
            return;
        }
        String path = currFile.getPath();
        String[] pathParts = null;
        pathParts = Constants.isWindows ? path.split("\\\\") : path.split(File.separator);
        if (Constants.isWindows) {
            int childCount = this.rootNode.getChildCount();
            DefaultMutableTreeNode myComputer = null;
            for (int i = 0; i < childCount; ++i) {
                FileTreeNode fileTreeNode = (FileTreeNode)((DefaultMutableTreeNode)this.rootNode.getChildAt(i)).getUserObject();
                if (!fileTreeNode.file.getPath().equals("::{20D04FE0-3AEA-1069-A2D8-08002B30309D}")) continue;
                myComputer = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
                TreePath treePath = new TreePath(myComputer.getPath());
                this.expandPath(treePath);
                break;
            }
            DefaultMutableTreeNode currNode = myComputer;
            block1: for (String part : pathParts) {
                childCount = currNode.getChildCount();
                for (int i = 0; i < childCount; ++i) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)currNode.getChildAt(i);
                    FileTreeNode fileTreeNode = (FileTreeNode)childNode.getUserObject();
                    String pathName = fileTreeNode.file.getName();
                    if (pathName.length() == 0) {
                        pathName = fileTreeNode.file.getPath().substring(0, 2);
                    }
                    if (!pathName.equals(part)) continue;
                    TreePath treePath = new TreePath(childNode.getPath());
                    this.expandPath(treePath);
                    this.selectionModel.setSelectionPath(treePath);
                    currNode = childNode;
                    continue block1;
                }
            }
        } else {
            DefaultMutableTreeNode currNode = this.rootNode;
            block3: for (String part : pathParts) {
                int childCount = currNode.getChildCount();
                boolean wasExpanded = false;
                for (int i = 0; i < childCount; ++i) {
                    DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)currNode.getChildAt(i);
                    FileTreeNode fileTreeNode = (FileTreeNode)childNode.getUserObject();
                    if (!fileTreeNode.file.getName().equals(part)) continue;
                    TreePath treePath = new TreePath(childNode.getPath());
                    this.expandPath(treePath);
                    this.selectionModel.setSelectionPath(treePath);
                    currNode = childNode;
                    wasExpanded = true;
                    continue block3;
                }
            }
        }
    }

    public void setDeleteEnabled(boolean allowDelete) {
        this.allowDelete = allowDelete;
    }

    public void setShowFiles(boolean showFiles) {
        if (this.showFiles != showFiles) {
            this.showFiles = showFiles;
            this.initRoot();
        }
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        if (showHiddenFiles != this.showHiddenFiles) {
            this.showHiddenFiles = showHiddenFiles;
            this.initRoot();
        }
    }

    public void setNavigateOSXApps(boolean navigateOSXApps) {
        this.navigateOSXApps = navigateOSXApps;
    }

    private class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private JFileChooser fileChooser = new JFileChooser();

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
            if (userObject instanceof FileTreeNode) {
                FileTreeNode fileTreeNode = (FileTreeNode)userObject;
                if (!Constants.isWindows) {
                    try {
                        this.setIcon(this.fileChooser.getIcon(fileTreeNode.file));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.setIcon(FileTree.this.fsv.getSystemIcon(fileTreeNode.file));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            return this;
        }
    }
}

