/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.AttributePage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CodeDefnPanel;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class NominalOrdinalPanel
extends JPanel
implements WizardPageSubPanelAPI {
    private JPanel currentSubPanel;
    private JPanel textSubPanel;
    private JPanel enumSubPanel;
    private JPanel enumPanel;
    private String enforcedField = "";
    private JLabel textDefinitionLabel;
    private JTextField textDefinitionField;
    private JTextField textSourceField;
    private CustomList textPatternsList;
    private JLabel chooseLabel;
    private JLabel enumDefinitionLabel;
    private CustomList enumDefinitionList;
    private CustomList importedDefinitionList;
    private JLabel codeLocationLabel;
    private JComboBox codeLocationPickList;
    private final String[] codeLocationPicklistVals = new String[]{"Codes are defined here", "Codes are imported from another table"};
    private JPanel tablePanel;
    private JLabel tableNameLabel;
    private JTextField tableNameTextField;
    private JButton tableNameButton;
    private LocateAction locateAction;
    private CodeDefnPanel codeImportPanel = null;
    private JCheckBox enumDefinitionFreeTextCheckBox;
    private final String[] textEnumPicklistVals = new String[]{"Enumerated values (belong to predefined list)", "Text values (free-form or matching a pattern)"};
    private static final String TO_BE_IMPORTED = "Imported later";
    private static final String SELECT_TABLE = "--select table--";
    private static final short CODES_DEFINED_HERE = 10;
    private static final short CODES_IMPORTED = 20;
    private short codeLocationValue = (short)10;
    private final String[] nomOrdDisplayNames = new String[]{"nominal", "ordinal"};
    double[] definedEnumColumnWidthPercentages = new double[]{25.0, 75.0};
    double[] importedEnumColumnWidthPercentages = new double[]{25.0, 75.0};
    private final int ENUMERATED_DOMAIN = 10;
    private final int TEXT_DOMAIN = 20;
    private final String EMPTY_STRING = "";
    private String nonNumericDomainID = "";
    private AbstractUIPage wizardPage;
    private JComboBox domainPickList;
    private OrderedMap returnMap = new OrderedMap();
    private StringBuffer nomOrdBuff = new StringBuffer();

    public NominalOrdinalPanel(AbstractUIPage page) {
        this.wizardPage = page;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        int width = WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.width;
        int height = 7 * WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.height;
        Dimension dims = new Dimension(width, height);
        String TEXT_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Describe a free text domain for the attribute.</html>";
        String ENUM_HELP = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Describe any codes that are used as values of the attribute.</html>";
        final JLabel helpTextLabel = this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Describe any codes that are used as values of the attribute.</html>");
        ItemListener listener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String value = e.getItem().toString();
                Log.debug(45, "PickList state changed: " + value);
                if (value.equals(NominalOrdinalPanel.this.textEnumPicklistVals[0])) {
                    Log.debug(45, NominalOrdinalPanel.this.nomOrdDisplayNames + "/enumeratedDomain selected");
                    NominalOrdinalPanel.this.setTextEnumSubPanel(10);
                    helpTextLabel.setText("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Describe any codes that are used as values of the attribute.</html>");
                } else if (value.equals(NominalOrdinalPanel.this.textEnumPicklistVals[1])) {
                    Log.debug(45, NominalOrdinalPanel.this.nomOrdDisplayNames + "/textDomain selected");
                    NominalOrdinalPanel.this.setTextEnumSubPanel(20);
                    helpTextLabel.setText("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Describe a free text domain for the attribute.</html>");
                }
            }
        };
        this.domainPickList = WidgetFactory.makePickList(this.textEnumPicklistVals, false, 0, listener);
        this.domainPickList.setPreferredSize(new Dimension(200, 10));
        JPanel pickListPanel = WidgetFactory.makePanel();
        this.chooseLabel = WidgetFactory.makeLabel("Choose:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        pickListPanel.add(this.chooseLabel);
        pickListPanel.add(this.domainPickList);
        JPanel measScalePanel = new JPanel();
        measScalePanel.setLayout(new GridLayout(1, 2, 3, 0));
        measScalePanel.add(pickListPanel);
        measScalePanel.add(helpTextLabel);
        this.add(measScalePanel);
        this.add(Box.createGlue());
        this.textSubPanel = this.getTextSubPanel();
        this.currentSubPanel = this.enumSubPanel = this.getEnumSubPanel();
        this.add(this.currentSubPanel);
    }

    private void setTextEnumSubPanel(int newDomain) {
        this.remove(this.currentSubPanel);
        this.currentSubPanel = newDomain == 10 ? this.enumSubPanel : this.textSubPanel;
        this.add(this.currentSubPanel);
        this.textDefinitionField.requestFocus();
        ((AttributePage)this.wizardPage).refreshUI();
    }

    private JPanel getTextSubPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(8);
        panel.add(WidgetFactory.makeHalfSpacer());
        JPanel topHorizPanel = new JPanel();
        topHorizPanel.setLayout(new GridLayout(1, 2));
        JPanel defFieldPanel = WidgetFactory.makePanel();
        this.textDefinitionLabel = WidgetFactory.makeLabel("Definition:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        defFieldPanel.add(this.textDefinitionLabel);
        this.textDefinitionField = WidgetFactory.makeOneLineTextField();
        defFieldPanel.add(this.textDefinitionField);
        topHorizPanel.add(defFieldPanel);
        topHorizPanel.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g: <i>U.S. telephone numbers in the format (999) 888-7777</i></font></html>"));
        panel.add(topHorizPanel);
        panel.add(WidgetFactory.makeHalfSpacer());
        JPanel middleHorizPanel = new JPanel();
        middleHorizPanel.setLayout(new GridLayout(1, 2));
        JPanel srcFieldPanel = WidgetFactory.makePanel();
        srcFieldPanel.add(WidgetFactory.makeLabel("Source:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS));
        this.textSourceField = WidgetFactory.makeOneLineTextField();
        srcFieldPanel.add(this.textSourceField);
        middleHorizPanel.add(srcFieldPanel);
        middleHorizPanel.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g: <i>FIPS standard for postal abbreviations for U.S. states</i></font></html>"));
        panel.add(middleHorizPanel);
        panel.add(WidgetFactory.makeHalfSpacer());
        JPanel bottomHorizPanel = new JPanel();
        bottomHorizPanel.setLayout(new GridLayout(1, 2));
        Object[] colTemplates = new Object[]{new JTextField()};
        JPanel patternPanel = WidgetFactory.makePanel();
        patternPanel.add(WidgetFactory.makeLabel("Pattern(s):", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS));
        String[] colNames = new String[]{"Pattern(s) (optional):"};
        this.textPatternsList = WidgetFactory.makeList(colNames, colTemplates, 2, true, false, false, true, false, false);
        this.textPatternsList.setListButtonDimensions(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        patternPanel.add(this.textPatternsList);
        bottomHorizPanel.add(patternPanel);
        bottomHorizPanel.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Patterns are interpreted as regular expressions constraining allowable character sequences.<font style=\"font-size: 9px;\" color=\"#666666\">  e.g: <i>'[0-9]{3}-[0-9]{3}-[0-9]{4}' allows only numeric digits in the pattern of US phone numbers</i></font></html>"));
        panel.add(bottomHorizPanel);
        return panel;
    }

    private JPanel getEnumSubPanel() {
        JPanel panel = WidgetFactory.makeVerticalPanel(8);
        panel.add(WidgetFactory.makeHalfSpacer());
        JPanel locationPanel = WidgetFactory.makePanel();
        this.codeLocationLabel = WidgetFactory.makeLabel("Location:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        locationPanel.add(this.codeLocationLabel);
        ItemListener listener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                String value = e.getItem().toString();
                Log.debug(45, "CodeLocationPickList state changed: " + value);
                if (value.equals(NominalOrdinalPanel.this.codeLocationPicklistVals[0])) {
                    if (NominalOrdinalPanel.this.codeLocationValue == 20) {
                        NominalOrdinalPanel.this.tablePanel.setVisible(false);
                        NominalOrdinalPanel.this.enumPanel.remove(NominalOrdinalPanel.this.importedDefinitionList);
                        NominalOrdinalPanel.this.enumPanel.add(NominalOrdinalPanel.this.enumDefinitionList);
                        NominalOrdinalPanel.this.enumPanel.invalidate();
                    }
                    NominalOrdinalPanel.this.codeLocationValue = (short)10;
                } else if (value.equals(NominalOrdinalPanel.this.codeLocationPicklistVals[1])) {
                    if (NominalOrdinalPanel.this.codeLocationValue == 10) {
                        NominalOrdinalPanel.this.tablePanel.setVisible(true);
                        NominalOrdinalPanel.this.enumPanel.remove(NominalOrdinalPanel.this.enumDefinitionList);
                        NominalOrdinalPanel.this.enumPanel.add(NominalOrdinalPanel.this.importedDefinitionList);
                        NominalOrdinalPanel.this.enumPanel.invalidate();
                    }
                    NominalOrdinalPanel.this.codeLocationValue = (short)20;
                }
            }
        };
        this.codeLocationPickList = WidgetFactory.makePickList(this.codeLocationPicklistVals, false, 0, listener);
        this.codeLocationPickList.setPreferredSize(new Dimension(200, 10));
        locationPanel.add(this.codeLocationPickList);
        this.tablePanel = WidgetFactory.makePanel();
        this.tableNameLabel = this.getLabel("Table Name:  ");
        this.tableNameLabel.setForeground(WizardSettings.WIZARD_CONTENT_REQD_TEXT_COLOR);
        this.tablePanel.add(this.tableNameLabel);
        this.tableNameTextField = WidgetFactory.makeOneLineTextField(SELECT_TABLE);
        this.tableNameTextField.setEditable(false);
        this.tablePanel.add(this.tableNameTextField);
        this.locateAction = new LocateAction(this.wizardPage);
        this.tableNameButton = WidgetFactory.makeJButton("locate", this.locateAction);
        this.tableNameButton.setMinimumSize(new Dimension(55, 17));
        this.tableNameButton.setMaximumSize(new Dimension(55, 17));
        this.tableNameButton.setMargin(new Insets(0, 2, 1, 2));
        JPanel tableNameButtonPanel = new JPanel(new BorderLayout());
        tableNameButtonPanel.add((Component)this.tableNameButton, "Center");
        tableNameButtonPanel.setBorder(new EmptyBorder(0, 10, 0, 5));
        if (!this.isAnyDataTablePresent()) {
            this.tableNameTextField.setText(TO_BE_IMPORTED);
            this.tableNameButton.setEnabled(false);
        }
        this.tablePanel.add(tableNameButtonPanel);
        this.tablePanel.setVisible(false);
        JPanel importPanel = new JPanel();
        importPanel.setLayout(new GridLayout(1, 2, 3, 0));
        importPanel.add(locationPanel);
        importPanel.add(this.tablePanel);
        panel.add(importPanel);
        panel.add(WidgetFactory.makeHalfSpacer());
        Object[] colTemplates = new Object[]{new JTextField(), new JTextField()};
        String[] colNames = new String[]{"Code", "Definition"};
        this.enumPanel = WidgetFactory.makePanel();
        this.enumDefinitionLabel = WidgetFactory.makeLabel("Definitions:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        this.enumPanel.add(this.enumDefinitionLabel);
        this.enumDefinitionList = WidgetFactory.makeList(colNames, colTemplates, 2, true, false, false, true, false, false);
        this.importedDefinitionList = WidgetFactory.makeList(colNames, colTemplates, 2, false, false, false, false, false, false);
        this.importedDefinitionList.setBorder(new EmptyBorder(0, 0, 1, 5));
        this.enumDefinitionList.setColumnWidthPercentages(this.definedEnumColumnWidthPercentages);
        this.importedDefinitionList.setColumnWidthPercentages(this.importedEnumColumnWidthPercentages);
        this.enumDefinitionList.setListButtonDimensions(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.enumPanel.add(this.enumDefinitionList);
        panel.add(this.enumPanel);
        JPanel helpPanel = new JPanel();
        helpPanel.setLayout(new GridLayout(1, 7));
        helpPanel.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">Example:</font></html>"));
        helpPanel.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">CA</font></html>"));
        helpPanel.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><left><font style=\"font-size: 9px;\" color=\"#666666\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;California</font></left></html>"));
        helpPanel.add(this.getLabel(""));
        helpPanel.add(this.getLabel(""));
        helpPanel.add(this.getLabel(""));
        helpPanel.add(this.getLabel(""));
        panel.add(WidgetFactory.makeHalfSpacer());
        this.enumDefinitionFreeTextCheckBox = WidgetFactory.makeCheckBox("Attribute contains free-text in addition to those values listed above", false);
        JPanel cbPanel = WidgetFactory.makePanel();
        cbPanel.add(this.enumDefinitionFreeTextCheckBox);
        cbPanel.add(Box.createGlue());
        panel.add(cbPanel);
        return panel;
    }

    boolean isAnyDataTablePresent() {
        AbstractDataPackage adp = this.getADP();
        if (adp == null) {
            return false;
        }
        return adp.getEntityCount() > 0;
    }

    private AbstractDataPackage getADP() {
        AbstractDataPackage adp = null;
        DataViewContainerPanel resultPane = null;
        MorphoFrame morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (morphoFrame != null) {
            resultPane = morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null) {
            adp = resultPane.getAbstractDataPackage();
        }
        return adp;
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public void onLoadAction() {
        WidgetFactory.unhiliteComponent(this.enumDefinitionLabel);
        WidgetFactory.unhiliteComponent(this.textDefinitionLabel);
    }

    public boolean validateUserInput() {
        if (this.currentSubPanel == this.enumSubPanel) {
            WidgetFactory.unhiliteComponent(this.enumDefinitionLabel);
            WidgetFactory.unhiliteComponent(this.tableNameLabel);
            String loc = (String)this.codeLocationPickList.getSelectedItem();
            if (loc.equals(this.codeLocationPicklistVals[1])) {
                if (this.tableNameTextField.getText().equals(SELECT_TABLE)) {
                    WidgetFactory.hiliteComponent(this.tableNameLabel);
                    return false;
                }
            } else if (!this.isEnumListDataValid()) {
                WidgetFactory.hiliteComponent(this.enumDefinitionLabel);
                return false;
            }
        } else {
            WidgetFactory.unhiliteComponent(this.textDefinitionLabel);
            if (this.textDefinitionField.getText().trim().equals("")) {
                WidgetFactory.hiliteComponent(this.textDefinitionLabel);
                this.textDefinitionField.requestFocus();
                return false;
            }
            this.textPatternsList.deleteEmptyRows((short)51, new short[]{10});
        }
        return true;
    }

    public OrderedMap getPanelData(String xPathRoot) {
        String enforced;
        this.returnMap.clear();
        String id = this.nonNumericDomainID.trim();
        if (id != null && !id.equals("")) {
            this.returnMap.put((Object)(xPathRoot + "/nonNumericDomain/@id"), (Object)id);
        }
        if ((enforced = this.enforcedField.trim()) != null && !enforced.equals("")) {
            this.returnMap.put((Object)(xPathRoot + "/nonNumericDomain/enumeratedDomain[1]/@enforced"), (Object)enforced);
        }
        this.nomOrdBuff.delete(0, this.nomOrdBuff.length());
        this.nomOrdBuff.append(xPathRoot);
        this.nomOrdBuff.append("/nonNumericDomain/");
        xPathRoot = this.nomOrdBuff.toString();
        if (this.currentSubPanel == this.enumSubPanel) {
            if (this.codeLocationValue == 10) {
                this.getEnumListData(xPathRoot + "enumeratedDomain[1]", this.returnMap);
            } else {
                if (this.codeImportPanel == null) {
                    this.codeImportPanel = new CodeDefnPanel();
                }
                OrderedMap importMap = this.codeImportPanel.getPanelData(xPathRoot + "enumeratedDomain[1]/entityCodeList");
                this.returnMap.putAll((Map)importMap);
            }
            if (this.enumDefinitionFreeTextCheckBox.isSelected()) {
                this.returnMap.put((Object)(xPathRoot + "textDomain[1]/definition"), (Object)"Free text (unrestricted)");
                this.returnMap.put((Object)(xPathRoot + "textDomain[1]/pattern[1]"), (Object)".*");
            }
        } else {
            this.returnMap.put((Object)(xPathRoot + "textDomain[1]/definition"), (Object)this.textDefinitionField.getText().trim());
            int index = 1;
            List rowLists = this.textPatternsList.getListOfRowLists();
            String nextStr = null;
            for (Object nextRowObj : rowLists) {
                List nextRow;
                if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
                nextStr = (String)nextRow.get(0);
                this.nomOrdBuff.delete(0, this.nomOrdBuff.length());
                this.nomOrdBuff.append(xPathRoot);
                this.nomOrdBuff.append("textDomain[1]/pattern[");
                this.nomOrdBuff.append(index++);
                this.nomOrdBuff.append("]");
                this.returnMap.put((Object)this.nomOrdBuff.toString(), (Object)nextStr);
            }
            String source = this.textSourceField.getText().trim();
            if (!source.equals("")) {
                this.returnMap.put((Object)(xPathRoot + "textDomain[1]/source"), (Object)source);
            }
        }
        return this.returnMap;
    }

    private void getEnumListData(String xpathRoot, OrderedMap resultsMap) {
        this.enumDefinitionList.deleteEmptyRows((short)51, new short[]{10, 30});
        int index = 1;
        StringBuffer buff = new StringBuffer();
        List rowLists = this.enumDefinitionList.getListOfRowLists();
        Object srcObj = null;
        Object srcStr = null;
        for (Object nextRowObj : rowLists) {
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            buff.delete(0, buff.length());
            buff.append(xpathRoot);
            buff.append("/codeDefinition[");
            buff.append(index++);
            buff.append("]/");
            resultsMap.put((Object)(buff.toString() + "code"), (Object)((String)nextRow.get(0)).trim());
            srcObj = nextRow.get(1);
            if (srcObj == null) continue;
            resultsMap.put((Object)(buff.toString() + "definition"), (Object)((String)srcObj).trim());
        }
    }

    public boolean isImportNeeded() {
        if (this.codeLocationValue == 10) {
            return false;
        }
        if (this.codeImportPanel == null) {
            return true;
        }
        return this.codeImportPanel.getTableName() == null;
    }

    private boolean isEnumListDataValid() {
        this.enumDefinitionList.deleteEmptyRows((short)61, new short[]{10, 10});
        List rowLists = this.enumDefinitionList.getListOfRowLists();
        if (rowLists == null || rowLists.size() < 1) {
            return false;
        }
        for (Object nextRowObj : rowLists) {
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1 || nextRow.get(0) != null && nextRow.get(1) != null && !((String)nextRow.get(0)).trim().equals("") && !((String)nextRow.get(1)).trim().equals("")) continue;
            return false;
        }
        return true;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
        String defn;
        String enforced;
        Log.debug(50, "datapackagewizard: NominalOrdinalPanel.setPanelData() called with xPathRoot = " + xPathRoot);
        String id = (String)map.get((Object)(xPathRoot + "/@id"));
        if (id != null) {
            this.nonNumericDomainID = id.toString();
            map.remove((Object)(xPathRoot + "/@id"));
        }
        if ((enforced = (String)map.get((Object)(xPathRoot + "/enumeratedDomain[1]/@enforced"))) != null && !enforced.equals("")) {
            this.enforcedField = enforced.toString();
            map.remove((Object)(xPathRoot + "enumeratedDomain[1]/@enforced"));
        } else {
            enforced = (String)map.get((Object)(xPathRoot + "/enumeratedDomain/@enforced"));
            if (enforced != null && !enforced.equals("")) {
                this.enforcedField = enforced.toString();
                map.remove((Object)(xPathRoot + "/enumeratedDomain/@enforced"));
            }
        }
        boolean b1 = map.containsKey((Object)(xPathRoot + "/enumeratedDomain[1]/entityCodeList/entityReference"));
        if (!b1) {
            b1 = map.containsKey((Object)(xPathRoot + "/enumeratedDomain/entityCodeList/entityReference"));
        }
        if ((defn = (String)map.get((Object)(xPathRoot + "/textDomain[1]/definition"))) == null) {
            defn = (String)map.get((Object)(xPathRoot + "/textDomain/definition"));
            if (defn != null) {
                map.remove((Object)(xPathRoot + "/textDomain/definition"));
            }
        } else {
            map.remove((Object)(xPathRoot + "/textDomain[1]/definition"));
        }
        if (defn != null) {
            if (defn.equals("Free text (unrestricted)")) {
                this.enumDefinitionFreeTextCheckBox.setSelected(true);
            } else {
                this.enumDefinitionFreeTextCheckBox.setSelected(false);
            }
        }
        if (b1) {
            this.locateAction.setPageData(xPathRoot + "/enumeratedDomain/entityCodeList", map);
            this.tablePanel.setVisible(true);
            if (this.codeLocationValue == 10) {
                this.enumPanel.remove(this.enumDefinitionList);
                this.enumPanel.add(this.importedDefinitionList);
                this.enumPanel.invalidate();
            }
            this.codeLocationPickList.setSelectedItem(this.codeLocationPicklistVals[1]);
            this.codeLocationValue = (short)20;
            this.domainPickList.setSelectedItem(this.textEnumPicklistVals[0]);
            return;
        }
        boolean found = this.setEnumListData(xPathRoot + "/enumeratedDomain[1]", map);
        if (!found) {
            found = this.setEnumListData(xPathRoot + "/enumeratedDomain", map);
        }
        if (found) {
            this.tablePanel.setVisible(false);
            if (this.codeLocationValue == 20) {
                this.enumPanel.remove(this.importedDefinitionList);
                this.enumPanel.add(this.enumDefinitionList);
                this.enumPanel.invalidate();
            }
            this.codeLocationValue = (short)10;
            this.codeLocationPickList.setSelectedItem(this.codeLocationPicklistVals[0]);
            this.domainPickList.setSelectedItem(this.textEnumPicklistVals[0]);
            return;
        }
        if (defn != null) {
            this.textDefinitionField.setText(defn);
            this.domainPickList.setSelectedItem(this.textEnumPicklistVals[1]);
        }
        this.setTextListData(xPathRoot + "/textDomain[1]", map);
        this.setTextListData(xPathRoot + "/textDomain", map);
        String source = (String)map.get((Object)(xPathRoot + "/textDomain[1]/source"));
        if (source == null) {
            source = (String)map.get((Object)(xPathRoot + "/textDomain/source"));
            if (source != null) {
                map.remove((Object)(xPathRoot + "/textDomain/source"));
            }
        } else {
            map.remove((Object)(xPathRoot + "/textDomain[1]/source"));
        }
        if (source != null) {
            this.textSourceField.setText(source);
        }
    }

    private boolean setEnumListData(String xPathRoot, OrderedMap map) {
        int index = 1;
        boolean codePresent = false;
        while (true) {
            ArrayList<String> row = new ArrayList<String>();
            String code = (String)map.get((Object)(xPathRoot + "/codeDefinition[" + index + "]/code"));
            if (code != null) {
                map.remove((Object)(xPathRoot + "/codeDefinition[" + index + "]/code"));
            }
            if (index == 1 && code == null && (code = (String)map.get((Object)(xPathRoot + "/codeDefinition/code"))) != null) {
                map.remove((Object)(xPathRoot + "/codeDefinition/code"));
            }
            if (code == null) break;
            codePresent = true;
            row.add(code);
            String defn = (String)map.get((Object)(xPathRoot + "/codeDefinition[" + index + "]/definition"));
            if (defn != null) {
                map.remove((Object)(xPathRoot + "/codeDefinition[" + index + "]/definition"));
            }
            if (index == 1 && defn == null && (defn = (String)map.get((Object)(xPathRoot + "/codeDefinition/definition"))) != null) {
                map.remove((Object)(xPathRoot + "/codeDefinition/definition"));
            }
            row.add(defn);
            this.enumDefinitionList.addRow(row);
            ++index;
        }
        return codePresent;
    }

    private void setTextListData(String xPathRoot, OrderedMap map) {
        int index = 1;
        while (true) {
            ArrayList<String> row = new ArrayList<String>();
            String pattern = (String)map.get((Object)(xPathRoot + "/pattern[" + index + "]"));
            if (pattern != null) {
                map.remove((Object)(xPathRoot + "/pattern[" + index + "]"));
            }
            if (index == 1 && pattern == null && (pattern = (String)map.get((Object)(xPathRoot + "/pattern"))) != null) {
                map.remove((Object)(xPathRoot + "/pattern"));
            }
            if (pattern == null) break;
            row.add(pattern);
            this.textPatternsList.addRow(row);
            ++index;
        }
    }

    public List getTextList() {
        return this.textPatternsList.getListOfRowLists();
    }

    class LocateAction
    extends AbstractAction {
        private AbstractUIPage attributePage;
        private Dimension DIALOG_SIZE = new Dimension(500, 450);
        private JDialog importDialog = null;

        LocateAction(AbstractUIPage page) {
            this.attributePage = page;
        }

        public void actionPerformed(ActionEvent ae) {
            if (NominalOrdinalPanel.this.codeImportPanel == null) {
                NominalOrdinalPanel.this.codeImportPanel = new CodeDefnPanel();
            }
            if (this.importDialog == null) {
                ActionListener okAction = new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        LocateAction.this.okAction();
                    }
                };
                ActionListener cancelAction = new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        LocateAction.this.cancelAction();
                    }
                };
                Point loc = this.attributePage.getLocationOnScreen();
                int xc = (int)(loc.getX() + (double)(this.attributePage.getWidth() / 2) - (double)(this.DIALOG_SIZE.width / 2));
                int yc = (int)(loc.getY() + (double)(this.attributePage.getHeight() / 2) - (double)(this.DIALOG_SIZE.height / 2));
                this.importDialog = WidgetFactory.makeContainerDialogNoParent(NominalOrdinalPanel.this.codeImportPanel, okAction, cancelAction);
                this.importDialog.setBounds(xc, yc, this.DIALOG_SIZE.width, this.DIALOG_SIZE.height);
            }
            this.importDialog.setVisible(true);
        }

        private void okAction() {
            if (!NominalOrdinalPanel.this.codeImportPanel.validateUserInput()) {
                return;
            }
            this.importDialog.setVisible(false);
            String tableName = NominalOrdinalPanel.this.codeImportPanel.getTableName();
            if (tableName == null) {
                NominalOrdinalPanel.this.tableNameTextField.setText(NominalOrdinalPanel.TO_BE_IMPORTED);
                NominalOrdinalPanel.this.importedDefinitionList.removeAllRows();
            } else {
                NominalOrdinalPanel.this.tableNameTextField.setText(tableName);
                this.fillCustomList();
            }
        }

        private void cancelAction() {
            this.importDialog.setVisible(false);
        }

        private void fillCustomList() {
            List importedCodes = NominalOrdinalPanel.this.codeImportPanel.getColumnData();
            if (importedCodes == null) {
                return;
            }
            Iterator it = importedCodes.iterator();
            NominalOrdinalPanel.this.importedDefinitionList.removeAllRows();
            while (it.hasNext()) {
                List row = (List)it.next();
                NominalOrdinalPanel.this.importedDefinitionList.addRow(row);
            }
            NominalOrdinalPanel.this.importedDefinitionList.fireEditingStopped();
            NominalOrdinalPanel.this.importedDefinitionList.setEditable(false);
            NominalOrdinalPanel.this.importedDefinitionList.scrollToRow(0);
        }

        public void setPageData(String xPath, OrderedMap map) {
            if (NominalOrdinalPanel.this.codeImportPanel == null) {
                NominalOrdinalPanel.this.codeImportPanel = new CodeDefnPanel();
            }
            NominalOrdinalPanel.this.codeImportPanel.setPanelData(xPath, map);
            String name = NominalOrdinalPanel.this.codeImportPanel.getTableName();
            if (name == null) {
                NominalOrdinalPanel.this.tableNameTextField.setText(NominalOrdinalPanel.TO_BE_IMPORTED);
            } else {
                NominalOrdinalPanel.this.tableNameTextField.setText(name);
                this.fillCustomList();
            }
        }
    }
}

