/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageLibrary;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.KeywordsPage;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;

public class Keywords
extends AbstractUIPage {
    private final String pageID = "KEYWORDS";
    private final String nextPageID = "PARTY_INTRO";
    private final String title = "Keywords";
    private final String subtitle = "";
    private final String KEYWORDSET_REL_XPATH = "/keywordSet[";
    private String xPathRoot = "/eml:eml/dataset/keywordSet[";
    private final String pageNumber = "3";
    private final String[] colNames = new String[]{"Keywords", "Thesaurus"};
    private final Object[] editors = null;
    private CustomList keywordsList;
    private OrderedMap returnMap = new OrderedMap();

    public Keywords() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        Keywords vbox = this;
        vbox.add(WidgetFactory.makeDefaultSpacer());
        JLabel desc1 = WidgetFactory.makeHTMLLabel("<b>Enter the keywords.</b> A data package may have multiple keywords associated with it to enable easy searching and categorization.  In addition, one or more keywords may be associated with a &quot;keyword thesaurus&quot;, which allows the association of a data package with an authoritative definition. Thesauri may also be used for internal categorization.", 3);
        vbox.add(desc1);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        this.keywordsList = WidgetFactory.makeList(this.colNames, this.editors, 4, true, true, false, true, true, true);
        this.keywordsList.setBorder(new EmptyBorder(0, 5, 5, 10));
        vbox.add(this.keywordsList);
        vbox.add(WidgetFactory.makeDefaultSpacer());
        this.initActions();
    }

    private void initActions() {
        this.keywordsList.setCustomAddAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nKeywords: CustomAddAction called");
                Keywords.this.showNewKeywordsDialog();
            }
        });
        this.keywordsList.setCustomEditAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Log.debug(45, "\nKeywords: CustomEditAction called");
                Keywords.this.showEditKeywordsDialog();
            }
        });
    }

    private void showNewKeywordsDialog() {
        KeywordsPage keywordsPage = (KeywordsPage)WizardPageLibrary.getPage("KEYWORDS_PAGE");
        ModalDialog wpd = new ModalDialog(keywordsPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = keywordsPage.getSurrogate();
            newRow.add(keywordsPage);
            this.keywordsList.addRow(newRow);
        }
    }

    private void showEditKeywordsDialog() {
        List selRowList = this.keywordsList.getSelectedRowList();
        if (selRowList == null || selRowList.size() < 3) {
            return;
        }
        Object dialogObj = selRowList.get(2);
        if (dialogObj == null || !(dialogObj instanceof KeywordsPage)) {
            return;
        }
        KeywordsPage editKeywordsPage = (KeywordsPage)dialogObj;
        ModalDialog wpd = new ModalDialog(editKeywordsPage, WizardContainerFrame.getDialogParent(), 770, 570, false);
        wpd.resetBounds();
        wpd.setVisible(true);
        if (wpd.USER_RESPONSE == 10) {
            List newRow = editKeywordsPage.getSurrogate();
            newRow.add(editKeywordsPage);
            this.keywordsList.replaceSelectedRow(newRow);
        }
    }

    public void onLoadAction() {
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        return true;
    }

    public OrderedMap getPageData() {
        return this.getPageData(this.xPathRoot);
    }

    public OrderedMap getPageData(String rootXPath) {
        this.returnMap.clear();
        int index = 1;
        Object nextRowObj2 = null;
        List nextRowList = null;
        Object nextUserObject = null;
        OrderedMap nextNVPMap = null;
        KeywordsPage nextKeywordsPage = null;
        List rowLists = this.keywordsList.getListOfRowLists();
        if (rowLists != null && rowLists.isEmpty()) {
            return this.returnMap;
        }
        for (Object nextRowObj2 : rowLists) {
            if (nextRowObj2 == null || (nextRowList = (List)nextRowObj2).size() < 3 || (nextUserObject = nextRowList.get(2)) == null) continue;
            nextKeywordsPage = nextUserObject;
            nextNVPMap = nextKeywordsPage.getPageData(rootXPath + index++ + "]");
            this.returnMap.putAll((Map)nextNVPMap);
        }
        return this.returnMap;
    }

    public String getPageID() {
        return "KEYWORDS";
    }

    public String getTitle() {
        return "Keywords";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "PARTY_INTRO";
    }

    public String getPageNumber() {
        return "3";
    }

    public boolean setPageData(OrderedMap map, String _xPathRoot) {
        if (_xPathRoot != null && _xPathRoot.trim().length() > 0) {
            this.xPathRoot = _xPathRoot;
        }
        if (map == null || map.isEmpty()) {
            this.keywordsList.removeAllRows();
            return true;
        }
        ArrayList toDeleteList = new ArrayList();
        Iterator keyIt = map.keySet().iterator();
        Object nextXPathObj = null;
        String nextXPath = null;
        Object nextValObj = null;
        String nextVal = null;
        ArrayList keywordList = new ArrayList();
        while (keyIt.hasNext()) {
            nextXPathObj = keyIt.next();
            if (nextXPathObj == null) continue;
            nextXPath = (String)nextXPathObj;
            nextValObj = map.get(nextXPathObj);
            nextVal = nextValObj == null ? "" : ((String)nextValObj).trim();
            Log.debug(45, "Keyword:  nextXPath = " + nextXPath + "\n nextVal   = " + nextVal);
            if (!nextXPath.startsWith("/keywordSet[")) continue;
            Log.debug(45, ">>>>>>>>>> adding to keywordsetList: nextXPathObj=" + nextXPathObj + "; nextValObj=" + nextValObj);
            this.addToKeywordSet(nextXPathObj, nextValObj, keywordList);
            toDeleteList.add(nextXPathObj);
        }
        Iterator persIt = keywordList.iterator();
        Object nextStepMapObj = null;
        OrderedMap nextStepMap = null;
        int keywordPredicate = 1;
        this.keywordsList.removeAllRows();
        boolean keywordRetVal = true;
        while (persIt.hasNext()) {
            nextStepMapObj = persIt.next();
            if (nextStepMapObj == null || (nextStepMap = (OrderedMap)nextStepMapObj).isEmpty()) continue;
            KeywordsPage nextStep = (KeywordsPage)WizardPageLibrary.getPage("KEYWORDS_PAGE");
            boolean checkMethod = nextStep.setPageData(nextStepMap, this.xPathRoot + "/keywordSet[" + keywordPredicate++ + "]/");
            if (!checkMethod) {
                keywordRetVal = false;
            }
            List newRow = nextStep.getSurrogate();
            newRow.add(nextStep);
            this.keywordsList.addRow(newRow);
        }
        if (!keywordRetVal) {
            Log.debug(20, "Keyword.setPageData - Method sub-class returned FALSE");
        }
        Iterator dlIt = toDeleteList.iterator();
        while (dlIt.hasNext()) {
            map.remove(dlIt.next());
        }
        boolean returnVal = map.isEmpty();
        if (!returnVal) {
            Log.debug(20, "Keyword.setPageData returning FALSE! Map still contains:" + map);
        }
        return returnVal && keywordRetVal;
    }

    private void addToKeywordSet(Object nextPersonnelXPathObj, Object nextPersonnelVal, List keywordList) {
        if (nextPersonnelXPathObj == null) {
            return;
        }
        String nextPersonnelXPath = (String)nextPersonnelXPathObj;
        int predicate = this.getFirstPredicate(nextPersonnelXPath, "/keywordSet[");
        if (predicate >= keywordList.size()) {
            for (int i = keywordList.size(); i <= predicate; ++i) {
                keywordList.add(new OrderedMap());
            }
        }
        if (predicate < keywordList.size()) {
            Object nextMapObj = keywordList.get(predicate);
            OrderedMap nextMap = (OrderedMap)nextMapObj;
            nextMap.put(nextPersonnelXPathObj, nextPersonnelVal);
        } else {
            Log.debug(15, "**** ERROR - KeywordsaddToKeywordSet() - predicate > keywordSet.size()");
        }
    }

    private int getFirstPredicate(String xpath, String firstSegment) {
        String tempXPath = xpath.substring(xpath.indexOf(firstSegment) + firstSegment.length());
        return Integer.parseInt(tempXPath.substring(0, tempXPath.indexOf("]")));
    }
}

