/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.StringUtil;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WizardSettings {
    private static final String ALL_UNIT_TYPES_XPATH = "/stmml:unitList/stmml:unitType/@name";
    public static final String BASIC_UNIT_TYPES_XPATH = "/stmml:unitList/stmml:unitType/@name[string(.)=string(../dimension/@name)]";
    private static String[] basicUnitTypes = new String[]{"length", "time", "mass", "charge", "temperature", "amount", "luminosity", "dimensionless", "angle"};
    private static Node udRootNode = null;
    private static String[] unitDictionaryUnitTypesArray = null;
    private static String[] customUnitDictionaryUnitTypesArray = null;
    private static String[] unitDictionaryBasicUnitTypesArray = null;
    private static String[] existingSIUnits = null;
    private static Node[] unitsNodeArray = null;
    private static final String UNITS_XPATH = "/stmml:unitList/stmml:unit";
    public static final short ENTITY_DATATABLE = 10;
    private static final OrderedMap mimeTypesMap = new OrderedMap();
    private static List unitsReturnList = new ArrayList();
    private static List unitsList = new ArrayList();
    private static List unitsRemainderList = new ArrayList();
    private static Map unitDictionaryUnitsCacheMap = new HashMap();
    private static Map customUnitDictionaryUnitsCacheMap = new HashMap();
    private static Map unitPreferenceMap = new HashMap();
    private static String summaryText;
    private static String dataLocation;
    private static final String EML_UNIT_DICTIONARY_PATH = "/xsl/eml-unitDictionary.xml";
    public static final int WIZARD_X_COORD = 100;
    public static final int WIZARD_Y_COORD = 100;
    public static final int WIZARD_WIDTH = 800;
    public static final int WIZARD_HEIGHT = 600;
    public static final int DIALOG_WIDTH = 770;
    public static final int DIALOG_HEIGHT = 570;
    public static final int ATTR_DIALOG_HEIGHT = 600;
    public static final String PACKAGE_WIZ_FIRST_PAGE_ID = "INTRODUCTION";
    public static final String ENTITY_WIZ_FIRST_PAGE_ID = "DATA_LOCATION";
    public static final Color TOP_PANEL_BG_COLOR;
    protected static final Dimension TOP_PANEL_DIMS;
    public static final int PADDING = 5;
    public static final Dimension DEFAULT_SPACER_DIMS;
    protected static final Font TITLE_FONT;
    protected static final Color TITLE_TEXT_COLOR;
    protected static final Font SUBTITLE_FONT;
    protected static final Color SUBTITLE_TEXT_COLOR;
    public static final Font BUTTON_FONT;
    public static final Color BUTTON_TEXT_COLOR;
    public static final Font WIZARD_CONTENT_FONT;
    public static final Font WIZARD_CONTENT_BOLD_FONT;
    public static final Color WIZARD_CONTENT_TEXT_COLOR;
    public static final Color WIZARD_CONTENT_REQD_TEXT_COLOR;
    public static final Color WIZARD_CONTENT_HILITE_BG_COLOR;
    public static final Color WIZARD_CONTENT_HILITE_FG_COLOR;
    public static final Dimension WIZARD_CONTENT_LABEL_DIMS;
    public static final Dimension WIZARD_REDUCED_CONTENT_LABEL_DIMS;
    public static final Dimension WIZARD_CONTENT_TEXTFIELD_DIMS;
    public static final Dimension WIZARD_CONTENT_SINGLE_LINE_DIMS;
    private static final String FONT_STYLE = "style=\"font-size: 9px;\"";
    public static final String HTML_FONT_OPENING = "<font style=\"font-size: 9px;\" face=\"Sans-Serif\">";
    public static final String HTML_EXAMPLE_FONT_OPENING = "<font style=\"font-size: 9px;\" color=\"#666666\">";
    public static final String HTML_EXAMPLE_FONT_CLOSING = "</font>";
    public static final String HTML_TABLE_LABEL_OPENING = "<html><table width=\"100%\"><tr><td valign=\"top\" width=\"100%\"><font style=\"font-size: 9px;\" face=\"Sans-Serif\">";
    public static final String HTML_TABLE_LABEL_CLOSING = "</font></td></tr></table></html>";
    public static final String HTML_NO_TABLE_OPENING = "<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">";
    public static final String HTML_NO_TABLE_CLOSING = "</html>";
    public static final Dimension NAV_BUTTON_DIMS;
    public static final Dimension LIST_BUTTON_DIMS;
    public static final Dimension LIST_BUTTON_DIMS_SMALL;
    public static final String IMPORT_BUTTON_TEXT = "Import";
    public static final String FINISH_BUTTON_TEXT = "Finish";
    public static final String PREV_BUTTON_TEXT = "< Back";
    protected static final String NEXT_BUTTON_TEXT = "Next >";
    protected static final String CANCEL_BUTTON_TEXT = "Cancel";
    protected static final String OK_BUTTON_TEXT = "OK";
    public static String NUMBER_OF_STEPS;
    public static final int ACCESS_PAGE_AUTHSYS = 1;
    public static final int ACCESS_PAGE_GROUP = 2;
    public static final int ACCESS_PAGE_USER = 3;
    public static final int MAX_IMPORTED_ROWS_DISPLAYED_IN_CODE_IMPORT = 25;
    protected static final String EML200_SCHEMA_NAMESPACE = "eml://ecoinformatics.org/eml-2.0.0";
    public static final String EML201_SCHEMA_NAMESPACE = "eml://ecoinformatics.org/eml-2.0.1";
    protected static final String NEW_EML200_DOCUMENT_TEXT = "<eml:eml    packageId=\"\" system=\"knb\"    xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.0\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.0 eml.xsd\">    <dataset>    <title> </title>    <creator> </creator>   </dataset> </eml:eml>";
    protected static final String TEMP_REFS_EML200_DOCUMENT_TEXT = "<eml:eml    packageId=\"\" system=\"knb\"    xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.0\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.0 eml.xsd\">    <dataset>    <title> </title>    <creator> </creator>   <coverage><taxonomicCoverage><taxonomicSystem><classificationSystem>                             <classificationSystemCitation><title> </title>            </classificationSystemCitation> </classificationSystem>            </taxonomicSystem> </taxonomicCoverage></coverage>   <project><title> </title></project>   </dataset> </eml:eml>";
    protected static final String NEW_EML201_DOCUMENT_TEXT = "<eml:eml    packageId=\"\" system=\"knb\"    xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.1\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.1 eml.xsd\">    <dataset>    <title> </title>    <creator> </creator>   </dataset> </eml:eml>";
    public static final String TEMP_REFS_EML201_DOCUMENT_TEXT = "<eml:eml    packageId=\"\" system=\"knb\"    xmlns:eml=\"eml://ecoinformatics.org/eml-2.0.1\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xsi:schemaLocation=\"eml://ecoinformatics.org/eml-2.0.1 eml.xsd\">    <dataset>    <title> </title>    <creator> </creator>   <coverage><taxonomicCoverage><taxonomicSystem><classificationSystem>                             <classificationSystemCitation><title> </title>            </classificationSystemCitation> </classificationSystem>            </taxonomicSystem> </taxonomicCoverage></coverage>   <project><title> </title></project>   </dataset> </eml:eml>";
    public static final short INLINE = 0;
    public static final short ONLINE = 10;
    public static final short OFFLINE = 20;
    public static final short NODATA = 30;
    public static final String SUMMARY_TEXT_INLINE = "In addition to describing your data, you have chosen to include it within the data package.";
    public static final String SUMMARY_TEXT_ONLINE = "You have chosen to describe data that is available online at: ";
    public static final String SUMMARY_TEXT_OFFLINE = "You have chosen to describe data, but not make the data itself available at this time.";
    public static final String SUMMARY_TEXT_NODATA = "You have chosen not to include or describe any data in your data package at this time. Data may be added later";
    public static final String HEX_VALUE_TAB = "#x09";
    public static final String HEX_VALUE_SPACE = "#x20";
    private static float floatNum;
    public static final String[] stdTaxonRanks;
    public static final String[] commonTaxonRanks;
    public static final int NUMBER_OF_TAXON_RANKS = 7;

    public static void setSummaryText(String text) {
        if (text == null) {
            return;
        }
        if (text.equals(SUMMARY_TEXT_INLINE) || text.equals(SUMMARY_TEXT_ONLINE) || text.equals(SUMMARY_TEXT_NODATA) || text.equals(SUMMARY_TEXT_OFFLINE)) {
            summaryText = text;
            WizardSettings.setDataLocation(null);
        }
    }

    public static String getSummaryText() {
        return summaryText;
    }

    public static void setDataLocation(String loc) {
        dataLocation = loc;
    }

    public static String getDataLocation() {
        return dataLocation;
    }

    public static String getUniqueID() {
        return UISettings.getUniqueID();
    }

    public static String[] getSIUnits() {
        if (existingSIUnits != null) {
            return existingSIUnits;
        }
        String[] unitTypes = WizardSettings.getUnitDictionaryUnitTypes();
        existingSIUnits = new String[unitTypes.length];
        for (int i = 0; i < unitTypes.length; ++i) {
            WizardSettings.getUnitDictionaryUnitsOfType(unitTypes[i]);
            WizardSettings.existingSIUnits[i] = WizardSettings.getPreferredType(unitTypes[i]);
        }
        Arrays.sort(existingSIUnits);
        return existingSIUnits;
    }

    public static String[] getUnitDictionaryBasicUnitTypes() {
        return basicUnitTypes;
    }

    public static String[] getUnitDictionaryUnitTypes() {
        if (unitDictionaryUnitTypesArray == null) {
            unitDictionaryUnitTypesArray = WizardSettings.getUnitTypesWithXPath(ALL_UNIT_TYPES_XPATH);
        }
        Object[] newArr = new String[unitDictionaryUnitTypesArray.length + customUnitDictionaryUnitTypesArray.length];
        for (int i = 0; i < unitDictionaryUnitTypesArray.length; ++i) {
            newArr[i] = unitDictionaryUnitTypesArray[i];
        }
        for (int j = 0; j < customUnitDictionaryUnitTypesArray.length; ++j) {
            newArr[i++] = customUnitDictionaryUnitTypesArray[j];
        }
        Arrays.sort(newArr);
        return newArr;
    }

    private static String[] getUnitDictionaryOriginalUnitTypes() {
        if (unitDictionaryUnitTypesArray == null) {
            unitDictionaryUnitTypesArray = WizardSettings.getUnitTypesWithXPath(ALL_UNIT_TYPES_XPATH);
        }
        return unitDictionaryUnitTypesArray;
    }

    private static String[] getUnitTypesWithXPath(String unitXPath) {
        FileReader reader = null;
        try {
            File unitDict = new File("./xsl/eml-unitDictionary.xml");
            reader = new FileReader(unitDict);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug(12, "Exception: <" + e + "> trying to open unit dictionary file.\n" + "\nClasspath was: \n" + System.getProperty("java.class.path") + "\n");
            reader = null;
        }
        if (reader == null) {
            Log.debug(1, "Can't find unit dictionary file at: /xsl/eml-unitDictionary.xml");
            return new String[]{"ERROR"};
        }
        try {
            udRootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)reader);
        }
        catch (IOException ioe) {
            Log.debug(12, "Exception getting unit dictionary RootNode: " + ioe);
            ioe.printStackTrace();
            return new String[]{"IOException!"};
        }
        Node[] unitTypesNodeArray = null;
        unitTypesNodeArray = WizardSettings.getNodeArrayWithXPath(udRootNode, unitXPath);
        if (unitTypesNodeArray == null) {
            Log.debug(1, "Fatal error - unitTypesNodeArray == NULL");
            return new String[]{"ERROR!!"};
        }
        int totUnitTypes = unitTypesNodeArray.length;
        Object[] unitTypesArray = new String[totUnitTypes];
        for (int i = 0; i < totUnitTypes; ++i) {
            unitTypesArray[i] = unitTypesNodeArray[i].getNodeValue();
        }
        Arrays.sort(unitTypesArray);
        return unitTypesArray;
    }

    public static String[] getUnitDictionaryUnitsOfType(String unitType) {
        if (unitType == null) {
            return null;
        }
        Object[] returnArray = null;
        if (unitDictionaryUnitsCacheMap.containsKey(unitType)) {
            returnArray = (String[])unitDictionaryUnitsCacheMap.get(unitType);
        } else if (customUnitDictionaryUnitsCacheMap.containsKey(unitType)) {
            returnArray = (String[])customUnitDictionaryUnitsCacheMap.get(unitType);
        } else {
            String val;
            Attr nameAttr;
            if (udRootNode == null || unitDictionaryUnitTypesArray == null) {
                WizardSettings.getUnitDictionaryUnitTypes();
            }
            unitsReturnList.clear();
            unitsList.clear();
            unitsRemainderList.clear();
            if (unitsNodeArray == null && (unitsNodeArray = WizardSettings.getNodeArrayWithXPath(udRootNode, UNITS_XPATH)) == null) {
                Log.debug(1, "Fatal error - unitsNodeArray == NULL");
                return new String[]{"ERROR!!"};
            }
            for (int i = 0; i < unitsNodeArray.length; ++i) {
                NamedNodeMap attribNNMap = unitsNodeArray[i].getAttributes();
                if (attribNNMap == null || attribNNMap.getLength() < 1) continue;
                Node unitTypeAttrNode = attribNNMap.getNamedItem("unitType");
                Node parentSIAttrNode2 = attribNNMap.getNamedItem("parentSI");
                if (unitTypeAttrNode != null) {
                    if (!((Attr)unitTypeAttrNode).getValue().equals(unitType)) continue;
                    WizardSettings.addAttributeNameToList(attribNNMap, unitsList);
                    if (parentSIAttrNode2 != null) {
                        String parentSIVal2 = ((Attr)parentSIAttrNode2).getValue();
                        unitPreferenceMap.put(unitType.toLowerCase(), parentSIVal2);
                        continue;
                    }
                    nameAttr = (Attr)attribNNMap.getNamedItem("name");
                    if (nameAttr == null || (val = nameAttr.getValue().trim()).length() <= 0) continue;
                    unitPreferenceMap.put(unitType.toLowerCase(), val);
                    continue;
                }
                unitsRemainderList.add(unitsNodeArray[i]);
            }
            for (Object nextObj : unitsRemainderList) {
                NamedNodeMap attribNNMap;
                if (nextObj == null || (attribNNMap = ((Node)nextObj).getAttributes()) == null || attribNNMap.getLength() < 1) continue;
                Node parentSIAttrNode = attribNNMap.getNamedItem("parentSI");
                if (parentSIAttrNode != null) {
                    if (!unitsList.contains(StringUtil.stripTabsNewLines((String)((Attr)parentSIAttrNode).getValue()))) continue;
                    String parentSIVal = ((Attr)parentSIAttrNode).getValue();
                    unitPreferenceMap.put(unitType.toLowerCase(), parentSIVal);
                    WizardSettings.addAttributeNameToList(attribNNMap, unitsReturnList);
                    continue;
                }
                nameAttr = (Attr)attribNNMap.getNamedItem("name");
                if (nameAttr == null || (val = nameAttr.getValue().trim()).length() <= 0) continue;
                unitPreferenceMap.put(unitType.toLowerCase(), val);
            }
            unitsReturnList.addAll(unitsList);
            if (unitType.equalsIgnoreCase("amount")) {
                returnArray = new String[unitsReturnList.size() + 1];
                unitsReturnList.add("dimensionless");
            } else {
                returnArray = new String[unitsReturnList.size()];
            }
            unitsReturnList.toArray(returnArray);
            if (returnArray.length > 1) {
                Arrays.sort(returnArray);
            }
            unitDictionaryUnitsCacheMap.put(unitType, returnArray);
        }
        return returnArray;
    }

    public static String getDisplayFormOfUnitType(String unitType) {
        if (unitType == null || unitType.trim().equals("")) {
            return "";
        }
        StringBuffer buff = new StringBuffer();
        int SPACE = 32;
        int length = unitType.length();
        char[] originalUnitTypeChars = new char[length];
        unitType.getChars(0, length, originalUnitTypeChars, 0);
        char[] upperCaseUnitTypeChars = new char[length];
        unitType.toUpperCase().getChars(0, length, upperCaseUnitTypeChars, 0);
        buff.append(upperCaseUnitTypeChars[0]);
        for (int i = 1; i < length; ++i) {
            if (originalUnitTypeChars[i] == upperCaseUnitTypeChars[i]) {
                buff.append(' ');
            }
            buff.append(originalUnitTypeChars[i]);
        }
        return buff.toString();
    }

    public static String getStandardFormOfUnitType(String unitType) {
        StringTokenizer st = new StringTokenizer(unitType, " ");
        String result = "";
        int cnt = 0;
        while (st.hasMoreTokens()) {
            result = cnt == 0 ? result + st.nextToken().toLowerCase() : result + st.nextToken();
            ++cnt;
        }
        return result;
    }

    public static void insertObjectIntoArray(Object[] arr, Object value, Object[] newArr) {
        int idx = Arrays.binarySearch(arr, value);
        int pos = 0;
        pos = idx >= 0 ? idx : -(idx + 1);
        int i = 0;
        for (i = 0; i < pos; ++i) {
            newArr[i] = arr[i];
        }
        newArr[i] = value;
        for (int j = pos; j < arr.length; ++j) {
            newArr[j + 1] = arr[j];
        }
    }

    public static List getDefinitionsForUnitType(String unitType) {
        Node rootNode;
        FileReader reader = null;
        try {
            File unitDict = new File("./xsl/eml-unitDictionary.xml");
            reader = new FileReader(unitDict);
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.debug(12, "Exception: <" + e + "> trying to open unit dictionary file.\n" + "\nClasspath was: \n" + System.getProperty("java.class.path") + "\n");
            reader = null;
        }
        if (reader == null) {
            Log.debug(1, "Can't find unit dictionary file at: /xsl/eml-unitDictionary.xml");
            return null;
        }
        try {
            rootNode = XMLUtilities.getXMLReaderAsDOMTreeRootNode((Reader)reader);
        }
        catch (IOException ioe) {
            Log.debug(12, "Exception getting unit dictionary RootNode: " + ioe);
            ioe.printStackTrace();
            return null;
        }
        unitType = WizardSettings.getStandardFormOfUnitType(unitType);
        Node unitTypeNode = null;
        String unitTypeXPath = "/stmml:unitList/stmml:unitType[@name='" + unitType + "']";
        try {
            unitTypeNode = XMLUtilities.getNodeWithXPath((Node)rootNode, (String)unitTypeXPath);
        }
        catch (Exception te) {
            Log.debug(12, "Exception retreving the given unitType node");
            return null;
        }
        if (unitTypeNode == null) {
            Log.debug(12, "Got no nodes for the given unit type");
            return null;
        }
        ArrayList result = new ArrayList();
        NodeList children = unitTypeNode.getChildNodes();
        Log.debug(12, "children got = " + children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node nameAttr;
            String name = "";
            String power = "";
            Node child = children.item(i);
            NamedNodeMap attrs = child.getAttributes();
            if (attrs == null || (nameAttr = attrs.getNamedItem("name")) == null) continue;
            name = nameAttr.getNodeValue();
            Node powerAttr = attrs.getNamedItem("power");
            power = powerAttr != null ? powerAttr.getNodeValue() : "1";
            ArrayList<String> row = new ArrayList<String>();
            row.add(WizardSettings.getDisplayFormOfUnitType(name));
            row.add(power);
            result.add(row);
        }
        try {
            if (reader != null) {
                ((Reader)reader).close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    public static String getPreferredType(String unitType) {
        if (unitType == null) {
            return null;
        }
        String res = (String)unitPreferenceMap.get(unitType.toLowerCase());
        return res;
    }

    public static boolean isCustomUnit(String type, String unit) {
        boolean newT = unitDictionaryUnitsCacheMap.containsKey(type = WizardSettings.getStandardFormOfUnitType(type));
        if (newT) {
            Object[] units = (String[])unitDictionaryUnitsCacheMap.get(type);
            return Arrays.binarySearch(units, unit) < 0;
        }
        return true;
    }

    public static OrderedMap getSupportedMIMETypesForEntity(short entityType) {
        mimeTypesMap.clear();
        switch (entityType) {
            case 10: {
                mimeTypesMap.put((Object)"Microsoft Excel", (Object)"application/vnd.ms-excel");
                mimeTypesMap.put((Object)"XML text", (Object)"application/xml");
                mimeTypesMap.put((Object)"HTML text", (Object)"Text/html");
                mimeTypesMap.put((Object)"XHTML text", (Object)"application/xhtml+xml");
                mimeTypesMap.put((Object)"Mathematica", (Object)"application/mathematica");
                break;
            }
        }
        return mimeTypesMap;
    }

    private static void addAttributeNameToList(NamedNodeMap map, List list) {
        Node nameAttrNode = map.getNamedItem("name");
        if (nameAttrNode != null) {
            list.add(StringUtil.stripTabsNewLines((String)((Attr)nameAttrNode).getValue()));
        }
    }

    private static Node[] getNodeArrayWithXPath(Node rootNode, String xpath) {
        NodeList nodeList = null;
        try {
            nodeList = XMLUtilities.getNodeListWithXPath((Node)rootNode, (String)xpath);
        }
        catch (Exception ioe) {
            Log.debug(12, "Exception getting nodeList: " + ioe);
            ioe.printStackTrace();
            return null;
        }
        if (nodeList == null) {
            Log.debug(1, "Fatal error - nodeList == NULL");
            return null;
        }
        return XMLUtilities.getNodeListAsNodeArray((NodeList)nodeList);
    }

    public static boolean isFloat(String numberString) {
        try {
            floatNum = Float.parseFloat(numberString);
        }
        catch (Exception e) {
            return false;
        }
        return !Float.isNaN(floatNum);
    }

    public static int getIndexOfTaxonRank(String rank) {
        for (int i = 0; i < commonTaxonRanks.length; ++i) {
            if (!commonTaxonRanks[i].equals(rank)) continue;
            return i;
        }
        return -1;
    }

    public static List getTaxonHierarchyTillIndex(int index) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i <= index; ++i) {
            ret.add(commonTaxonRanks[i]);
        }
        return ret;
    }

    static /* synthetic */ String[] access$002(String[] x0) {
        customUnitDictionaryUnitTypesArray = x0;
        return x0;
    }

    static {
        Thread initThread = new Thread(){

            public void run() {
                WizardSettings.access$002(new String[0]);
                String[] temp = WizardSettings.getUnitDictionaryOriginalUnitTypes();
                for (int i = 0; i < temp.length; ++i) {
                    WizardSettings.getUnitDictionaryUnitsOfType(temp[i]);
                }
                Log.debug(45, "*** WizardSettings static init thread done");
            }
        };
        initThread.run();
        TOP_PANEL_BG_COLOR = new Color(11, 85, 112);
        TOP_PANEL_DIMS = new Dimension(100, 60);
        DEFAULT_SPACER_DIMS = new Dimension(15, 15);
        TITLE_FONT = new Font("Sans-Serif", 1, 13);
        TITLE_TEXT_COLOR = new Color(255, 255, 255);
        SUBTITLE_FONT = new Font("Sans-Serif", 0, 11);
        SUBTITLE_TEXT_COLOR = new Color(255, 255, 255);
        BUTTON_FONT = new Font("Sans-Serif", 0, 11);
        BUTTON_TEXT_COLOR = new Color(51, 51, 51);
        WIZARD_CONTENT_FONT = new Font("Sans-Serif", 0, 11);
        WIZARD_CONTENT_BOLD_FONT = new Font("Sans-Serif", 1, 11);
        WIZARD_CONTENT_TEXT_COLOR = new Color(51, 51, 51);
        WIZARD_CONTENT_REQD_TEXT_COLOR = new Color(221, 0, 0);
        WIZARD_CONTENT_HILITE_BG_COLOR = new Color(175, 0, 0);
        WIZARD_CONTENT_HILITE_FG_COLOR = new Color(255, 255, 255);
        WIZARD_CONTENT_LABEL_DIMS = new Dimension(100, 20);
        WIZARD_REDUCED_CONTENT_LABEL_DIMS = new Dimension(80, 20);
        WIZARD_CONTENT_TEXTFIELD_DIMS = new Dimension(2000, 20);
        WIZARD_CONTENT_SINGLE_LINE_DIMS = new Dimension(2000, 20);
        NAV_BUTTON_DIMS = new Dimension(70, 25);
        LIST_BUTTON_DIMS = new Dimension(85, 30);
        LIST_BUTTON_DIMS_SMALL = new Dimension(60, 25);
        NUMBER_OF_STEPS = "15";
        floatNum = 0.0f;
        stdTaxonRanks = new String[]{"Kingdom", "Sub-Kingdom", "Phylum", "Sub-Phylum", "Class", "Sub-Class", "Order", "Sub-Order", "Family", "Sub-Family", "Genus", "Sub-Genus", "Species", "Sub-Species"};
        commonTaxonRanks = new String[]{"Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species"};
    }
}

