/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.AddAction;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomJTable;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.DeleteAction;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.DuplicateAction;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.EditAction;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.MoveDownAction;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.MoveUpAction;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CustomList
extends JPanel {
    public static final short NULL = 0;
    public static final short EMPTY_STRING_TRIM = 10;
    public static final short EMPTY_STRING_NOTRIM = 20;
    public static final short IGNORE = 30;
    public static final short OR = 51;
    public static final short AND = 61;
    private CustomJTable table;
    private JButton addButton;
    private JButton editButton;
    private JButton duplicateButton;
    private JButton deleteButton;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private boolean showAddButton;
    private boolean showEditButton;
    private boolean showDuplicateButton;
    private boolean showDeleteButton;
    private boolean showMoveUpButton;
    private boolean showMoveDownButton;
    protected AddAction addAction;
    protected DeleteAction deleteAction;
    protected EditAction editAction;
    protected DuplicateAction duplicateAction;
    protected MoveUpAction moveUpAction;
    protected MoveDownAction moveDownAction;
    private static TableModelEvent tableModelEvent;
    private DefaultTableModel model;
    private Dimension buttonDims;
    private JScrollPane scrollPane;
    private Action customAddAction;
    private Action customEditAction;
    private Action customDuplicateAction;
    private Action customDeleteAction;
    private boolean enabled = true;
    private double[] columnWidthPercentages;
    private JPanel buttonBox;
    private boolean selectionExists = true;

    public CustomList(String[] colNames, Object[] columnEditors, int displayRows, boolean showAddButton, boolean showEditButton, boolean showDuplicateButton, boolean showDeleteButton, boolean showMoveUpButton, boolean showMoveDownButton) {
        this.showAddButton = showAddButton;
        this.showEditButton = showEditButton;
        this.showDuplicateButton = showDuplicateButton;
        this.showDeleteButton = showDeleteButton;
        this.showMoveUpButton = showMoveUpButton;
        this.showMoveDownButton = showMoveDownButton;
        this.init(colNames, displayRows, columnEditors);
    }

    private void init(String[] colNames, int displayRows, Object[] columnEditors) {
        this.setLayout(new BorderLayout());
        this.initList(colNames, displayRows, columnEditors);
        this.initButtons();
        this.doEnablesDisables(new int[0]);
    }

    private void initList(String[] colNames, int displayRows, Object[] columnEditors) {
        int i;
        Vector<String> colNamesVec = new Vector<String>(colNames.length + 1);
        for (int i2 = 0; i2 < colNames.length; ++i2) {
            colNamesVec.add(i2, colNames[i2]);
        }
        colNamesVec.add(colNames.length, "*UserObject*");
        Vector rowsData = new Vector();
        this.table = new CustomJTable(this, rowsData, colNamesVec, columnEditors);
        this.model = (DefaultTableModel)this.table.getModel();
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.table.setShowHorizontalLines(false);
        this.table.setShowVerticalLines(true);
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.removeColumn(columnModel.getColumn(this.table.getColumnCount() - 1));
        this.columnWidthPercentages = new double[this.table.getColumnCount()];
        double equalP = 100.0 / (double)this.table.getColumnCount();
        for (i = 0; i < this.table.getColumnCount(); ++i) {
            this.columnWidthPercentages[i] = equalP;
        }
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getViewport().setBackground(Color.white);
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                CustomList.this.setColumnSizes(CustomList.this.scrollPane.getViewport().getSize().getWidth());
            }
        });
        this.add((Component)this.scrollPane, "Center");
        this.setBorder(new EmptyBorder(0, 0, 10, 0));
        this.addAction = new AddAction(this.table, this);
        this.deleteAction = new DeleteAction(this.table, this);
        this.editAction = new EditAction(this.table, this);
        this.duplicateAction = new DuplicateAction(this.table, this);
        this.moveUpAction = new MoveUpAction(this.table, this);
        this.moveDownAction = new MoveDownAction(this.table, this);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (CustomList.this.table.getRowCount() == 0) {
                    CustomList.this.doEnablesDisables(new int[0]);
                    return;
                }
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Log.debug(45, "ListSelectionListener::valueChanged():");
                Log.debug(45, "      - ListSelectionEvent first index  = " + e.getFirstIndex());
                Log.debug(45, "      - ListSelectionEvent last  index  = " + e.getLastIndex());
                Log.debug(45, "      - getSelectedRowIndex  = " + CustomList.this.getSelectedRowIndex());
                CustomList.this.doEnablesDisables(CustomList.this.table.getSelectedRows());
            }
        });
        if (columnEditors == null) {
            Log.debug(45, "NULL Column Editor Array; making ALL columns non-editable");
            for (int colIdx = 0; colIdx < this.table.getColumnCount(); ++colIdx) {
                this.table.makeColumnNotEditable(colIdx);
            }
        } else {
            for (i = 0; i < columnEditors.length; ++i) {
                DefaultCellEditor cellEd;
                if (i > this.table.getColumnCount() - 1) continue;
                Object editor = columnEditors[i];
                TableColumn column = this.table.getColumnModel().getColumn(i);
                if (editor == null) {
                    Log.debug(51, "\nNULL Column Editor; making column " + i + " non-editable");
                    this.table.makeColumnNotEditable(i);
                    continue;
                }
                Log.debug(51, "\nsetting Column " + i + " Editor = " + editor);
                if (editor instanceof JTextField) {
                    Log.debug(51, "(JTextField)");
                    cellEd = new DefaultCellEditor((JTextField)editor);
                    cellEd.setClickCountToStart(1);
                    column.setCellEditor(cellEd);
                    continue;
                }
                if (editor instanceof JCheckBox) {
                    Log.debug(51, "(JCheckBox)");
                    cellEd = new DefaultCellEditor((JCheckBox)editor);
                    cellEd.setClickCountToStart(1);
                    column.setCellEditor(cellEd);
                    continue;
                }
                if (editor instanceof JComboBox) {
                    Log.debug(51, "(JComboBox)");
                    cellEd = new DefaultCellEditor((JComboBox)editor);
                    cellEd.setClickCountToStart(1);
                    column.setCellEditor(cellEd);
                    continue;
                }
                Log.debug(51, "(NOT RECOGNIZED - SETTING NON-EDITABLE)");
                this.table.makeColumnNotEditable(i);
            }
        }
    }

    public TableModelEvent getTableModelEvent() {
        if (tableModelEvent == null) {
            tableModelEvent = new TableModelEvent(this.table.getModel());
        }
        return tableModelEvent;
    }

    private void setColumnSizes(double tableWidth) {
        double minFactor = 0.5;
        double maxFactor = 2.0;
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            double fraction = this.columnWidthPercentages[i] / 100.0;
            int preferredWidth = (int)(tableWidth * fraction) - 1;
            TableColumn column = this.table.getColumnModel().getColumn(i);
            int headerWidth = this.getHeaderWidth(i, column);
            if (preferredWidth < headerWidth) {
                preferredWidth = headerWidth;
            }
            column.setPreferredWidth(preferredWidth);
            column.setMinWidth((int)((double)preferredWidth * 0.5));
            column.setMaxWidth((int)((double)preferredWidth * 2.0));
        }
    }

    public void setColumnWidthPercentages(double[] columnWidths) {
        int len = columnWidths.length;
        if (len != this.table.getColumnCount()) {
            Log.debug(50, "CustomList.setColumnWidthPercentages: Length of array passed is notequal to the number of columns");
            return;
        }
        double sum = 0.0;
        for (int i = 0; i < len; ++i) {
            sum += columnWidths[i];
        }
        if (sum != 100.0) {
            Log.debug(50, "CustomList.setColumnWidthPercentages: Sum of the column width percentages is not equal to 100%");
            return;
        }
        this.columnWidthPercentages = columnWidths;
    }

    public void setBorderForButtonPanel(int top, int left, int bottom, int right) {
        this.buttonBox.setBorder(new EmptyBorder(top, left, bottom, right));
        this.remove(this.buttonBox);
        this.add((Component)this.buttonBox, "East");
        this.validate();
        this.repaint();
    }

    private int getHeaderWidth(int colNumber, TableColumn column) {
        TableCellRenderer headerRenderer = column.getHeaderRenderer();
        if (headerRenderer == null) {
            headerRenderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component comp = headerRenderer.getTableCellRendererComponent(this.table, column.getHeaderValue(), false, false, -1, colNumber);
        int headerWidth = comp.getPreferredSize().width;
        Insets ins = ((JComponent)((Object)headerRenderer)).getInsets();
        return ins.left + headerWidth + ins.right;
    }

    public void setListButtonDimensions(Dimension dims) {
        this.buttonDims = dims == null ? WizardSettings.LIST_BUTTON_DIMS : dims;
        this.resizeButtons();
    }

    public void focusAddButton() {
        if (this.addButton != null) {
            this.addButton.requestFocus();
        }
    }

    public void scrollToRow(int row) {
        if (row < 0 || row >= this.table.getRowCount()) {
            return;
        }
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
    }

    private void initButtons() {
        this.buttonBox = new JPanel();
        this.buttonBox.setLayout(new BoxLayout(this.buttonBox, 1));
        boolean buttonPresent = false;
        this.buttonBox.setBorder(new EmptyBorder(0, 10, 5, 5));
        if (this.showAddButton) {
            this.addButton = new JButton(this.addAction);
            this.addButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            this.buttonBox.add(this.addButton);
            buttonPresent = true;
        }
        if (this.showEditButton) {
            this.editButton = new JButton(this.editAction);
            this.editButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            this.buttonBox.add(this.editButton);
            buttonPresent = true;
        }
        if (this.showDuplicateButton) {
            this.duplicateButton = new JButton(this.duplicateAction);
            this.duplicateButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            this.buttonBox.add(this.duplicateButton);
            buttonPresent = true;
        }
        if (this.showDeleteButton) {
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            this.buttonBox.add(this.deleteButton);
            buttonPresent = true;
        }
        if (this.showMoveUpButton) {
            this.moveUpButton = new JButton(this.moveUpAction);
            this.moveUpButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            this.buttonBox.add(this.moveUpButton);
            buttonPresent = true;
        }
        if (this.showMoveDownButton) {
            this.moveDownButton = new JButton(this.moveDownAction);
            this.moveDownButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
            this.buttonBox.add(this.moveDownButton);
            buttonPresent = true;
        }
        if (!buttonPresent) {
            return;
        }
        this.setListButtonDimensions(WizardSettings.LIST_BUTTON_DIMS);
        this.resizeButtons();
        this.buttonBox.add(Box.createGlue());
        this.add((Component)this.buttonBox, "East");
    }

    private void resizeButtons() {
        if (this.showAddButton) {
            WidgetFactory.setPrefMaxSizes(this.addButton, this.buttonDims);
        }
        if (this.showEditButton) {
            WidgetFactory.setPrefMaxSizes(this.editButton, this.buttonDims);
        }
        if (this.showDuplicateButton) {
            WidgetFactory.setPrefMaxSizes(this.duplicateButton, this.buttonDims);
        }
        if (this.showDeleteButton) {
            WidgetFactory.setPrefMaxSizes(this.deleteButton, this.buttonDims);
        }
        if (this.showMoveUpButton) {
            WidgetFactory.setPrefMaxSizes(this.moveUpButton, this.buttonDims);
        }
        if (this.showMoveDownButton) {
            WidgetFactory.setPrefMaxSizes(this.moveDownButton, this.buttonDims);
        }
    }

    private void doEnablesDisables(int[] selRows) {
        Log.debug(51, "\n\n>>>> doEnablesDisables(): selRows count = " + selRows.length);
        boolean bl = this.selectionExists = selRows != null && selRows.length > 0;
        if (this.showAddButton) {
            this.addButton.setEnabled(true);
        }
        if (this.showEditButton) {
            this.editButton.setEnabled(this.selectionExists);
        }
        if (this.showDuplicateButton) {
            this.duplicateButton.setEnabled(this.selectionExists);
        }
        if (this.showDeleteButton) {
            this.deleteButton.setEnabled(this.selectionExists);
        }
        if (this.showMoveUpButton) {
            this.moveUpButton.setEnabled(this.selectionExists && selRows[0] > 0);
        }
        if (this.showMoveDownButton) {
            this.moveDownButton.setEnabled(this.selectionExists && selRows[selRows.length - 1] < this.table.getRowCount() - 1);
        }
    }

    public void fireEditingStopped() {
        Component editingComp = this.table.getEditorComponent();
        if (editingComp != null) {
            this.table.editingStopped(new ChangeEvent(editingComp));
            EventListener[] list = editingComp.getListeners(FocusListener.class);
            for (int i = 0; list != null && i < list.length; ++i) {
                ((FocusListener)list[i]).focusLost(new FocusEvent(editingComp, 1005));
            }
        }
    }

    public void fireAddAction() {
        this.addAction.actionPerformed(null);
    }

    public void fireEditAction() {
        this.editAction.actionPerformed(null);
    }

    public void fireDeleteAction() {
        this.deleteAction.actionPerformed(null);
    }

    public void fireDuplicateAction() {
        this.duplicateAction.actionPerformed(null);
    }

    public void fireMoveUpAction() {
        this.moveUpAction.actionPerformed(null);
    }

    public void fireMoveDownAction() {
        this.moveDownAction.actionPerformed(null);
    }

    public int getSelectedRowIndex() {
        return this.table.getSelectedRow();
    }

    public List getSelectedRowList() {
        int selRow = this.getSelectedRowIndex();
        if (selRow < 0) {
            return null;
        }
        List listOfRowLists = this.getListOfRowLists();
        if (listOfRowLists == null) {
            return null;
        }
        Object rowObj = listOfRowLists.get(selRow);
        if (rowObj == null) {
            return null;
        }
        return (List)rowObj;
    }

    public List[] getSelectedRows() {
        int[] rows = this.table.getSelectedRows();
        if (rows == null || rows.length < 1) {
            return null;
        }
        List listOfRowLists = this.getListOfRowLists();
        if (listOfRowLists == null) {
            return null;
        }
        List[] returnList = new List[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            returnList[i] = (List)listOfRowLists.get(rows[i]);
        }
        return returnList;
    }

    public void setSelectedRows(int[] idx) {
        DefaultListSelectionModel newModel = new DefaultListSelectionModel();
        newModel.setSelectionMode(2);
        for (int i = 0; i < idx.length; ++i) {
            newModel.addSelectionInterval(idx[i], idx[i]);
        }
        this.table.setSelectionModel(newModel);
    }

    public void replaceSelectedRow(List newRow) {
        int selRow;
        if (newRow == null) {
            newRow = new ArrayList();
        }
        if ((selRow = this.getSelectedRowIndex()) < 0) {
            return;
        }
        this.removeRow(selRow);
        this.model.insertRow(selRow, newRow.toArray());
    }

    public void replaceRow(int rowIndex, List newRow) {
        if (this.model.getRowCount() <= rowIndex) {
            return;
        }
        if (newRow == null) {
            newRow = new ArrayList();
        }
        this.removeRow(rowIndex);
        this.model.insertRow(rowIndex, newRow.toArray());
    }

    public int getRowCount() {
        return this.table.getRowCount();
    }

    public void addRow(List rowList) {
        int row = this.getSelectedRowIndex();
        if (this.table.getRowCount() == 0) {
            row = -1;
        }
        if (row < 0) {
            row = this.model.getRowCount();
            this.model.addRow(rowList.toArray());
        } else {
            this.model.insertRow(++row, rowList.toArray());
        }
        this.fireEditingStopped();
        this.table.tableChanged(this.getTableModelEvent());
        Component comp = this.table.getComponentAt(row, 0);
        if (comp != null) {
            this.table.editCellAt(row, 0, new EventObject(comp));
            comp.requestFocus();
        }
        this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
        this.table.setRowSelectionInterval(row, row);
        this.table.validate();
        this.table.repaint();
    }

    public void removeRow(int row) {
        this.model.removeRow(row);
        this.table.tableChanged(this.getTableModelEvent());
        this.table.clearSelection();
    }

    public void removeAllRows() {
        this.model = (DefaultTableModel)this.table.getModel();
        while (this.table.getRowCount() > 0) {
            this.model.removeRow(0);
        }
        this.table.tableChanged(this.getTableModelEvent());
        this.model = (DefaultTableModel)this.table.getModel();
    }

    public void deleteEmptyRows(short logicMode, short[] conditions) {
        if (conditions == null) {
            return;
        }
        if (logicMode != 51 && logicMode != 61) {
            return;
        }
        List rowLists = this.getListOfRowLists();
        boolean[] rowsToDelete = new boolean[rowLists.size()];
        Arrays.fill(rowsToDelete, false);
        int rowNumber = -1;
        Iterator it = rowLists.iterator();
        while (it.hasNext()) {
            ++rowNumber;
            Object nextRowObj = it.next();
            if (nextRowObj == null) {
                rowsToDelete[rowNumber] = true;
                continue;
            }
            List nextRow = (List)nextRowObj;
            if (nextRow.size() < 1) {
                rowsToDelete[rowNumber] = true;
                continue;
            }
            if (logicMode == 51) {
                this.checkColumnContents_OR(nextRow, conditions, rowsToDelete, rowNumber);
                continue;
            }
            this.checkColumnContents_AND(nextRow, conditions, rowsToDelete, rowNumber);
        }
        for (int i = rowsToDelete.length - 1; i > -1; --i) {
            if (!rowsToDelete[i]) continue;
            this.removeRow(i);
        }
    }

    private void checkColumnContents_OR(List nextRow, short[] conditions, boolean[] rowsToDelete, int rowNumber) {
        block6: for (int colIdx = 0; colIdx < conditions.length; ++colIdx) {
            switch (conditions[colIdx]) {
                case 30: {
                    continue block6;
                }
                case 0: {
                    if (nextRow.get(colIdx) != null) continue block6;
                    rowsToDelete[rowNumber] = true;
                    continue block6;
                }
                case 20: {
                    if (nextRow.get(colIdx) != null && nextRow.get(colIdx) instanceof String && !((String)nextRow.get(colIdx)).equals("")) continue block6;
                    rowsToDelete[rowNumber] = true;
                    continue block6;
                }
                case 10: {
                    if (nextRow.get(colIdx) != null && nextRow.get(colIdx) instanceof String && !((String)nextRow.get(colIdx)).trim().equals("")) continue block6;
                    rowsToDelete[rowNumber] = true;
                }
            }
        }
    }

    private void checkColumnContents_AND(List nextRow, short[] conditions, boolean[] rowsToDelete, int rowNumber) {
        boolean result = true;
        int ignoreCount = 0;
        block6: for (int colIdx = 0; colIdx < conditions.length; ++colIdx) {
            switch (conditions[colIdx]) {
                case 30: {
                    ++ignoreCount;
                    continue block6;
                }
                case 0: {
                    result = result && nextRow.get(colIdx) == null;
                    continue block6;
                }
                case 20: {
                    result = result && (nextRow.get(colIdx) == null || !(nextRow.get(colIdx) instanceof String) || ((String)nextRow.get(colIdx)).equals(""));
                    continue block6;
                }
                case 10: {
                    result = result && (nextRow.get(colIdx) == null || !(nextRow.get(colIdx) instanceof String) || ((String)nextRow.get(colIdx)).trim().equals(""));
                }
            }
        }
        if (ignoreCount >= conditions.length) {
            result = false;
        }
        rowsToDelete[rowNumber] = result;
    }

    public List getListOfRowLists() {
        int currentSelection = this.getSelectedRowIndex();
        this.fireEditingStopped();
        return this.model.getDataVector();
    }

    public void setCustomAddAction(Action a) {
        this.customAddAction = a;
    }

    public Action getCustomAddAction() {
        return this.customAddAction;
    }

    public void setCustomEditAction(Action a) {
        this.customEditAction = a;
    }

    public Action getCustomEditAction() {
        return this.customEditAction;
    }

    public void setCustomDuplicateAction(Action a) {
        this.customDuplicateAction = a;
    }

    public Action getCustomDuplicateAction() {
        return this.customDuplicateAction;
    }

    public void setCustomDeleteAction(Action a) {
        this.customDeleteAction = a;
    }

    public Action getCustomDeleteAction() {
        return this.customDeleteAction;
    }

    public void setEditable(boolean editable) {
        this.table.setEditableForAllColumns(editable);
    }

    public void editCellAt(int row, int col) {
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        if (col >= this.table.getColumnCount() || col < 0) {
            return;
        }
        this.table.editCellAt(row, col);
    }

    public void selectAndEditCell(int row, int col) {
        if (row >= this.table.getRowCount() || row < 0) {
            return;
        }
        if (col >= this.table.getColumnCount() || col < 0) {
            return;
        }
        this.table.selectAndEditCell(row, col);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.table.setEnabled(enabled);
        if (!enabled) {
            if (this.showAddButton) {
                this.addButton.setEnabled(enabled);
            }
            if (this.showEditButton) {
                this.editButton.setEnabled(enabled);
            }
            if (this.showDuplicateButton) {
                this.duplicateButton.setEnabled(enabled);
            }
            if (this.showDeleteButton) {
                this.deleteButton.setEnabled(enabled);
            }
            if (this.showMoveUpButton) {
                this.moveUpButton.setEnabled(enabled);
            }
            if (this.showMoveDownButton) {
                this.moveDownButton.setEnabled(enabled);
            }
            this.setEditable(enabled);
        } else {
            this.doEnablesDisables(this.table.getSelectedRows());
            this.setEditable(true);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBackground(Color bgColor) {
        if (bgColor != null && this.table != null) {
            this.table.setBackground(bgColor);
            this.scrollPane.getViewport().setBackground(bgColor);
        }
    }
}

