/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.DataViewContainerPanel;
import edu.ucsb.nceas.morpho.datapackage.DataViewer;
import edu.ucsb.nceas.morpho.framework.MorphoFrame;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.util.Command;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TablePasteCommand
implements Command {
    protected JTable target;
    private MorphoFrame morphoFrame = null;

    public void setTarget(JTable tbl) {
        this.target = tbl;
    }

    public JTable getTarget() {
        return this.target;
    }

    public void execute(ActionEvent event) {
        JTable jtable;
        DataViewer dataView;
        DataViewContainerPanel resultPane = null;
        this.morphoFrame = UIController.getInstance().getCurrentActiveWindow();
        if (this.morphoFrame != null) {
            resultPane = this.morphoFrame.getDataViewContainerPanel();
        }
        if (resultPane != null && (dataView = resultPane.getCurrentDataViewer()) != null && dataView.getTextFlag() && (jtable = dataView.getDataTable()) != null) {
            this.setTarget(jtable);
            this.paste(event);
        }
    }

    private void paste(ActionEvent evt) {
        Transferable t;
        JTable tbl = this.target;
        if (tbl == null) {
            tbl = (JTable)evt.getSource();
        }
        if ((t = tbl.getToolkit().getSystemClipboard().getContents(null)) == null) {
            return;
        }
        try {
            String sel = (String)t.getTransferData(DataFlavor.stringFlavor);
            StringTokenizer rowTokenizer = new StringTokenizer(sel, "\n");
            int rowCount = rowTokenizer.countTokens();
            String[][] data = new String[rowCount][];
            for (int i = 0; i < rowCount; ++i) {
                String row = rowTokenizer.nextToken();
                StringTokenizer colTokenizer = new StringTokenizer(row, "\t");
                int colCount = colTokenizer.countTokens();
                String[] cols = new String[colCount];
                data[i] = cols;
                for (int j = 0; j < colCount; ++j) {
                    cols[j] = colTokenizer.nextToken();
                }
            }
            this.applySelection(tbl, data);
            ((AbstractTableModel)tbl.getModel()).fireTableStructureChanged();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    protected void applySelection(JTable tbl, String[][] data) {
        int dataCols;
        int row = tbl.getSelectedRow();
        int col = tbl.getSelectedColumn();
        int selRows = tbl.getSelectedRowCount();
        int selCols = tbl.getSelectedColumnCount();
        int dataRows = data.length;
        int n = dataCols = dataRows > 0 ? data[0].length : 0;
        if (selRows == 1 && selCols == 1) {
            selRows = tbl.getRowCount() - row;
            selCols = tbl.getColumnCount() - col;
        }
        if (dataRows > selRows) {
            dataRows = selRows;
        }
        if (dataCols > selCols) {
            dataCols = selCols;
        }
        for (int i = 0; i < dataRows; ++i) {
            for (int j = 0; j < dataCols; ++j) {
                this.setValueAt(tbl, row + i, col + j, data[i][j]);
            }
        }
    }

    protected void setValueAt(JTable tbl, int row, int column, String value) {
        tbl.setValueAt(value, row, column);
    }
}

