/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.datapackage;

import edu.ucsb.nceas.morpho.datapackage.AbstractDataPackage;
import edu.ucsb.nceas.morpho.datapackage.ExternalRefsPage;
import edu.ucsb.nceas.morpho.datapackage.ReferenceMapping;
import edu.ucsb.nceas.morpho.datapackage.ReferenceSelectionEvent;
import edu.ucsb.nceas.morpho.datapackage.ReferencesListener;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.xml.transform.TransformerException;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReferencesHandler {
    private final String DEFAULT_DROPDOWN_ITEM = " ";
    private final String EXT_DIALOG_DROPDOWN_ITEM = "Select from a different data package";
    private String displayName;
    private String genericName;
    private String[] surrogateXPaths;
    private ModalDialog externalRefsDialog;
    private ExternalRefsPage externalRefsPage;
    private List listenerList = new ArrayList();
    private StringBuffer surrogateBuff = new StringBuffer();
    private static OrderedMap returnMap = new OrderedMap();

    public ReferencesHandler(String genericName, String[] surrogateXPaths) {
        this.displayName = genericName;
        this.genericName = genericName;
        this.surrogateXPaths = surrogateXPaths;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGenericName() {
        return this.genericName;
    }

    protected List getReferences(AbstractDataPackage dataPkg, String suppressRefID) {
        if (dataPkg == null) {
            return new ArrayList(0);
        }
        if (suppressRefID == null) {
            suppressRefID = "";
        }
        List idsList = dataPkg.getIDsForNodesWithName(this.genericName);
        Iterator idIt = idsList.iterator();
        ArrayList<ReferenceMapping> returnVals = new ArrayList<ReferenceMapping>();
        while (idIt.hasNext()) {
            Node nextSubtree;
            String nextID = (String)idIt.next();
            if (nextID == null || nextID.trim().length() < 1 || nextID.equals(suppressRefID) || (nextSubtree = dataPkg.getSubtreeAtReference(nextID)) == null) continue;
            returnVals.add(new ReferenceMapping(nextID, this.getSurrogate(nextSubtree)));
        }
        return returnVals;
    }

    public JComboBox getJComboBox(AbstractDataPackage dataPkg, ReferencesListener listener, Frame parent) {
        JComboBox dropdown = new JComboBox();
        if (dataPkg == null) {
            return dropdown;
        }
        this.updateJComboBox(dataPkg, dropdown, null);
        final ReferencesHandler instance = this;
        final AbstractDataPackage finalPkg = dataPkg;
        final Frame finalParent = parent;
        final JComboBox finalDropdown = dropdown;
        dropdown.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                JComboBox source = (JComboBox)e.getSource();
                ReferenceSelectionEvent event = null;
                switch (source.getSelectedIndex()) {
                    case 0: {
                        Log.debug(45, "ReferenceHandler ItemListener - top item ('none selected' - blank) selected ");
                        event = new ReferenceSelectionEvent(null, 0, null, null);
                        break;
                    }
                    case 1: {
                        Log.debug(45, "ReferenceHandler ItemListener - second item (copy from external package) selected");
                        event = instance.showCopyExternalRefsDialog(finalPkg, finalParent);
                        finalDropdown.setSelectedIndex(0);
                        break;
                    }
                    default: {
                        ReferenceMapping refMap = (ReferenceMapping)source.getSelectedItem();
                        Log.debug(45, "ReferenceHandler ItemListener - third or subsequent item selected (ref from current pkg); refID = " + refMap.getID());
                        Node subtree = finalPkg.getSubtreeAtReference(refMap.getID());
                        if (subtree == null) {
                            Log.debug(15, "ReferenceHandler ItemListener - no subtree found with refID: " + refMap.getID());
                            ReferencesHandler.this.updateJComboBox(finalPkg, finalDropdown, null);
                            return;
                        }
                        OrderedMap map = XMLUtilities.getDOMTreeAsXPathMap((Node)subtree);
                        event = new ReferenceSelectionEvent(refMap.getID(), 10, map, subtree.getNodeName());
                    }
                }
                ReferencesHandler.this.fireReferencesSelectionEvent(event);
            }
        });
        this.addReferencesListener(listener);
        return dropdown;
    }

    public void updateJComboBox(AbstractDataPackage dataPkg, JComboBox dropdown, String suppressRefID) {
        List refMapList = this.getReferences(dataPkg, suppressRefID);
        Object[] array = refMapList.toArray();
        Arrays.sort(array, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        int refMappingsLength = 2 + array.length;
        ReferenceMapping[] refMappings = new ReferenceMapping[refMappingsLength];
        refMappings[0] = new ReferenceMapping(" 0", " ");
        refMappings[1] = new ReferenceMapping("Select from a different data package1", "Select from a different data package");
        for (int i = 0; i < array.length; ++i) {
            refMappings[i + 2] = (ReferenceMapping)array[i];
        }
        dropdown.setModel(new DefaultComboBoxModel<ReferenceMapping>(refMappings));
        dropdown.validate();
        dropdown.repaint();
    }

    private ReferenceSelectionEvent showCopyExternalRefsDialog(AbstractDataPackage dataPkg, Frame parent) {
        ReferenceSelectionEvent event = new ReferenceSelectionEvent();
        if (this.externalRefsDialog == null) {
            this.externalRefsPage = new ExternalRefsPage(this);
            this.externalRefsDialog = new ModalDialog(this.externalRefsPage, parent, 770, 570, false);
        }
        this.externalRefsPage.setReferenceSelectionEvent(event);
        this.externalRefsPage.setCurrentDataPackageID(dataPkg.getPackageId());
        this.externalRefsPage.setDisplayName(this.displayName);
        this.externalRefsDialog.setVisible(true);
        if (this.externalRefsDialog.USER_RESPONSE == 10) {
            event = this.externalRefsPage.getReferenceSelectionEvent();
        }
        return event;
    }

    public static Node updateOriginalReferenceSubtree(AbstractDataPackage adp, String subtreeID, OrderedMap newData, List nodesToBeIgnored) {
        Log.debug(45, "updateOriginalReferenceSubtree() Got subtreeID=" + subtreeID + "\nnewData map:" + newData);
        if (subtreeID == null || subtreeID.trim().length() < 1) {
            Log.debug(15, "\n** ERROR - subtreeID map is NULL/blank!");
            return null;
        }
        if (newData == null) {
            Log.debug(15, "\n** ERROR - newData map is NULL!");
            return null;
        }
        if (adp == null) {
            Log.debug(15, "\n** ERROR - AbstractDataPackage map is NULL!");
            return null;
        }
        Node referencedSubtree = adp.getSubtreeAtReference(subtreeID);
        if (referencedSubtree == null) {
            Log.debug(15, "ReferencesHandler.updateOriginalReferenceSubtree() - got null back from datapackage - couldn't find subtree with this refID: " + subtreeID);
            return null;
        }
        String rootNodeName = referencedSubtree.getNodeName();
        newData = ReferencesHandler.replaceXPathMapWith(newData, "/" + rootNodeName);
        nodesToBeIgnored = ReferencesHandler.replaceXPathListWith(nodesToBeIgnored, "/" + rootNodeName);
        DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
        Document doc = impl.createDocument("", rootNodeName, null);
        Element subtreeRoot = doc.getDocumentElement();
        try {
            XMLUtilities.getXPathMapAsDOMTree((Map)newData, (Node)subtreeRoot);
        }
        catch (TransformerException w) {
            Log.debug(15, "TransformerException (" + w + ") calling " + "XMLUtilities.getXPathMapAsDOMTree(map, subtreeRoot) with \n" + "newData = " + newData + " and subtreeRoot = " + subtreeRoot);
            w.printStackTrace();
            Log.debug(5, "ERROR: Unable to update original reference data!");
            return null;
        }
        Node check = null;
        Log.debug(45, "updateOriginalReferenceSubtree() adding subtree to package...");
        Log.debug(45, "subtreeRoot=" + XMLUtilities.getDOMTreeAsString((Node)subtreeRoot));
        if (nodesToBeIgnored != null) {
            for (String xpath : nodesToBeIgnored) {
                Node oldNode = null;
                Node newNode = null;
                try {
                    oldNode = XMLUtilities.getTextNodeWithXPath((Node)referencedSubtree, (String)xpath);
                }
                catch (TransformerException te) {
                    Log.debug(15, "Got Exception while trying to retreive the node to be ignored in ReferencesHandler- " + te);
                    te.printStackTrace();
                }
                if (oldNode == null || oldNode.getNodeType() != 3) {
                    Log.debug(30, "oldNode is null or not text - " + oldNode + " for xpath = " + xpath + "; node name = " + referencedSubtree.getNodeName());
                    continue;
                }
                String oldVal = oldNode.getNodeValue();
                try {
                    newNode = XMLUtilities.getTextNodeWithXPath((Node)subtreeRoot, (String)xpath);
                }
                catch (TransformerException te) {
                    Log.debug(15, "Got Exception while trying to retreive the node to be ignored in ReferencesHandler- " + te);
                    te.printStackTrace();
                }
                if (newNode == null || newNode.getNodeType() != 3) {
                    Log.debug(30, "newNode is null or not text - " + newNode + " for xpath = " + xpath);
                    try {
                        XMLUtilities.addTextNodeToDOMTree((Node)subtreeRoot, (String)xpath, (String)oldVal);
                    }
                    catch (TransformerException te) {
                        Log.debug(15, "Got Exception while trying to add a text node in ReferencesHandler- " + te);
                        te.printStackTrace();
                    }
                    continue;
                }
                String newVal = newNode.getNodeValue();
                newNode.setNodeValue(oldNode.getNodeValue());
            }
        }
        if ((check = adp.replaceSubtreeAtReference(subtreeID, subtreeRoot)) == null) {
            Log.debug(15, "updateOriginalReferenceSubtree(): NULL returned from ADP.replaceSubtreeAtReference(); subtreeID=" + subtreeID + ";\nsubtreeRoot=" + subtreeRoot);
            Log.debug(5, "** ERROR: Unable to update original ref **\n");
        }
        return referencedSubtree;
    }

    public static Node deleteOriginalReferenceSubtree(AbstractDataPackage adp, String subtreeID) {
        Log.debug(45, "deleteOriginalReferenceSubtree() Got subtreeID=" + subtreeID);
        if (subtreeID == null || subtreeID.trim().length() < 1) {
            Log.debug(15, "\n** ERROR - subtreeID is NULL/blank!");
            return null;
        }
        if (adp == null) {
            Log.debug(15, "\n** ERROR - AbstractDataPackage map is NULL!");
            return null;
        }
        List referencers = adp.getSubtreesThatReference(subtreeID);
        if (referencers == null || referencers.size() < 1) {
            Log.debug(15, "deleteOriginalReferenceSubtree() found no subtrees that reference id: " + subtreeID);
            return null;
        }
        Node deletedSubtree = adp.getSubtreeAtReferenceNoClone(subtreeID);
        if (deletedSubtree == null) {
            Log.debug(15, "adp.getSubtreeAtReference(" + subtreeID + ") returned null");
            Log.debug(5, "ERROR: cannot delete!");
            return null;
        }
        Node firstReferer = null;
        int idx = 0;
        while (firstReferer == null && idx < referencers.size()) {
            firstReferer = (Node)referencers.get(idx++);
        }
        Node[] firstRefererKids = XMLUtilities.getNodeListAsNodeArray((NodeList)firstReferer.getChildNodes());
        for (int indx = 0; indx < firstRefererKids.length; ++indx) {
            firstReferer.removeChild(firstRefererKids[indx]);
        }
        Node[] deletedKids = XMLUtilities.getNodeListAsNodeArray((NodeList)deletedSubtree.getChildNodes());
        for (int index = 0; index < deletedKids.length; ++index) {
            firstReferer.appendChild(deletedKids[index]);
        }
        ((Element)deletedSubtree).setAttribute("id", "");
        ((Element)firstReferer).setAttribute("id", subtreeID);
        deletedSubtree.getParentNode().removeChild(deletedSubtree);
        return firstReferer;
    }

    private String getSurrogate(Node subtreeRoot) {
        if (this.surrogateXPaths == null || subtreeRoot == null) {
            return "";
        }
        this.surrogateBuff.delete(0, this.surrogateBuff.length());
        String baseXPath = "/" + subtreeRoot.getNodeName();
        Log.debug(45, "ReferencesHandler.getSurrogate() - baseXPath = " + baseXPath);
        Node textNode = null;
        for (int i = 0; i < this.surrogateXPaths.length; ++i) {
            String nextEntry = this.surrogateXPaths[i];
            if (nextEntry.startsWith("/")) {
                try {
                    textNode = XMLUtilities.getTextNodeWithXPath((Node)subtreeRoot, (String)(baseXPath + nextEntry));
                }
                catch (Exception ex) {
                    Log.debug(15, "exception in ReferenceHandler.getSurrogate() - " + ex);
                    ex.printStackTrace();
                }
                if (textNode != null) {
                    this.surrogateBuff.append(textNode.getNodeValue());
                    continue;
                }
                this.surrogateBuff.append(" ");
                continue;
            }
            this.surrogateBuff.append(nextEntry);
        }
        return this.surrogateBuff.toString();
    }

    public void addReferencesListener(ReferencesListener listener) {
        if (listener == null) {
            Log.debug(15, "addReferencesListener() received NULL listener");
            return;
        }
        if (this.listenerList.contains(listener)) {
            Log.debug(15, "Not adding; listener already registered: " + listener);
            return;
        }
        this.listenerList.add(listener);
    }

    public void removeReferencesListener(ReferencesListener listener) {
        if (listener == null) {
            Log.debug(15, "removeReferencesListener() received NULL listener");
            return;
        }
        if (!this.listenerList.contains(listener)) {
            Log.debug(15, "Cannot remove - listener wasn't registered: " + listener);
            return;
        }
        this.listenerList.remove(listener);
    }

    private void fireReferencesSelectionEvent(ReferenceSelectionEvent event) {
        for (ReferencesListener nextListener : this.listenerList) {
            if (nextListener == null) continue;
            nextListener.referenceSelected(event);
        }
    }

    private static OrderedMap replaceXPathMapWith(OrderedMap map, String newRoot) {
        returnMap.clear();
        for (String xpath : map.keySet()) {
            Object value = map.get((Object)xpath);
            xpath = ReferencesHandler.replaceSingleXPathWith(xpath, newRoot);
            Log.debug(45, "\nReferencesHandler.replaceXPathMapWith(); adding xpath to map: " + xpath);
            returnMap.put((Object)xpath, value);
        }
        return returnMap;
    }

    private static List replaceXPathListWith(List xpaths, String newRoot) {
        if (xpaths == null) {
            return null;
        }
        Object xpathRoot = null;
        ArrayList<String> newList = new ArrayList<String>();
        for (String xpath : xpaths) {
            xpath = ReferencesHandler.replaceSingleXPathWith(xpath, newRoot);
            Log.debug(45, "\nReferencesHandler.replaceXPathListWith(); adding xpath to map: " + xpath);
            newList.add(xpath);
        }
        return newList;
    }

    private static String replaceSingleXPathWith(String path, String newRoot) {
        boolean firstLoop = true;
        String xpath = path;
        String xpathRoot = null;
        while (xpath.startsWith("/")) {
            xpath = xpath.substring(1);
        }
        int firstSlashIdx = xpath.indexOf("/");
        if (firstSlashIdx < 0) {
            firstSlashIdx = xpath.length();
        }
        if (firstLoop) {
            xpathRoot = xpath.substring(0, firstSlashIdx);
            Log.debug(45, "\nReferencesHandler.replaceSingleXPathWith(); xpathRoot=" + xpathRoot);
            firstLoop = false;
        }
        xpath = newRoot + xpath.substring(firstSlashIdx);
        return xpath;
    }
}

