/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.calendar;

import com.toedter.calendar.JDayChooser;
import com.toedter.components.JSpinField;
import java.util.Calendar;
import javax.swing.JFrame;

public class JYearChooser
extends JSpinField {
    private JDayChooser dayChooser;
    private int year;

    public JYearChooser() {
        Calendar calendar = Calendar.getInstance();
        this.dayChooser = null;
        this.setMinimum(calendar.getMinimum(1));
        this.setMaximum(calendar.getMaximum(1));
        this.setValue(calendar.get(1));
    }

    protected void setValue(int newValue, boolean updateTextField, boolean updateScrollbar) {
        int oldYear = this.year;
        this.year = newValue;
        super.setValue(newValue, updateTextField, updateScrollbar);
        if (this.dayChooser != null) {
            this.dayChooser.setYear(newValue);
        }
        this.firePropertyChange("year", oldYear, this.year);
    }

    public void setYear(int y) {
        super.setValue(y);
    }

    public int getYear() {
        return this.year;
    }

    public void setDayChooser(JDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JYearChooser");
        frame.getContentPane().add(new JYearChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

