/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.xml;

import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class SleepTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    public SleepTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        long sleep = this.getSleepTime();
        if (sleep < 0L) {
            while (true) {
                ((JFCTestCase)this.getTestCase()).sleep(10000L);
            }
        }
        ((JFCTestCase)this.getTestCase()).sleep(sleep);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("duration");
    }

    protected long getSleepTime() {
        if ("forever".equals(this.getString("duration"))) {
            return -1L;
        }
        return this.getLong("duration", 300L);
    }
}

