/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import junit.extensions.jfcunit.finder.Finder;
import junit.extensions.jfcunit.finder.IconMatcher;

public class JMenuItemFinder
extends Finder {
    private IconMatcher m_iconMatcher;
    private String m_text = null;
    private boolean m_caseIndependent = false;

    public JMenuItemFinder(String text) {
        this(text, null, false);
    }

    public JMenuItemFinder(String text, boolean caseIndependent) {
        this(text, null, caseIndependent);
    }

    public JMenuItemFinder(Icon icon) {
        this(null, icon, false);
    }

    public JMenuItemFinder(String text, Icon icon) {
        this(text, icon, false);
    }

    public JMenuItemFinder(String text, Icon icon, boolean caseIndependent) {
        this.setText(text);
        this.setIcon(icon);
        this.m_caseIndependent = caseIndependent;
        this.recreatePatternMatcher(this.m_text, caseIndependent);
    }

    public void setCaseIndependent(boolean ignoreCase) {
        super.setCaseIndependent(ignoreCase);
        this.m_caseIndependent = ignoreCase;
        this.recreatePatternMatcher(this.m_text, this.m_caseIndependent);
    }

    public final void setIcon(Icon icon) {
        try {
            this.m_iconMatcher = icon == null ? null : new IconMatcher(icon);
        }
        catch (InterruptedException ie) {
            this.m_iconMatcher = null;
        }
    }

    public final Icon getIcon() {
        return this.m_iconMatcher.getIcon();
    }

    public final void setText(String text) {
        this.m_text = text;
        this.recreatePatternMatcher(this.m_text, this.m_caseIndependent);
    }

    public final String getText() {
        return this.m_text;
    }

    public boolean testComponent(Component comp) {
        return !(comp == null || !(comp instanceof JMenuItem) || this.m_text != null && !this.evaluate(((JMenuItem)comp).getText(), this.m_text) || this.m_iconMatcher != null && !this.m_iconMatcher.matches(((JMenuItem)comp).getIcon()));
    }
}

