/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;

class UnitTypesListItem
implements Comparable {
    private ComboBoxModel model;
    private String unitType;
    private String unitTypeDisplayString;
    private String[] unitsOfThisType;

    public UnitTypesListItem(String unitType, String oneUnitOfThisType) {
        this.unitType = unitType;
        String[] units = new String[]{oneUnitOfThisType};
        this.unitsOfThisType = units;
        this.unitTypeDisplayString = WizardSettings.getDisplayFormOfUnitType(unitType);
        this.model = new DefaultComboBoxModel<String>(this.unitsOfThisType);
    }

    public UnitTypesListItem(String unitType, String[] unitsOfThisType) {
        this.unitType = unitType;
        this.unitTypeDisplayString = WizardSettings.getDisplayFormOfUnitType(unitType);
        this.unitsOfThisType = unitsOfThisType;
        this.model = new DefaultComboBoxModel<String>(unitsOfThisType);
    }

    public ComboBoxModel getComboBoxModel() {
        return this.model;
    }

    public String toString() {
        return this.unitTypeDisplayString;
    }

    public void addUnit(String newUnit) {
        if (Arrays.binarySearch(this.unitsOfThisType, newUnit) >= 0) {
            return;
        }
        Object[] newArr = new String[this.unitsOfThisType.length + 1];
        WizardSettings.insertObjectIntoArray(this.unitsOfThisType, newUnit, newArr);
        this.unitsOfThisType = newArr;
        this.model = new DefaultComboBoxModel<String>(this.unitsOfThisType);
    }

    public String[] getUnitsOfThisType() {
        return this.unitsOfThisType;
    }

    public int compareTo(Object o) {
        return this.unitTypeDisplayString.compareTo(((UnitTypesListItem)o).toString());
    }

    public String getOriginalUnitType() {
        return this.unitType;
    }
}

