/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.framework.AbstractUIPage;
import edu.ucsb.nceas.morpho.framework.ModalDialog;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardContainerFrame;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.CitationPage;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.ParentTaxaPanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonHierarchy;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonImportPanel;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages.TaxonLevel;
import edu.ucsb.nceas.morpho.util.Command;
import edu.ucsb.nceas.morpho.util.GUIAction;
import edu.ucsb.nceas.morpho.util.HyperlinkButton;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.morpho.util.UISettings;
import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Taxonomic
extends AbstractUIPage {
    public final String pageID = "TAXONOMIC";
    private final String nextPageID = "METHODS";
    public final String pageNumber = "12";
    public final String title = "Taxonomic Coverage";
    public final String subtitle = "";
    private final String xPathRoot = "/eml:eml/dataset/coverage/taxonomicCoverage[1]";
    private final String heading = "<p><b>Enter information about the Taxonomic Coverage. </b>By default, you may enter information on Genus and Species.  If you would like to enter information at another classification rank or would like to change the default classification rank, click the edit button.  Note that the field 'Higher Level Taxa' is dynamically generated from your entries and is not manually editable.</p>";
    private final String headingNoImportTable = "<p><b>Enter information about the Taxonomic Coverage. </b>By default, you may enter information on Genus and Species.  If you would like to enter information at another classification rank or would like to change the default classification rank, click the edit button.  Note that the field 'Higher Level Taxa' is dynamically generated from your entries and is not manually editable.</p><br><p>If your information about the taxonomic coverage is extensive (e.g., an extensive list of species), you can import this information in the form of a table. See the Frequently Asked Questions section of the Morpho User Guide to find out how to do this.</p>";
    private String[] colNames = new String[]{"Higher Level Taxa", "Rank", "Name", "Rank", "Name", "Common Name(s)"};
    private int selectedRowIdx = 0;
    private final String[] classColNames = new String[]{"Citation Title", "Creator", "Citation Type"};
    private final Object[] classEditors = new Object[]{null, null, null};
    private CustomList taxonList;
    private CustomList classList;
    private JDialog importTaxaDialog = null;
    private TaxonImportPanel taxonImportPanel = null;
    private JDialog parentTaxaDialog = null;
    private JTextField[] colObjects;
    private static int validateTaxonCounter = 0;
    private static int commonNameCounter = 0;
    private static int taxonNameCounter = 0;

    public Taxonomic() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        this.add((Component)centerPanel, "Center");
        Color bgColor = new Color(192, 192, 192);
        this.colObjects = new JTextField[6];
        this.colObjects[0] = new JTextField();
        this.colObjects[0].setEditable(false);
        this.colObjects[0].setBackground(bgColor);
        this.colObjects[0].setDisabledTextColor(Color.black);
        this.colObjects[0].setForeground(Color.black);
        for (int i = 1; i < 6; ++i) {
            this.colObjects[i] = new JTextField();
        }
        this.colObjects[1].setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                return Taxonomic.this.verifyTaxonRank(Taxonomic.this, ((JTextField)input).getText(), 1);
            }

            public boolean shouldYieldFocus(JComponent input) {
                return true;
            }
        });
        this.colObjects[2].setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                return Taxonomic.this.verifyTaxonName(Taxonomic.this, (JTextField)input, 2);
            }

            public boolean shouldYieldFocus(JComponent input) {
                return true;
            }
        });
        this.colObjects[3].setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                return Taxonomic.this.verifyTaxonRank(Taxonomic.this, ((JTextField)input).getText(), 3);
            }

            public boolean shouldYieldFocus(JComponent input) {
                return true;
            }
        });
        this.colObjects[4].setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                return Taxonomic.this.verifyTaxonName(Taxonomic.this, (JTextField)input, 4);
            }

            public boolean shouldYieldFocus(JComponent input) {
                return true;
            }
        });
        this.colObjects[5].setInputVerifier(new InputVerifier(){

            public boolean verify(JComponent input) {
                return Taxonomic.this.verifyCommonName(Taxonomic.this, (JTextField)input);
            }

            public boolean shouldYieldFocus(JComponent input) {
                return true;
            }
        });
        this.taxonList = WidgetFactory.makeList(this.colNames, this.colObjects, 0, true, true, false, true, false, false);
        double[] colPercentages = new double[]{28.0, 14.0, 14.0, 14.0, 14.0, 16.0};
        this.taxonList.setColumnWidthPercentages(colPercentages);
        AbstractAction addAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Taxonomic.this.TaxonListAddAction();
            }
        };
        AbstractAction editAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Taxonomic.this.TaxonListEditAction();
            }
        };
        this.taxonList.setCustomAddAction(addAction);
        this.taxonList.setCustomEditAction(editAction);
        JPanel taxonPanel = new JPanel(new BorderLayout());
        taxonPanel.setLayout(new BoxLayout(taxonPanel, 1));
        GUIAction action = new GUIAction("Import Taxon Information from Data table...", null, new Command(){

            public void execute(ActionEvent ae) {
                Point p = Taxonomic.this.getLocationOnScreen();
                int xc = (int)p.getX() + Taxonomic.this.getWidth() / 2 - 300;
                int yc = (int)p.getY() + Taxonomic.this.getHeight() / 2 - 225;
                ActionListener okAction = new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        Taxonomic.this.taxonImportOKAction();
                    }
                };
                ActionListener cancelAction = new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        Taxonomic.this.taxonImportCancelAction();
                    }
                };
                Taxonomic.this.taxonImportPanel = new TaxonImportPanel();
                Taxonomic.this.importTaxaDialog = WidgetFactory.makeContainerDialog(Taxonomic.this.taxonImportPanel, okAction, cancelAction, "Import", "Cancel");
                Taxonomic.this.importTaxaDialog.setBounds(xc, yc, 600, 450);
                Taxonomic.this.importTaxaDialog.setVisible(true);
            }
        });
        this.taxonImportPanel = new TaxonImportPanel();
        boolean displayTable = this.taxonImportPanel.displayTable;
        this.taxonImportPanel = null;
        HyperlinkButton importButton = new HyperlinkButton(action);
        importButton.setPreferredSize(UISettings.INIT_SCR_LINKBUTTON_DIMS);
        importButton.setMinimumSize(UISettings.INIT_SCR_LINKBUTTON_DIMS);
        importButton.setMaximumSize(UISettings.INIT_SCR_LINKBUTTON_DIMS);
        JLabel headLabel = null;
        headLabel = !displayTable ? WidgetFactory.makeHTMLLabel("<p><b>Enter information about the Taxonomic Coverage. </b>By default, you may enter information on Genus and Species.  If you would like to enter information at another classification rank or would like to change the default classification rank, click the edit button.  Note that the field 'Higher Level Taxa' is dynamically generated from your entries and is not manually editable.</p><br><p>If your information about the taxonomic coverage is extensive (e.g., an extensive list of species), you can import this information in the form of a table. See the Frequently Asked Questions section of the Morpho User Guide to find out how to do this.</p>", 6, false) : WidgetFactory.makeHTMLLabel("<p><b>Enter information about the Taxonomic Coverage. </b>By default, you may enter information on Genus and Species.  If you would like to enter information at another classification rank or would like to change the default classification rank, click the edit button.  Note that the field 'Higher Level Taxa' is dynamically generated from your entries and is not manually editable.</p>", 3, false);
        Box headPanel = Box.createVerticalBox();
        headPanel.add(headLabel);
        headPanel.add(Box.createVerticalGlue());
        if (displayTable) {
            JPanel importPanel = new JPanel(new BorderLayout());
            importPanel.add(Box.createGlue(), "North");
            importPanel.add((Component)importButton, "West");
            importPanel.add(Box.createGlue(), "South");
            headPanel.add(importPanel);
            headPanel.add(Box.createVerticalGlue());
        }
        taxonPanel.setLayout(new BorderLayout());
        taxonPanel.add((Component)this.taxonList, "Center");
        taxonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        centerPanel.add(headPanel);
        centerPanel.add(WidgetFactory.makeDefaultSpacer());
        centerPanel.add(taxonPanel);
        centerPanel.add(WidgetFactory.makeDefaultSpacer());
        JPanel classTablePanel = WidgetFactory.makeVerticalPanel(-1);
        classTablePanel.add(WidgetFactory.makeHTMLLabel("<b>Classification System </b>If the list of taxa belong to one or more different classification systems, list the citations for those systems.", 2, false));
        classTablePanel.add(Box.createVerticalGlue());
        JPanel classPanel = new JPanel(new BorderLayout());
        this.classList = WidgetFactory.makeList(this.classColNames, this.classEditors, -1, true, true, false, true, false, false);
        classPanel.add((Component)this.classList, "Center");
        classPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        classTablePanel.add(classPanel);
        AbstractAction classAddAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Taxonomic.this.classificationCitationAddAction();
            }
        };
        AbstractAction classEditAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Taxonomic.this.classificationCitationEditAction();
            }
        };
        this.classList.setCustomAddAction(classAddAction);
        this.classList.setCustomEditAction(classEditAction);
        classTablePanel.setMaximumSize(new Dimension(2000, 150));
        classTablePanel.setPreferredSize(new Dimension(2000, 150));
        centerPanel.add(classTablePanel);
        centerPanel.add(WidgetFactory.makeDefaultSpacer());
    }

    private void classificationCitationAddAction() {
        CitationPage citationPage = new CitationPage();
        ModalDialog wpd = new ModalDialog(citationPage, WizardContainerFrame.getDialogParent(), 770, 570);
        if (wpd.USER_RESPONSE == 10) {
            int rowNum = this.classList.getRowCount();
            List row = citationPage.getSurrogate();
            OrderedMap map = citationPage.getPageData("/classificationSystemCitation[1]");
            row.add(map);
            this.classList.addRow(row);
        }
        this.refreshCitationList();
    }

    private void classificationCitationEditAction() {
        int rowNum = this.classList.getSelectedRowIndex();
        if (rowNum < 0 || rowNum > this.classList.getRowCount()) {
            return;
        }
        List row = this.classList.getSelectedRowList();
        OrderedMap map = (OrderedMap)row.get(3);
        OrderedMap copyMap = (OrderedMap)map.clone();
        CitationPage citationPage = new CitationPage();
        citationPage.setPageData(copyMap, "/classificationSystemCitation[1]");
        ModalDialog wpd = new ModalDialog(citationPage, WizardContainerFrame.getDialogParent(), 770, 570);
        if (wpd.USER_RESPONSE == 10) {
            row = citationPage.getSurrogate();
            row.add(citationPage.getPageData("/classificationSystemCitation[1]"));
            this.classList.replaceSelectedRow(row);
        }
        this.refreshCitationList();
    }

    private void TaxonListAddAction() {
        List rows = this.taxonList.getListOfRowLists();
        ArrayList<Object> newRow = new ArrayList<Object>();
        TaxonHierarchy hier = null;
        if (rows.size() == 0) {
            newRow.add("");
            newRow.add("Genus");
            newRow.add("");
            newRow.add("Species");
            newRow.add("");
            newRow.add("");
            hier = new TaxonHierarchy();
        } else {
            List r;
            Object o;
            int selIdx = this.taxonList.getSelectedRowIndex();
            if (selIdx < 0) {
                selIdx = rows.size() - 1;
            }
            if ((o = (r = (List)rows.get(selIdx)).get(6)) != null && o instanceof TaxonHierarchy) {
                TaxonHierarchy hr = (TaxonHierarchy)o;
                hier = (TaxonHierarchy)hr.clone();
                int cnt = hier.getLevelCount();
                TaxonLevel parentLevel = hier.getTaxonAtLevel(cnt - 2);
                TaxonLevel currentLevel = hier.getTaxonAtLevel(cnt - 1);
                if (parentLevel != null) {
                    parentLevel.setName("");
                    parentLevel.setCommonNames(null);
                    hier.setTaxonAtLevel(cnt - 2, parentLevel);
                }
                if (currentLevel != null) {
                    currentLevel.setName("");
                    currentLevel.setCommonNames(null);
                    hier.setTaxonAtLevel(cnt - 1, currentLevel);
                }
                newRow.add((String)r.get(0));
                newRow.add((String)r.get(1));
                newRow.add("");
                newRow.add((String)r.get(3));
                newRow.add("");
                newRow.add("");
            } else {
                newRow.add("");
                newRow.add("");
                newRow.add("");
                newRow.add("");
                newRow.add("");
                newRow.add("");
            }
        }
        newRow.add(hier);
        this.taxonList.addRow(newRow);
    }

    private void TaxonListEditAction() {
        List row = this.taxonList.getSelectedRowList();
        this.selectedRowIdx = this.taxonList.getSelectedRowIndex();
        if (row.size() < 7) {
            return;
        }
        Object o = row.get(6);
        if (o == null || !(o instanceof TaxonHierarchy)) {
            return;
        }
        TaxonHierarchy hier = (TaxonHierarchy)o;
        String parent = ((String)row.get(0)).trim();
        Vector allTaxons = hier.getAllTaxons();
        TaxonHierarchy newHier = new TaxonHierarchy(new Vector());
        for (int i = 0; i < allTaxons.size() - 2; ++i) {
            newHier.addTaxon((TaxonLevel)allTaxons.get(i));
        }
        String rank1 = ((String)row.get(1)).trim();
        String level1 = ((String)row.get(2)).trim();
        String rank2 = ((String)row.get(3)).trim();
        String level2 = ((String)row.get(4)).trim();
        String cn2 = ((String)row.get(5)).trim();
        if (!rank1.equals("")) {
            TaxonLevel origLevel = hier.getTaxonAtRank(rank1);
            String[] commNames = null;
            if (origLevel != null) {
                commNames = origLevel.getCommonNames();
            }
            TaxonLevel tl1 = new TaxonLevel(rank1, level1, commNames);
            newHier.addTaxon(tl1);
        }
        if (!rank2.equals("")) {
            TaxonLevel tl2 = new TaxonLevel(rank2, level2, this.parseCommonNames(cn2));
            newHier.addTaxon(tl2);
        }
        final ParentTaxaPanel panel = new ParentTaxaPanel();
        panel.setHierarchy(newHier);
        ActionListener okAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Taxonomic.this.parentTaxaOKAction(panel);
            }
        };
        ActionListener cancelAction = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Taxonomic.this.parentTaxaDialog.setVisible(false);
            }
        };
        this.parentTaxaDialog = WidgetFactory.makeContainerDialog(panel, okAction, cancelAction);
        Point p = this.getLocationOnScreen();
        int xc = (int)p.getX() + this.getWidth() / 2 - 225;
        int yc = (int)p.getY() + this.getHeight() / 2 - 250;
        this.parentTaxaDialog.setBounds(xc, yc, 450, 500);
        this.parentTaxaDialog.setVisible(true);
    }

    private String[] parseCommonNames(String names) {
        ArrayList<String> t = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(names, ",");
        while (st.hasMoreTokens()) {
            t.add(st.nextToken().trim());
        }
        if (t.size() == 0) {
            return null;
        }
        String[] ret = new String[t.size()];
        ret = t.toArray(ret);
        return ret;
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    private void parentTaxaOKAction(ParentTaxaPanel panel) {
        if (!panel.onAdvanceAction()) {
            return;
        }
        List newRow = panel.getSurrogate();
        newRow.add(panel.getHierarchy());
        this.taxonList.replaceSelectedRow(newRow);
        this.parentTaxaDialog.setVisible(false);
    }

    private void taxonImportOKAction() {
        List importedData = this.taxonImportPanel.getListOfImportedTaxa();
        for (List t : importedData) {
            String taxon = (String)t.get(0);
            String rank = (String)t.get(1);
            int rankIdx = WizardSettings.getIndexOfTaxonRank(rank);
            ArrayList<Object> newRow = new ArrayList<Object>();
            newRow.add("");
            if (rankIdx <= 5) {
                newRow.add(rank);
                newRow.add(taxon);
                newRow.add("");
                newRow.add("");
            } else {
                newRow.add("");
                newRow.add("");
                newRow.add(rank);
                newRow.add(taxon);
            }
            newRow.add("");
            TaxonLevel tl = new TaxonLevel(rank, taxon, null);
            TaxonHierarchy hier = new TaxonHierarchy(new Vector());
            hier.addTaxon(tl);
            newRow.add(hier);
            this.taxonList.addRow(newRow);
        }
        this.importTaxaDialog.setVisible(false);
    }

    private void taxonImportCancelAction() {
        this.importTaxaDialog.setVisible(false);
    }

    private List getHierarchy(String hier) {
        StringTokenizer st = new StringTokenizer(hier, ";");
        ArrayList<String> result = new ArrayList<String>();
        if (hier.trim().equals("")) {
            return result;
        }
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int idx = token.indexOf("=");
            result.add(token.substring(0, idx));
        }
        return result;
    }

    public void onLoadAction() {
        if (this.taxonList.getRowCount() == 0) {
            this.TaxonListAddAction();
        }
        this.refreshCitationList();
    }

    private void refreshCitationList() {
        List rows = this.classList.getListOfRowLists();
        for (int i = 0; i < rows.size(); ++i) {
            OrderedMap map;
            List row = (List)rows.get(i);
            if (row.size() < 4 || (map = (OrderedMap)row.get(3)) == null || map.size() == 0) continue;
            OrderedMap copyMap = (OrderedMap)map.clone();
            CitationPage citationPage = new CitationPage();
            citationPage.setPageData(copyMap, "/classificationSystemCitation[1]");
            row = citationPage.getSurrogate();
            row.add(citationPage.getPageData("/classificationSystemCitation[1]"));
            this.classList.replaceRow(i, row);
        }
    }

    public void onRewindAction() {
    }

    public boolean onAdvanceAction() {
        this.taxonList.fireEditingStopped();
        this.taxonList.selectAndEditCell(0, 0);
        List rows = this.classList.getListOfRowLists();
        if (rows != null && rows.size() > 0) {
            List data = this.taxonList.getListOfRowLists();
            int len = data.size();
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    List row = (List)data.get(i);
                    if (row.size() < 7) continue;
                    TaxonHierarchy th = (TaxonHierarchy)row.get(6);
                    Vector taxonLevels = th.getAllTaxons();
                    for (int j = 0; j < taxonLevels.size(); ++j) {
                        TaxonLevel level = (TaxonLevel)taxonLevels.get(j);
                        String tRank = level.getRank();
                        String tName = level.getName();
                        if (tRank.trim().equals("") || tName.trim().equals("")) continue;
                        return true;
                    }
                }
            }
            JOptionPane.showMessageDialog(this, "You must enter the Taxonomic information along with the Citation details!", "Error", 0);
            return false;
        }
        return true;
    }

    public OrderedMap getPageData() {
        return this.getPageData("/eml:eml/dataset/coverage/taxonomicCoverage[1]");
    }

    public OrderedMap getPageData(String rootXPath) {
        String tName;
        String tRank;
        TaxonLevel level;
        OrderedMap result = new OrderedMap();
        List rows = this.classList.getListOfRowLists();
        if (rows != null && rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                List row = (List)rows.get(i);
                OrderedMap map = (OrderedMap)row.get(3);
                for (String k : map.keySet()) {
                    String newKey = rootXPath + "/taxonomicSystem[1]/classificationSystem[" + (i + 1) + "]" + k;
                    result.put((Object)newKey, (Object)((String)map.get((Object)k)));
                }
            }
            result.put((Object)(rootXPath + "/taxonomicSystem[1]/identifierName[1]/organizationName[1]"), (Object)"Unknown");
            result.put((Object)(rootXPath + "/taxonomicSystem[1]/taxonomicProcedures[1]"), (Object)"Unknown");
        }
        Iterator it1 = result.keySet().iterator();
        Log.debug(45, "OrderedMap returning from TaxonomicPage");
        while (it1.hasNext()) {
            String k = (String)it1.next();
            Log.debug(45, k + "--" + (String)result.get((Object)k));
        }
        List data = this.taxonList.getListOfRowLists();
        int len = data.size();
        for (int i = len - 1; i > -1; --i) {
            List row = (List)data.get(i);
            TaxonHierarchy th = (TaxonHierarchy)row.get(6);
            Vector taxonLevels = th.getAllTaxons();
            boolean removeTaxonLevel = true;
            for (int j = 0; j < taxonLevels.size(); ++j) {
                level = (TaxonLevel)taxonLevels.get(j);
                tRank = level.getRank();
                tName = level.getName();
                if (tRank.trim().equals("") || tName.trim().equals("")) continue;
                removeTaxonLevel = false;
            }
            if (!removeTaxonLevel) continue;
            data.remove(i);
        }
        len = data.size();
        ArrayList<TaxonHierarchy> validHierarchies = new ArrayList<TaxonHierarchy>();
        for (int i = 0; i < len; ++i) {
            String cn;
            String name1;
            String rank2;
            String rank1;
            List row = (List)data.get(i);
            TaxonHierarchy th = (TaxonHierarchy)row.get(6);
            if (!th.isValidHierarchy() || (rank1 = (String)row.get(1)).trim().length() > 0 && !this.isValidTaxonName(rank1) || (rank2 = (String)row.get(3)).trim().length() > 0 && !this.isValidTaxonName(rank2) || (name1 = (String)row.get(2)).trim().length() > 0 && !this.isValidTaxonName(name1)) continue;
            String name2 = (String)row.get(4);
            if (name2.trim().length() > 0) {
                if (!this.isValidTaxonName(name2)) continue;
                TaxonLevel tempLevel = th.getTaxonAtRank(rank2);
                tempLevel.setName(name2);
            }
            if ((cn = (String)row.get(5)).trim().length() > 0 && !this.validateCommonNames(cn)) continue;
            validHierarchies.add(th);
        }
        len = validHierarchies.size();
        Object[] hierarchies = new TaxonHierarchy[len];
        for (int i = 0; i < len; ++i) {
            hierarchies[i] = (TaxonHierarchy)validHierarchies.get(i);
        }
        Arrays.sort(hierarchies);
        String lastAddedPrefix = "";
        String prefix = rootXPath + "/taxonomicClassification[1]";
        if (len > 0) {
            Vector taxonLevels = ((TaxonHierarchy)hierarchies[0]).getAllTaxons();
            for (int i = 0; i < taxonLevels.size(); ++i) {
                level = (TaxonLevel)taxonLevels.get(i);
                tRank = level.getRank();
                tName = level.getName();
                if (tRank.trim().equals("") || tName.trim().equals("")) continue;
                result.put((Object)(prefix + "/taxonRankName"), (Object)tRank);
                result.put((Object)(prefix + "/taxonRankValue"), (Object)tName);
                String[] cn = level.getCommonNames();
                for (int j = 0; cn != null && j < cn.length; ++j) {
                    result.put((Object)(prefix + "/commonName[" + (j + 1) + "]"), (Object)cn[j]);
                }
                lastAddedPrefix = prefix;
                if (i >= taxonLevels.size() - 1) continue;
                prefix = prefix + "/taxonomicClassification[1]";
            }
            Object prevHier = null;
            if (!result.isEmpty()) {
                prevHier = hierarchies[0];
            }
            for (int i = 1; i < len; ++i) {
                int cmp = -1;
                if (prevHier != null && (cmp = ((TaxonHierarchy)hierarchies[i]).compareTo(prevHier)) == 0) continue;
                if (cmp < 0) {
                    Log.debug(10, "Error in getPageData! Sorting not correct");
                    continue;
                }
                prevHier = hierarchies[i];
                int start = 0;
                int idx = -1;
                idx = lastAddedPrefix.indexOf("taxonomicClassification", start);
                start = idx + new String("taxonomicClassification").length();
                String currPrefix = lastAddedPrefix.substring(0, start);
                int closingBrace = lastAddedPrefix.indexOf("]", start);
                int currPosition = 0;
                if (closingBrace < start + 1) {
                    Log.debug(25, "Error - cldnt get index");
                } else {
                    String pos = lastAddedPrefix.substring(start + 1, closingBrace);
                    try {
                        currPosition = Integer.parseInt(pos);
                    }
                    catch (Exception e) {
                        Log.debug(45, "not a number - " + pos);
                    }
                }
                currPrefix = currPrefix + "[" + ++currPosition + "]";
                Vector newTaxonLevels = ((TaxonHierarchy)hierarchies[i]).getAllTaxons();
                for (int k = 0; k < newTaxonLevels.size(); ++k) {
                    TaxonLevel level2 = (TaxonLevel)newTaxonLevels.get(k);
                    String tRank2 = level2.getRank();
                    String tName2 = level2.getName();
                    if (tRank2.trim().equals("") || tName2.trim().equals("")) continue;
                    result.put((Object)(currPrefix + "/taxonRankName"), (Object)tRank2);
                    result.put((Object)(currPrefix + "/taxonRankValue"), (Object)tName2);
                    String[] cn = level2.getCommonNames();
                    for (int j = 0; cn != null && j < cn.length; ++j) {
                        result.put((Object)(currPrefix + "/commonName[" + (j + 1) + "]"), (Object)cn[j]);
                    }
                    lastAddedPrefix = currPrefix;
                    if (k >= newTaxonLevels.size() - 1) continue;
                    currPrefix = currPrefix + "/taxonomicClassification[1]";
                }
            }
        }
        return result;
    }

    public String getPageID() {
        return "TAXONOMIC";
    }

    public String getTitle() {
        return "Taxonomic Coverage";
    }

    public String getSubtitle() {
        return "";
    }

    public String getNextPageID() {
        return "METHODS";
    }

    public String getPageNumber() {
        return "12";
    }

    public boolean setPageData(OrderedMap data, String _xPathRoot) {
        boolean result = true;
        if (data == null || data.isEmpty()) {
            return true;
        }
        data.remove((Object)(_xPathRoot + "/@scope"));
        data.remove((Object)(_xPathRoot + "/@id"));
        try {
            DOMImplementation impl = DOMImplementationImpl.getDOMImplementation();
            Document doc = impl.createDocument("", "taxonomicCoverage", null);
            Element covRoot = doc.getDocumentElement();
            XMLUtilities.getXPathMapAsDOMTree((Map)data, (Node)covRoot);
            result = this.traverseTree(covRoot, new TaxonHierarchy(new Vector()));
            if (!result) {
                return false;
            }
            this.removeAllKeysStartingWith(_xPathRoot + "/taxonomicClassification", data);
        }
        catch (Exception e) {
            Log.debug(10, "Invalid orderedmap - " + e);
            return false;
        }
        int size = data.keySet().size();
        String[] keys = new String[size];
        keys = data.keySet().toArray(keys);
        int pos = 1;
        for (int cnt = 0; cnt < size; ++cnt) {
            String key = keys[cnt];
            int idx = key.indexOf("/taxonomicSystem[1]/classificationSystem[" + pos + "]");
            if (idx > -1) {
                OrderedMap map = new OrderedMap();
                OrderedMap subMap = new OrderedMap();
                int idx2 = key.substring(idx).indexOf("/classificationSystemCitation");
                map.put((Object)key.substring(idx + idx2), data.get((Object)key));
                subMap.put((Object)key, data.get((Object)key));
                ++cnt;
                while (cnt < size) {
                    key = keys[cnt];
                    int newidx = key.indexOf("/taxonomicSystem[1]/classificationSystem[" + pos + "]");
                    if (newidx <= -1) {
                        --cnt;
                        break;
                    }
                    int citidx = key.substring(newidx).indexOf("/classificationSystemCitation");
                    map.put((Object)key.substring(citidx + newidx), data.get((Object)key));
                    subMap.put((Object)key, data.get((Object)key));
                    ++cnt;
                }
                OrderedMap map1 = (OrderedMap)map.clone();
                CitationPage cpage = new CitationPage();
                boolean flag = cpage.setPageData(map, "/classificationSystemCitation[1]");
                if (!flag) {
                    return false;
                }
                List row = cpage.getSurrogate();
                if (row.size() == 0) break;
                row.add(map1);
                data.removeAll((Map)subMap);
                this.classList.addRow(row);
                ++pos;
                continue;
            }
            if (key.indexOf("identifierName") > -1) {
                data.remove((Object)key);
                continue;
            }
            if (key.indexOf("taxonomicProcedures") <= -1) continue;
            data.remove((Object)key);
        }
        this.taxonList.editCellAt(0, 2);
        return data.keySet().size() <= 0;
    }

    private boolean traverseTree(Node root, TaxonHierarchy hier) {
        boolean toReturn = true;
        if (root == null) {
            return true;
        }
        Log.debug(40, "Traversing - " + root.getNodeName());
        NodeList children = root.getChildNodes();
        if (children.getLength() == 0) {
            Log.debug(40, "no children - returning true");
            return true;
        }
        TaxonLevel level = null;
        boolean middleNodePresent = false;
        boolean endNodePresent = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("taxonomicClassification")) {
                this.traverseTree(child, (TaxonHierarchy)hier.clone());
                middleNodePresent = true;
                continue;
            }
            if (name.equals("taxonRankName")) {
                Node cnNode;
                String rankName = child.getFirstChild().getNodeValue();
                String rankVal = "";
                Node value = child.getNextSibling();
                if (value != null && value.getNodeName().equals("taxonRankValue")) {
                    rankVal = value.getFirstChild().getNodeValue();
                    ++i;
                }
                String[] cns = null;
                Node curr = value;
                ArrayList<String> cn = new ArrayList<String>();
                int cnt = 0;
                while ((cnNode = curr.getNextSibling()) != null && cnNode.getNodeName().equals("commonName")) {
                    String val = cnNode.getFirstChild().getNodeValue();
                    cn.add(val);
                    ++cnt;
                    ++i;
                    curr = cnNode;
                }
                if (cnt > 0) {
                    cns = new String[cnt];
                    cns = cn.toArray(cns);
                }
                level = new TaxonLevel(rankName, rankVal, cns);
                hier.addTaxon(level);
                endNodePresent = true;
                continue;
            }
            if (name.equals("taxonomicSystem")) continue;
            toReturn = false;
        }
        if (!middleNodePresent && endNodePresent) {
            ParentTaxaPanel panel = new ParentTaxaPanel();
            panel.setHierarchy(hier);
            List list = panel.getSurrogate();
            list.add(hier);
            this.taxonList.addRow(list);
        }
        return toReturn;
    }

    private void removeAllKeysStartingWith(String path, OrderedMap map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(path)) continue;
            it.remove();
        }
    }

    private int compareStrings(String first, String sec) {
        int i;
        int len1 = first.length();
        int len2 = sec.length();
        for (i = 0; i < len1; ++i) {
            char s;
            if (i >= len2) {
                return i;
            }
            char f = first.charAt(i);
            if (f < (s = sec.charAt(i))) {
                return -i;
            }
            if (f <= s) continue;
            return i;
        }
        if (i < len2) {
            return -i;
        }
        return 0;
    }

    private TaxonLevel getTaxonLevel(OrderedMap map, String currPrefix) {
        String cn;
        String rank = (String)map.get((Object)(currPrefix + "/taxonRank"));
        if (rank == null || rank.trim().equals("")) {
            return null;
        }
        String name = (String)map.get((Object)(currPrefix + "/taxonName"));
        if (name == null) {
            name = "";
        }
        ArrayList<String> commonNames = new ArrayList<String>();
        int cnIdx = 1;
        while ((cn = (String)map.get((Object)(currPrefix + "/commonName[" + cnIdx + "]"))) != null) {
            commonNames.add(cn);
            ++cnIdx;
        }
        String[] cns = null;
        if (cnIdx > 1) {
            cns = new String[cnIdx - 1];
            cns = commonNames.toArray(cns);
        }
        TaxonLevel level = new TaxonLevel(rank, name, cns);
        return level;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean verifyTaxonRank(Taxonomic parent, String newText, int pos) {
        TaxonHierarchy tr;
        int res;
        List row;
        if (validateTaxonCounter > 0) {
            return true;
        }
        ++validateTaxonCounter;
        boolean error = false;
        int rowIdx = this.taxonList.getSelectedRowIndex();
        if (newText == null) {
            --validateTaxonCounter;
            return true;
        }
        if (!this.isValidTaxonName(newText)) {
            JOptionPane.showMessageDialog(this, "Invalid characters in the taxon rank. Only letters and spaces are allowed.", "Error", 0);
            --validateTaxonCounter;
            int[] selRows = new int[]{rowIdx};
            this.taxonList.setSelectedRows(selRows);
            return false;
        }
        List selRow = this.taxonList.getSelectedRowList();
        TaxonHierarchy hier = null;
        if (selRow.size() > 5) {
            hier = (TaxonHierarchy)selRow.get(6);
        }
        if (hier == null) {
            return true;
        }
        int currcnt = hier.getLevelCount();
        if (pos == 1) {
            String nextRank = (String)selRow.get(3);
            TaxonLevel currLevel = null;
            int mypos = currcnt - 2;
            mypos = nextRank.trim().equals("") ? currcnt - 1 : currcnt - 2;
            currLevel = hier.getTaxonAtLevel(mypos);
            if (currLevel == null) {
                currLevel = new TaxonLevel(newText, "", new String[0]);
                hier.insertTaxonAtLevel(0, currLevel);
            } else {
                currLevel.setRank(newText);
            }
            if (!newText.trim().equals("")) {
                // empty if block
            }
        } else if (pos == 3) {
            String prevRank;
            int parentLen = 0;
            String[] cn = this.parseCommonNames((String)selRow.get(0));
            if (cn != null) {
                parentLen = cn.length;
            }
            if ((prevRank = (String)selRow.get(1)).trim().length() > 0) {
                ++parentLen;
            }
            if (currcnt == parentLen) {
                hier.addTaxon(new TaxonLevel("", "", new String[0]));
                currcnt = hier.getLevelCount();
            }
            int mypos = currcnt - 1;
            TaxonLevel currLevel = hier.getTaxonAtLevel(mypos);
            currLevel.setRank(newText);
            if (newText.trim().equals("")) {
                // empty if block
            }
        }
        if (!hier.isValidHierarchy()) {
            JOptionPane.showMessageDialog(this, "Error in the entry! The entered taxon rank is already present in the taxonomic hierarchy", "Error", 0);
            int idx = this.taxonList.getSelectedRowIndex();
            --validateTaxonCounter;
            int[] selRows = new int[]{idx};
            return false;
        }
        List data = this.taxonList.getListOfRowLists();
        Iterator it = data.iterator();
        int cnt = -1;
        do {
            if (!it.hasNext()) {
                --validateTaxonCounter;
                return true;
            }
            row = (List)it.next();
        } while (++cnt == rowIdx || row.size() < 6 || (res = hier.compareTo(tr = (TaxonHierarchy)row.get(6))) != 0);
        JOptionPane.showMessageDialog(this, "Error in the entry! The entered taxonomic hierarchy is already present in the list", "Error", 0);
        int idx = this.taxonList.getSelectedRowIndex();
        --validateTaxonCounter;
        int[] selRows = new int[]{idx};
        this.taxonList.setSelectedRows(selRows);
        return false;
    }

    public boolean verifyCommonName(Taxonomic parent, JTextField jc) {
        if (commonNameCounter > 0) {
            return true;
        }
        ++commonNameCounter;
        String newName = jc.getText();
        if (!this.validateCommonNames(newName)) {
            JOptionPane.showMessageDialog(parent, "Invalid characters in the common name(s). Only letters, digits and spaces are allowed. Common names are seperated by a comma", "Error", 0);
            int rowIdx = this.taxonList.getSelectedRowIndex();
            --commonNameCounter;
            int[] selRows = new int[]{rowIdx};
            this.taxonList.setSelectedRows(selRows);
            return false;
        }
        List row = this.taxonList.getSelectedRowList();
        TaxonHierarchy currHier = (TaxonHierarchy)row.get(6);
        int currcount = currHier.getLevelCount();
        TaxonLevel currLevel = currHier.getTaxonAtLevel(currcount - 1);
        String[] cns = this.parseCommonNames(newName);
        currLevel.setCommonNames(cns);
        --commonNameCounter;
        return true;
    }

    private boolean validateCommonNames(String text) {
        char[] arr = text.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == ',' || Character.isLetterOrDigit(arr[i]) || Character.isSpaceChar(arr[i])) continue;
            return false;
        }
        return true;
    }

    public boolean verifyTaxonName(Taxonomic parent, JTextField jc, int pos) {
        String newName;
        if (taxonNameCounter > 0) {
            return true;
        }
        ++taxonNameCounter;
        int rowIdx = this.taxonList.getSelectedRowIndex();
        if (rowIdx < 0) {
            rowIdx = this.selectedRowIdx;
        }
        if (!this.isValidTaxonName(newName = jc.getText())) {
            JOptionPane.showMessageDialog(parent, "Invalid characters in the taxon name. Only letters, digits and spaces are allowed.", "Error", 0);
            int[] selRows = new int[]{rowIdx};
            this.taxonList.setSelectedRows(selRows);
            --taxonNameCounter;
            return false;
        }
        List row = this.taxonList.getSelectedRowList();
        if (row == null) {
            row = (List)this.taxonList.getListOfRowLists().get(this.selectedRowIdx);
        }
        TaxonHierarchy currHier = (TaxonHierarchy)row.get(6);
        int currcount = currHier.getLevelCount();
        if (pos == 2) {
            String r2 = (String)row.get(3);
            TaxonLevel currLevel = null;
            if (r2.trim().equals("")) {
                currLevel = currHier.getTaxonAtLevel(currcount - 1);
            } else if (currcount > 1) {
                currLevel = currHier.getTaxonAtLevel(currcount - 2);
            } else {
                currLevel = new TaxonLevel("", newName, null);
                currHier.insertTaxonAtLevel(0, currLevel);
            }
            if (currLevel != null) {
                currLevel.setName(newName);
            }
        } else if (pos == 4) {
            TaxonLevel currLevel = currHier.getTaxonAtLevel(currcount - 1);
            currLevel.setName(newName);
        }
        List data = this.taxonList.getListOfRowLists();
        Iterator it = data.iterator();
        int cnt = -1;
        while (it.hasNext()) {
            TaxonHierarchy tr;
            int res;
            List currRow = (List)it.next();
            if (++cnt == rowIdx || currRow.size() < 6 || (res = currHier.compareTo(tr = (TaxonHierarchy)currRow.get(6))) != 0) continue;
            JOptionPane.showMessageDialog(this, "Error in the entry! The entered taxonomic hierarchy is already present in the list", "Error", 0);
            --taxonNameCounter;
            int[] selRows = new int[]{rowIdx};
            this.taxonList.setSelectedRows(selRows);
            return false;
        }
        List allRows = this.taxonList.getListOfRowLists();
        for (int i = 0; i < allRows.size(); ++i) {
            TaxonHierarchy parentHier;
            List currRow;
            TaxonHierarchy hier;
            if (i != rowIdx && (hier = (TaxonHierarchy)(currRow = (List)allRows.get(i)).get(6)) != null && hier.getLevelCount() != 0 && (parentHier = hier.getParentsOfName(newName)) != null && pos != 2) continue;
        }
        --taxonNameCounter;
        return true;
    }

    private boolean isValidTaxonName(String text) {
        char[] arr = text.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (Character.isLetterOrDigit(arr[i]) || Character.isSpaceChar(arr[i])) continue;
            return false;
        }
        return true;
    }
}

