/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.morpho.plugins.datapackagewizard.pages;

import edu.ucsb.nceas.morpho.datapackage.EML200DataPackage;
import edu.ucsb.nceas.morpho.framework.UIController;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.CustomList;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WidgetFactory;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardPageSubPanelAPI;
import edu.ucsb.nceas.morpho.plugins.datapackagewizard.WizardSettings;
import edu.ucsb.nceas.morpho.util.Log;
import edu.ucsb.nceas.utilities.OrderedMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class DateTimePanel
extends JPanel
implements WizardPageSubPanelAPI {
    private JLabel formatStringLabel;
    private JLabel precisionLabel;
    private JTextField formatStringField;
    private JTextField precisionField;
    private CustomList boundsList;
    private String[] boundsPickListValues = new String[]{"<", "<="};
    private JButton addButton;
    private JButton delButton;
    private String dateTimeDomainID = "";
    private String emlVersion = "";
    private boolean precisionRequired = false;
    private static final String EML_VER_200 = "eml-2.0.0";
    private OrderedMap returnMap = new OrderedMap();

    public DateTimePanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        int width = WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.width;
        int height = 7 * WizardSettings.WIZARD_CONTENT_SINGLE_LINE_DIMS.height;
        Dimension dims = new Dimension(width, height);
        this.setPreferredSize(dims);
        this.emlVersion = ((EML200DataPackage)UIController.getInstance().getCurrentAbstractDataPackage()).getEMLVersion();
        Log.debug(30, "EML version: " + this.emlVersion);
        JPanel formatStringPanel = WidgetFactory.makePanel();
        this.formatStringLabel = WidgetFactory.makeLabel("Format:", true, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        formatStringPanel.add(this.formatStringLabel);
        this.formatStringField = WidgetFactory.makeOneLineTextField();
        formatStringPanel.add(this.formatStringField);
        JPanel formatStringGrid = new JPanel(new GridLayout(1, 2));
        formatStringGrid.add(formatStringPanel);
        formatStringGrid.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g: YYYY-MM-DDThh:mm:ss ,&nbsp;&nbsp;YYYY-MM-DD ,&nbsp;&nbsp;hh:mm:ss.sss</font></html>"));
        this.add(formatStringGrid);
        if (this.emlVersion.equals(EML_VER_200)) {
            this.precisionRequired = true;
        }
        JPanel precisionPanel = WidgetFactory.makePanel();
        this.precisionLabel = WidgetFactory.makeLabel("Precision:", this.precisionRequired, WizardSettings.WIZARD_CONTENT_LABEL_DIMS);
        precisionPanel.add(this.precisionLabel);
        this.precisionField = WidgetFactory.makeOneLineTextField();
        precisionPanel.add(this.precisionField);
        JPanel precisionGrid = new JPanel(new GridLayout(1, 2));
        precisionGrid.add(precisionPanel);
        precisionGrid.add(this.getLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Precision of a date or time measurement, interpreted in the smallest units represented by the datetime format.&nbsp;&nbsp;<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g: 1 day, 1 hour, 1 minute</font></html>"));
        this.add(WidgetFactory.makeHalfSpacer());
        this.add(precisionGrid);
        this.add(WidgetFactory.makeHalfSpacer());
        String[] colNames = new String[]{"Min.", "", "", "", "Max."};
        JLabel valueLabel = new JLabel("value", null, 0);
        JComboBox combobox1 = WidgetFactory.makePickList(this.boundsPickListValues, false, 0, null);
        JComboBox combobox2 = WidgetFactory.makePickList(this.boundsPickListValues, false, 0, null);
        Object[] colTemplates = new Object[]{new JTextField(), combobox1, valueLabel, combobox2, new JTextField()};
        JPanel boundsPanel = WidgetFactory.makePanel(3);
        boundsPanel.add(WidgetFactory.makeLabel("Bounds:", false, WizardSettings.WIZARD_CONTENT_LABEL_DIMS));
        this.boundsList = WidgetFactory.makeList(colNames, colTemplates, 2, false, false, false, false, false, false);
        this.boundsList.setListButtonDimensions(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.boundsList.setBorderForButtonPanel(0, 5, 0, 0);
        boundsPanel.add(this.boundsList);
        JPanel boundsGrid = new JPanel(new GridLayout(1, 2));
        boundsGrid.add(boundsPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        this.addButton = new JButton("Add");
        this.addButton.setPreferredSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.addButton.setMaximumSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.addButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        this.delButton = new JButton("Delete");
        this.delButton.setPreferredSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.delButton.setMaximumSize(WizardSettings.LIST_BUTTON_DIMS_SMALL);
        this.delButton.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        this.delButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DateTimePanel.this.boundsList.fireAddAction();
                if (DateTimePanel.this.boundsList.getRowCount() > 0) {
                    DateTimePanel.this.delButton.setEnabled(true);
                }
            }
        });
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                DateTimePanel.this.boundsList.fireDeleteAction();
                if (DateTimePanel.this.boundsList.getRowCount() == 0) {
                    DateTimePanel.this.delButton.setEnabled(false);
                }
            }
        });
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.delButton);
        buttonPanel.add(Box.createVerticalGlue());
        JPanel outerButtonPanel = new JPanel();
        outerButtonPanel.setLayout(new BoxLayout(outerButtonPanel, 0));
        outerButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        outerButtonPanel.add(buttonPanel);
        outerButtonPanel.add(Box.createHorizontalStrut(10));
        JPanel boundsHelpPanel = new JPanel();
        boundsHelpPanel.setLayout(new BorderLayout());
        JLabel helpLabel = new JLabel("<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\">Range of permitted values, in same date-time format as used in the format description above.&nbsp;&nbsp;&nbsp;<html><font style=\"font-size: 9px;\" face=\"Sans-Serif\"><font style=\"font-size: 9px;\" color=\"#666666\">e.g: if format is \"YYYY-MM-DD\", a valid minimum would be \"2001-05-29\"</font><br></br></html>");
        helpLabel.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        boundsHelpPanel.add((Component)helpLabel, "Center");
        outerButtonPanel.add(boundsHelpPanel);
        boundsGrid.add(outerButtonPanel);
        this.add(boundsGrid);
        this.add(Box.createGlue());
    }

    private JLabel getLabel(String text) {
        if (text == null) {
            text = "";
        }
        JLabel label = new JLabel(text);
        label.setAlignmentX(1.0f);
        label.setFont(WizardSettings.WIZARD_CONTENT_FONT);
        label.setBorder(BorderFactory.createMatteBorder(1, 10, 1, 3, (Color)null));
        return label;
    }

    public void onLoadAction() {
        WidgetFactory.unhiliteComponent(this.formatStringLabel);
        if (this.precisionRequired) {
            WidgetFactory.unhiliteComponent(this.precisionLabel);
        }
        this.formatStringField.requestFocus();
    }

    public boolean validateUserInput() {
        this.boundsList.deleteEmptyRows((short)61, new short[]{10, 30, 30, 30, 10});
        if (this.formatStringField.getText().trim().equals("")) {
            WidgetFactory.hiliteComponent(this.formatStringLabel);
            this.formatStringField.requestFocus();
            return false;
        }
        WidgetFactory.unhiliteComponent(this.formatStringLabel);
        String precision = this.precisionField.getText().trim();
        if (this.precisionRequired && precision.equals("")) {
            WidgetFactory.hiliteComponent(this.precisionLabel);
            this.precisionField.requestFocus();
            return false;
        }
        return true;
    }

    public OrderedMap getPanelData(String xPathRoot) {
        this.returnMap.clear();
        this.returnMap.put((Object)(xPathRoot + "/formatString"), (Object)this.formatStringField.getText().trim());
        if (!this.precisionField.getText().trim().equals("")) {
            this.returnMap.put((Object)(xPathRoot + "/dateTimePrecision"), (Object)this.precisionField.getText().trim());
        }
        int index = 0;
        List rowLists = this.boundsList.getListOfRowLists();
        if (rowLists.size() > 0) {
            this.returnMap.put((Object)(xPathRoot + "/dateTimeDomain"), (Object)"");
            String id = this.dateTimeDomainID.trim();
            if (id != null && !id.equals("")) {
                this.returnMap.put((Object)(xPathRoot + "/dateTimeDomain/@id"), (Object)id);
            }
            xPathRoot = xPathRoot + "/dateTimeDomain/bounds[";
        }
        String nextMin = null;
        String nextMax = null;
        Object nextExcl = null;
        for (Object nextRowObj : rowLists) {
            List nextRow;
            if (nextRowObj == null || (nextRow = (List)nextRowObj).size() < 1) continue;
            ++index;
            if (nextRow.get(0) != null && !(nextMin = (String)nextRow.get(0)).trim().equals("")) {
                this.returnMap.put((Object)(xPathRoot + index + "]/minimum"), (Object)nextMin);
                nextExcl = nextRow.get(1);
                if (nextExcl != null && ((String)nextExcl).equals("<")) {
                    this.returnMap.put((Object)(xPathRoot + index + "]/minimum/@exclusive"), (Object)"true");
                } else {
                    this.returnMap.put((Object)(xPathRoot + index + "]/minimum/@exclusive"), (Object)"false");
                }
            }
            if (nextRow.get(4) == null || (nextMax = (String)nextRow.get(4)).trim().equals("")) continue;
            this.returnMap.put((Object)(xPathRoot + index + "]/maximum"), (Object)nextMax);
            nextExcl = nextRow.get(3);
            if (nextExcl != null && ((String)nextExcl).equals("<")) {
                this.returnMap.put((Object)(xPathRoot + index + "]/maximum/@exclusive"), (Object)"true");
                continue;
            }
            this.returnMap.put((Object)(xPathRoot + index + "]/maximum/@exclusive"), (Object)"false");
        }
        return this.returnMap;
    }

    public void setPanelData(String xPathRoot, OrderedMap map) {
        String id;
        String precision;
        String format = (String)map.get((Object)(xPathRoot + "/formatString"));
        if (format != null) {
            this.formatStringField.setText(format);
            map.remove((Object)(xPathRoot + "/formatString"));
        }
        if ((precision = (String)map.get((Object)(xPathRoot + "/dateTimePrecision"))) != null) {
            this.precisionField.setText(precision);
            map.remove((Object)(xPathRoot + "/dateTimePrecision"));
        }
        if ((id = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/@id"))) != null) {
            this.dateTimeDomainID = id.toString();
            map.remove((Object)(xPathRoot + "/dateTimeDomain/@id"));
        }
        int index = 1;
        while (true) {
            ArrayList<String> row = new ArrayList<String>();
            String min = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/minimum"));
            if (index == 1 && min == null) {
                min = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds/minimum"));
            }
            if (min != null) {
                row.add(min);
                String excl = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/minimum/@exclusive"));
                if (excl != null) {
                    map.remove((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/minimum/@exclusive"));
                }
                if (index == 1 && excl == null && (excl = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds/minimum/@exclusive"))) != null) {
                    map.remove((Object)(xPathRoot + "/dateTimeDomain/bounds/minimum/@exclusive"));
                }
                if (excl != null) {
                    if (excl.equalsIgnoreCase("true")) {
                        row.add("<");
                    } else {
                        row.add("<=");
                    }
                }
            } else {
                row.add("");
                row.add("<");
            }
            row.add("value");
            String max = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/maximum"));
            if (max != null) {
                map.remove((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/maximum"));
            }
            if (index == 1 && max == null) {
                max = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds/maximum"));
            }
            if (max != null) {
                String excl = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/maximum/@exclusive"));
                if (excl != null) {
                    map.remove((Object)(xPathRoot + "/dateTimeDomain/bounds[" + index + "]/maximum/@exclusive"));
                }
                if (index == 1 && excl == null && (excl = (String)map.get((Object)(xPathRoot + "/dateTimeDomain/bounds/maximum/@exclusive"))) != null) {
                    map.remove((Object)(xPathRoot + "/dateTimeDomain/bounds/maximum/@exclusive"));
                }
                if (excl != null) {
                    if (excl.equalsIgnoreCase("true")) {
                        row.add("<");
                    } else {
                        row.add("<=");
                    }
                }
                row.add(max);
            } else {
                row.add("<");
                row.add("");
            }
            if (min == null && max == null) break;
            this.boundsList.addRow(row);
            ++index;
        }
    }
}

